/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.server;

import com.creamtec.ajaxswing.support.FileOpener;
import com.sygate.scm.common.acl.AdminACLUtils;
import com.sygate.scm.common.acl.AuthorizationManager;
import com.sygate.scm.common.acl.BasicPermission;
import com.sygate.scm.common.acl.Permission;
import com.sygate.scm.common.acl.PrivilegeContext;
import com.sygate.scm.common.acl.SitePermission;
import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.SchemaHelper;
import com.sygate.scm.common.configobject.TimeUtil;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.rpc.RpcData;
import com.sygate.scm.common.configobject.schema.DatabasePrivilege;
import com.sygate.scm.common.configobject.schema.IpAddress;
import com.sygate.scm.common.configobject.schema.License;
import com.sygate.scm.common.configobject.schema.LicenseCode;
import com.sygate.scm.common.configobject.schema.NetworkACL;
import com.sygate.scm.common.configobject.schema.PrivilegeValue;
import com.sygate.scm.common.configobject.schema.ReplicationContent;
import com.sygate.scm.common.configobject.schema.ReplicationPartnership;
import com.sygate.scm.common.configobject.schema.SemConfigRoot;
import com.sygate.scm.common.configobject.schema.SemServer;
import com.sygate.scm.common.configobject.schema.SemServerList;
import com.sygate.scm.common.configobject.schema.SemServerState;
import com.sygate.scm.common.configobject.schema.SemSite;
import com.sygate.scm.common.configobject.schema.ServerArray;
import com.sygate.scm.common.configobject.schema.ServerBackupConfig;
import com.sygate.scm.common.configobject.schema.SitePrivilege;
import com.sygate.scm.common.configobject.schema.SitePrivilegeSet;
import com.sygate.scm.common.configobject.schema.TransportServerCertificate;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.AjaxSwingManager;
import com.sygate.scm.common.ui.CertificateDlg;
import com.sygate.scm.common.ui.ClientAgent;
import com.sygate.scm.common.ui.CustomLookAndFeel;
import com.sygate.scm.common.ui.UIColorUtilities;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.handler.AdminHandler;
import com.sygate.scm.console.handler.LicenseHandler;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.ServerHandler;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.help.HelpUtil;
import com.sygate.scm.console.logicobject.AdminObject;
import com.sygate.scm.console.logicobject.AdminPrivilegeObject;
import com.sygate.scm.console.logicobject.ContainerObject;
import com.sygate.scm.console.logicobject.DatabaseObject;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.logicobject.Partner;
import com.sygate.scm.console.logicobject.PartnerGroup;
import com.sygate.scm.console.logicobject.ServerObject;
import com.sygate.scm.console.logicobject.SiteObject;
import com.sygate.scm.console.logicobject.TreeItem;
import com.sygate.scm.console.ui.dlg.SimpleProgressDlg;
import com.sygate.scm.console.ui.monitoring.dialog.LogFileFilter;
import com.sygate.scm.console.ui.policy.lu.LuDownloadNowDlg;
import com.sygate.scm.console.ui.policy.lu.LuDownloadStatusDlg;
import com.sygate.scm.console.ui.policy.lu.LuLatestDownloadDlg;
import com.sygate.scm.console.ui.server.DbStatusPanel;
import com.sygate.scm.console.ui.server.PartnerListPanel;
import com.sygate.scm.console.ui.server.PartnerStatusPanel;
import com.sygate.scm.console.ui.server.RemoteSitePanel;
import com.sygate.scm.console.ui.server.ServerBasePanel;
import com.sygate.scm.console.ui.server.ServerStatusPanel;
import com.sygate.scm.console.ui.server.ServersWelcomePanel;
import com.sygate.scm.console.ui.server.SiteStatusPanel;
import com.sygate.scm.console.ui.server.dlg.AddPartnerWizard;
import com.sygate.scm.console.ui.server.dlg.ConfigureRSAWizard;
import com.sygate.scm.console.ui.server.dlg.DatabasePropertiesDialog;
import com.sygate.scm.console.ui.server.dlg.ExternalLoggingPropertiesDlg;
import com.sygate.scm.console.ui.server.dlg.ImportCertificateWizard;
import com.sygate.scm.console.ui.server.dlg.PartnerDlg;
import com.sygate.scm.console.ui.server.dlg.ReIndexRunNowDlg;
import com.sygate.scm.console.ui.server.dlg.ServerPropertiesDlg;
import com.sygate.scm.console.ui.server.dlg.SitePropertiesDlg;
import com.sygate.scm.console.ui.server.dlg.SmartCardDialog;
import com.sygate.scm.console.ui.server.dlg.TxnLogRunNowDlg;
import com.sygate.scm.console.ui.server.dlg.VipServerDialog;
import com.sygate.scm.console.ui.util.PagePanel;
import com.sygate.scm.console.ui.util.SideBar;
import com.sygate.scm.console.ui.util.TabbedPageModel;
import com.sygate.scm.console.ui.util.TaskObject;
import com.sygate.scm.console.ui.util.TaskPanel;
import com.sygate.scm.console.ui.util.TaskPanelBase;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.ui.util.Utilities;
import com.sygate.scm.console.ui.util.renderer.CustomTreeCellRenderer;
import com.sygate.scm.console.util.AjaxSwingUtil;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.console.util.GUIManager;
import com.sygate.scm.console.util.ServerSystemLogMonitor;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.BackupUtils;
import com.sygate.scm.util.GUIDGenerator;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.ReplicationScheduleUtility;
import com.sygate.scm.util.ScmLicense;
import com.sygate.scm.util.SwingWorker;
import com.sygate.scm.util.Utility;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ServersPanel
extends PagePanel
implements FileOpener {
    private static final long serialVersionUID = 7453261446794272949L;
    public static final int SERVERS_NODE = 0;
    public static final int LICENSE_NODE = 1;
    public static final String LICENSE_MANAGEMENT = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.LicMgmt");
    private static final String UPDATE_LICENSE_WARNING = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.UpdateLicWarning");
    private static final String LOGOUT_CONSOLE = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.LogoutConsole");
    private static final String XML_EXTENSION = "xml";
    private static final String XML_DESCRIPTION = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.XmlDesc");
    private static MessageResourcesFile resource = new MessageResourcesFile("com.sygate.scm.console.ui.server.dlg.serverdialog");
    private static HashMap<String, Integer> privilegeMap = new HashMap();
    static final String SERVER_TITLE = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServerStatusPanel.title.SvrMgmt");
    private ServerTaskPane rightSidePane;
    private static HashMap<Integer, String> titleMap = new HashMap();
    private JButton refreshBtn = new JButton();
    private JTree tree = new JTree();
    private JPanel blankPanel = new JPanel();
    private HashMap<String, TabbedPageModel> panelMap = new HashMap();
    private JSplitPane splitPane;
    private JTextArea monitoringArea;
    String[] option = new String[]{UIText.get(3584)};
    private boolean refresh = false;
    private static final String PAGE_NAME = "ServerSubPanel";

    public ServersPanel() {
        privilegeMap.clear();
        this.initialize();
        this.setName(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.title.Servers"));
        Image refreshImage = Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("refresh.gif"));
        this.refreshBtn.setIcon(new ImageIcon(refreshImage));
        this.refreshBtn.setHorizontalAlignment(0);
        this.refreshBtn.setVerticalAlignment(0);
        this.refreshBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServersPanel.this.refresh();
            }
        });
        JButton[] buttons = new JButton[]{this.refreshBtn};
        this.setImageButton(buttons);
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ServersPanel.this.maybeShowPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                ServersPanel.this.maybeShowPopup(e);
            }
        });
        this.tree.putClientProperty("JTree.lineStyle", "Angled");
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                ServersPanel.this.treeSelectionChanged();
            }
        });
    }

    @Override
    public void initPanel() {
    }

    @Override
    public void selectItemIndex(int index) {
        this.tree.setSelectionRow(index);
        this.tree.scrollRowToVisible(index);
    }

    @Override
    public void switchOut() {
        ServerSystemLogMonitor.getServerMonitor().setMonitoring(false, this.getMonitoringArea());
        if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
            ClientAgent.getCurrentInstance().setUpdateBrowserInterval(0);
        }
    }

    @Override
    public void switchIn() {
        if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
            ClientAgent.getCurrentInstance().setUpdateBrowserInterval(2);
            ClientAgent.getCurrentInstance().setUpdateBrowser(true);
        }
        ServerSystemLogMonitor.getServerMonitor().setMonitoring(true, this.getMonitoringArea());
        ServerSystemLogMonitor.getServerMonitor().start();
        if (!LicenseObject.getInstance().isSBProduct()) {
            this.setViewPaneTitle(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.title.view"));
        } else {
            this.setViewPaneTitle(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.title.view.sb"));
        }
    }

    public void checkCertificate() {
        SwingWorker worker = new SwingWorker(){
            private ConsoleException exception = null;
            private RpcData ret = null;
            private RpcData data = new RpcData();
            private SimpleProgressDlg dlg = null;
            private String siteName = null;

            public Object construct() {
                Partner partner = (Partner)ServersPanel.this.getSelectedTreeNodeUserObject();
                if (partner == null) {
                    return null;
                }
                if (!Manager.isLocalSite(partner.getSemSite().getId())) {
                    ServersPanel.this.displayRemoteSiteWarning();
                    return null;
                }
                this.siteName = partner.getName();
                Utility.addPairToRpcData((RpcData)this.data, (String)"action", (String)"checkCertificate");
                Utility.addPairToRpcData((RpcData)this.data, (String)"siteName", (String)this.siteName);
                try {
                    this.dlg = new SimpleProgressDlg(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.title.PleaseWait"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.CheckingRemotepartnerCertificate"), false, false);
                    this.dlg.setCursor(Cursor.getPredefinedCursor(3));
                    this.dlg.setVisible(true);
                    this.ret = (RpcData)GUIManager.sendCommand("Replication", (AbstractSchema)this.data);
                    this.dlg.dispose();
                    return this.ret;
                }
                catch (ConsoleException e) {
                    this.exception = e;
                    return null;
                }
            }

            public void finished() {
                if (this.exception != null) {
                    if (this.dlg != null) {
                        this.dlg.dispose();
                    }
                    String msg = this.exception.getMessageString();
                    if (this.exception.getMessageId() == 68) {
                        msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.theSMSServerYouHaveloggedIntoIs");
                    } else if (this.exception.getMessageId() == 154) {
                        msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.dismatchDbVersionOnRemoteSite");
                    }
                    JOptionPane.showMessageDialog(Manager.getFrame(), msg, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.title.CheckCertificate"), 0);
                    if (this.exception.needRelogin()) {
                        Manager.getFrame().showLoginPanel();
                    }
                    AjaxSwingManager.endOperation();
                    return;
                }
                if (this.ret != null) {
                    String remoteSiteName = Utility.getValueFromRpcData((RpcData)this.ret, (String)"siteName");
                    if (this.ret.getNameValuePairCount() > 0) {
                        if ("MismatchCertificate".equalsIgnoreCase(remoteSiteName)) {
                            X509Certificate cert = null;
                            String str = Utility.getValueFromRpcData((RpcData)this.ret, (String)"remoteCertificate");
                            System.out.println("ServerHandler>> getRemoteCertificate: Certificate str=" + str);
                            try {
                                byte[] buf = Utility.toByteArray((String)str);
                                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                                cert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(buf));
                            }
                            catch (CertificateException ex) {
                                System.out.println("CertificateException : " + ex.getMessage());
                            }
                            if (cert != null) {
                                CertificateDlg dlg = new CertificateDlg((JFrame)Manager.getFrame(), cert, CustomLookAndFeel.TITLE_LOGO_ICON);
                                if (dlg.isOk()) {
                                    System.out.println("Certificate is trusted");
                                    this.data = new RpcData();
                                    Utility.addPairToRpcData((RpcData)this.data, (String)"action", (String)"trustCertificate");
                                    Utility.addPairToRpcData((RpcData)this.data, (String)"siteName", (String)this.siteName);
                                    Utility.addPairToRpcData((RpcData)this.data, (String)"servercert", (String)str);
                                    try {
                                        GUIManager.sendCommand("Replication", (AbstractSchema)this.data);
                                        JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.InfoUpdatedSvrCert"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.title.CheckCertificate"), 1);
                                    }
                                    catch (ConsoleException ce) {
                                        System.out.println("ConsoleException : " + ce.getMessage());
                                        JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.InfoFailUpdateSvrCert"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.title.CheckCertificate"), 1);
                                    }
                                } else {
                                    System.out.println("Certificate is not trusted");
                                    dlg.dispose();
                                    JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.InfoFailUpdateSvrCert"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.title.CheckCertificate"), 1);
                                }
                                dlg.dispose();
                            }
                        } else if ("TrustedCertificate".equalsIgnoreCase(remoteSiteName)) {
                            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.InfoSameSvrCert"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.title.CheckCertificate"), 1);
                        } else {
                            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.InfoFailUpdateSvrCert"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.title.CheckCertificate"), 1);
                        }
                        if (this.dlg != null) {
                            this.dlg.dispose();
                        }
                        AjaxSwingManager.endOperation();
                    }
                }
            }
        };
        AjaxSwingManager.beginOperation();
        worker.start();
    }

    @Override
    public void refreshTaskBarViews() {
        block7: {
            this.setRefresh(true);
            try {
                HashMap<String, ItemVisualStatus> map = this.noteTreeVisualStatus();
                TreeModel treeModel = ServerHandler.getServerTree();
                ServersPanel.modifyTreeModelBaseOnSitePrivilegeSet(treeModel, AdminObject.retrieveCurrentAdminObject());
                this.tree.setModel(treeModel);
                this.tree.setBackground(UIColorUtilities.SECONDARY_NAVIGATION_BACKGROUND);
                this.tree.setCellRenderer(new CustomTreeCellRenderer(){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                        Component panel = super.getTreeCellRendererComponent(tree, value, false, expanded, leaf, row, false);
                        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
                        TreeItem treeItemObj = (TreeItem)node.getUserObject();
                        UIUtilities.setName((JComponent)panel, ServersPanel.PAGE_NAME, UIUtilities.ComponentType.TREENODE, treeItemObj.getItemType() + "_" + treeItemObj.getName());
                        if (sel) {
                            this.setForeground(UIColorUtilities.SECONDARY_NAVIGATION_SELECTED_FOREGROUND);
                        } else {
                            this.setForeground(UIColorUtilities.SECONDARY_NAVIGATION_FOREGROUND);
                        }
                        return panel;
                    }
                });
                if (map == null || map.isEmpty()) {
                    DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)treeModel.getRoot();
                    int rootChildCount = rootNode.getChildCount();
                    for (int i = 0; i < rootChildCount; ++i) {
                        DefaultMutableTreeNode thisNode = (DefaultMutableTreeNode)rootNode.getChildAt(i);
                        TreeItem thisItem = (TreeItem)thisNode.getUserObject();
                        int thisItemType = thisItem.getItemType();
                        if (thisItemType != 13) continue;
                        this.tree.expandPath(new TreePath(thisNode.getPath()));
                        int siteChildCount = thisNode.getChildCount();
                        for (int s = 0; s < siteChildCount; ++s) {
                            DefaultMutableTreeNode thisSiteChildNode = (DefaultMutableTreeNode)thisNode.getChildAt(s);
                            this.tree.expandPath(new TreePath(thisSiteChildNode.getPath()));
                        }
                    }
                    this.tree.setSelectionRow(0);
                } else {
                    if (this.tree.getSelectionPath() == null) {
                        this.tree.setSelectionRow(0);
                    }
                    this.applyTreeVisualStatus(map);
                }
                this.setSideBarViews(this.tree);
                this.setRefresh(false);
            }
            catch (ConsoleException e) {
                JOptionPane.showMessageDialog(Manager.getFrame(), e.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.title.ConsoleError"), 0);
                if (!e.needRelogin()) break block7;
                Manager.getFrame().showLoginPanel();
            }
        }
    }

    public void aboutAllowPartner() {
        HelpUtil.showHelp(null);
    }

    public void displayRemoteSiteWarning() {
        JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.error.FeatNotForRemoteSites"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.title.ConsoleWarning"), 2);
    }

    public void addPartner() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        TreeItem item = (TreeItem)node.getUserObject();
        if (item == null) {
            return;
        }
        switch (item.getItemType()) {
            case 13: {
                if (Manager.isLocalSite(item.getId())) break;
                this.displayRemoteSiteWarning();
                return;
            }
            case 17: {
                DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
                SiteObject site = (SiteObject)parent.getUserObject();
                if (site == null) {
                    return;
                }
                if (Manager.isLocalSite(site.getId())) break;
                this.displayRemoteSiteWarning();
                return;
            }
            case 18: {
                DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
                DefaultMutableTreeNode grandParent = (DefaultMutableTreeNode)parent.getParent();
                SiteObject site = (SiteObject)grandParent.getUserObject();
                if (site == null) {
                    return;
                }
                if (Manager.isLocalSite(site.getId())) break;
                this.displayRemoteSiteWarning();
                return;
            }
        }
        DefaultTreeModel model = (DefaultTreeModel)this.tree.getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)model.getRoot();
        DefaultMutableTreeNode localSite = (DefaultMutableTreeNode)model.getChild(root, 0);
        DefaultMutableTreeNode siteNode = (DefaultMutableTreeNode)model.getChild(localSite, localSite.getChildCount() - 1);
        if (siteNode == null) {
            return;
        }
        AddPartnerWizard dlg = new AddPartnerWizard(((SiteObject)localSite.getUserObject()).getSemSite(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.title.AddReplPartner"));
        if (dlg.isOk()) {
            this.refresh();
        }
        dlg.dispose();
    }

    public void deletePartner() {
        block10: {
            DefaultMutableTreeNode node;
            if (!this.objectExistsAfterRefresh()) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.error.DelPartner"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.title.PartnerRemoved"), 2);
            }
            if ((node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent()) == null) {
                return;
            }
            Partner partner = (Partner)node.getUserObject();
            if (partner == null) {
                return;
            }
            SemSite site = partner.getSemSite();
            if (!Manager.isLocalSite(site.getId())) {
                this.displayRemoteSiteWarning();
                return;
            }
            if (UIUtilities.isReplicating(partner)) {
                UIUtilities.showWarningDialog(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.warning.DeleteLater"));
                return;
            }
            if (0 != JOptionPane.showConfirmDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.ConfirmDelPartner"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.title.DelPartner"), 0)) {
                return;
            }
            try {
                ServerHandler.delPartner(partner);
                ConsoleLogger.logAdminEvent(16386, MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.PartnerNamed"), partner.getName()));
                DefaultMutableTreeNode selectionNode = node.getNextSibling();
                if (selectionNode == null && (selectionNode = node.getPreviousSibling()) == null) {
                    selectionNode = (DefaultMutableTreeNode)node.getParent();
                }
                DefaultTreeModel treeModel = (DefaultTreeModel)this.tree.getModel();
                treeModel.removeNodeFromParent(node);
                this.tree.setSelectionPath(new TreePath(selectionNode.getPath()));
                if (ReplicationScheduleUtility.getSiteMap().containsKey(partner.getId())) {
                    ReplicationScheduleUtility.getSiteMap().remove(partner.getId());
                }
                this.refresh();
            }
            catch (ConsoleException e) {
                JOptionPane.showMessageDialog(Manager.getFrame(), e.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.title.ConsoleError"), 0);
                if (!e.needRelogin()) break block10;
                Manager.getFrame().showLoginPanel();
            }
        }
    }

    public void editPartner() {
        PartnerDlg dlg;
        block11: {
            Partner remotePartner;
            if (!this.objectExistsAfterRefresh()) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.error.EditPartner"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.title.PartnerRemoved"), 2);
            }
            if ((remotePartner = (Partner)this.getSelectedTreeNodeUserObject()) == null) {
                return;
            }
            SemSite localSite = remotePartner.getSemSite();
            if (!this.isReadOnly(localSite.getId()) && !Manager.isLocalSite(localSite.getId())) {
                this.displayRemoteSiteWarning();
                return;
            }
            ReplicationPartnership remotePartnership = remotePartner.getReplicationPartnership();
            ReplicationContent remotePartnerReplicationContent = remotePartnership.getOptReplicationContent();
            boolean replicateClientPackages_Original = Utility.getBooleanValue((Boolean)remotePartnerReplicationContent.getOptReplicateClientPackages(), (Boolean)remotePartnerReplicationContent.getDefReplicateClientPackages());
            boolean readOnly = this.isReadOnly(localSite.getId());
            dlg = new PartnerDlg(remotePartner, readOnly);
            if (dlg.isOk()) {
                try {
                    boolean updateUSNforClientPackages = false;
                    boolean updateUSNforLuContents = false;
                    boolean updateUSNforReport = false;
                    boolean replicateClientPackages_New = remotePartnerReplicationContent.getOptReplicateClientPackages();
                    if (!replicateClientPackages_Original && replicateClientPackages_New) {
                        updateUSNforClientPackages = true;
                        updateUSNforLuContents = true;
                    }
                    boolean replicateLogs_Original = Utility.getBooleanValue((Boolean)dlg.replicateLogsToRemotePartnerOrg(), (Boolean)remotePartnerReplicationContent.getDefReplicateLogs());
                    boolean replicateLogs_New = dlg.replicateLogsToRemotePartner();
                    if (!replicateLogs_Original && replicateLogs_New) {
                        updateUSNforReport = true;
                    }
                    ServerHandler.updatePartner(remotePartner, dlg.replicateLogsToRemotePartner(), updateUSNforClientPackages, updateUSNforLuContents, updateUSNforReport);
                    ConsoleLogger.logAdminEvent(16391, MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.PartnerNamed"), remotePartner.getName()));
                    this.refresh();
                    if (dlg.isReplicationScheduleChanged()) {
                        JOptionPane.showMessageDialog(Manager.getFrame(), dlg.isInitiatorSite() ? resource.getString("PartnerDlg.info.SettingChangedGeneral") : MessageFormat.format(resource.getString("PartnerDlg.info.SettingChangedByReciever"), ServerHandler.retrieveSite(remotePartner.getName()).getName()), resource.getString("PartnerDlg.title.Information"), 1);
                    } else if (dlg.isOtherSettingFlagChanged().booleanValue()) {
                        JOptionPane.showMessageDialog(Manager.getFrame(), resource.getString("PartnerDlg.info.SettingChangedGeneral"), resource.getString("PartnerDlg.title.Information"), 1);
                    }
                }
                catch (ConsoleException e) {
                    LoggerUtilities.logException((Throwable)e);
                    JOptionPane.showMessageDialog(Manager.getFrame(), e.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.title.ConsoleError"), 0);
                    if (!e.needRelogin()) break block11;
                    Manager.getFrame().showLoginPanel();
                }
            }
        }
        dlg.dispose();
    }

    public void replicateNow() {
        SemServer firstServer = this.getFirstServer();
        if (!this.isFirstServer(firstServer)) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.error.FirstSvrRepl"), firstServer == null ? "" : firstServer.getName()), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.title.ReplFailed"), 2);
        } else {
            Partner partner;
            if (!this.objectExistsAfterRefresh()) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.error.ReplPartner"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.title.PartnerRemoved"), 2);
            }
            if ((partner = (Partner)this.getSelectedTreeNodeUserObject()) == null) {
                return;
            }
            if (!Manager.isLocalSite(partner.getSemSite().getId())) {
                this.displayRemoteSiteWarning();
                return;
            }
            if (UIUtilities.isReplicating(partner)) {
                UIUtilities.showWarningDialog(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.warning.ReplicateLater"));
                return;
            }
            if (0 != JOptionPane.showConfirmDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.ConfirmOneTimeRepl"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.title.ReplNow"), 0)) {
                return;
            }
            this.performReplicate(partner);
        }
    }

    public void cancelReplicate() {
        SemServer firstServer = this.getFirstServer();
        if (!this.isFirstServer(firstServer)) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.error.FirstSvrReplCancel"), firstServer == null ? "" : firstServer.getName()), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.title.CancelReplFailed"), 2);
        } else {
            Partner partner;
            if (!this.objectExistsAfterRefresh()) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.error.CancelReplPartner"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.title.PartnerRemoved"), 2);
            }
            if ((partner = (Partner)this.getSelectedTreeNodeUserObject()) == null) {
                return;
            }
            if (!Manager.isLocalSite(partner.getSemSite().getId())) {
                this.displayRemoteSiteWarning();
                return;
            }
            if (!UIUtilities.isReplicating(partner)) {
                UIUtilities.showWarningDialog(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.warning.ReplicateNotRunning"));
                return;
            }
            if (0 != JOptionPane.showConfirmDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.ConfirmCancelRepl"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.title.CancelRepl"), 0)) {
                return;
            }
            this.performCancelReplicate(partner);
        }
    }

    private SemServer getFirstServer() {
        SemServer firstServer = null;
        String siteGuid = DataobjectManager.getInstance().getLoginInformation().getSiteGUID();
        try {
            SemSite semSite = DataobjectManager.getInstance().getSemSite(siteGuid);
            ServerArray serverArray = semSite.getServerArray();
            firstServer = serverArray.getSemServer(0);
        }
        catch (Exception e) {
            LoggerUtilities.logException((Throwable)e);
        }
        return firstServer;
    }

    public void aboutManageServer() {
        HelpUtil.showHelp(null);
    }

    public void aboutAddSite() {
        HelpUtil.showHelp(null);
    }

    public void aboutRemoteSites() {
        HelpUtil.showHelp("sesm_admin_pane_remote_sites");
    }

    public void aboutRestoreSite() {
        HelpUtil.showHelp(null);
    }

    public void editSite() {
        SitePropertiesDlg dlg;
        block6: {
            SiteObject siteObject;
            if (!this.objectExistsAfterRefresh()) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.error.EditSiteRemoved"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.title.SiteRemoved"), 2);
            }
            if ((siteObject = (SiteObject)this.getSelectedTreeNodeUserObject()) == null) {
                return;
            }
            dlg = new SitePropertiesDlg(siteObject, this.isReadOnly(siteObject.getId()));
            if (dlg.isOk()) {
                siteObject = dlg.getModel();
                try {
                    siteObject = new SiteObject((SemSite)DataobjectManager.getInstance().updateObject("Merge", (TopLevelObject)siteObject.getSemSite()));
                    ConsoleLogger.logAdminEvent(16388, MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.SiteNamed"), siteObject.getName()));
                    if (Manager.isLocalSite(siteObject.getId())) {
                        siteObject.setDisplayName(MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.LocalSiteNamed"), siteObject.getName()));
                    }
                    this.refresh();
                }
                catch (ConsoleException ex) {
                    JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.title.ConsoleError"), 0);
                    if (!ex.needRelogin()) break block6;
                    Manager.getFrame().showLoginPanel();
                }
            }
        }
        dlg.dispose();
    }

    public void deleteSite() {
        block7: {
            SiteObject siteObject;
            if (!this.objectExistsAfterRefresh()) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.error.DelSiteRemoved"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.title.SiteRemoved"), 2);
            }
            if ((siteObject = (SiteObject)this.getSelectedTreeNodeUserObject()) == null) {
                return;
            }
            if (Manager.isLocalSite(siteObject.getId())) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.error.DelConnSite"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.title.DelConnSite"), 0);
                return;
            }
            if (this.isSiteInUse(siteObject)) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.error.InUseSite"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.title.InUseSite"), 2);
                return;
            }
            if (0 != JOptionPane.showConfirmDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.error.DelRemoteSite"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.title.DelRemoteSite"), 0)) {
                return;
            }
            try {
                ServerHandler.deleteSite(siteObject);
                ConsoleLogger.logAdminEvent(16387, MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.SiteNamed"), siteObject.getName()));
                this.refresh();
            }
            catch (ConsoleException ex) {
                JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.title.ConsoleError"), 0);
                if (!ex.needRelogin()) break block7;
                Manager.getFrame().showLoginPanel();
            }
        }
    }

    public void editServer() {
        ServerObject server;
        if (!this.objectExistsAfterRefresh()) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.error.EditSvrRemoved"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.title.SvrRemoved"), 2);
        }
        if ((server = (ServerObject)this.getSelectedTreeNodeUserObject()) == null) {
            return;
        }
        ServersPanel.showEditServerDialog(server);
        this.refresh();
    }

    public void deleteServer() {
        block11: {
            DefaultMutableTreeNode node;
            if (!this.objectExistsAfterRefresh()) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.error.DelSvrRemoved"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.title.SvrRemoved"), 2);
            }
            if ((node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent()) == null) {
                return;
            }
            ServerObject server = (ServerObject)node.getUserObject();
            if (server == null) {
                return;
            }
            DefaultMutableTreeNode siteNode = (DefaultMutableTreeNode)node.getParent();
            SiteObject siteObject = (SiteObject)siteNode.getUserObject();
            if (siteObject == null) {
                return;
            }
            if (!Manager.isLocalSite(siteObject.getId())) {
                this.displayRemoteSiteWarning();
                return;
            }
            if (Manager.isLocalServer(server.getId())) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.error.DelConnSPM"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.title.Warning"), 2);
                return;
            }
            if (0 != JOptionPane.showConfirmDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.ConfirmDelSvr"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.title.DelSvr"), 0)) {
                return;
            }
            try {
                boolean deleted = ServerHandler.delServer(server);
                if (!deleted) {
                    return;
                }
                ConsoleLogger.logAdminEvent(16404, MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.ServerNamed"), server.getName()));
                DefaultMutableTreeNode selectionNode = node.getNextSibling();
                if (selectionNode == null && (selectionNode = node.getPreviousSibling()) == null) {
                    selectionNode = (DefaultMutableTreeNode)node.getParent();
                }
                DefaultTreeModel treeModel = (DefaultTreeModel)this.tree.getModel();
                treeModel.removeNodeFromParent(node);
                this.tree.setSelectionPath(new TreePath(selectionNode.getPath()));
            }
            catch (ConsoleException e) {
                JOptionPane.showMessageDialog(Manager.getFrame(), e.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.title.Error"), 0);
                if (!e.needRelogin()) break block11;
                Manager.getFrame().showLoginPanel();
            }
        }
    }

    public void editLicense() {
        if (JOptionPane.showConfirmDialog(Manager.getFrame(), UPDATE_LICENSE_WARNING, LICENSE_MANAGEMENT, 0, 2) != 0) {
            return;
        }
        File file = this.getFile(true, XML_EXTENSION, XML_DESCRIPTION);
        if (file == null) {
            return;
        }
        String content = Utility.getFileContent((File)file);
        ScmLicense scmLicense = new ScmLicense(content);
        if (!scmLicense.isValid()) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.error.InvalidLicFile"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.title.LicError"), 0);
            return;
        }
        if (scmLicense.isLicenseExpired()) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.error.ExpiredLic"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.title.LicError"), 0);
            return;
        }
        DataobjectManager manager = DataobjectManager.getInstance();
        try {
            SemConfigRoot root = manager.getSemConfigRoot();
            License license = root.getLicense();
            LicenseCode licenseCode = license.getLicenseCode(0);
            ScmLicense oldLicense = new ScmLicense(licenseCode.getContent());
            if (oldLicense.isPerpetual() && !scmLicense.isPerpetual() && 0 != JOptionPane.showConfirmDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.ConfirmEvalLicReplace"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.title.Warning"), 0)) {
                return;
            }
            licenseCode.setContent(content);
            license.setLicenseCode(0, licenseCode);
            manager.updateObject(null, (TopLevelObject)root);
            AdminHandler.refreshCurrentAdmin();
            AdminObject admin = AdminObject.retrieveCurrentAdminObject();
            admin.setNotifyMtnLicenseExpiration(true);
            admin.update();
            this.refresh();
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        JOptionPane.showMessageDialog(Manager.getFrame(), LOGOUT_CONSOLE, LICENSE_MANAGEMENT, 1);
        Manager.getFrame().showLoginPanel();
    }

    public void importCertificate() {
        ServerObject server;
        if (!this.objectExistsAfterRefresh()) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.error.ImportSvrRemoved"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.title.SvrRemoved"), 2);
        }
        if ((server = (ServerObject)this.getSelectedTreeNodeUserObject()) == null) {
            return;
        }
        if (!Manager.isLocalServer(server.getId())) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.error.UpdateSvrConn"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.title.Warning"), 2);
            return;
        }
        ImportCertificateWizard wizard = new ImportCertificateWizard(server.toString());
        wizard.dispose();
    }

    public void configureRSA() {
        ServerObject server = (ServerObject)this.getSelectedTreeNodeUserObject();
        if (server == null) {
            return;
        }
        if (!Manager.isLocalServer(server.getId())) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.error.RSAConfigSvrConn"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.title.Warning"), 2);
            return;
        }
        ConfigureRSAWizard wizard = new ConfigureRSAWizard(server);
        wizard.dispose();
    }

    public void configureVip() {
        ServerObject server = (ServerObject)this.getSelectedTreeNodeUserObject();
        if (server == null) {
            return;
        }
        VipServerDialog vipDialog = new VipServerDialog(server, false);
        vipDialog.dispose();
    }

    public void configureSmartCard() {
        ServerObject server = (ServerObject)this.getSelectedTreeNodeUserObject();
        if (server == null) {
            return;
        }
        SmartCardDialog smartCardDialog = new SmartCardDialog(false);
        smartCardDialog.dispose();
    }

    public void editDatabase() {
        DatabasePropertiesDialog dialog;
        block7: {
            DefaultMutableTreeNode node;
            if (!this.objectExistsAfterRefresh()) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.error.DBRemoved"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.title.DBRemoved"), 2);
            }
            if ((node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent()) == null) {
                return;
            }
            DatabaseObject databaseObject = (DatabaseObject)node.getUserObject();
            if (databaseObject == null) {
                return;
            }
            DefaultMutableTreeNode siteNode = (DefaultMutableTreeNode)node.getParent();
            SiteObject siteObject = (SiteObject)siteNode.getUserObject();
            if (siteObject == null) {
                return;
            }
            boolean readOnly = this.isDbReadOnly(siteObject);
            dialog = new DatabasePropertiesDialog(siteObject.getSemSite(), readOnly);
            if (!readOnly && dialog.isOk()) {
                try {
                    ServerHandler.updateDatabase(siteObject.getSemSite());
                    this.refresh();
                    ConsoleLogger.logAdminEvent(16390);
                }
                catch (ConsoleException e) {
                    JOptionPane.showMessageDialog(Manager.getFrame(), e.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.title.ConsoleError"), 0);
                    if (!e.needRelogin()) break block7;
                    Manager.getFrame().showLoginPanel();
                }
            }
        }
        dialog.dispose();
    }

    public void backupNow() {
        block10: {
            DefaultMutableTreeNode node;
            if (!this.objectExistsAfterRefresh()) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.error.DBRemovedBackup"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.title.DBRemoved"), 2);
            }
            if ((node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent()) == null) {
                return;
            }
            DatabaseObject database = (DatabaseObject)node.getUserObject();
            if (database == null) {
                return;
            }
            DefaultMutableTreeNode siteNode = (DefaultMutableTreeNode)node.getParent();
            SiteObject siteObject = (SiteObject)siteNode.getUserObject();
            if (siteObject == null) {
                return;
            }
            if (Manager.isLocalSite(siteObject.getId())) {
                try {
                    int result = UIUtilities.confirmYesNoOptionDialog(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.InfoBackupStartedConfirmation"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.title.Backup"));
                    if (result == 0) {
                        String backupFileName = BackupUtils.getBackupFilename();
                        GUIManager.backup(backupFileName);
                        ConsoleLogger.logAdminEvent(16401);
                        Object backupFilePath = "";
                        String serverName = "";
                        SemSite semSite = siteObject.getSemSite();
                        ServerArray serverArray = semSite.getServerArray();
                        for (int i = 0; i < serverArray.getSemServerCount(); ++i) {
                            SemServer server = serverArray.getSemServer(i);
                            if (!Manager.isLocalServer(server.getId())) continue;
                            backupFilePath = server.getOptServerBackupConfig().getBackupFolderPath();
                            serverName = server.getName();
                            break;
                        }
                        backupFilePath = (String)backupFilePath + System.getProperty("file.separator") + backupFileName;
                        JOptionPane.showOptionDialog(Manager.getFrame(), MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.InfoBackupStarted"), serverName, backupFilePath), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.title.Backup"), 0, 1, null, this.option, this.option[0]);
                    }
                    break block10;
                }
                catch (ConsoleException ex) {
                    JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.title.ConsoleError"), 0);
                    if (ex.needRelogin()) {
                        Manager.getFrame().showLoginPanel();
                    }
                    break block10;
                }
            }
            this.displayRemoteSiteWarning();
            return;
        }
    }

    public void truncateTxnLog() {
        DefaultMutableTreeNode node;
        if (!this.objectExistsAfterRefresh()) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.error.DBRemovedBackup"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.title.DBRemoved"), 2);
        }
        if ((node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent()) == null) {
            return;
        }
        DatabaseObject database = (DatabaseObject)node.getUserObject();
        if (database == null) {
            return;
        }
        DefaultMutableTreeNode siteNode = (DefaultMutableTreeNode)node.getParent();
        if (siteNode == null) {
            return;
        }
        SiteObject siteObject = (SiteObject)siteNode.getUserObject();
        if (siteObject == null) {
            return;
        }
        if (!Manager.isLocalSite(siteObject.getId())) {
            this.displayRemoteSiteWarning();
            return;
        }
        TxnLogRunNowDlg txnLogDlg = new TxnLogRunNowDlg();
        txnLogDlg.dispose();
    }

    public void rebuildIndexes() {
        DefaultMutableTreeNode node;
        if (!this.objectExistsAfterRefresh()) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.error.DBRemovedBackup"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.title.DBRemoved"), 2);
        }
        if ((node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent()) == null) {
            return;
        }
        DatabaseObject database = (DatabaseObject)node.getUserObject();
        if (database == null) {
            return;
        }
        DefaultMutableTreeNode siteNode = (DefaultMutableTreeNode)node.getParent();
        if (siteNode == null) {
            return;
        }
        SiteObject siteObject = (SiteObject)siteNode.getUserObject();
        if (siteObject == null) {
            return;
        }
        if (!Manager.isLocalSite(siteObject.getId())) {
            this.displayRemoteSiteWarning();
            return;
        }
        ReIndexRunNowDlg reIndexDlg = new ReIndexRunNowDlg();
        reIndexDlg.dispose();
    }

    public void editExternalLogging() {
        block7: {
            DefaultMutableTreeNode node;
            if (!LicenseObject.getInstance().isExternalLogging()) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.error.LicLogDisabled"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.title.LicError"), 2);
                return;
            }
            if (!this.objectExistsAfterRefresh()) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.error.SiteConfigLogRemoved"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.title.SiteRemoved"), 2);
            }
            if ((node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent()) == null) {
                return;
            }
            try {
                SiteObject siteObject;
                ExternalLoggingPropertiesDlg dlg;
                TreeItem item = (TreeItem)node.getUserObject();
                if (!(item instanceof SiteObject)) {
                    item = (TreeItem)((DefaultMutableTreeNode)node.getParent()).getUserObject();
                }
                if ((dlg = new ExternalLoggingPropertiesDlg(siteObject = (SiteObject)item, this.isSiteReadOnly(siteObject))).isOk() && dlg.updateModel(siteObject)) {
                    ServerHandler.updateSite(siteObject);
                    ConsoleLogger.logAdminEvent(16402, MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.SiteNamed"), siteObject.getName()));
                }
                dlg.dispose();
            }
            catch (ConsoleException ex) {
                JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.title.ConsoleError"), 0);
                if (!ex.needRelogin()) break block7;
                Manager.getFrame().showLoginPanel();
            }
        }
    }

    public void showLUStatus() {
        LuDownloadStatusDlg.showStatus();
    }

    public void showLULatestDownload() {
        LuLatestDownloadDlg dlg = new LuLatestDownloadDlg(Manager.getFrame());
        dlg.setVisible(true);
    }

    public void downloadLuContents() {
        if (LicenseObject.getInstance().isSBProduct()) {
            try {
                if (!LicenseHandler.hasValidLicense()) {
                    String msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.licenseExpired.message");
                    String title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.licenseExpired.title");
                    JOptionPane.showMessageDialog(this, msg, title, 0);
                    return;
                }
            }
            catch (ConsoleException e) {
                LoggerUtilities.logException((Throwable)e);
            }
        }
        LuDownloadNowDlg dlg = new LuDownloadNowDlg(Manager.getFrame(), "", true);
        dlg.setVisible(true);
        if (dlg.isOk()) {
            ServerSystemLogMonitor.getLuStatusMonitor().setMonitorStartTime(TimeUtil.getServerTime());
            try {
                GUIManager.runLuNow();
            }
            catch (ConsoleException ce) {
                LoggerUtilities.logException((Throwable)ce);
            }
            this.showLUStatus();
        }
    }

    @Override
    public void refresh() {
        this.refreshTaskBarViews();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportServer() {
        ServerObject server;
        if (!this.objectExistsAfterRefresh()) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.SvrEditRemoved"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.title.SvrRemoved"), 2);
        }
        if ((server = (ServerObject)this.getSelectedTreeNodeUserObject()) == null) {
            return;
        }
        JFileChooser fc = new JFileChooser();
        fc.setSelectedFile(new File(fc.getCurrentDirectory(), server.getParentSite().getName() + "_" + server.getName() + "_server_properties.xml"));
        fc.setFileSelectionMode(0);
        fc.setApproveButtonText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.button.Export"));
        fc.setDialogTitle(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.title.ExportSvrProps"));
        LogFileFilter logFileFilter = new LogFileFilter(XML_EXTENSION);
        FileFilter fileFilter = fc.getFileFilter();
        if (fileFilter != null) {
            fc.removeChoosableFileFilter(fileFilter);
        }
        fc.setFileFilter(logFileFilter);
        File file = null;
        if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
            fc.setDialogType(1);
            fc.setSelectedFile(new File(server.getName() + ".xml"));
            if (0 != fc.showSaveDialog(Manager.getFrame())) {
                return;
            }
            file = fc.getSelectedFile();
            if (file == null) {
                return;
            }
        } else {
            if (0 != fc.showOpenDialog(Manager.getFrame())) {
                return;
            }
            file = fc.getSelectedFile();
            if (file == null) {
                return;
            }
            Object path = file.getPath();
            if (!((String)path).endsWith(".xml")) {
                path = (String)path + ".xml";
            }
            if ((file = new File((String)path)).exists() && 0 != JOptionPane.showConfirmDialog(Manager.getFrame(), MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.ConfirmOverwriteExistFile"), file.getAbsolutePath()), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.title.ExportSvrProps"), 0)) {
                return;
            }
        }
        boolean excepFlag = false;
        SemServer semServer = server.getSemServer();
        OutputStream fos = null;
        try {
            fos = new BufferedOutputStream(new FileOutputStream(file));
            semServer.writeXML(fos);
            fos.flush();
        }
        catch (Throwable ex) {
            excepFlag = true;
            LoggerUtilities.logException((Throwable)ex);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Throwable ex) {
                    excepFlag = true;
                }
            }
        }
        if (!AjaxSwingCommonUtil.isAjaxSwingRunning() && !excepFlag) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.exportServerSuccessMsg"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.title.ExportSvrProps"), 1);
        }
    }

    public void importServer() {
        ServerObject server = this.getServerForImport();
        if (server == null) {
            return;
        }
        JFileChooser fc = new JFileChooser();
        fc.setDialogType(0);
        fc.setFileSelectionMode(0);
        fc.setApproveButtonText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.button.Import"));
        fc.setDialogTitle(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.title.ImportSvrProps"));
        String chooserDesc = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.FileType.xml");
        LogFileFilter logFileFilter = new LogFileFilter(XML_EXTENSION, chooserDesc);
        FileFilter fileFilter = fc.getFileFilter();
        if (fileFilter != null) {
            fc.removeChoosableFileFilter(fileFilter);
        }
        fc.setFileFilter(logFileFilter);
        if (0 != fc.showOpenDialog(Manager.getFrame())) {
            return;
        }
        File file = fc.getSelectedFile();
        this.importServer(server, file);
    }

    private void importServer(ServerObject server, File file) {
        if (file == null) {
            return;
        }
        String filePath = AjaxSwingUtil.getDisplayFileName(file);
        if (!file.exists()) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.error.NamedFileExist"), filePath), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.title.ImportSvrProps"), 2);
            return;
        }
        if (0 != JOptionPane.showConfirmDialog(Manager.getFrame(), MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.ConfirmImportSvrProps"), filePath), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.title.ImportSvrProps"), 0)) {
            return;
        }
        System.out.println("ServersPanel>> importServer: Begin... File=" + file.getAbsolutePath());
        SemServer semServerFile = null;
        boolean excepFlag = false;
        try (FileInputStream fis = new FileInputStream(file);
             BufferedInputStream bis = new BufferedInputStream(fis);){
            semServerFile = (SemServer)SemServer.readXML((InputStream)bis);
        }
        catch (Throwable ex) {
            ConsoleLogger.log(ex);
        }
        if (semServerFile == null) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.error.PropsFormat"), filePath), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.title.ImportSvrProps"), 2);
            excepFlag = true;
        }
        SemServer semServerMem = server.getSemServer();
        ServersPanel.printSemServer(semServerMem, "before merge - mem");
        if (semServerFile != null) {
            ServersPanel.printSemServer(semServerFile, "before merge - file");
        }
        ServersPanel.importSemServer(semServerFile, semServerMem);
        ServersPanel.printSemServer(semServerMem, "after merge - mem");
        SemSite semSite = server.getParentSite();
        try {
            DataobjectManager.getInstance().updateObject("Merge", (TopLevelObject)semSite);
            ConsoleLogger.logAdminEvent(16389, MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.SvrNamed"), server.getName()));
            this.refresh();
        }
        catch (ConsoleException ce) {
            JOptionPane.showMessageDialog(Manager.getFrame(), ce.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.title.Error"), 0);
            if (ce.needRelogin()) {
                Manager.getFrame().showLoginPanel();
            }
            excepFlag = true;
        }
        NetworkACL acl = semServerMem.getConsoleNetworkACL().getNetworkACL();
        if (!ServerHandler.isCurrentConsoleAllowedAccess(acl)) {
            System.out.println("ServersPanel>> importServer: ServerHandler.isCurrentConsoleAllowedAccess is FALSE! Then relogin!");
            Manager.getFrame().showLoginPanel();
            excepFlag = true;
        }
        if (!excepFlag) {
            System.out.println("ServersPanel>> importServer: Done!");
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.SuccessFullServerPropImport"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.title.ImportSvrProps"), 1);
        }
    }

    public void resetSlideComponent(SideBar bar, JPanel panel) {
        this.sideBar = bar;
        this.rightComponent = panel;
    }

    public static void showEditServerDialog(ServerObject server) {
        ServerPropertiesDlg dlg;
        Integer privilege = privilegeMap.get(server.getId());
        boolean readOnly = false;
        if (privilege != null && privilege == 2) {
            readOnly = true;
        }
        if ((dlg = new ServerPropertiesDlg(server, readOnly)).isOk()) {
            boolean isCurrentConsoleAllowedAccess;
            block5: {
                server = dlg.getModel();
                isCurrentConsoleAllowedAccess = dlg.isConsoleAccessAllowed();
                SemSite semSite = server.getParentSite();
                try {
                    DataobjectManager.getInstance().updateObject("Merge", (TopLevelObject)semSite);
                    ConsoleLogger.logAdminEvent(16389, MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.ServerNamed"), server.getName()));
                }
                catch (ConsoleException ce) {
                    JOptionPane.showMessageDialog(Manager.getFrame(), ce.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.title.Error"), 0);
                    if (!ce.needRelogin()) break block5;
                    Manager.getFrame().showLoginPanel();
                }
            }
            if (!isCurrentConsoleAllowedAccess) {
                Manager.getFrame().showLoginPanel();
            }
        }
        dlg.dispose();
    }

    public void openFile(File file) {
        ServerObject server = this.getServerForImport();
        if (server == null) {
            return;
        }
        this.importServer(server, file);
    }

    private ServerObject getServerForImport() {
        if (!this.objectExistsAfterRefresh()) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.error.SvrEditRemoved"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.title.SvrRemoved"), 2);
        }
        ServerObject server = (ServerObject)this.getSelectedTreeNodeUserObject();
        return server;
    }

    public static void modifyTreeModelBaseOnSitePrivilegeSet(TreeModel treeModel, AdminObject currentAdmin) {
        AdminObject admin = null;
        admin = currentAdmin == null ? AdminObject.retrieveCurrentAdminObject() : currentAdmin;
        if (admin.isSysAdmin()) {
            return;
        }
        privilegeMap.clear();
        AdminPrivilegeObject privilegeObject = admin.getAdminPrivilege();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)treeModel.getRoot();
        int size = root.getChildCount();
        int i = 0;
        while (i < size) {
            DefaultMutableTreeNode subNode = (DefaultMutableTreeNode)root.getChildAt(i);
            if (subNode.getUserObject() instanceof ContainerObject) {
                int remoteSites = subNode.getChildCount();
                int j = 0;
                while (j < remoteSites) {
                    DefaultMutableTreeNode remoteSite = (DefaultMutableTreeNode)subNode.getChildAt(j);
                    if (!ServersPanel.modifySiteBaseOnSitePrivilege(remoteSite, privilegeObject)) {
                        ++j;
                        continue;
                    }
                    remoteSites = subNode.getChildCount();
                }
                if (subNode.getChildCount() == 0) {
                    root.remove(subNode);
                    size = root.getChildCount();
                    continue;
                }
                ++i;
                continue;
            }
            if (!ServersPanel.modifySiteBaseOnSitePrivilege(subNode, privilegeObject)) {
                ++i;
                continue;
            }
            size = root.getChildCount();
        }
    }

    private void treeSelectionChanged() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        TreeItem item = (TreeItem)node.getUserObject();
        if (item instanceof LicenseObject) {
            item = LicenseObject.getInstance();
            node.setUserObject(item);
        }
        this.setComponent(item, node);
    }

    private void setComponent(TreeItem item, DefaultMutableTreeNode node) {
        this.setComponent(item);
    }

    private void setComponent(TreeItem item) {
        int itemType = item.getItemType();
        String title = null;
        title = itemType == 13 && !Manager.isLocalSite(item.getId()) ? titleMap.get(191) : titleMap.get(itemType);
        if (title == null) {
            title = SERVER_TITLE;
        }
        this.getRightSidePane().setTitle(title);
        TabbedPageModel tabbedPage = this.getTabbedPage(item);
        if (tabbedPage != null) {
            tabbedPage.setSelectedItem(item);
            this.setTopComponent((Component)((Object)tabbedPage));
            this.setCurrentTaskPanel(this.getRightSidePane());
        } else {
            this.setTopComponent(this.blankPanel);
            this.setCurrentTaskPanel(this.getRightSidePane());
        }
        if (tabbedPage instanceof ServerBasePanel) {
            ServerBasePanel serverSubPanel = (ServerBasePanel)tabbedPage;
            if (item instanceof ServerObject) {
                ServerObject server = (ServerObject)item;
                SemServerState state = server.getServerState();
                DataobjectManager manager = DataobjectManager.getInstance();
                try {
                    state = manager.getSemServerState(server.getId());
                    SemSite semSite = server.getParentSite();
                    if (semSite != null && Manager.isLocalSite(semSite.getId())) {
                        Integer status;
                        Integer n = status = DataobjectManager.isServerOnline(state) ? Integer.valueOf(0) : Integer.valueOf(1);
                        if (!status.equals(state.getOptStatus())) {
                            state.setOptStatus(status);
                        }
                    }
                    for (IpAddress ip : state.getIpAddress()) {
                        ip.setContent(Utilities.shortenIpv6Address(ip.getContent()));
                    }
                    server.setServerState(state);
                    serverSubPanel.refreshRightTable(server);
                }
                catch (ConsoleException e) {
                    LoggerUtilities.logException((Throwable)e);
                }
            }
            this.setSideBarTasks(PAGE_NAME, serverSubPanel.getTaskList(item));
        } else {
            this.setSideBarTasks(PAGE_NAME, new ArrayList<List<TaskObject>>());
        }
    }

    private ServerTaskPane getRightSidePane() {
        if (this.rightSidePane == null) {
            this.rightSidePane = new ServerTaskPane();
        }
        return this.rightSidePane;
    }

    private void setTopComponent(Component component) {
        int loc = this.getSplitPane().getDividerLocation();
        this.getSplitPane().setTopComponent(component);
        if (loc == 0) {
            this.getSplitPane().setDividerLocation(0.8);
            this.getSplitPane().setResizeWeight(1.0);
        } else {
            this.getSplitPane().setDividerLocation(loc);
        }
    }

    private JSplitPane getSplitPane() {
        if (this.splitPane == null) {
            this.splitPane = new JSplitPane(0);
            this.splitPane.setBorder(BorderFactory.createEmptyBorder());
            this.splitPane.setTopComponent(this.blankPanel);
            JScrollPane areaScroll = new JScrollPane(this.getMonitoringArea());
            this.splitPane.setBottomComponent(areaScroll);
            this.splitPane.setDividerLocation(1.0);
            this.splitPane.setResizeWeight(0.89);
        }
        return this.splitPane;
    }

    private JTextArea getMonitoringArea() {
        if (this.monitoringArea == null) {
            this.monitoringArea = new JTextArea();
            this.monitoringArea.setRows(4);
            this.monitoringArea.setEditable(false);
        }
        return this.monitoringArea;
    }

    private TabbedPageModel getTabbedPage(TreeItem item) {
        int itemType = item.getItemType();
        TabbedPageModel panel = null;
        Object id = Integer.toString(itemType);
        boolean exist = true;
        boolean readOnly = false;
        switch (itemType) {
            case 4: {
                panel = this.panelMap.get(id);
                if (panel != null) break;
                exist = false;
                panel = new ServersWelcomePanel();
                break;
            }
            case 13: {
                SiteObject site = (SiteObject)item;
                readOnly = this.isReadOnly(site.getId());
                id = (String)id + Boolean.toString(readOnly);
                panel = this.panelMap.get(id);
                if (panel != null) break;
                exist = false;
                panel = new SiteStatusPanel(readOnly);
                break;
            }
            case 14: {
                ServerObject server = (ServerObject)item;
                readOnly = this.isReadOnly(server.getId());
                id = (String)id + Boolean.toString(readOnly);
                panel = this.panelMap.get(id);
                if (panel != null) break;
                exist = false;
                panel = new ServerStatusPanel(readOnly);
                break;
            }
            case 15: {
                DatabaseObject db = (DatabaseObject)item;
                readOnly = this.isReadOnly(db.getId());
                id = (String)id + Boolean.toString(readOnly);
                panel = this.panelMap.get(id);
                if (panel == null) {
                    exist = false;
                    panel = new DbStatusPanel(readOnly);
                }
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
                DefaultMutableTreeNode siteNode = (DefaultMutableTreeNode)node.getParent();
                SiteObject siteObject = (SiteObject)siteNode.getUserObject();
                ((DbStatusPanel)panel).setSiteId(siteObject.getSemSite().getId());
                if (Manager.isLocalSite(siteObject.getId())) {
                    ((DbStatusPanel)panel).setDbUser(GUIManager.getDbUser());
                    break;
                }
                ((DbStatusPanel)panel).setDbUser(db.getDBOperatorUserName());
                break;
            }
            case 17: {
                PartnerGroup partnerGroup = (PartnerGroup)item;
                readOnly = this.isReadOnly(partnerGroup.getSiteId());
                id = (String)id + Boolean.toString(readOnly);
                panel = this.panelMap.get(id);
                if (panel != null) break;
                exist = false;
                panel = new PartnerListPanel(readOnly);
                break;
            }
            case 18: {
                Partner partner = (Partner)item;
                readOnly = this.isReadOnly(partner.getLocalSiteId());
                id = (String)id + Boolean.toString(readOnly);
                panel = this.panelMap.get(id);
                if (panel != null) break;
                exist = false;
                panel = new PartnerStatusPanel(readOnly, ServersPanel.isPartnerSiteRemovable(partner));
                break;
            }
            case 19: {
                panel = this.panelMap.get(id);
                if (panel != null) break;
                exist = false;
                panel = new RemoteSitePanel(true);
                break;
            }
        }
        if (!exist) {
            this.panelMap.put((String)id, panel);
        }
        return panel;
    }

    private static boolean isPartnerSiteRemovable(Partner partner) {
        try {
            boolean isLocalOk;
            String partnerSiteName = partner.getReplicationPartnership().getPartnerSiteName();
            PrivilegeContext context = DataobjectManager.getInstance().getCurrentPrivilegeContext();
            SemSite remote = SchemaHelper.getSemSiteByName(DataobjectManager.getInstance().getAllSemSite(), (String)partnerSiteName);
            boolean isRemoteOk = true;
            if (remote != null) {
                isRemoteOk = ServersPanel.checkPermissionForSite(context, remote);
            }
            return (isLocalOk = ServersPanel.checkPermissionForSite(context, partner.getSemSite())) && isRemoteOk;
        }
        catch (ConsoleException e) {
            ConsoleLogger.log(e);
            return false;
        }
    }

    private static boolean checkPermissionForSite(PrivilegeContext context, SemSite site) {
        AuthorizationManager manager = AuthorizationManager.getInstance();
        return manager.checkPermission(context, (Permission)new SitePermission(site, BasicPermission.AccessAction.FULL_ACCESS));
    }

    private boolean isSiteReadOnly(SiteObject siteObject) {
        if (siteObject == null) {
            return true;
        }
        PrivilegeContext context = DataobjectManager.getInstance().getCurrentPrivilegeContext();
        return !AdminACLUtils.checkSiteFullAccessPermission((PrivilegeContext)context, (SemSite)siteObject.getSemSite());
    }

    private boolean isDbReadOnly(SiteObject siteObject) {
        if (siteObject == null) {
            return true;
        }
        PrivilegeContext context = DataobjectManager.getInstance().getCurrentPrivilegeContext();
        return !AdminACLUtils.checkDbFullAccessPermission((PrivilegeContext)context, (SemSite)siteObject.getSemSite());
    }

    private boolean isReadOnly(String id) {
        AdminObject admin = AdminObject.retrieveCurrentAdminObject();
        if (admin.isSysAdmin()) {
            return false;
        }
        if (id == null || id.trim().length() == 0) {
            return true;
        }
        Integer privilege = privilegeMap.get(id);
        if (privilege == null) {
            return false;
        }
        return privilege != 0;
    }

    private void maybeShowPopup(MouseEvent e) {
        int selRow = this.tree.getRowForLocation(e.getX(), e.getY());
        if (selRow == -1) {
            return;
        }
        this.tree.setSelectionRow(selRow);
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        if (e.isPopupTrigger()) {
            TreeItem treeItem = (TreeItem)node.getUserObject();
            if (treeItem == null) {
                return;
            }
            JPopupMenu popup = this.setupPopupMenu(treeItem);
            if (popup != null) {
                popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    private JPopupMenu setupPopupMenu(TreeItem item) {
        JPopupMenu popup = null;
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServersPanel.this.menuActionPerformed(e);
            }
        };
        TabbedPageModel tabbedPage = this.getTabbedPage(item);
        if (tabbedPage != null) {
            tabbedPage.setSelectedItem(item);
        }
        if (tabbedPage instanceof ServerBasePanel) {
            ServerBasePanel serverSubPanel = (ServerBasePanel)tabbedPage;
            popup = serverSubPanel.getPopupMenu(item, listener);
        }
        return popup;
    }

    private void menuActionPerformed(ActionEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        TreeItem item = (TreeItem)node.getUserObject();
        if (item == null) {
            return;
        }
        JMenuItem source = (JMenuItem)e.getSource();
        String menu = source.getText();
        int taskIndex = (Integer)source.getClientProperty(menu);
        TabbedPageModel tabbedPage = this.getTabbedPage(item);
        if (tabbedPage != null) {
            tabbedPage.setSelectedItem(item);
        }
        if (tabbedPage instanceof ServerBasePanel) {
            ServerBasePanel serverSubPanel = (ServerBasePanel)tabbedPage;
            serverSubPanel.executeTask(taskIndex, null);
        }
    }

    private boolean objectExistsAfterRefresh() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (node == null) {
            return false;
        }
        TreeItem item = (TreeItem)node.getUserObject();
        if (item == null) {
            return false;
        }
        String selectedItemId = item.getId();
        this.refreshTaskBarViews();
        DefaultMutableTreeNode newNode = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (newNode == null) {
            return false;
        }
        TreeItem newItem = (TreeItem)newNode.getUserObject();
        if (newItem == null) {
            return false;
        }
        String newSelectedItemId = newItem.getId();
        return newSelectedItemId != null && newSelectedItemId.equals(selectedItemId);
    }

    private HashMap<String, ItemVisualStatus> noteTreeVisualStatus() {
        DefaultMutableTreeNode root;
        TreeItem item;
        DefaultMutableTreeNode selectedNode;
        if (this.tree == null) {
            return null;
        }
        TreePath selectionPath = this.tree.getSelectionPath();
        String selectedItemId = null;
        if (selectionPath != null && (selectedNode = (DefaultMutableTreeNode)selectionPath.getLastPathComponent()) != null && selectedNode.getUserObject() instanceof TreeItem && (item = (TreeItem)selectedNode.getUserObject()) != null) {
            selectedItemId = item.getId();
        }
        if ((root = (DefaultMutableTreeNode)this.tree.getModel().getRoot()) == null) {
            return null;
        }
        HashMap<String, ItemVisualStatus> map = new HashMap<String, ItemVisualStatus>();
        Enumeration<TreeNode> allNodes = root.breadthFirstEnumeration();
        while (allNodes.hasMoreElements()) {
            DefaultMutableTreeNode nextNode = (DefaultMutableTreeNode)allNodes.nextElement();
            if (!(nextNode.getUserObject() instanceof TreeItem)) continue;
            TreeItem item2 = (TreeItem)nextNode.getUserObject();
            String id = item2 == null ? null : item2.getId();
            TreePath nodePath = new TreePath(nextNode.getPath());
            boolean expanded = this.tree.isExpanded(nodePath);
            boolean selected = id != null && id.equals(selectedItemId);
            ItemVisualStatus status = new ItemVisualStatus(expanded, selected);
            map.put(id, status);
        }
        return map;
    }

    private void applyTreeVisualStatus(HashMap<String, ItemVisualStatus> map) {
        if (this.tree == null || map == null) {
            return;
        }
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.tree.getModel().getRoot();
        if (root == null) {
            return;
        }
        Enumeration<TreeNode> allNodes = root.breadthFirstEnumeration();
        while (allNodes.hasMoreElements()) {
            ItemVisualStatus status;
            TreeItem item;
            String id;
            DefaultMutableTreeNode nextNode = (DefaultMutableTreeNode)allNodes.nextElement();
            if (!(nextNode.getUserObject() instanceof TreeItem) || (id = (item = (TreeItem)nextNode.getUserObject()) == null ? null : item.getId()) == null || (status = map.get(id)) == null) continue;
            if (status.expanded) {
                this.tree.expandPath(new TreePath(nextNode.getPath()));
            }
            if (!status.selected) continue;
            this.tree.setSelectionPath(new TreePath(nextNode.getPath()));
        }
    }

    private void performCancelReplicate(Partner partner) {
        block2: {
            try {
                ServerHandler.cancelReplicate(partner);
                ConsoleLogger.logAdminEvent(16407, partner.getName());
                JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.CancelReplInfo"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.title.Info"), 1);
            }
            catch (ConsoleException e) {
                JOptionPane.showMessageDialog(Manager.getFrame(), e.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.title.ConsoleError"), 0);
                if (!e.needRelogin()) break block2;
                Manager.getFrame().showLoginPanel();
            }
        }
    }

    private boolean isFirstServer(SemServer semServer) {
        boolean isFirstServer = false;
        String currentServerID = Manager.getCurrentServerId();
        isFirstServer = semServer != null && semServer.getId().equals(currentServerID);
        return isFirstServer;
    }

    private void performReplicate(Partner partner) {
        block2: {
            try {
                ServerHandler.replicateNow(partner);
                ConsoleLogger.logAdminEvent(16400, partner.getName());
                JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.ReplInfo"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.title.Info"), 1);
            }
            catch (ConsoleException e) {
                JOptionPane.showMessageDialog(Manager.getFrame(), e.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.title.ConsoleError"), 0);
                if (!e.needRelogin()) break block2;
                Manager.getFrame().showLoginPanel();
            }
        }
    }

    private File getFile(boolean isOpen, final String fileExtension, final String description) {
        JFileChooser fc = new JFileChooser();
        if (!isOpen && AjaxSwingCommonUtil.isAjaxSwingRunning()) {
            fc.setSelectedFile(new File("export." + fileExtension));
            fc.showSaveDialog(Manager.getFrame());
            return fc.getSelectedFile();
        }
        fc.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String extension = Utility.getFileExtension((File)f);
                return extension != null && extension.equals(fileExtension);
            }

            @Override
            public String getDescription() {
                return description;
            }
        });
        fc.setApproveButtonText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "AdminPanel.button.Export"));
        if (isOpen && fc.showOpenDialog(Manager.getFrame()) != 0) {
            return null;
        }
        if (!isOpen && fc.showSaveDialog(Manager.getFrame()) != 0) {
            return null;
        }
        File file = fc.getSelectedFile();
        if (isOpen) {
            if (!file.exists()) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.error.NamedFile"), file.getName()), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.title.Message"), 2);
                return null;
            }
        } else {
            if (file.exists()) {
                return this.overwriteFile(file);
            }
            String extension = Utility.getFileExtension((File)file);
            if ((extension == null || !extension.equals(fileExtension)) && JOptionPane.showConfirmDialog(Manager.getFrame(), MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.ConfirmAppendFileExt"), fileExtension), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.title.FileExt"), 0) == 0 && (file = new File(file.getParentFile(), file.getName() + "." + fileExtension)).exists()) {
                return this.overwriteFile(file);
            }
        }
        return file;
    }

    private Object getSelectedTreeNodeUserObject() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (node == null) {
            return null;
        }
        Object userObject = null;
        try {
            userObject = node.getUserObject();
        }
        catch (Exception ignore) {
            LoggerUtilities.logException((Throwable)ignore);
        }
        return userObject;
    }

    private File overwriteFile(File file) {
        int retCode = JOptionPane.showConfirmDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.ConfirmOverwriteFile"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.title.OverwriteFile"), 0);
        return retCode == 0 ? file : null;
    }

    private static void importSemServer(SemServer serverFile, SemServer serverMem) {
        AbstractSchema o;
        int i;
        if (serverFile == null || serverMem == null) {
            return;
        }
        Vector v = serverMem.getChildren();
        if (v != null) {
            for (i = 0; i < v.size(); ++i) {
                o = (AbstractSchema)v.get(i);
                if (o instanceof ServerBackupConfig || o instanceof TransportServerCertificate) continue;
                serverMem.removeChild(o);
            }
        }
        if ((v = serverFile.getChildren()) != null) {
            for (i = 0; i < v.size(); ++i) {
                o = (AbstractSchema)v.get(i);
                if (o instanceof ServerBackupConfig || o instanceof TransportServerCertificate) continue;
                serverMem.addChild(o);
            }
        }
        GUIDGenerator guid = new GUIDGenerator();
        String description = serverFile.getOptDescription();
        serverMem.setOptDescription(description != null ? description : "");
        ServersPanel.washSemServerChidlrenIdAndTime((ConfigObject)serverMem, guid);
    }

    private static void washSemServerChidlrenIdAndTime(ConfigObject parent, GUIDGenerator guid) {
        if (parent == null) {
            return;
        }
        Vector v = parent.getChildren();
        if (v != null) {
            for (int i = 0; i < v.size(); ++i) {
                ConfigObject o = (ConfigObject)v.get(i);
                o.setI(guid.getGUIDString());
                o.setT(TimeUtil.getServerTime());
                ServersPanel.washSemServerChidlrenIdAndTime(o, guid);
            }
        }
    }

    private static void printSemServer(SemServer server, String name) {
        try {
            String str = server.getString();
            System.out.println("========= printSemServer: Begin [" + name + "] ===============");
            System.out.println(str);
            System.out.println("========= printSemServer: Done [" + name + "] ===============");
        }
        catch (Throwable ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    private boolean isSiteInUse(SiteObject siteObj) {
        block3: {
            try {
                int appliedCount;
                SemServerList defaultList = GUIManager.getDefaultServerList(siteObj.getId());
                ArrayList<String> ids = new ArrayList<String>();
                ids.add(defaultList.getId());
                HashMap<String, Integer> appliedMap = DataobjectManager.getInstance().getPoliciesAppliedCount(ids);
                Integer count = appliedMap.get(defaultList.getId());
                int n = appliedCount = count == null ? 0 : count;
                if (appliedCount > 0) {
                    return true;
                }
            }
            catch (ConsoleException e) {
                JOptionPane.showMessageDialog(Manager.getFrame(), e.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.title.ConsoleError"), 0);
                if (!e.needRelogin()) break block3;
                Manager.getFrame().showLoginPanel();
            }
        }
        return false;
    }

    private static boolean modifySiteBaseOnSitePrivilege(DefaultMutableTreeNode site, AdminPrivilegeObject privilegeObject) {
        if (site == null || privilegeObject == null) {
            return false;
        }
        Object siteObject = site.getUserObject();
        if (siteObject == null || !(siteObject instanceof SiteObject)) {
            site.removeFromParent();
            return true;
        }
        String siteId = ((SiteObject)siteObject).getId();
        SitePrivilege privilege = privilegeObject.getSitePrivilegeById(siteId);
        if (privilege == null) {
            site.removeFromParent();
            return true;
        }
        PrivilegeValue value = privilege.getOptPrivilegeValue();
        if (value != null && value.getOptPrivilege() != null) {
            if (value.getOptPrivilege() == 1) {
                site.removeFromParent();
                return true;
            }
            if (value.getOptPrivilege() == 0) {
                return false;
            }
            privilegeMap.put(siteId, value.getOptPrivilege());
            DefaultMutableTreeNode nextNode = site.getNextNode();
            while (nextNode != null && !(nextNode.getUserObject() instanceof PartnerGroup)) {
                DefaultMutableTreeNode temp = nextNode.getNextNode();
                ServersPanel.modifyServersBaseOnSitePrivilege(nextNode, privilege);
                nextNode = temp;
            }
            return false;
        }
        return false;
    }

    private static void modifyServersBaseOnSitePrivilege(DefaultMutableTreeNode server, SitePrivilege privilege) {
        if (server == null || privilege == null) {
            return;
        }
        Object serverObject = server.getUserObject();
        if (serverObject == null) {
            return;
        }
        if (serverObject instanceof ServerObject) {
            ServersPanel.modifySEPMServerBaseOnServerPrivilege(server, privilege);
        } else if (serverObject instanceof DatabaseObject) {
            ServersPanel.modifyDataBaseServerBaseOnServerPrivilege(server, privilege);
        }
    }

    private static void modifySEPMServerBaseOnServerPrivilege(DefaultMutableTreeNode server, SitePrivilege privilege) {
        ServerObject serverObject = (ServerObject)server.getUserObject();
        String id = serverObject.getId();
        if (id == null) {
            server.removeFromParent();
        } else if (AdminACLUtils.isAccessDenied((SitePrivilegeSet)((SitePrivilegeSet)privilege.getParent()), (SemServer)serverObject.getSemServer())) {
            server.removeFromParent();
        } else {
            privilegeMap.put(id, AdminACLUtils.getPrivilegeValue((SitePrivilegeSet)((SitePrivilegeSet)privilege.getParent()), (SemServer)serverObject.getSemServer()).getOptPrivilege());
        }
    }

    private static void modifyDataBaseServerBaseOnServerPrivilege(DefaultMutableTreeNode server, SitePrivilege privilege) {
        String id = null;
        id = ((DatabaseObject)server.getUserObject()).getId();
        if (id == null) {
            server.removeFromParent();
        } else {
            DatabasePrivilege databasePrivilege = privilege.getOptDatabasePrivilege();
            if (databasePrivilege == null) {
                server.removeFromParent();
            } else {
                PrivilegeValue value = databasePrivilege.getOptPrivilegeValue();
                if (value != null && value.getOptPrivilege() != null) {
                    if (value.getOptPrivilege() == 1) {
                        server.removeFromParent();
                    } else {
                        privilegeMap.put(id, value.getOptPrivilege());
                    }
                }
            }
        }
    }

    @Override
    public int getItemIndex(int id) {
        int index = -1;
        int row = -1;
        switch (id) {
            case 0: {
                index = 0;
                break;
            }
            case 1: {
                row = this.getRowIndex(this.tree, LICENSE_MANAGEMENT, 0);
                if (row == -1) break;
                index = row;
                break;
            }
        }
        return index;
    }

    public void setRefresh(boolean refresh) {
        this.refresh = refresh;
    }

    public boolean isRefresh() {
        return this.refresh;
    }

    static {
        titleMap.put(4, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersWelcomePanel.title.SrvMgmt"));
        titleMap.put(13, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "SiteStatusPanel.title.SiteMgmt"));
        titleMap.put(14, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServerStatusPanel.title.SvrMgmt"));
        titleMap.put(15, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "DbStatusPanel.DBManagement"));
        titleMap.put(17, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "PartnerListPanel.ReplPartnerMgmt"));
        titleMap.put(18, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "PartnerStatusPanel.PartnerMgmt"));
        titleMap.put(191, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "RemoteSitePanel.RemoteSiteNode"));
        titleMap.put(19, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "RemoteSitePanel.RemoteSiteMgmt"));
        titleMap.put(67, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "LicenseSummaryPanel.html.LicMgmt"));
        titleMap.put(68, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServerStatusPanel.title.SvrMgmt"));
    }

    private static class ItemVisualStatus {
        public boolean expanded;
        public boolean selected;

        public ItemVisualStatus(boolean expanded, boolean selected) {
            this.expanded = expanded;
            this.selected = selected;
        }
    }

    public class ServerTaskPane
    extends TaskPanelBase
    implements ContentSensitiveHelpPage {
        private static final long serialVersionUID = 3809905134615495184L;
        private String titleName = SERVER_TITLE;

        ServerTaskPane() {
            this.initialize();
        }

        @Override
        protected Component getContentPanel() {
            return ServersPanel.this.getSplitPane();
        }

        @Override
        protected String getTitleName() {
            return this.titleName;
        }

        public TaskPanel getTaskPane() {
            JSplitPane sPanel = ServersPanel.this.getSplitPane();
            Component com = sPanel.getTopComponent();
            if (com instanceof TaskPanel) {
                return (TaskPanel)((Object)com);
            }
            return null;
        }

        @Override
        public String getContentSensitiveHelpToken() {
            Component comp = ServersPanel.this.getSplitPane().getTopComponent();
            String token = null;
            if (comp instanceof ContentSensitiveHelpPage) {
                token = ((ContentSensitiveHelpPage)((Object)comp)).getContentSensitiveHelpToken();
            }
            System.err.println("Servers panel: " + comp.getClass().getName() + "  [" + token + "]");
            return token;
        }
    }
}

