/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.server;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.AdminObject;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.logicobject.ServerObject;
import com.sygate.scm.console.logicobject.TreeItem;
import com.sygate.scm.console.ui.policy.lu.LuDownloadStatusDlg;
import com.sygate.scm.console.ui.server.ServerBasePanel;
import com.sygate.scm.console.ui.server.ServersPanel;
import com.sygate.scm.console.ui.util.TaskObject;
import com.sygate.scm.util.HTMLUtilities;
import java.awt.Toolkit;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.ListSelectionListener;

public class ServerStatusPanel
extends ServerBasePanel {
    private static final long serialVersionUID = 772957396943772313L;
    private static final int DEL_SERVER = 1;
    private static final int UPDATE_SERVER_CERT = 2;
    private static final int RSA_CONFIG = 3;
    private static final int EDIT_SERVER = 4;
    private static final int EXPORT_SERVER = 5;
    private static final int IMPORT_SERVER = 6;
    private static final int RUN_LIVEUPDATE = 7;
    private static final int SHOW_LIVEUPDATE_STATUS = 8;
    private static final int SHOW_LIVEUPDATE_LATEST = 9;
    private static final int VIP_CONFIG = 11;
    private static final int SMARTCARD_CONFIG = 12;
    private final String editPropertiesTaskName = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServerStatusPanel.html.EditSvrProps");
    private final String viewPropertiesTaskName = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServerStatusPanel.html.ViewSvrProps");

    public ServerStatusPanel(boolean readOnly) {
        super(readOnly);
    }

    @Override
    public void executeTask(int taskIndex, Object userObject) {
        ServersPanel serverPanel = this.getServerPanel();
        switch (taskIndex) {
            case 1: {
                serverPanel.deleteServer();
                break;
            }
            case 2: {
                serverPanel.importCertificate();
                break;
            }
            case 3: {
                serverPanel.configureRSA();
                break;
            }
            case 4: {
                serverPanel.editServer();
                break;
            }
            case 5: {
                serverPanel.exportServer();
                break;
            }
            case 6: {
                serverPanel.importServer();
                break;
            }
            case 7: {
                serverPanel.downloadLuContents();
                break;
            }
            case 8: {
                LuDownloadStatusDlg.setOnlyShowLUStatusButtonPressed(true);
                serverPanel.showLUStatus();
                break;
            }
            case 9: {
                serverPanel.showLULatestDownload();
                break;
            }
            case 11: {
                serverPanel.configureVip();
                break;
            }
            case 12: {
                serverPanel.configureSmartCard();
                break;
            }
        }
    }

    @Override
    public void addTableSelectionListener(ListSelectionListener listener) {
    }

    @Override
    protected String getPanelName() {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServerStatusPanel.title.SvrMgmt");
    }

    @Override
    protected String getLeftTableContent(Object item) {
        URL action = ConsoleMain.actionURL;
        URL wizard = ConsoleMain.wizardURL;
        return "\t<TR>\t\t<TD>" + HTMLUtilities.img((URL)action) + "   <A href='http://localhost/a.html#DEL'>" + MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServerStatusPanel.html.DelSelectedSvr") + "</A></TD></TR>\t<TR>\t\t<TD>" + HTMLUtilities.img((URL)wizard) + "   <A href='http://localhost/a.html#CERT'>" + MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServerStatusPanel.html.UpdateSvrCert") + "</A></TD></TR>\t<TR>\t\t<TD>" + HTMLUtilities.img((URL)wizard) + "   <A href='http://action/a.html#RSA'>" + MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServerStatusPanel.html.ConfigRSAClient") + "</A></TD></TR>\t<TR>\t\t<TD>" + HTMLUtilities.img((URL)action) + "   <A href='http://localhost/a.html#PROP'>" + MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServerStatusPanel.html.EditSvrProps") + "</A></TD></TR>\t<TR>\t\t<TD>" + HTMLUtilities.img((URL)action) + "   <A href='http://localhost/a.html#EXPORT'>" + MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServerStatusPanel.html.ExportSvrProps") + "</A></TD></TR>\t<TR>\t\t<TD>" + HTMLUtilities.img((URL)action) + "   <A href='http://localhost/a.html#IMPORT'>" + MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServerStatusPanel.html.ImportSvrProps") + "</A></TD></TR>";
    }

    @Override
    protected String getRightTableContent(Object item) {
        ServerObject server = (ServerObject)item;
        boolean isSBProduct = LicenseObject.getInstance().isSBProduct();
        StringBuffer baseTable = new StringBuffer();
        String firstTableRow = this.trWithBackground() + "\t\t<TD width='" + MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServerStatusPanel.html.PanelTableWidth") + "'>" + MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServerStatusPanel.html.SvrName") + "</TD>\t\t<TD>" + server.getName() + "</TD></TR>";
        baseTable.append(firstTableRow);
        if (!isSBProduct) {
            String desc = this.getHTMLTableRow(isSBProduct, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServerStatusPanel.html.Desc"), HTMLUtilities.filterAndConvertNewLines((String)server.getDescription()));
            baseTable.append(desc);
        }
        baseTable.append(this.getHTMLTableRow(!isSBProduct, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServerStatusPanel.html.ProductVer"), server.getProductVersion()) + this.getHTMLTableRow(isSBProduct, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServerStatusPanel.html.OS"), server.getServerOS()) + this.getHTMLTableRow(!isSBProduct, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServerStatusPanel.html.Addr"), server.getServerAddressString()) + this.getHTMLTableRow(isSBProduct, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServerStatusPanel.html.StartTime"), server.getDisplayServerStartTime()) + this.getHTMLTableRow(!isSBProduct, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServerStatusPanel.html.CreationTime"), server.getDisplayCreationTime()) + this.getHTMLTableRow(isSBProduct, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServerStatusPanel.html.Status"), server.getStatus()));
        String sbsString = this.getHTMLTableRow(!isSBProduct, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServerStatusPanel.html.ClientCommPort"), server.getHttpPort());
        if (!isSBProduct) {
            return baseTable.toString();
        }
        return baseTable.toString() + sbsString;
    }

    @Override
    protected void linkActivated(HyperlinkEvent e) {
        ServersPanel serverPanel = this.getServerPanel(e);
        if (serverPanel != null) {
            if ("DEL".equals(e.getURL().getRef())) {
                serverPanel.deleteServer();
            } else if ("CERT".equals(e.getURL().getRef())) {
                serverPanel.importCertificate();
            } else if ("RSA".equals(e.getURL().getRef())) {
                serverPanel.configureRSA();
            } else if ("PROP".equals(e.getURL().getRef())) {
                serverPanel.editServer();
            } else if ("EXPORT".equals(e.getURL().getRef())) {
                serverPanel.exportServer();
            } else if ("IMPORT".equals(e.getURL().getRef())) {
                serverPanel.importServer();
            }
        }
    }

    @Override
    protected List<TaskObject> getRealTaskList(TreeItem item) {
        ServerObject server;
        if (item instanceof ServerObject && !Manager.isLocalServer((server = (ServerObject)item).getId())) {
            return this.getRemoteTaskList();
        }
        ImageIcon export = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("export.png")));
        ImageIcon importIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("import.png")));
        ImageIcon deleteAction = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("delete.png")));
        ImageIcon cert = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("manage.png")));
        ImageIcon config = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("config.png")));
        ImageIcon edit = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("edit.png")));
        ImageIcon liveUpdate = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("Policy_LiveUpdate_16b.png")));
        ArrayList<TaskObject> firstList = new ArrayList<TaskObject>();
        if (LicenseObject.getInstance().isSBProduct()) {
            firstList.add(new TaskObject(this.editPropertiesTaskName, 4, edit));
            firstList.add(new TaskObject(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "SiteStatusPanel.html.RunLiveUpdate"), 7, liveUpdate));
            firstList.add(new TaskObject(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "SiteStatusPanel.html.ShowLiveUpdateStatus"), 8, liveUpdate));
            firstList.add(new TaskObject(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "SiteStatusPanel.html.ShowLiveUpdateLatestDownload"), 9, liveUpdate));
        } else {
            firstList.addAll(this.constructTaskList(export, importIcon, config, edit, deleteAction, cert, this.readOnly, false));
        }
        return firstList;
    }

    protected List<TaskObject> getRemoteTaskList() {
        ArrayList<TaskObject> firstList = new ArrayList<TaskObject>();
        ImageIcon export = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("export.png")));
        ImageIcon importIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("import.png")));
        ImageIcon config = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("config.png")));
        ImageIcon edit = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("edit.png")));
        firstList.addAll(this.constructTaskList(export, importIcon, config, edit, null, null, this.readOnly, true));
        return firstList;
    }

    private List<TaskObject> constructTaskList(Icon export, Icon importIcon, Icon config, Icon edit, Icon delete, Icon cert, boolean readOnly, boolean isRemote) {
        ArrayList<TaskObject> result = new ArrayList<TaskObject>();
        result.add(new TaskObject(readOnly ? this.viewPropertiesTaskName : this.editPropertiesTaskName, 4, edit));
        if (!readOnly) {
            result.add(ServerTask.DELETE_SERVER.getTaskObject());
            if (!isRemote) {
                result.add(new TaskObject(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServerStatusPanel.html.UpdateSvrCert"), 2, cert));
            }
            result.add(new TaskObject(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServerStatusPanel.html.ConfigRSAClient"), 3, config));
            AdminObject admin = AdminObject.retrieveCurrentAdminObject();
            if (admin.isSysAdmin()) {
                result.add(new TaskObject(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServerStatusPanel.html.ConfigVIP"), 11, config));
            }
            result.add(new TaskObject(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServerStatusPanel.html.ConfigSmartCard"), 12, config));
            result.add(new TaskObject(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServerStatusPanel.html.ImportSvrProps"), 6, importIcon, null, this.getServerPanel(), true));
        }
        result.add(new TaskObject(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServerStatusPanel.html.ExportSvrProps"), 5, export));
        return result;
    }

    private String getHTMLTableRow(boolean isBgcolor, String attributeName, String attributeValue) {
        String tableRow = null;
        String trTag = "<TR>";
        if (isBgcolor) {
            trTag = this.trWithBackground();
        }
        tableRow = trTag + "<TD>" + attributeName + "</TD><TD style=\"padding-left:5px;\">" + attributeValue + "</TD></TR>";
        return tableRow;
    }

    @Override
    public int getTableSelectedItem() {
        return 0;
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_admin_pane_servers_server";
    }

    private static enum ServerTask {
        DELETE_SERVER("ServerStatusPanel.html.DelSelectedSvr", "delete.png", 1);

        private TaskObject taskObject;

        private ServerTask(String titleResourceKey, String iconFileName, int index) {
            this.taskObject = new TaskObject(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", titleResourceKey), index, new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource(iconFileName))));
        }

        TaskObject getTaskObject() {
            return this.taskObject;
        }
    }
}

