/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.server;

import com.creamtec.sepm.ajaxswing.support.components.JEditorPane;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UIColorUtilities;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.logicobject.TreeItem;
import com.sygate.scm.console.ui.MainPanel;
import com.sygate.scm.console.ui.admin.AdminPanel;
import com.sygate.scm.console.ui.server.ServersPanel;
import com.sygate.scm.console.ui.util.PagePanel;
import com.sygate.scm.console.ui.util.TabbedPageModel;
import com.sygate.scm.console.ui.util.TaskObject;
import com.sygate.scm.console.ui.util.TaskPanel;
import com.sygate.scm.util.HTMLUtilities;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.Utility;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public abstract class ServerBasePanel
extends JPanel
implements TabbedPageModel,
TaskPanel,
ContentSensitiveHelpPage {
    private static final long serialVersionUID = -4620514768706845259L;
    protected static final String menuStrDelete = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.menu.Delete");
    protected static final String menuStrEditProps = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.menu.EditProperties");
    protected static final String menuStrViewProps = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.menu.ViewProperties");
    private JEditorPane statusEditor = null;
    private int pageId;
    protected boolean readOnly;
    protected List<List<TaskObject>> taskList;
    protected List<List<TaskObject>> remoteTaskList;

    public ServerBasePanel() {
        this(false);
    }

    public ServerBasePanel(boolean readOnly) {
        this.readOnly = readOnly;
        this.initialize();
    }

    @Override
    public void refresh() {
    }

    protected String getContentText(Object item) {
        String text = HTMLUtilities.HTML_DOCUMENT_BEGIN + "<TABLE width=100% border='0' valign='top'><TR><TD>" + this.getRightTable(item) + "</TD></TR></TABLE></BODY></HTML>";
        return text;
    }

    protected ServersPanel getServerPanel(HyperlinkEvent hyperLinkEvent) {
        if (hyperLinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            PagePanel currentPanel = MainPanel.getCurrentPanel();
            if (currentPanel instanceof ServersPanel) {
                return (ServersPanel)currentPanel;
            }
            if (currentPanel instanceof AdminPanel) {
                AdminPanel adminPanel = (AdminPanel)currentPanel;
                return adminPanel.getServersPanel();
            }
        }
        return null;
    }

    protected ServersPanel getServerPanel() {
        PagePanel currentPanel = MainPanel.getCurrentPanel();
        if (currentPanel instanceof ServersPanel) {
            return (ServersPanel)currentPanel;
        }
        if (currentPanel instanceof AdminPanel) {
            AdminPanel adminPanel = (AdminPanel)currentPanel;
            return adminPanel.getServersPanel();
        }
        return null;
    }

    protected String trUtil(boolean truefalse) {
        if (truefalse) {
            return this.trWithBackground();
        }
        return "<TR>";
    }

    protected String trWithBackground() {
        return " <TR class='adminBasePanelTRWithBg' bgcolor='" + UIColorUtilities.colorToString((Color)UIColorUtilities.TABLE_STRIPE) + "'>";
    }

    protected String getTimeString(String time) {
        if (time.length() == 0) {
            return "";
        }
        try {
            DateFormat format = DateFormat.getDateTimeInstance(0, 1);
            format.setTimeZone(Utility.getLocalTimeZone());
            return format.format(new Date(Long.parseLong(time)));
        }
        catch (NumberFormatException ex) {
            LoggerUtilities.logException((Throwable)ex);
            return "";
        }
    }

    private void addMenuItem(TaskObject task, JPopupMenu popup, ActionListener listener) {
        JMenuItem menuItem = new JMenuItem(task.getDisplayName());
        menuItem.putClientProperty(task.getDisplayName(), task.getTaskIndex());
        menuItem.setEnabled(task.isEnable());
        menuItem.setToolTipText(task.getToolTipText());
        menuItem.addActionListener(listener);
        popup.add(menuItem);
    }

    protected JPopupMenu getPopupMenu(TreeItem item, ActionListener listener) {
        List<TaskObject> list = this.getRealTaskList(item);
        if (list.size() > 0) {
            JPopupMenu popup = new JPopupMenu();
            for (TaskObject task : list) {
                this.addMenuItem(task, popup, listener);
            }
            return popup;
        }
        return null;
    }

    protected List<List<TaskObject>> getTaskList(TreeItem item) {
        this.taskList = new ArrayList<List<TaskObject>>();
        this.taskList.add(this.getRealTaskList(item));
        return this.taskList;
    }

    protected abstract List<TaskObject> getRealTaskList(TreeItem var1);

    protected abstract String getPanelName();

    protected abstract String getLeftTableContent(Object var1);

    protected abstract String getRightTableContent(Object var1);

    protected abstract void linkActivated(HyperlinkEvent var1);

    private void initialize() {
        this.setLayout(new BorderLayout());
        JScrollPane sPane = new JScrollPane((Component)this.getStatusEditor());
        this.add((Component)sPane, "Center");
        sPane.setBorder(BorderFactory.createEmptyBorder());
    }

    private JEditorPane getStatusEditor() {
        if (this.statusEditor == null) {
            this.statusEditor = new JEditorPane();
            this.statusEditor.setContentType("text/html");
            this.statusEditor.setEditable(false);
            this.statusEditor.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent hyperLinkEvent) {
                    ServerBasePanel.this.linkActivated(hyperLinkEvent);
                }
            });
        }
        return this.statusEditor;
    }

    private String getRightTable(Object item) {
        return "<TABLE width=100% border='0' valign='middle'>" + this.getRightTableContent(item) + "</TABLE>";
    }

    protected void refreshRightTable(Object item) {
        this.setSelectedItem(item);
    }

    @Override
    public void setSelectedItem(Object item) {
        this.getStatusEditor().setText(this.getContentText(item));
        this.getStatusEditor().setCaretPosition(0);
    }

    public int getPageId() {
        return this.pageId;
    }
}

