/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.server;

import com.sygate.scm.common.configobject.schema.SemSite;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.ServerHandler;
import com.sygate.scm.console.logicobject.Partner;
import com.sygate.scm.console.logicobject.TreeItem;
import com.sygate.scm.console.ui.server.ServerBasePanel;
import com.sygate.scm.console.ui.server.ServersPanel;
import com.sygate.scm.console.ui.util.TaskObject;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.util.HTMLUtilities;
import java.awt.Toolkit;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.ListSelectionListener;

public class PartnerStatusPanel
extends ServerBasePanel {
    private static final long serialVersionUID = 7640512383618094269L;
    private static final int ADD_REPL_PARTER = 1;
    private static final int DEL_PEPL_PARTNER = 2;
    private static final int REPLICATE = 3;
    private static final int EDIT_PARTNER = 4;
    private static final int CHECK_CERTIFICATE_INDEX = 5;
    private static final int CANCEL_REPLICATION_INDEX = 6;
    private boolean canDeleteRemoteSite;

    public PartnerStatusPanel(boolean readOnly, boolean canDeleteRemoteSite) {
        super(readOnly);
        this.canDeleteRemoteSite = canDeleteRemoteSite;
    }

    @Override
    protected String getPanelName() {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "PartnerStatusPanel.PartnerMgmt");
    }

    @Override
    protected String getLeftTableContent(Object item) {
        URL action = ConsoleMain.actionURL;
        URL wizard = ConsoleMain.wizardURL;
        return "<TR>\t\t<TD>" + HTMLUtilities.img((URL)wizard) + "   <A href='http://localhost/a.html#ADD'>" + MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "PartnerStatusPanel.html.AddReplPartner") + "</A></TD></TR>\t<TR>\t\t<TD>" + HTMLUtilities.img((URL)action) + "   <A href='http://localhost/a.html#DEL'>" + MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "PartnerStatusPanel.html.DelReplPartner") + "</A></TD></TR>\t<TR>\t\t<TD>" + HTMLUtilities.img((URL)action) + "   <A href='http://localhost/a.html#REPLICATE'>" + MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "PartnerStatusPanel.html.ReplNow") + "</A></TD></TR>\t<TR>\t\t<TD>" + HTMLUtilities.img((URL)action) + "   <A href='http://localhost/a.html#PROPERITES'>" + MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "PartnerStatusPanel.html.EditReplPartnerProps") + "</A></TD></TR>";
    }

    private String getLogReplicatedDirection(Partner partner) {
        String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "PartnerStatusPanel.html.LogReplDir.None");
        if (null == partner) {
            return str;
        }
        try {
            SemSite localSite = partner.getSemSite();
            SemSite site = ServerHandler.retrieveSite(partner.getName());
            Partner localPartner = null;
            if (site != null) {
                localPartner = ServerHandler.getPartner(site, localSite.getName());
            }
            if (partner.isReplicateLogs() && localPartner != null && localPartner.isReplicateLogs()) {
                str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "PartnerStatusPanel.html.LogReplDir.Both");
            } else if (localPartner != null && localPartner.isReplicateLogs()) {
                str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "PartnerStatusPanel.html.LogReplDir.Out");
            } else if (partner.isReplicateLogs()) {
                str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "PartnerStatusPanel.html.LogReplDir.In");
            }
        }
        catch (ConsoleException e) {
            ConsoleLogger.log(e);
        }
        return str;
    }

    @Override
    protected String getRightTableContent(Object item) {
        Partner partner = (Partner)item;
        return this.trUtil(true) + "\t\t<TD width='" + MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "PartnerStatusPanel.html.PanelTableWidth") + "'>" + MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "PartnerStatusPanel.html.PartnerName") + "</TD>\t<TD>" + HTMLUtilities.filterAndConvertNewLines((String)partner.getName()) + "</TD></TR>" + this.trUtil(false) + "\t\t<TD>" + MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "PartnerStatusPanel.html.PartnerDesc") + "</TD>\t\t<TD>" + HTMLUtilities.filterAndConvertNewLines((String)partner.getDescription()) + "</TD></TR>" + this.trUtil(true) + "\t\t<TD>" + MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "PartnerStatusPanel.html.ReplPolManagerList") + "</TD>\t\t<TD>" + HTMLUtilities.filterAndConvertNewLines((String)partner.getContactList()) + "</TD></TR>" + this.trUtil(false) + "\t\t<TD>" + MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "PartnerStatusPanel.html.AutoSync") + "</TD>\t\t<TD>" + (partner.isAutoReplicate() ? MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "PartnerStatusPanel.html.Yes") : MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "PartnerStatusPanel.html.No")) + "</TD></TR>" + this.trUtil(true) + "\t\t<TD>" + MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "PartnerStatusPanel.html.LogReplDir") + "</TD>\t\t<TD>" + this.getLogReplicatedDirection(partner) + "</TD></TR>" + this.trUtil(false) + "     <TD>" + MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "PartnerStatusPanel.html.ReplicateClientPackages") + "</TD>     <TD>" + (partner.isReplicateClientPackages() || partner.isReplicateLuContents() ? MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "PartnerStatusPanel.html.Yes") : MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "PartnerStatusPanel.html.No")) + "</TD></TR>" + this.trUtil(true) + "\t\t<TD>" + MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "PartnerStatusPanel.html.Repl.Freq") + "</TD>\t\t<TD>" + (String)(partner.getFrequency().equals("Hourly") ? MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "PartnerStatusPanel.html.Every") + " " + partner.getHourlyFrequency() + " " + MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "PartnerStatusPanel.html.Hour") : partner.getFrequency()) + "</TD></TR>" + this.trUtil(false) + "\t\t<TD>" + MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "PartnerStatusPanel.html.StartTime") + "</TD>\t\t<TD>" + partner.getStartTime() + "</TD></TR>" + this.trUtil(true) + "\t\t<TD>" + MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "PartnerStatusPanel.html.LastRepl") + "</TD>\t\t<TD>" + partner.getLastReplicationTime() + "</TD></TR>" + this.trUtil(false) + "\t\t<TD>" + MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "PartnerStatusPanel.html.LastReplSvr") + "</TD>\t\t<TD>" + HTMLUtilities.filterAndConvertNewLines((String)partner.getLastReplicationServer()) + "</TD></TR>" + this.trUtil(true) + "\t\t<TD>" + MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "PartnerStatusPanel.html.Status") + "</TD>\t\t<TD>" + partner.getStatus() + "</TD></TR>";
    }

    @Override
    protected void linkActivated(HyperlinkEvent e) {
        ServersPanel serverPanel = this.getServerPanel(e);
        if (serverPanel != null) {
            if ("ADD".equals(e.getURL().getRef())) {
                serverPanel.addPartner();
            } else if ("DEL".equals(e.getURL().getRef())) {
                serverPanel.deletePartner();
            } else if ("REPLICATE".equals(e.getURL().getRef())) {
                serverPanel.replicateNow();
            } else if ("PROPERITES".equals(e.getURL().getRef())) {
                serverPanel.editPartner();
            }
        }
    }

    @Override
    public void executeTask(int taskIndex, Object userObject) {
        ServersPanel serverPanel = this.getServerPanel();
        switch (taskIndex) {
            case 1: {
                serverPanel.addPartner();
                break;
            }
            case 2: {
                serverPanel.deletePartner();
                break;
            }
            case 3: {
                serverPanel.replicateNow();
                break;
            }
            case 4: {
                serverPanel.editPartner();
                break;
            }
            case 5: {
                serverPanel.checkCertificate();
                break;
            }
            case 6: {
                serverPanel.cancelReplicate();
                break;
            }
        }
    }

    @Override
    public void addTableSelectionListener(ListSelectionListener listener) {
    }

    @Override
    public int getTableSelectedItem() {
        return 0;
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_admin_pane_servers_partner";
    }

    @Override
    protected List<TaskObject> getRealTaskList(TreeItem item) {
        Partner partner = (Partner)item;
        String localSiteId = partner.getLocalSiteId();
        if (Manager.isLocalSite(localSiteId)) {
            ArrayList<TaskObject> firstList = new ArrayList<TaskObject>();
            if (!this.readOnly) {
                firstList.add(PartnerTask.ADD_REP_PARTNER.getTaskObject());
                if (this.canDeleteRemoteSite) {
                    firstList.add(PartnerTask.DELETE_REP_PARTNER.getTaskObject());
                }
                firstList.add(PartnerTask.REPLICATION_NOW.getTaskObject());
                firstList.add(PartnerTask.CANCEL_REPLICATION.getTaskObject());
                firstList.add(PartnerTask.CHECK_CERTIFICATE.getTaskObject());
            }
            firstList.add(this.readOnly ? PartnerTask.VIEW_REP_PARTNER.getTaskObject() : PartnerTask.EDIT_REP_PARTNER.getTaskObject());
            return firstList;
        }
        return new ArrayList<TaskObject>();
    }

    private static enum PartnerTask {
        ADD_REP_PARTNER("PartnerStatusPanel.html.AddReplPartner", "addReplicationPartner.png", 1),
        DELETE_REP_PARTNER("PartnerStatusPanel.html.DelReplPartner", "delete.png", 2),
        EDIT_REP_PARTNER("PartnerStatusPanel.html.EditReplPartnerProps", "edit.png", 4),
        VIEW_REP_PARTNER("PartnerStatusPanel.html.ViewReplPartnerProps", "edit.png", 4),
        CHECK_CERTIFICATE("PartnerStatusPanel.html.CheckCertificate", "checkCertificate.png", 5),
        REPLICATION_NOW("PartnerStatusPanel.html.ReplNow", "replicate_now.png", 3),
        CANCEL_REPLICATION("PartnerStatusPanel.html.CancelReplication", "disable.png", 6);

        private TaskObject taskObject;

        private PartnerTask(String titleResourceKey, String iconFileName, int index) {
            this.taskObject = new TaskObject(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", titleResourceKey), index, new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource(iconFileName))));
        }

        TaskObject getTaskObject() {
            return this.taskObject;
        }
    }
}

