/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.server;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.Partner;
import com.sygate.scm.console.logicobject.PartnerGroup;
import com.sygate.scm.console.logicobject.TreeItem;
import com.sygate.scm.console.ui.server.ServerBasePanel;
import com.sygate.scm.console.ui.server.ServersPanel;
import com.sygate.scm.console.ui.util.TaskObject;
import com.sygate.scm.util.HTMLUtilities;
import java.awt.Toolkit;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.ListSelectionListener;

public class PartnerListPanel
extends ServerBasePanel {
    private static final long serialVersionUID = 5346878585954793477L;
    private static final int ADD_REPL_PARTNER = 1;

    public PartnerListPanel(boolean readOnly) {
        super(readOnly);
    }

    @Override
    public void executeTask(int taskIndex, Object userObject) {
        ServersPanel serverPanel = this.getServerPanel();
        switch (taskIndex) {
            case 1: {
                serverPanel.addPartner();
                break;
            }
        }
    }

    @Override
    public void addTableSelectionListener(ListSelectionListener listener) {
    }

    @Override
    protected String getPanelName() {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "PartnerListPanel.ReplPartnerMgmt");
    }

    @Override
    protected String getLeftTableContent(Object item) {
        URL info = ConsoleMain.informURL;
        URL wizard = ConsoleMain.wizardURL;
        return "\t<TR>\t\t<TD>" + HTMLUtilities.img((URL)wizard) + "   <A href='http://localhost/a.html#ADD'>" + MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "PartnerListPanel.html.AddReplPartner") + "</A></TD></TR><TR>\t\t<TD>" + HTMLUtilities.img((URL)info) + "   <A href='http://localhost/a.html#ALLOW'>" + MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "PartnerListPanel.html.AboutRepl") + "</A></TD></TR>";
    }

    @Override
    protected String getRightTableContent(Object item) {
        PartnerGroup group = (PartnerGroup)item;
        StringBuilder text = new StringBuilder(this.trWithBackground() + "<TD>" + MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "PartnerListPanel.html.SiteName") + "</TD><TD>" + MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "PartnerListPanel.html.ContactSvr") + "</TD><TD>" + MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "PartnerListPanel.html.Status") + "</TD>");
        for (int i = 0; i < group.getPartnerCount(); ++i) {
            if (i % 2 != 0) {
                text.append(this.trWithBackground());
                text.append("<TD>");
            } else {
                text.append("<TR><TD>");
            }
            Partner partner = group.getPartner(i);
            text.append(HTMLUtilities.filterAndConvertNewLines((String)partner.getName()) + "</TD><TD>" + HTMLUtilities.filterAndConvertNewLines((String)partner.getContactList()) + "<TD>" + partner.getStatus() + "</TD></TR>");
        }
        return text.toString();
    }

    @Override
    protected void linkActivated(HyperlinkEvent e) {
        ServersPanel serverPanel = this.getServerPanel(e);
        if (serverPanel != null) {
            if ("ALLOW".equals(e.getURL().getRef())) {
                serverPanel.aboutAllowPartner();
            } else if ("ADD".equals(e.getURL().getRef())) {
                serverPanel.addPartner();
            }
        }
    }

    @Override
    public int getTableSelectedItem() {
        return 0;
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_admin_pane_servers_partner_list";
    }

    @Override
    protected List<TaskObject> getRealTaskList(TreeItem item) {
        PartnerGroup partnerGroup = (PartnerGroup)item;
        if (Manager.isLocalSite(partnerGroup.getSiteId())) {
            ImageIcon wizard = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("addReplicationPartner.png")));
            ArrayList<TaskObject> firstList = new ArrayList<TaskObject>();
            if (!this.readOnly) {
                firstList.add(new TaskObject(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "PartnerListPanel.html.AddReplPartner"), 1, wizard));
            }
            return firstList;
        }
        return new ArrayList<TaskObject>();
    }
}

