/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.server;

import com.sygate.scm.common.configobject.schema.SemSite;
import com.sygate.scm.common.configobject.schema.SemSiteState;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.DatabaseObject;
import com.sygate.scm.console.logicobject.TreeItem;
import com.sygate.scm.console.ui.server.ServerBasePanel;
import com.sygate.scm.console.ui.server.ServersPanel;
import com.sygate.scm.console.ui.util.TaskObject;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.console.util.GUIManager;
import com.sygate.scm.util.HTMLUtilities;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.Toolkit;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.ListSelectionListener;

public class DbStatusPanel
extends ServerBasePanel {
    private static final long serialVersionUID = 3918409297479865055L;
    private static final int BACKUP_SITE = 1;
    private static final int EDIT_DB = 2;
    private static final int CONFIG_EXT_LOG = 3;
    private static final int TRUNCATE_LOGS = 4;
    private static final int REBUILD_INDEXES = 5;
    private String editPropertiesTaskName = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "DbStatusPanel.html.EditDBProps");
    private String viewPropertiesTaskName = MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "DbStatusPanel.html.ViewDBProps");
    private String siteId = null;
    private String dbUser = null;

    public String getSiteId() {
        return this.siteId;
    }

    public void setSiteId(String siteId) {
        this.siteId = siteId;
    }

    public void setDbUser(String dbUser) {
        this.dbUser = dbUser;
    }

    public DbStatusPanel(boolean readOnly) {
        super(readOnly);
    }

    @Override
    protected String getPanelName() {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "DbStatusPanel.DBManagement");
    }

    @Override
    protected String getLeftTableContent(Object item) {
        URL info = ConsoleMain.informURL;
        URL action = ConsoleMain.actionURL;
        return "  <TR>   <TD>" + HTMLUtilities.img((URL)action) + "   <A href='http://localhost/a.html#BACKUP'>" + MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "DbStatusPanel.html.EditBackupSettings") + "</A></TD></TR> <TR>   <TD>" + HTMLUtilities.img((URL)action) + "   <A href='http://localhost/a.html#BACKUPNOW'>" + MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "DbStatusPanel.html.BackupSiteNow") + "</A></TD></TR> <TR>   <TD>" + HTMLUtilities.img((URL)action) + "   <A href='http://localhost/a.html#EDIT'>" + MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "DbStatusPanel.html.EditDBProps") + "</A></TD></TR> <TR>   <TD>" + HTMLUtilities.img((URL)info) + "   <A href='http://localhost/a.html#RESTORE'>" + MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "DbStatusPanel.html.AboutSPMDB") + "</A></TD></TR>";
    }

    private SemSiteState getSemSiteStateForLocalSite(DatabaseObject currentDb) {
        SemSiteState siteState = null;
        try {
            String currentSiteId = Manager.getCurrentSiteId();
            System.out.print("Query SemSiteState, currentSiteId: " + currentSiteId);
            DataobjectManager dataobjectManager = DataobjectManager.getInstance();
            SemSite localSite = dataobjectManager.getSemSite(currentSiteId);
            if (localSite.getDatabaseArray().getDatabase().getId().equals(currentDb.getId())) {
                System.out.print("Query SemSiteState, the current selection is local site");
                siteState = dataobjectManager.getSemSiteState(currentSiteId);
            }
        }
        catch (Exception exc) {
            LoggerUtilities.logException((Throwable)exc);
        }
        return siteState;
    }

    private String getDatabaseSizeGb(SemSiteState siteState) {
        String sizeGB = "";
        ConsoleLogger.log("getDatabaseInstanceSpaceGb: " + siteState.getOptdbSizeMb());
        if (siteState.getOptdbSizeMb() != null) {
            ConsoleLogger.log("getDatabaseInstanceSpaceGb2: " + (double)siteState.getOptdbSizeMb().intValue() / 1024.0);
            sizeGB = String.valueOf(new BigDecimal((double)siteState.getOptdbSizeMb().intValue() / 1024.0).setScale(2, RoundingMode.HALF_UP).doubleValue());
            sizeGB = MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "DbStatusPanel.html.DBSizeGB"), sizeGB);
        }
        return sizeGB;
    }

    @Override
    protected String getRightTableContent(Object item) {
        DatabaseObject db = (DatabaseObject)item;
        SemSiteState siteState = this.getSemSiteStateForLocalSite(db);
        String dbUserOfThisSepm = this.dbUser;
        if (dbUserOfThisSepm == null) {
            dbUserOfThisSepm = GUIManager.getDbUser();
        }
        if (dbUserOfThisSepm == null) {
            dbUserOfThisSepm = "";
        }
        String content = this.trWithBackground() + "   <TD width = '" + MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "DbStatusPanel.html.TablePixelWidth") + "'>" + MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "DbStatusPanel.html.Name") + "</TD>   <TD> " + HTMLUtilities.filterAndConvertNewLines((String)db.getName()) + "</TD></TR> <TR>   <TD>" + MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "DbStatusPanel.html.Description") + "</TD>   <TD> " + HTMLUtilities.filterAndConvertNewLines((String)db.getDescription()) + "</TD></TR>" + this.trWithBackground() + "    <TD>" + MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "DbStatusPanel.html.DBAddress") + "</TD>   <TD>" + db.getServerAddress() + "</TD></TR> <TR>   <TD>" + MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "DbStatusPanel.html.DBPort") + "</TD>   <TD>" + db.getDatabaseInstancePort() + "</TD></TR>" + this.trWithBackground() + "   <TD>" + MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "DbStatusPanel.html.Type") + "</TD>   <TD>" + db.getProductName() + "</TD></TR> <TR>   <TD>" + MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "DbStatusPanel.html.Version") + "</TD>   <TD>" + db.getProductVersion() + "</TD></TR>" + this.trWithBackground() + "   <TD>" + (db.getProductName().toLowerCase().indexOf("oracle") != -1 ? MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "DbStatusPanel.html.SID") : MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "DbStatusPanel.html.DataBase")) + "</TD>   <TD>" + db.getDatabaseInstanceId() + "</TD></TR> <TR>   <TD>" + MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "DbStatusPanel.html.DBUser") + "</TD>   <TD>" + dbUserOfThisSepm + "</TD></TR>" + this.trWithBackground() + "   <TD>" + MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "DbStatusPanel.html.CreationTime") + "</TD>   <TD>" + db.getDisplayCreationTime() + "</TD></TR>";
        if (siteState != null) {
            content = content + " <TR>     <TD>" + MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "DbStatusPanel.html.DBSize") + "</TD>     <TD>" + this.getDatabaseSizeGb(siteState) + "</TD></TR>";
        }
        return content;
    }

    @Override
    protected void linkActivated(HyperlinkEvent e) {
        ServersPanel serverPanel = this.getServerPanel(e);
        if (serverPanel != null) {
            if ("BACKUPNOW".equals(e.getURL().getRef())) {
                serverPanel.backupNow();
            } else if ("RESTORE".equals(e.getURL().getRef())) {
                serverPanel.aboutRestoreSite();
            } else if ("EDIT".equals(e.getURL().getRef())) {
                serverPanel.editDatabase();
            }
        }
    }

    @Override
    public void executeTask(int taskIndex, Object userObject) {
        ServersPanel serverPanel = this.getServerPanel();
        switch (taskIndex) {
            case 1: {
                serverPanel.backupNow();
                break;
            }
            case 2: {
                serverPanel.editDatabase();
                break;
            }
            case 3: {
                serverPanel.editExternalLogging();
                break;
            }
            case 4: {
                serverPanel.truncateTxnLog();
                break;
            }
            case 5: {
                serverPanel.rebuildIndexes();
                break;
            }
        }
    }

    @Override
    public void addTableSelectionListener(ListSelectionListener listener) {
    }

    @Override
    public int getTableSelectedItem() {
        return 0;
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_admin_pane_servers_database";
    }

    @Override
    protected List<TaskObject> getRealTaskList(TreeItem item) {
        ImageIcon backup = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("backup.png")));
        ImageIcon properties = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("database_properties.png")));
        ArrayList<TaskObject> firstList = new ArrayList<TaskObject>();
        firstList.add(new TaskObject(this.readOnly ? this.viewPropertiesTaskName : this.editPropertiesTaskName, 2, properties));
        if (!this.readOnly && Manager.isLocalSite(this.siteId)) {
            firstList.add(new TaskObject(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "DbStatusPanel.html.BackupSiteNow"), 1, backup));
            firstList.add(new TaskObject(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "DbStatusPanel.html.TruncLogsNow"), 4, backup));
            firstList.add(new TaskObject(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "DbStatusPanel.html.ReIndexNow"), 5, backup));
        }
        return firstList;
    }
}

