/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.util;

import com.sygate.scm.common.configobject.schema.AmlLowBandwidth;
import com.sygate.scm.common.configobject.schema.SemClientGroup;
import com.sygate.scm.console.handler.CloudPolicyHandler;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.GroupObject;
import com.sygate.scm.util.GUID;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.Utility;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class PolicyUtil {
    public static ByteArrayInputStream convertBackendInputStream(InputStream in) throws IOException {
        if (in == null) {
            return null;
        }
        return PolicyUtil.processInputStream(in);
    }

    private static ByteArrayInputStream processInputStream(InputStream in) throws IOException {
        ByteArrayInputStream byteArrayInputStream;
        byte[] buff = new byte[1024];
        int len = -1;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            while ((len = in.read(buff)) > 0) {
                out.write(buff, 0, len);
                out.flush();
            }
            byteArrayInputStream = new ByteArrayInputStream(out.toByteArray());
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ioe) {
                LoggerUtilities.logException((Throwable)ioe);
                throw ioe;
            }
        }
        out.close();
        return byteArrayInputStream;
    }

    public static InputStream getMetadataFile(InputStream in, String fileName) {
        ZipInputStream zin = new ZipInputStream(in);
        ZipEntry entry = null;
        boolean found = false;
        try {
            while ((entry = zin.getNextEntry()) != null) {
                if (!entry.getName().equalsIgnoreCase(fileName)) continue;
                found = true;
                break;
            }
            if (found) {
                return PolicyUtil.processInputStream(zin);
            }
        }
        catch (IOException ioe) {
            LoggerUtilities.logException((Throwable)ioe);
        }
        return null;
    }

    public static boolean isLowBandwidthEnabled(GroupObject groupObj, String packageVersion) throws Exception {
        Boolean lowBandwidthEnabled = new AmlLowBandwidth().getDefEnableLowBandwidth();
        if (Utility.compareVersion((String)packageVersion, (String)"14.0.0.1000", (boolean)true) >= 0) {
            SemClientGroup semClientGroup = groupObj.getSemClientGroup();
            CloudPolicyHandler cloudHandler = CloudPolicyHandler.getInstance();
            lowBandwidthEnabled = cloudHandler.isEnableLowBandwidth(semClientGroup, new GUID(Manager.getCurrentDomainId()));
        }
        return Boolean.TRUE.equals(lowBandwidthEnabled);
    }

    public static String getRegex(String validator) {
        return ".*[" + validator + "].*";
    }
}

