/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.up.logicobject;

import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.schema.UpgradePolicy;
import com.sygate.scm.common.configobject.schema.UpgradeScheduleConfiguration;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.logicobject.PolicyIntObjectBase;
import com.sygate.scm.console.logicobject.PolicyObjectBase;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.util.Utility;

public class UpgradePolicyObject
extends PolicyIntObjectBase {
    protected UpgradeScheduleConfiguration schedule;

    public UpgradePolicyObject() {
    }

    public UpgradePolicyObject(PolicyIntObjectBase policyObject) {
        super(policyObject);
    }

    public UpgradePolicyObject(TopLevelObject policy) {
        super(policy);
        this.schedule = this.getUpgradeScheduleConfiguration();
    }

    @Override
    protected PolicyObjectBase createPolicyObject(TopLevelObject policyObj) throws ConsoleException {
        if (!(policyObj instanceof UpgradePolicy)) {
            throw new ConsoleException(302645248, 32);
        }
        return new UpgradePolicyObject(policyObj);
    }

    private UpgradeScheduleConfiguration getUpgradeScheduleConfiguration() {
        assert (this.policy != null);
        UpgradeScheduleConfiguration schedule = ((UpgradePolicy)this.policy).getOptUpgradeScheduleConfiguration();
        if (schedule == null) {
            schedule = new UpgradeScheduleConfiguration();
            ((UpgradePolicy)this.policy).setOptUpgradeScheduleConfiguration(schedule);
        }
        return schedule;
    }

    public UpgradePolicy getUpgradePolicy() {
        return (UpgradePolicy)this.policy;
    }

    @Override
    public boolean getEnabled() {
        return Utility.getBooleanValue((Boolean)((UpgradePolicy)this.policy).getOptEnable(), (Boolean)((UpgradePolicy)this.policy).getDefEnable());
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        ((UpgradePolicy)this.policy).setOptEnable(Boolean.valueOf(isEnabled));
    }

    @Override
    public String getCreator() {
        return ((UpgradePolicy)this.policy).getOptCreator();
    }

    @Override
    public void setCreator(String creator) {
        ((UpgradePolicy)this.policy).setOptCreator(creator);
    }

    @Override
    public String getTypeDesc() {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.up.upgradePolicy", "UpgradePolicyObject.UpgradePolicy");
    }

    @Override
    public String getTargetType() {
        return "UpgradePolicy";
    }

    @Override
    public String getTargetName() {
        return "UpgradePolicyApplied";
    }

    @Override
    public String getRefTargetName() {
        return "SuspendedUpgradePolicyLink";
    }

    @Override
    public int getItemType() {
        return 309;
    }

    @Override
    public String getLocalReferenceName() {
        return "LocalUpgradePolicy";
    }

    public String getStartTime() {
        String value = this.schedule.getOptStartTime();
        return value != null ? value : this.schedule.getDefStartTime();
    }

    public void setStartTime(String value) {
        this.schedule.setOptStartTime(value);
    }

    public String getEndTime() {
        String value = this.schedule.getOptEndTime();
        return value != null ? value : this.schedule.getDefEndTime();
    }

    public void setEndTime(String value) {
        this.schedule.setOptEndTime(value);
    }

    public boolean getEnableLinux() {
        Boolean value = this.schedule.getOptEnableLinux();
        return value != null ? value : this.schedule.getDefEnableLinux();
    }

    public void setEnableLinux(boolean value) {
        this.schedule.setOptEnableLinux(Boolean.valueOf(value));
    }

    public boolean getRunOnMissedEvent() {
        Boolean value = this.schedule.getOptRunOnMissedEvent();
        return value != null ? value : this.schedule.getDefRunOnMissedEvent();
    }

    public void setRunOnMissedEvent(boolean value) {
        this.schedule.setOptRunOnMissedEvent(Boolean.valueOf(value));
    }

    public int getDistributeDays() {
        Integer value = this.schedule.getOptDistributionWindowLengthSecs();
        int v = value != null ? value : this.schedule.getDefDistributionWindowLengthSecs();
        return v / 3600 / 24;
    }

    public void setDistributeDays(int value) {
        this.schedule.setOptDistributionWindowLengthSecs(Integer.valueOf(value * 24 * 3600));
    }

    public int getDelayDays() {
        Integer value = this.schedule.getOptDelayDays();
        return value != null ? value : this.schedule.getDefDelayDays();
    }

    public void setDelayDays(int value) {
        this.schedule.setOptDelayDays(Integer.valueOf(value));
    }

    private void setDay(WeekDay day, boolean value) {
        switch (day) {
            case SUNDAY: {
                this.schedule.setOptEnableSunday(Boolean.valueOf(value));
                break;
            }
            case MONDAY: {
                this.schedule.setOptEnableMonday(Boolean.valueOf(value));
                break;
            }
            case TUESDAY: {
                this.schedule.setOptEnableTuesday(Boolean.valueOf(value));
                break;
            }
            case WEDNESDAY: {
                this.schedule.setOptEnableWednesday(Boolean.valueOf(value));
                break;
            }
            case THURSDAY: {
                this.schedule.setOptEnableThursday(Boolean.valueOf(value));
                break;
            }
            case FRIDAY: {
                this.schedule.setOptEnableFriday(Boolean.valueOf(value));
                break;
            }
            case SATURDAY: {
                this.schedule.setOptEnableSaturday(Boolean.valueOf(value));
            }
        }
    }

    private boolean getWeekday(WeekDay day) {
        Boolean value = false;
        switch (day) {
            case SUNDAY: {
                value = this.schedule.getOptEnableSunday();
                return value != null ? value : this.schedule.getDefEnableSunday();
            }
            case MONDAY: {
                value = this.schedule.getOptEnableMonday();
                return value != null ? value : this.schedule.getDefEnableMonday();
            }
            case TUESDAY: {
                value = this.schedule.getOptEnableTuesday();
                return value != null ? value : this.schedule.getDefEnableTuesday();
            }
            case WEDNESDAY: {
                value = this.schedule.getOptEnableWednesday();
                return value != null ? value : this.schedule.getDefEnableWednesday();
            }
            case THURSDAY: {
                value = this.schedule.getOptEnableThursday();
                return value != null ? value : this.schedule.getDefEnableThursday();
            }
            case FRIDAY: {
                value = this.schedule.getOptEnableFriday();
                return value != null ? value : this.schedule.getDefEnableFriday();
            }
            case SATURDAY: {
                value = this.schedule.getOptEnableSaturday();
                return value != null ? value : this.schedule.getDefEnableSaturday();
            }
        }
        return value;
    }

    public int getWeekdays() {
        int value = 0;
        WeekDay[] weekdays = WeekDay.values();
        for (int i = 0; i < weekdays.length; ++i) {
            boolean b = this.getWeekday(weekdays[i]);
            int flag = b ? 1 : 0;
            value |= flag << i;
        }
        return value;
    }

    public void setWeekdays(int value) {
        WeekDay[] weekdays = WeekDay.values();
        for (int i = 0; i < weekdays.length; ++i) {
            boolean b = (value & 1 << i) > 0;
            this.setDay(weekdays[i], b);
        }
    }

    static enum WeekDay {
        SUNDAY,
        MONDAY,
        TUESDAY,
        WEDNESDAY,
        THURSDAY,
        FRIDAY,
        SATURDAY;

    }
}

