/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.up;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.policy.up.Described;
import com.sygate.scm.console.ui.policy.up.logicobject.UpgradePolicyObject;
import com.sygate.scm.console.ui.util.TimeSpinner1;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.ui.util.VerticalFlowLayout;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import java.awt.FlowLayout;
import java.util.Arrays;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class UpgradePolicyPanel
extends JPanel
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = -443145385458649965L;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String UP = "com.sygate.scm.console.ui.policy.up.upgradePolicy";
    private static final String AUTOMATION_BEGINE_TIME_HOUR = "BeginTimeHour";
    private static final String AUTOMATION_BEGINE_TIME_MIN = "BeginTimeMin";
    private static final String AUTOMATION_END_TIME_HOUR = "EndTimeHour";
    private static final String AUTOMATION_END_TIME_MIN = "EndTimeMin";
    private static final String AUTOMATION_MONDAY = "Monday";
    private static final String AUTOMATION_TUESDAY = "Tuesday";
    private static final String AUTOMATION_WEDNESDAY = "Wednesday";
    private static final String AUTOMATION_THURSDAY = "Thursday";
    private static final String AUTOMATION_FRIDAY = "Friday";
    private static final String AUTOMATION_SATURDAY = "Saturday";
    private static final String AUTOMATION_SUNDAY = "Sunday";
    private static final String AUTOMATION_RUN_ON_MISS_EVENT = "RunOnMissedEvent";
    private static final String AUTOMATION_DISTRIBUTE_DAYS = "DistributeDays";
    private static final String AUTOMATION_DELAY_DAYS = "DelayDays";
    private JPanel timePanel;
    private String timePattern = MSGRES.getString("com.sygate.scm.util.util", "timePattern");
    private TimeSpinner1 beginTime = new TimeSpinner1(this.timePattern);
    private TimeSpinner1 endTime = new TimeSpinner1(this.timePattern);
    JPanel schedulePanel;
    private JCheckBox monday = new JCheckBox(MSGRES.getString("com.sygate.scm.console.ui.policy.up.upgradePolicy", "UpgradePolicyPanel.checkbox.Monday"), true);
    private JCheckBox tuesday = new JCheckBox(MSGRES.getString("com.sygate.scm.console.ui.policy.up.upgradePolicy", "UpgradePolicyPanel.checkbox.Tuesday"), true);
    private JCheckBox wednesday = new JCheckBox(MSGRES.getString("com.sygate.scm.console.ui.policy.up.upgradePolicy", "UpgradePolicyPanel.checkbox.Wednesday"), true);
    private JCheckBox thursday = new JCheckBox(MSGRES.getString("com.sygate.scm.console.ui.policy.up.upgradePolicy", "UpgradePolicyPanel.checkbox.Thursday"), true);
    private JCheckBox friday = new JCheckBox(MSGRES.getString("com.sygate.scm.console.ui.policy.up.upgradePolicy", "UpgradePolicyPanel.checkbox.Friday"), true);
    private JCheckBox saturday = new JCheckBox(MSGRES.getString("com.sygate.scm.console.ui.policy.up.upgradePolicy", "UpgradePolicyPanel.checkbox.Saturday"), true);
    private JCheckBox sunday = new JCheckBox(MSGRES.getString("com.sygate.scm.console.ui.policy.up.upgradePolicy", "UpgradePolicyPanel.checkbox.Sunday"), true);
    private List<JCheckBox> weekdayList = Arrays.asList(this.sunday, this.monday, this.tuesday, this.wednesday, this.thursday, this.friday, this.saturday);
    private JCheckBox runOnMissedEvent = new JCheckBox(MSGRES.getString("com.sygate.scm.console.ui.policy.up.upgradePolicy", "UpgradePolicyPanel.checkbox.RunOnMissedEvent"), true);
    private JCheckBox enableLinux = new JCheckBox(MSGRES.getString("com.sygate.scm.console.ui.policy.up.upgradePolicy", "UpgradePolicyPanel.checkbox.EnableLinux"), true);
    private JSpinner distributeDays = new JSpinner(new SpinnerNumberModel(0, 0, 30, 1));
    private JSpinner delayDays = new JSpinner(new SpinnerNumberModel(0, 0, 45, 1));
    private UpgradePolicyObject policyObj;

    public UpgradePolicyPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new VerticalFlowLayout());
        this.add(new AvTemplatePane(MSGRES.getString(UP, "UpgradePolicyPanel.title.PolicyName"), MSGRES.getString(UP, "UpgradePolicyPanel.description.PolicyDescription")));
        this.add(this.getSchedulePanel());
    }

    private JPanel getSchedulePanel() {
        if (this.schedulePanel == null) {
            this.schedulePanel = new JPanel(new VerticalFlowLayout());
            this.schedulePanel.add(this.getTimePanel());
            JPanel distPanel = new JPanel(new FlowLayout(3));
            distPanel.add(new JLabel(MSGRES.getString(UP, "UpgradePolicyPanel.label.Distribution")));
            UIUtilities.setName(((JSpinner.DefaultEditor)this.distributeDays.getEditor()).getTextField(), "policyPage", UIUtilities.ComponentType.TEXTFIELD, AUTOMATION_DISTRIBUTE_DAYS);
            distPanel.add(this.distributeDays);
            distPanel.add(new JLabel(MSGRES.getString(UP, "UpgradePolicyPanel.label.Days")));
            this.schedulePanel.add(new Described(distPanel, MSGRES.getString(UP, "UpgradePolicyPanel.description.Distribution")));
            JPanel dayPanel = new JPanel(new FlowLayout(3, 12, 0));
            JPanel dayPanelWrap = new JPanel(new VerticalFlowLayout());
            dayPanelWrap.add(new JLabel(MSGRES.getString(UP, "UpgradePolicyPanel.label.Weekdays")));
            dayPanelWrap.add(dayPanel);
            UIUtilities.setName(this.sunday, "policyPage", UIUtilities.ComponentType.CHECKBOX, AUTOMATION_SUNDAY);
            dayPanel.add(this.sunday);
            UIUtilities.setName(this.monday, "policyPage", UIUtilities.ComponentType.CHECKBOX, AUTOMATION_MONDAY);
            dayPanel.add(this.monday);
            UIUtilities.setName(this.tuesday, "policyPage", UIUtilities.ComponentType.CHECKBOX, AUTOMATION_TUESDAY);
            dayPanel.add(this.tuesday);
            UIUtilities.setName(this.wednesday, "policyPage", UIUtilities.ComponentType.CHECKBOX, AUTOMATION_WEDNESDAY);
            dayPanel.add(this.wednesday);
            UIUtilities.setName(this.thursday, "policyPage", UIUtilities.ComponentType.CHECKBOX, AUTOMATION_THURSDAY);
            dayPanel.add(this.thursday);
            UIUtilities.setName(this.friday, "policyPage", UIUtilities.ComponentType.CHECKBOX, AUTOMATION_FRIDAY);
            dayPanel.add(this.friday);
            UIUtilities.setName(this.saturday, "policyPage", UIUtilities.ComponentType.CHECKBOX, AUTOMATION_SATURDAY);
            dayPanel.add(this.saturday);
            this.schedulePanel.add(new Described(dayPanelWrap, MSGRES.getString(UP, "UpgradePolicyPanel.description.Weekdays")));
            JPanel delayPanel = new JPanel(new FlowLayout(3));
            delayPanel.add(new JLabel(MSGRES.getString(UP, "UpgradePolicyPanel.label.DelayDays")));
            UIUtilities.setName(((JSpinner.DefaultEditor)this.delayDays.getEditor()).getTextField(), "policyPage", UIUtilities.ComponentType.TEXTFIELD, AUTOMATION_DELAY_DAYS);
            delayPanel.add(this.delayDays);
            delayPanel.add(new JLabel(MSGRES.getString(UP, "UpgradePolicyPanel.label.Days")));
            this.schedulePanel.add(new Described(delayPanel, MSGRES.getString(UP, "UpgradePolicyPanel.description.DelayDays")));
            UIUtilities.setName(this.runOnMissedEvent, "policyPage", UIUtilities.ComponentType.CHECKBOX, AUTOMATION_RUN_ON_MISS_EVENT);
            this.schedulePanel.add(new Described(this.runOnMissedEvent, MSGRES.getString(UP, "UpgradePolicyPanel.description.RunOnMissedEvent")));
        }
        return this.schedulePanel;
    }

    private JPanel getTimePanel() {
        if (this.timePanel == null) {
            this.timePanel = new JPanel(new VerticalFlowLayout(0, 0));
            JPanel rangePanel = new JPanel(new FlowLayout(3, 0, 0));
            this.timePanel.add(rangePanel);
            JPanel fromPanel = new JPanel(new FlowLayout(3));
            rangePanel.add(fromPanel);
            fromPanel.add(new JLabel(MSGRES.getString(UP, "UpgradePolicyPanel.label.BeginTime")));
            UIUtilities.setName(this.beginTime.getTextFieldHour(), "policyPage", UIUtilities.ComponentType.TEXTFIELD, AUTOMATION_BEGINE_TIME_HOUR);
            UIUtilities.setName(this.beginTime.getTextFieldMinute(), "policyPage", UIUtilities.ComponentType.TEXTFIELD, AUTOMATION_BEGINE_TIME_MIN);
            fromPanel.add(this.beginTime);
            JPanel toPanel = new JPanel(new FlowLayout(3));
            rangePanel.add(toPanel);
            toPanel.add(new JLabel(MSGRES.getString(UP, "UpgradePolicyPanel.label.EndTime")));
            UIUtilities.setName(this.endTime.getTextFieldHour(), "policyPage", UIUtilities.ComponentType.TEXTFIELD, AUTOMATION_END_TIME_HOUR);
            UIUtilities.setName(this.endTime.getTextFieldMinute(), "policyPage", UIUtilities.ComponentType.TEXTFIELD, AUTOMATION_END_TIME_MIN);
            toPanel.add(this.endTime);
            this.timePanel.add(new Described(rangePanel, MSGRES.getString(UP, "UpgradePolicyPanel.description.TimeWindow")));
        }
        return this.timePanel;
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_client_upgrade";
    }

    public void setObject(UpgradePolicyObject policyObj) throws ConsoleException {
        this.policyObj = policyObj;
        ConsoleLogger.log("Updating UpgradePolicyPanel");
        this.removeAll();
        this.initialize();
        this.validate();
        this.repaint();
        ConsoleLogger.log("Updating UpgradePolicyPanel done");
        this.updateValues();
    }

    protected void updateValues() throws ConsoleException {
        assert (this.policyObj != null);
        String[] start = this.policyObj.getStartTime().split(":");
        if (start.length != 2) {
            throw new ConsoleException();
        }
        this.beginTime.setHour(Integer.parseInt(start[0]));
        this.beginTime.setMinute(Integer.parseInt(start[1]));
        String[] end = this.policyObj.getEndTime().split(":");
        if (end.length != 2) {
            throw new ConsoleException();
        }
        this.endTime.setHour(Integer.parseInt(end[0]));
        this.endTime.setMinute(Integer.parseInt(end[1]));
        this.enableLinux.setSelected(this.policyObj.getEnableLinux());
        this.runOnMissedEvent.setSelected(this.policyObj.getRunOnMissedEvent());
        this.distributeDays.setValue(this.policyObj.getDistributeDays());
        this.delayDays.setValue(this.policyObj.getDelayDays());
        int weekdaysValue = this.policyObj.getWeekdays();
        this.setWeekdays(weekdaysValue);
    }

    private void setWeekdays(int weekdaysValue) {
        this.sunday.setSelected((weekdaysValue & 1) > 0);
        this.monday.setSelected((weekdaysValue & 2) > 0);
        this.tuesday.setSelected((weekdaysValue & 4) > 0);
        this.wednesday.setSelected((weekdaysValue & 8) > 0);
        this.thursday.setSelected((weekdaysValue & 0x10) > 0);
        this.friday.setSelected((weekdaysValue & 0x20) > 0);
        this.saturday.setSelected((weekdaysValue & 0x40) > 0);
    }

    private static int b2i(boolean b) {
        return b ? 1 : 0;
    }

    private int getWeekdays() {
        return UpgradePolicyPanel.b2i(this.sunday.isSelected()) | UpgradePolicyPanel.b2i(this.monday.isSelected()) << 1 | UpgradePolicyPanel.b2i(this.tuesday.isSelected()) << 2 | UpgradePolicyPanel.b2i(this.wednesday.isSelected()) << 3 | UpgradePolicyPanel.b2i(this.thursday.isSelected()) << 4 | UpgradePolicyPanel.b2i(this.friday.isSelected()) << 5 | UpgradePolicyPanel.b2i(this.saturday.isSelected()) << 6;
    }

    public void save() {
        this.policyObj.setEnableLinux(this.enableLinux.isSelected());
        this.policyObj.setRunOnMissedEvent(this.runOnMissedEvent.isSelected());
        this.policyObj.setDistributeDays((Integer)this.distributeDays.getValue());
        this.policyObj.setStartTime(String.format("%02d:%02d", this.beginTime.getHour(), this.beginTime.getMinute()));
        this.policyObj.setEndTime(String.format("%02d:%02d", this.endTime.getHour(), this.endTime.getMinute()));
        this.policyObj.setWeekdays(this.getWeekdays());
        this.policyObj.setDelayDays((Integer)this.delayDays.getValue());
    }

    public void setReadOnly() {
    }
}

