/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.up;

import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.schema.UpgradePolicy;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.logicobject.AdminObject;
import com.sygate.scm.console.logicobject.AppliablePolicyPool;
import com.sygate.scm.console.logicobject.GroupPolicyObject;
import com.sygate.scm.console.ui.policy.BasePolicyDialog;
import com.sygate.scm.console.ui.policy.PolicyTabPanel;
import com.sygate.scm.console.ui.policy.common.PolicyInt;
import com.sygate.scm.console.ui.policy.up.UpgradePolicyPanel;
import com.sygate.scm.console.ui.policy.up.UpgradePolicyTabPanel;
import com.sygate.scm.console.ui.policy.up.logicobject.UpgradePolicyObject;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.util.GUIDGenerator;
import com.sygate.scm.util.SystemLevel;
import com.sygate.scm.util.UpgradePolicyUtility;
import com.sygate.scm.util.Utility;
import java.awt.Component;
import java.awt.Container;
import java.util.logging.Logger;
import javax.swing.JPanel;

public class UpgradePolicyDialog
extends BasePolicyDialog {
    private static final long serialVersionUID = 1L;
    private static final MessageResourcesFile TEMPLATE_RES = new MessageResourcesFile("com.sygate.scm.util.template.template_displayname");
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String UP = "com.sygate.scm.console.ui.policy.up.upgradePolicy";
    private static final String AUTOMATION_BUTTON_OK = "ButtonOK";
    private static final Logger logger = Logger.getLogger(UpgradePolicyDialog.class.getName());
    private UpgradePolicyObject policyObj;
    private UpgradePolicyPanel upgradePolicyPanel;

    public UpgradePolicyDialog(String name, GroupPolicyObject gpObj, Boolean ... isLocal) {
        super(309, name, gpObj, MSGRES.getString(UP, "UpgradePolicyDialog.title"), true, isLocal);
        this.initialize();
    }

    public UpgradePolicyDialog(AbstractUIObject pool) {
        this(pool, false);
    }

    public UpgradePolicyDialog(AbstractUIObject pool, boolean isCheckPolicyEnforcement) {
        super(309, pool, MSGRES.getString(UP, "UpgradePolicyDialog.title"), isCheckPolicyEnforcement, true);
        this.initialize();
    }

    @Override
    public PolicyInt createNewPolicy(AppliablePolicyPool pool) {
        String newName;
        this.setNewPolicy(true);
        UpgradePolicy policy = this.createUpgradePolicy();
        this.policyObj = new UpgradePolicyObject((TopLevelObject)policy);
        if (this.policyObj.getName() != null && (newName = PolicyHandler.adjustName(this.policyObj.getName(), pool.getAllName(), 255)) != null) {
            this.policyObj.setName(newName);
        }
        this.policyObj.addNewObj((TopLevelObject)policy);
        this.setValues();
        return this.policyObj;
    }

    @Override
    public PolicyInt createNewPolicy(TopLevelObject policy) {
        this.policyObj = new UpgradePolicyObject(policy);
        this.setValues();
        return this.policyObj;
    }

    @Override
    protected void commit() {
        this.policyObj.getUpgradePolicy().setName(this.getOverviewPanel().getPolicyName());
        this.policyObj.getUpgradePolicy().setOptDescription(this.getOverviewPanel().getPolicyDesc());
        this.policyObj.getUpgradePolicy().setOptEnable(Boolean.valueOf(this.getOverviewPanel().isPolicyEnabled()));
        this.getUpgradePolicyPanel().save();
    }

    @Override
    protected boolean isValidate() {
        return true;
    }

    @Override
    protected PolicyTabPanel createTabPanel() {
        UpgradePolicyTabPanel buttonPanel = new UpgradePolicyTabPanel(this, "<html>" + MSGRES.getString(UP, "UpgradePolicyDialog.UpgradePolicy") + "</html>", "up_policy_32.png");
        buttonPanel.putClientProperty("cssClass", "UpgradePolicyDialogTabPanel");
        return buttonPanel;
    }

    @Override
    protected void addPolicyEditorPanels(JPanel mainPanel) {
        super.addPolicyEditorPanels(mainPanel);
        mainPanel.add((Component)UIUtilities.createScrollPaneWithoutBoard(this.getUpgradePolicyPanel()), MSGRES.getString(UP, "UpgradePolicyTabPanel.UpgradePolicySettings"));
    }

    protected UpgradePolicyPanel getUpgradePolicyPanel() {
        if (this.upgradePolicyPanel == null) {
            this.upgradePolicyPanel = new UpgradePolicyPanel();
        }
        return this.upgradePolicyPanel;
    }

    @Override
    protected Container[] readOnlyContainers() {
        return new Container[]{this.getOverviewPanel(), this.getUpgradePolicyPanel()};
    }

    private void initialize() {
        UIUtilities.setName(this.jBOk, "policyPage", UIUtilities.ComponentType.BUTTON, AUTOMATION_BUTTON_OK);
    }

    private UpgradePolicy createUpgradePolicy() {
        UpgradePolicy policy = UpgradePolicyUtility.getInstance().getDefaultUpgradePolicy(null);
        if (policy == null) {
            policy = new UpgradePolicy();
            String GUIDString = new GUIDGenerator().getGUIDString();
            policy.setId(GUIDString);
            MetadataAttributes mAttr = new MetadataAttributes();
            policy.setMetadataAttributes(mAttr);
        }
        policy.setOptCreator(AdminObject.retrieveCurrentAdminObject().getName());
        policy.setOptEnable(Boolean.TRUE);
        policy.setName(TEMPLATE_RES.getString("$$I18N.DefaultSPlcyTp.NEW.UPGRADE.POLICY$$"));
        policy.setOptDescription("");
        return policy;
    }

    private void setValues() {
        block2: {
            try {
                this.getOverviewPanel().setObject(this.policyObj);
                this.getOverviewPanel().setPolicyEnabled(Utility.getBooleanValue((Boolean)this.policyObj.getUpgradePolicy().getOptEnable(), (Boolean)this.policyObj.getUpgradePolicy().getDefEnable()));
                this.getUpgradePolicyPanel().setObject(this.policyObj);
            }
            catch (ConsoleException ex) {
                logger.log(SystemLevel.STDERR, "", ex);
                if (!ex.needRelogin()) break block2;
                Manager.getFrame().showLoginPanel();
            }
        }
    }
}

