/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.override.logicobject;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.ui.policy.override.logicobject.ExceptionUIObject;
import java.awt.Toolkit;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class PolicyExceptionUIObject
implements TableRow {
    private String gehProtectionTechnolgy;
    private String gehPlatform = MSGRES.getString("com.sygate.scm.console.ui.policy.override.override", "OverridePanel.platform.windows");
    private String gehOverride;
    private String gehOverrideDisplayName;
    private String gehAction;
    private ExceptionUIObject gehRiskData;
    private String gehSource = null;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String GEH = "com.sygate.scm.console.ui.policy.override.override";
    private static final int COLUMN_INDEX_EXCEPTION_ITEM = 0;
    public static final int COLUMN_INDEX_PLATFORM = 1;
    public static final int COLUMN_INDEX_PROTECTION_TECHNOLOGY = 2;
    public static final int COLUMN_INDEX_ACTION = 3;
    public static final int COLUMN_INDEX_SOURCE = 4;
    public static final String PLATFORM_WIN = MSGRES.getString("com.sygate.scm.console.ui.policy.override.override", "OverridePanel.platform.windows");
    public static final String PLATFORM_LINUX = MSGRES.getString("com.sygate.scm.console.ui.policy.override.override", "OverridePanel.platform.linux");
    public static final String PLATFORM_MAC = MSGRES.getString("com.sygate.scm.console.ui.policy.override.override", "OverridePanel.platform.macintosh");

    public PolicyExceptionUIObject() {
    }

    public PolicyExceptionUIObject(String pTechnology, String override, String action, ExceptionUIObject riskData, String source) {
        this(pTechnology, null, override, action, riskData, source);
    }

    public PolicyExceptionUIObject(String pTechnology, String platform, String override, String action, ExceptionUIObject riskData, String source) {
        this(pTechnology, platform, override, action, riskData, source, null);
    }

    public PolicyExceptionUIObject(String pTechnology, String platform, String override, String action, ExceptionUIObject riskData, String source, String overrideDisplayName) {
        this.gehProtectionTechnolgy = pTechnology;
        this.gehOverrideDisplayName = this.gehOverride = override;
        if (overrideDisplayName != null) {
            this.gehOverrideDisplayName = overrideDisplayName;
        }
        this.gehAction = action;
        this.gehRiskData = riskData;
        if (platform != null) {
            this.gehPlatform = platform;
        }
        this.gehSource = source;
    }

    public String getProtectionTechnology() {
        return this.gehProtectionTechnolgy;
    }

    public JLabel getPlatformLabel() {
        JLabel label = new JLabel();
        ImageIcon platformIcon = PolicyExceptionUIObject.getPlatformIcon(this.gehPlatform);
        if (platformIcon != null) {
            label.setIcon(platformIcon);
        }
        label.setText(this.gehPlatform);
        return label;
    }

    private static ImageIcon getPlatformIcon(String packagePlatform) {
        if (MSGRES.getString(GEH, "OverridePanel.platform.windows").equals(packagePlatform)) {
            return new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("windowsIcon.png")));
        }
        if (MSGRES.getString(GEH, "OverridePanel.platform.macintosh").equals(packagePlatform)) {
            return new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("appleIcon.png")));
        }
        if (MSGRES.getString(GEH, "OverridePanel.platform.linux").equals(packagePlatform)) {
            return new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("icon_os_linux.png")));
        }
        return null;
    }

    public String getGehOverrideDisplayName() {
        return this.gehOverrideDisplayName;
    }

    public String getOverride() {
        return this.gehOverride;
    }

    public String getAction() {
        return this.gehAction;
    }

    public ExceptionUIObject getRiskData() {
        return this.gehRiskData;
    }

    public void setProtectionTechnology(String ptechnology) {
        this.gehProtectionTechnolgy = ptechnology;
    }

    public void setPlatform(String platform) {
        this.gehPlatform = platform;
    }

    public String getPlatform() {
        return this.gehPlatform;
    }

    public void setAction(String action) {
        this.gehAction = action;
    }

    public void setRiskData(ExceptionUIObject riskData) {
        this.gehRiskData = riskData;
    }

    @Override
    public Object getValueAt(int index) {
        switch (index) {
            case 2: {
                return this.getProtectionTechnology();
            }
            case 1: {
                return this.getPlatformLabel();
            }
            case 0: {
                return this.gehOverrideDisplayName;
            }
            case 3: {
                return this.getAction();
            }
            case 4: {
                return this.getGehSource();
            }
        }
        return null;
    }

    @Override
    public Class<?> getValueTypeAt(int index) {
        switch (index) {
            case 1: {
                return JLabel.class;
            }
            case 2: {
                return String.class;
            }
            case 0: {
                return String.class;
            }
            case 3: {
                return String.class;
            }
            case 4: {
                return String.class;
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int index) {
        switch (index) {
            case 3: {
                this.setAction((String)value);
                break;
            }
        }
    }

    public String getGehSource() {
        return this.gehSource;
    }

    public void setGehSource(String gehSource) {
        this.gehSource = gehSource;
    }

    public boolean isSepmUiDefinedException() {
        return this.gehSource == null || this.gehSource.isEmpty();
    }

    public String toString() {
        return "[" + this.gehOverride + ", " + this.gehPlatform + ", " + this.gehAction + ", " + this.gehProtectionTechnolgy + ", " + this.gehRiskData.toString() + "]";
    }
}

