/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.override.logicobject;

import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.schema.PolicyOverride;
import com.sygate.scm.common.configobject.schema.SourceInfo;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.logicobject.PolicyIntObjectBase;
import com.sygate.scm.console.logicobject.PolicyObjectBase;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.util.Utility;
import java.util.Vector;

public class OverridePolicyObject
extends PolicyIntObjectBase {
    private boolean isExclusiveEdit = false;

    public OverridePolicyObject() {
        this.setIsExclusiveEdit();
    }

    public OverridePolicyObject(PolicyIntObjectBase policyObject) {
        super(policyObject);
        this.setIsExclusiveEdit();
    }

    public OverridePolicyObject(TopLevelObject policy) {
        super(policy);
        this.setIsExclusiveEdit();
    }

    @Override
    protected PolicyObjectBase createPolicyObject(TopLevelObject policyObj) throws ConsoleException {
        if (!(policyObj instanceof PolicyOverride)) {
            throw new ConsoleException(302645248, 32);
        }
        this.setIsExclusiveEdit();
        return new OverridePolicyObject(policyObj);
    }

    private void setIsExclusiveEdit() {
        PolicyOverride overridePolicy = this.getOverridePolicy();
        if (overridePolicy != null) {
            Vector sources = overridePolicy.getSourceInfo();
            for (SourceInfo sourceInfo : sources) {
                if (sourceInfo.getOptexclusiveEdit() == null || !sourceInfo.getOptexclusiveEdit().booleanValue()) continue;
                this.isExclusiveEdit = true;
            }
        }
    }

    public PolicyOverride getOverridePolicy() {
        return (PolicyOverride)this.policy;
    }

    @Override
    public boolean isExclusiveEdit() {
        return this.isExclusiveEdit;
    }

    @Override
    public boolean getEnabled() {
        return Utility.getBooleanValue((Boolean)((PolicyOverride)this.policy).getOptEnable(), (Boolean)((PolicyOverride)this.policy).getDefEnable());
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        ((PolicyOverride)this.policy).setOptEnable(Boolean.valueOf(isEnabled));
    }

    @Override
    public String getCreator() {
        return ((PolicyOverride)this.policy).getOptCreator();
    }

    @Override
    public void setCreator(String creator) {
        ((PolicyOverride)this.policy).setOptCreator(creator);
    }

    @Override
    public String getTypeDesc() {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.override.override", "OverridePolicyObject.OverridePolicy");
    }

    @Override
    public String getTargetType() {
        return "PolicyOverride";
    }

    @Override
    public String getTargetName() {
        return "PolicyOverrideApplied";
    }

    @Override
    public String getRefTargetName() {
        return "SuspendedPolicyOverrideLink";
    }

    @Override
    public int getItemType() {
        return 128;
    }

    @Override
    public String getLocalReferenceName() {
        return "LocalPolicyOverride";
    }
}

