/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.override.logicobject;

import com.sygate.scm.common.configobject.schema.NonPEFileOverride;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.ui.policy.override.PolicyOverrideConstants;
import com.sygate.scm.console.ui.policy.override.logicobject.ExceptionUIObject;

public class NonPEFileExclusionUIObject
extends ExceptionUIObject
implements TableRow {
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String GEH = "com.sygate.scm.console.ui.policy.override.override";
    private Integer actorType;
    private String actor;
    private String fileName;
    private String fileFingerPrint;
    private String fileDescription;
    private Long fileSize;
    private Integer action;

    public NonPEFileExclusionUIObject() {
    }

    public NonPEFileExclusionUIObject(NonPEFileOverride nonPEFileOverride) {
        this(nonPEFileOverride.getOptActorType(), nonPEFileOverride.getOptActor(), nonPEFileOverride.getOptName(), nonPEFileOverride.getOptCheckSum(), nonPEFileOverride.getOptFileSize(), nonPEFileOverride.getOptDescription());
    }

    public NonPEFileExclusionUIObject(Integer actorType, String actor, String fileName, String fileFingerPrint, Long fileSize, String fileDescription) {
        this.setFileName(fileName);
        this.setFileFingerPrint(fileFingerPrint);
        this.setFileSize(fileSize);
        this.setFileDescription(fileDescription);
        this.setActorType(actorType);
        this.setActor(actor);
    }

    public String getActor() {
        return this.actor;
    }

    public void setActor(String actor) {
        this.actor = actor;
        this.gehContent[3] = actor;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
        this.gehContent[0] = fileName;
    }

    public String getFileFingerPrint() {
        return this.fileFingerPrint;
    }

    public void setFileFingerPrint(String fileFingerPrint) {
        this.fileFingerPrint = fileFingerPrint;
        this.gehContent[1] = fileFingerPrint;
    }

    public String getFileDescription() {
        return this.fileDescription;
    }

    public void setFileDescription(String fileDescription) {
        this.fileDescription = fileDescription;
    }

    public Integer getActorType() {
        return this.actorType;
    }

    public void setActorType(Integer actorType) {
        this.actorType = actorType;
    }

    public Integer getAction() {
        return this.action;
    }

    public void setAction(Integer action) {
        this.action = action;
    }

    public void setAction(String actionString) {
        int actionType = 0;
        if (actionString == null) {
            actionType = 0;
        } else if (actionString.equals(PolicyOverrideConstants.GEH_QUARANTINE)) {
            actionType = 2;
        } else if (actionString.equals(PolicyOverrideConstants.GEH_BLOCK)) {
            actionType = 1;
        } else if (actionString.equals(PolicyOverrideConstants.GEH_LOGONLY)) {
            actionType = 3;
        } else if (actionString.equals(PolicyOverrideConstants.GEH_IGNORE)) {
            actionType = 0;
        }
        this.setAction(actionType);
    }

    public String getActionString() {
        Integer actionType = this.getAction();
        if (actionType == null) {
            actionType = 0;
        }
        String actionString = null;
        if (actionType == 2) {
            actionString = PolicyOverrideConstants.GEH_QUARANTINE;
        } else if (actionType == 1) {
            actionString = PolicyOverrideConstants.GEH_BLOCK;
        } else if (actionType == 3) {
            actionString = PolicyOverrideConstants.GEH_LOGONLY;
        } else if (actionType == 0) {
            actionString = PolicyOverrideConstants.GEH_IGNORE;
        }
        return actionString;
    }

    public Long getFileSize() {
        return this.fileSize;
    }

    public void setFileSize(Long fileSize) {
        this.fileSize = fileSize;
        if (fileSize != null) {
            this.gehContent[2] = Long.toString(fileSize);
        }
    }

    public String getOverride() {
        return this.getFileFingerPrint();
    }

    @Override
    public Object getValueAt(int index) {
        return null;
    }

    @Override
    public void setValueAt(Object value, int index) {
    }

    @Override
    public Class<?> getValueTypeAt(int index) {
        return null;
    }

    @Override
    protected void setNoOfFields() {
        this.gehNoOfFields = 4;
    }

    @Override
    protected void setRiskType() {
        this.gehRiskType = 13;
    }

    @Override
    protected void setFieldName() {
        this.gehFieldName = new String[]{MSGRES.getString(GEH, "NonPEFileExclusionDialog.label.summary.file.name"), MSGRES.getString(GEH, "NonPEFileExclusionDialog.label.summary.file.checksum"), MSGRES.getString(GEH, "NonPEFileExclusionDialog.label.summary.file.filesize"), MSGRES.getString(GEH, "NonPEFileExclusionDialog.label.summary.actor")};
    }

    @Override
    protected void setContent() {
        this.gehContent = new String[this.gehNoOfFields];
    }
}

