/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.override.logicobject;

import com.sygate.scm.common.configobject.schema.DirectoryOverride;
import com.sygate.scm.common.configobject.schema.Extension;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.ui.policy.override.logicobject.SecurityRiskExceptionUIObject;
import java.util.StringTokenizer;

public class DirectoryExclusionUIObject
extends SecurityRiskExceptionUIObject
implements TableRow {
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String GEH = "com.sygate.scm.console.ui.policy.override.override";
    public static final int SECURITY_RISK = DirectoryOverride.GEPT_RISK;
    public static final int TRUSCAN = DirectoryOverride.GEPT_HPP;
    public static final int ALL = DirectoryOverride.ALL;
    public static final int ADC = DirectoryOverride.GEPT_ADC;
    private String gehDirectoryExclusion;
    private String gehPrefix;
    private String gehExtension;
    private String gehAction;
    private boolean gehExcludeSubdirectory;
    private int gehScanType;

    public DirectoryExclusionUIObject() {
    }

    public DirectoryExclusionUIObject(String dir, String prefix, String extensions, boolean exclude, int scanType, int scanCat) {
        this.setDirectoryExclusion(dir);
        this.setPrefix(prefix);
        this.setExtensionList(extensions);
        this.setExcludeSubdirectory(exclude);
        this.setScanType(scanType);
        this.setGehScanCategories(scanCat);
    }

    public DirectoryExclusionUIObject(DirectoryOverride dir, int scanCat) {
        String path = dir.getOptDirectoryPath();
        path = path == null ? "" : path;
        this.setDirectoryExclusion(path);
        if (dir.getOptScanType() != null) {
            this.setScanType(dir.getOptScanType());
        } else {
            this.setScanType(dir.getDefScanType());
        }
        this.setPrefix(dir.getPrefixVariable());
        if (dir.getOptExcludeSubDirectories() != null) {
            this.setExcludeSubdirectory(dir.getOptExcludeSubDirectories());
        }
        StringBuffer extList = new StringBuffer();
        for (int i = 0; i < dir.getExtensionCount(); ++i) {
            extList.append(dir.getExtension(i).getContent());
            extList.append(",");
        }
        this.setExtensionList(extList.toString());
        this.setGehScanCategories(scanCat);
    }

    @Override
    protected void setNoOfFields() {
        this.gehNoOfFields = 2;
    }

    @Override
    protected void setRiskType() {
        this.gehRiskType = 5;
    }

    @Override
    protected void setContent() {
        this.gehContent = new String[this.gehNoOfFields];
    }

    @Override
    protected void setFieldName() {
        this.gehFieldName = new String[]{MSGRES.getString(GEH, "DirectoryExclusionDialog.label.excludeSubdirectories")};
    }

    public boolean getExcludeSubdirectory() {
        return this.gehExcludeSubdirectory;
    }

    public String getDirectoryExclusion() {
        return this.gehDirectoryExclusion;
    }

    public String getExtensionList() {
        return this.gehExtension;
    }

    public String getPrefix() {
        return this.gehPrefix;
    }

    public int getScanType() {
        return this.gehScanType;
    }

    public String getAction() {
        return this.gehAction;
    }

    public void setExcludeSubdirectory(boolean excl) {
        this.gehExcludeSubdirectory = excl;
        String yesno = "no";
        if (!excl) {
            yesno = "yes";
        }
        this.gehContent[0] = MSGRES.getString(GEH, "DirectoryExclusionDialog.label." + yesno);
    }

    public void setDirectoryExclusion(String directory) {
        this.gehDirectoryExclusion = directory;
    }

    public void setPrefix(String prefix) {
        this.gehPrefix = prefix;
    }

    public void setScanType(int scanType) {
        this.gehScanType = scanType;
    }

    public void setExtensionList(String ext) {
        this.gehExtension = ext;
    }

    public void setAction(String action) {
        this.gehAction = action;
    }

    @Override
    public Object getValueAt(int index) {
        return null;
    }

    @Override
    public Class<?> getValueTypeAt(int index) {
        return null;
    }

    @Override
    public void setValueAt(Object value, int index) {
    }

    public DirectoryOverride getDirectoryOverride() {
        DirectoryOverride dir = new DirectoryOverride();
        dir.setOptDirectoryPath(this.getDirectoryExclusion());
        dir.setPrefixVariable(this.getPrefix());
        dir.setOptExcludeSubDirectories(Boolean.valueOf(this.getExcludeSubdirectory()));
        dir.setOptScanType(Integer.valueOf(this.getScanType()));
        String extList = this.getExtensionList();
        StringTokenizer st = new StringTokenizer(extList, ",");
        String ext = null;
        while (st.hasMoreTokens()) {
            ext = st.nextToken();
            Extension extension = new Extension();
            extension.setContent(ext);
            dir.addExtension(extension);
        }
        return dir;
    }
}

