/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.override.logicobject;

import com.sygate.scm.common.configobject.schema.DetectedProcesses;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.ui.policy.override.logicobject.ExceptionUIObject;
import com.sygate.scm.console.ui.policy.override.logicobject.PolicyExceptionUIObject;

public class DetectedProcessUIObject
extends ExceptionUIObject
implements TableRow {
    private static final String GEH = "com.sygate.scm.console.ui.policy.override.override";
    private static final int ProcessName = 0;
    private static final int ProductName = 2;
    private static final int FilePath = 1;
    private static final int Checksum = 4;
    private static final int Company = 3;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private String gehDetectedProcess;
    private String gehChecksum;
    private String gehAltChecksum;
    private String gehProductName;
    private String gehFilePath;
    private String gehCompany;
    private long gehFileSize;
    private String gehAction;
    private int gehOS;

    public DetectedProcessUIObject() {
    }

    public DetectedProcessUIObject(String checksum, String alterChecksum, String productName, String filePath, String company, long fileSize) {
        this.setDetectedProcess(productName);
        this.setChecksum(checksum);
        this.setAltChecksum(alterChecksum);
        this.setCompany(company);
        this.setFilePath(filePath);
        this.setProductName(productName);
        this.setFileSize(fileSize);
        this.setOS(DetectedProcesses.WINDOWS);
    }

    public DetectedProcessUIObject(String checksum, String alterChecksum, String productName, String filePath, String company, long fileSize, int OS2) {
        this(checksum, alterChecksum, productName, filePath, company, fileSize);
        this.setOS(this.gehOS);
    }

    @Override
    protected void setNoOfFields() {
        this.gehNoOfFields = 5;
    }

    @Override
    protected void setRiskType() {
        this.gehRiskType = 1;
    }

    @Override
    protected void setContent() {
        this.gehContent = new String[this.gehNoOfFields];
    }

    @Override
    protected void setFieldName() {
        this.gehFieldName = new String[]{MSGRES.getString(GEH, "HPPDetectedProcessesDlg.label.detectedProcess"), MSGRES.getString(GEH, "HPPDetectedProcessesDlg.table.productName"), MSGRES.getString(GEH, "HPPDetectedProcessesDlg.table.filePath"), MSGRES.getString(GEH, "HPPDetectedProcessesDlg.table.checksum"), MSGRES.getString(GEH, "HPPDetectedProcessesDlg.table.company")};
    }

    public String getDetectedProcess() {
        return this.gehDetectedProcess;
    }

    public String getChecksum() {
        return this.gehChecksum;
    }

    public String getAltChecksum() {
        return this.gehAltChecksum;
    }

    public String getProductName() {
        return this.gehProductName;
    }

    public String getFilePath() {
        return this.gehFilePath;
    }

    public String getCompany() {
        return this.gehCompany;
    }

    public Long getFileSize() {
        return this.gehFileSize;
    }

    public String getAction() {
        return this.gehAction;
    }

    public void setDetectedProcess(String detectedProcess) {
        this.gehDetectedProcess = detectedProcess;
        int directoryEndIndex = detectedProcess.lastIndexOf("/");
        if (directoryEndIndex < 0) {
            directoryEndIndex = detectedProcess.lastIndexOf("\\");
        }
        if (directoryEndIndex > -1) {
            if (this.gehProductName == null || "".equals(this.gehProductName)) {
                this.setProductName(detectedProcess.substring(directoryEndIndex + 1, detectedProcess.length()));
            }
            if (this.gehFilePath == null || "".equals(this.gehFilePath)) {
                this.setFilePath(detectedProcess.substring(0, directoryEndIndex + 1));
            }
        } else {
            if (this.gehProductName == null || "".equals(this.gehProductName)) {
                this.setProductName(detectedProcess);
            }
            if (this.gehFilePath == null || "".equals(this.gehFilePath)) {
                this.setFilePath("");
            }
        }
        this.gehContent[0] = detectedProcess;
    }

    public void setChecksum(String checksum) {
        this.gehChecksum = checksum;
        this.gehContent[3] = checksum;
    }

    public void setAltChecksum(String altChecksum) {
        this.gehAltChecksum = altChecksum;
    }

    public void setProductName(String productName) {
        this.gehProductName = productName;
        this.gehContent[1] = productName;
    }

    public void setFilePath(String filePath) {
        this.gehFilePath = filePath;
        this.gehContent[2] = filePath;
    }

    public void setCompany(String company) {
        this.gehCompany = company;
        this.gehContent[4] = company;
    }

    public void setFileSize(long fileSize) {
        this.gehFileSize = fileSize;
    }

    public void setAction(String action) {
        this.gehAction = action;
    }

    public int getOS() {
        return this.gehOS;
    }

    public void setOS(int gehOS) {
        this.gehOS = gehOS;
    }

    public String getOSPlatFormString() {
        return DetectedProcessUIObject.getOSPlatFormString(this.gehOS);
    }

    public static String getOSPlatFormString(int platForm) {
        if (DetectedProcesses.MAC.equals(platForm)) {
            return PolicyExceptionUIObject.PLATFORM_MAC;
        }
        if (DetectedProcesses.LINUX.equals(platForm)) {
            return PolicyExceptionUIObject.PLATFORM_LINUX;
        }
        return PolicyExceptionUIObject.PLATFORM_WIN;
    }

    public static int getOSPlatForm(String osPlatForm) {
        if (PolicyExceptionUIObject.PLATFORM_MAC.equals(osPlatForm)) {
            return DetectedProcesses.MAC;
        }
        if (PolicyExceptionUIObject.PLATFORM_LINUX.equals(osPlatForm)) {
            return DetectedProcesses.LINUX;
        }
        return DetectedProcesses.WINDOWS;
    }

    @Override
    public Object getValueAt(int index) {
        String returnData = null;
        switch (index) {
            case 0: {
                returnData = this.gehContent[0];
                break;
            }
            case 2: {
                returnData = this.gehContent[1];
                break;
            }
            case 1: {
                returnData = this.gehContent[2];
                if (returnData == null) break;
                returnData = returnData.replaceAll("/", "\\\\");
                break;
            }
            case 4: {
                returnData = this.gehContent[3];
                break;
            }
            case 3: {
                returnData = this.gehContent[4];
                break;
            }
        }
        return returnData;
    }

    public Class<String> getValueTypeAt(int index) {
        return String.class;
    }

    @Override
    public void setValueAt(Object value, int index) {
    }
}

