/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.override.logicobject;

import com.sygate.scm.console.ui.policy.override.logicobject.CertificateExclusionUIObject;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.util.AutoClose;
import com.sygate.scm.util.IOUtilities;
import com.sygate.scm.util.SymantecMessageDigest;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.security.auth.x500.X500Principal;

public class CertificateExclusionUIObjectHelper {
    private static final int Sha1StringLength = 40;
    private static final int Sha2StringLength = 64;
    private static final int MaxIssuerLength = 256;
    private static final int MaxSignerLength = 256;

    public static CertificateExclusionUIObject getCertificateExclusionUIObject(String certificateFileName) {
        if (null == certificateFileName) {
            return null;
        }
        CertificateExclusionUIObject certificateObject = null;
        try (AutoClose fileStream = IOUtilities.getAutoCloseInputStream((InputStream)new FileInputStream(certificateFileName));){
            String thumbprintSHA2;
            String thumbprint;
            String signer;
            String issuer;
            CertificateFactory x509CertFact = CertificateFactory.getInstance("X.509");
            X509Certificate cert = (X509Certificate)x509CertFact.generateCertificate((InputStream)fileStream.getObject());
            if (null != cert && CertificateExclusionUIObjectHelper.isValidCertificate(issuer = CertificateExclusionUIObjectHelper.getIssuer(cert), signer = CertificateExclusionUIObjectHelper.getSigner(cert), thumbprint = CertificateExclusionUIObjectHelper.getThumbPrint(cert), thumbprintSHA2 = CertificateExclusionUIObjectHelper.getThumbPrintSHA2(cert))) {
                certificateObject = new CertificateExclusionUIObject(issuer, signer, thumbprint, thumbprintSHA2);
            }
        }
        catch (FileNotFoundException exception) {
            ConsoleLogger.log(exception);
        }
        catch (CertificateException exception) {
            ConsoleLogger.log(exception);
        }
        catch (NoSuchAlgorithmException exception) {
            ConsoleLogger.log(exception);
        }
        return certificateObject;
    }

    public static boolean isValidCertificateExclusionObject(CertificateExclusionUIObject certObj) {
        if (null == certObj) {
            return false;
        }
        return CertificateExclusionUIObjectHelper.isValidCertificate(certObj.getIssuer(), certObj.getSigner(), certObj.getThumbprint(), certObj.getThumbprintSHA2());
    }

    private static String getIssuer(X509Certificate cert) {
        if (null == cert) {
            return null;
        }
        X500Principal principal = cert.getIssuerX500Principal();
        if (null == principal) {
            return null;
        }
        String issuerName = principal.getName();
        return CertificateExclusionUIObjectHelper.getRfc2253CommonName(issuerName);
    }

    private static String getSigner(X509Certificate cert) {
        if (null == cert) {
            return null;
        }
        String subjectName = cert.getSubjectX500Principal().getName();
        return CertificateExclusionUIObjectHelper.getRfc2253CommonName(subjectName);
    }

    private static String getRfc2253CommonName(String rfc2253Name) {
        if (null == rfc2253Name) {
            return null;
        }
        String cn = null;
        try {
            LdapName ln = new LdapName(rfc2253Name);
            for (Rdn rdn : ln.getRdns()) {
                if (!rdn.getType().equalsIgnoreCase("CN")) continue;
                cn = rdn.getValue().toString();
                break;
            }
        }
        catch (InvalidNameException error) {
            ConsoleLogger.log(error);
        }
        return cn;
    }

    private static String getThumbPrint(X509Certificate cert) throws NoSuchAlgorithmException, CertificateEncodingException {
        MessageDigest md = SymantecMessageDigest.getInstance((String)"SHA-1");
        byte[] der = cert.getEncoded();
        md.update(der);
        byte[] digest = md.digest();
        return CertificateExclusionUIObjectHelper.hexify(digest);
    }

    private static String getThumbPrintSHA2(X509Certificate cert) throws NoSuchAlgorithmException, CertificateEncodingException {
        MessageDigest md = SymantecMessageDigest.getInstance((String)"SHA-256");
        byte[] der = cert.getEncoded();
        md.update(der);
        byte[] digest = md.digest();
        return CertificateExclusionUIObjectHelper.hexify(digest);
    }

    private static String hexify(byte[] bytes) {
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        StringBuffer buf = new StringBuffer(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            buf.append(hexDigits[(bytes[i] & 0xF0) >> 4]);
            buf.append(hexDigits[bytes[i] & 0xF]);
        }
        return buf.toString();
    }

    private static boolean isValidCertificate(String issuer, String signer, String thumbprint, String thumbprintSHA2) {
        if (CertificateExclusionUIObjectHelper.isEmptyString(issuer) || CertificateExclusionUIObjectHelper.isEmptyString(signer) || CertificateExclusionUIObjectHelper.isEmptyString(thumbprint)) {
            return false;
        }
        if (issuer.length() > 256) {
            return false;
        }
        if (signer.length() > 256) {
            return false;
        }
        if (thumbprint.length() != 40) {
            return false;
        }
        return thumbprintSHA2 == null || CertificateExclusionUIObjectHelper.isEmptyString(thumbprintSHA2) || thumbprintSHA2.length() == 64;
    }

    private static boolean isEmptyString(String str) {
        return null == str || str.isEmpty();
    }
}

