/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.override.logicobject;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.ui.policy.override.logicobject.ExceptionUIObject;
import java.text.MessageFormat;
import java.util.Optional;

public class CertificateExclusionUIObject
extends ExceptionUIObject
implements TableRow {
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String GEH = "com.sygate.scm.console.ui.policy.override.override";
    private String issuer;
    private String signer;
    private String thumbprint;
    private String thumbprintSHA2;
    private String gehAction;

    public CertificateExclusionUIObject() {
    }

    public CertificateExclusionUIObject(String issuer, String signer, String thumbPrint, String thumbPrintSHA2) {
        this.setIssuer(issuer);
        this.setSigner(signer);
        this.setThumbprint(thumbPrint);
        this.setThumbprintSHA2(thumbPrintSHA2);
    }

    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String gehIssuer) {
        if (null != this.gehContent) {
            this.gehContent[0] = gehIssuer;
        }
        this.issuer = gehIssuer;
    }

    public String getSigner() {
        return this.signer;
    }

    public void setSigner(String gehSigner) {
        if (null != this.gehContent) {
            this.gehContent[1] = gehSigner;
        }
        this.signer = gehSigner;
    }

    public String getThumbprint() {
        return this.thumbprint;
    }

    public void setThumbprint(String gehThumbprint) {
        if (null != this.gehContent) {
            this.gehContent[2] = gehThumbprint;
        }
        this.thumbprint = gehThumbprint;
    }

    public String getThumbprintSHA2() {
        return this.thumbprintSHA2;
    }

    public void setThumbprintSHA2(String gehThumbprintSHA2) {
        if (null != this.gehContent) {
            this.gehContent[3] = gehThumbprintSHA2;
        }
        this.thumbprintSHA2 = gehThumbprintSHA2;
    }

    @Override
    public Object getValueAt(int index) {
        return null;
    }

    @Override
    public void setValueAt(Object value, int index) {
    }

    @Override
    public Class<?> getValueTypeAt(int index) {
        return null;
    }

    @Override
    protected void setNoOfFields() {
        this.gehNoOfFields = 4;
    }

    @Override
    protected void setRiskType() {
        this.gehRiskType = 12;
    }

    @Override
    protected void setFieldName() {
        this.gehFieldName = new String[]{MSGRES.getString(GEH, "CertificateExceptionDialog.label.issuer"), MSGRES.getString(GEH, "CertificateExceptionDialog.label.signer"), MSGRES.getString(GEH, "CertificateExceptionDialog.label.sha1"), MSGRES.getString(GEH, "CertificateExceptionDialog.label.sha2")};
    }

    @Override
    protected void setContent() {
        this.gehContent = new String[this.gehNoOfFields];
    }

    public String getAction() {
        return this.gehAction;
    }

    public void setAction(String action) {
        this.gehAction = action;
    }

    public String getDisplayName() {
        Optional<String> sha256Value = Optional.ofNullable(this.getThumbprintSHA2()).filter(v -> !v.isEmpty());
        return Optional.ofNullable(this.getSigner()).filter(v -> !v.isEmpty()).map(v -> this.formatDisplayName(this.getSigner())).orElse(this.formatDisplayName(sha256Value.orElse(this.getThumbprint())));
    }

    public String formatDisplayName(String value) {
        return MessageFormat.format(MSGRES.getString(GEH, "CertificateExceptionDialog.displayname"), value);
    }
}

