/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.override;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.policy.override.logicobject.TrustedURLDomainUIObject;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.util.Utility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class TrustedURLDomainExceptionDialog
extends DialogBase {
    private static final long serialVersionUID = -7193255645493988983L;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String GEH = "com.sygate.scm.console.ui.policy.override.override";
    private static final String EXCLUDE = "?";
    private JTextField gehDomainNameTextBox;
    private String gehDomainName;
    private String gehProtocol = "HTTP";
    private String gehHost;
    private List<String> gehDomainList;
    private TrustedURLDomainUIObject gehSelectedDomainExclusion;
    private String gehDomainNameTobeEdited;
    public int INVALID_IP = -1;
    public int VALID_IP = 1;
    public int IP_PART_ERROR = 0;

    public TrustedURLDomainExceptionDialog() {
        super(Manager.getFrame(), MSGRES.getString(GEH, "TrustedURLDomainExceptionDialog.title.domain"), true);
        this.initialize();
        UiUtilities.centerComponent((Component)this);
    }

    public TrustedURLDomainExceptionDialog(String domain) {
        super(Manager.getFrame(), MSGRES.getString(GEH, "TrustedURLDomainExceptionDialog.title.domainEdit"), true);
        this.gehDomainName = domain;
        this.gehDomainNameTobeEdited = domain;
        this.initialize();
        UiUtilities.centerComponent((Component)this);
    }

    private void initialize() {
        Container cont = this.getContentPane();
        cont.setLayout(new BorderLayout());
        JPanel newPanel = new JPanel();
        newPanel.setLayout(new BoxLayout(newPanel, 1));
        JLabel descTextLabel = new JLabel(MSGRES.getString(GEH, "TrustedURLDomainExceptionDialog.heading.note"));
        AvTemplatePane avPane = new AvTemplatePane(MSGRES.getString(GEH, "TrustedURLDomainExceptionDialog.heading.label"), MSGRES.getString(GEH, "TrustedURLDomainExceptionDialog.heading.desc"), false);
        avPane.add(descTextLabel);
        newPanel.add(avPane);
        newPanel.add(Box.createVerticalStrut(1));
        newPanel.add(this.getEditPanel());
        cont.add((Component)newPanel, "Center");
        cont.add((Component)this.getButtonPanel(), "South");
        this.pack();
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_geh_override_add_sro_domain";
    }

    private JPanel getEditPanel() {
        JPanel ePanel = new JPanel(new FlowLayout(0));
        JLabel dlabel = new JLabel(MSGRES.getString(GEH, "TrustedURLDomainExceptionDialog.serverName"));
        if (this.gehDomainNameTextBox == null) {
            this.gehDomainNameTextBox = new JTextField();
        }
        RestrictedPlainDocument doc = new RestrictedPlainDocument(1023);
        doc.setValidator(EXCLUDE, false);
        this.gehDomainNameTextBox.setDocument(doc);
        this.gehDomainNameTextBox.setPreferredSize(new Dimension(300, this.gehDomainNameTextBox.getPreferredSize().height));
        ePanel.add(dlabel);
        ePanel.add(this.gehDomainNameTextBox);
        if (this.gehDomainName != null) {
            this.gehDomainNameTextBox.setText(this.gehDomainName);
        }
        ePanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 20));
        return ePanel;
    }

    public void setDomainName(String domainName) {
        this.gehDomainName = domainName;
    }

    public void setList(ArrayList<String> domainList) {
        this.gehDomainList = domainList;
    }

    public TrustedURLDomainUIObject getSelectedDomain() {
        return this.gehSelectedDomainExclusion;
    }

    @Override
    protected boolean isValidate() {
        char[] array;
        int reply;
        this.gehDomainName = this.getDomainNameText();
        this.gehDomainName = this.gehDomainName.toLowerCase();
        if (this.gehDomainName.indexOf("://") != -1) {
            this.gehProtocol = this.gehDomainName.substring(0, this.gehDomainName.indexOf("://")).toUpperCase();
            this.gehDomainName = this.gehDomainName.substring(this.gehProtocol.length() + 3);
        }
        if (this.gehDomainName.indexOf(":") != -1) {
            if (this.gehDomainName.indexOf("]:") != -1) {
                this.gehDomainName = this.gehDomainName.substring(0, this.gehDomainName.lastIndexOf(":"));
            } else if (this.gehDomainName.indexOf(".") != -1 && this.gehDomainName.indexOf("[") == -1 && !this.gehDomainName.startsWith(":")) {
                this.gehDomainName = this.gehDomainName.substring(0, this.gehDomainName.lastIndexOf(":"));
            }
        }
        if (this.gehDomainName.indexOf("/") != -1) {
            this.gehDomainName = this.gehDomainName.substring(0, this.gehDomainName.indexOf("/"));
        }
        if (this.gehDomainName.indexOf("[") != -1) {
            this.gehDomainName = this.gehDomainName.substring(this.gehDomainName.indexOf("[") + 1, this.gehDomainName.indexOf("]"));
        }
        this.gehHost = this.gehDomainName;
        if (this.gehDomainName == null || this.gehDomainName.trim().length() == 0) {
            JOptionPane.showMessageDialog(this, MSGRES.getString(GEH, "TrustedURLDomainExceptionDialog.error.emptyDomainName"), MSGRES.getString(GEH, "OverridePolicySelectDlg.error"), 0);
            return false;
        }
        boolean isValidIpFormat = this.validateAnIpAddressWithRegularExpression(this.gehHost);
        if (isValidIpFormat) {
            boolean isValidIp = Utility.isValidIPAddr((String)this.gehHost);
            if (isValidIp) {
                if (this.gehDomainList != null && (this.gehDomainNameTobeEdited == null || !this.gehDomainNameTobeEdited.equals(this.gehDomainName)) && this.gehDomainList.contains(this.gehDomainName.toUpperCase())) {
                    this.gehDomainName = null;
                    JOptionPane.showMessageDialog(this, MSGRES.getString(GEH, "TrustedURLDomainExceptionDialog.error.ipAddressAlreayUsed"), MSGRES.getString(GEH, "OverridePolicySelectDlg.error"), 0);
                    return false;
                }
                this.gehHost = this.gehDomainName;
                return true;
            }
            JOptionPane.showMessageDialog(this, MSGRES.getString(GEH, "TrustedURLDomainExceptionDialog.error.invalidateIP"), MSGRES.getString(GEH, "OverridePolicySelectDlg.error"), 0);
            return false;
        }
        if (this.gehDomainList != null && (this.gehDomainNameTobeEdited == null || !this.gehDomainNameTobeEdited.equals(this.gehDomainName)) && this.gehDomainList.contains(this.gehDomainName.toUpperCase())) {
            this.gehDomainName = null;
            JOptionPane.showMessageDialog(this, MSGRES.getString(GEH, "TrustedURLDomainExceptionDialog.error.alreayUsed"), MSGRES.getString(GEH, "OverridePolicySelectDlg.error"), 0);
            return false;
        }
        if ("FTP".equals(this.gehProtocol) && (reply = JOptionPane.showConfirmDialog(this, MSGRES.getString(GEH, "TrustedURLDomainExceptionDialog.warning.ftpHostnameException"), MSGRES.getString(GEH, "OverridePolicySelectDlg.warning"), 0, 2)) == 1) {
            return false;
        }
        boolean containInvalidChar = false;
        for (char c : array = this.gehDomainName.toCharArray()) {
            if (c == '-' || c == '.' || c == '*' || c == '[' || c == ']' || c >= '0' && c <= '9' || c >= 'a' && c <= 'z') continue;
            containInvalidChar = true;
            break;
        }
        if (containInvalidChar) {
            JOptionPane.showMessageDialog(this, MSGRES.getString(GEH, "TrustedURLDomainExceptionDialog.error.invalidateChars"), MSGRES.getString(GEH, "OverridePolicySelectDlg.error"), 0);
            return false;
        }
        String domainName = "([\\-\\+0-9a-z]+\\.)";
        String regExp = "^((([a-z]+|\\*)\\.|\\*)?" + domainName + "{1,19}[a-z]+|[a-z0-9\\-]+|(\\d{1,3}\\.){3}\\d{1,3})";
        Pattern pattern = null;
        Matcher matcher = null;
        pattern = Pattern.compile(regExp);
        matcher = pattern.matcher(this.gehDomainName);
        if (!matcher.matches()) {
            JOptionPane.showMessageDialog(this, MSGRES.getString(GEH, "TrustedURLDomainExceptionDialog.error.invalidateDomainName"), MSGRES.getString(GEH, "OverridePolicySelectDlg.error"), 0);
            return false;
        }
        return true;
    }

    private boolean validateAnIpAddressWithRegularExpression(String ipAddress) {
        Pattern pattern = Pattern.compile("^(([0-9]{1,3}\\.){3}[0-9]{1,3}|(.*[:].*))");
        return pattern.matcher(ipAddress).matches();
    }

    public int validateIPParts(String address) throws Exception {
        if (address != null) {
            StringTokenizer tokenizer = new StringTokenizer(address, ".");
            int tokens = tokenizer.countTokens();
            if (tokens != 4) {
                throw new Exception(MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "IPField.msg.theIPAddressDoesNotHave"));
            }
            for (int i = 0; i < 4; ++i) {
                String token = tokenizer.nextToken();
                if (this.isValidIPPart(token)) continue;
                Object[] obj = new Object[]{token};
                String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "IPField.msg.isNotValidIP");
                String fm = MessageFormat.format(str, obj);
                JOptionPane.showMessageDialog(this, fm, MSGRES.getString(GEH, "OverridePolicySelectDlg.error"), 0);
                return this.IP_PART_ERROR;
            }
        }
        return this.VALID_IP;
    }

    private boolean isValidIPPart(String valueAsString) {
        if (valueAsString.length() == 0) {
            return true;
        }
        int valueAsInt = -1;
        try {
            valueAsInt = Integer.parseInt(valueAsString);
            return valueAsInt >= 0 && valueAsInt <= 255;
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    protected void commit() {
        this.gehSelectedDomainExclusion = new TrustedURLDomainUIObject(this.gehProtocol, this.gehHost);
    }

    private String getDomainNameText() {
        String domainName = this.gehDomainNameTextBox.getText().trim();
        return domainName;
    }
}

