/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.override;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.policy.dialog.FolderPrefixGlossaryDialog;
import com.sygate.scm.console.ui.policy.override.PrefixSeparator;
import com.sygate.scm.console.ui.policy.override.logicobject.ApplicationEventFilterUIObject;
import com.sygate.scm.console.ui.policy.override.logicobject.PermittedApplicationUIObject;
import com.sygate.scm.console.ui.policy.override.logicobject.PolicyExceptionUIObject;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.ui.util.VerticalFlowLayout;
import com.sygate.scm.util.ConstantValue;
import com.sygate.scm.util.Utility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Calendar;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class TamperProtectionDialog
extends DialogBase {
    private static final long serialVersionUID = 1L;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String CE_PROPERTY = "com.sygate.scm.console.ui.policy.override.override";
    private JComboBox<String> prefixComboBox;
    private JTextField fileNameTextBox;
    private JCheckBox allowAccessCheckBox;
    private final ArrayList<String> existingPermAppList;
    private final ArrayList<String> gehAddedPermittedApplicationList;
    private PermittedApplicationUIObject permittedApplication;
    private ApplicationEventFilterUIObject applicationEventFilter;
    private String filePathTobeEdited;
    private static final String EXCLUDE = "?*";

    TamperProtectionDialog(ArrayList<String> existingPermAppList, ArrayList<String> gehAddedPermittedApplicationList) {
        super(Manager.getFrame(), MSGRES.getString(CE_PROPERTY, "TamperProtectionDialog.title.add"), true);
        this.existingPermAppList = existingPermAppList;
        this.gehAddedPermittedApplicationList = gehAddedPermittedApplicationList;
        this.createGUI(false);
        UiUtilities.centerComponent((Component)this);
    }

    TamperProtectionDialog(PolicyExceptionUIObject uiObject, ArrayList<String> existingPermAppList, ArrayList<String> gehAddedPermittedApplicationList, boolean isReadonly) {
        super(Manager.getFrame(), MSGRES.getString(CE_PROPERTY, "TamperProtectionDialog.title.edit"), true);
        boolean isPermApp;
        this.existingPermAppList = existingPermAppList;
        this.gehAddedPermittedApplicationList = gehAddedPermittedApplicationList;
        this.createGUI(isReadonly);
        UiUtilities.centerComponent((Component)this);
        this.filePathTobeEdited = uiObject.getOverride();
        boolean bl = isPermApp = uiObject.getRiskData().getRiskType() == 6;
        if (isPermApp) {
            PrefixSeparator separator = new PrefixSeparator(this.filePathTobeEdited);
            String prefix = separator.getPrefix();
            if (prefix != null && !prefix.equals("")) {
                this.prefixComboBox.setSelectedItem(prefix);
            }
            this.fileNameTextBox.setText(separator.getPath());
        } else {
            ApplicationEventFilterUIObject pObj = (ApplicationEventFilterUIObject)uiObject.getRiskData();
            String prefix = pObj.getPrefixApplication();
            if (prefix != null && !prefix.equals("")) {
                this.prefixComboBox.setSelectedItem(prefix);
            }
            this.fileNameTextBox.setText(pObj.getApplicationName());
        }
        this.allowAccessCheckBox.setSelected(isPermApp);
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_geh_override_add_tpo";
    }

    @Override
    protected boolean isValidate() {
        String gehFileName = this.getFileName();
        if (gehFileName.length() == 0) {
            JOptionPane.showMessageDialog(this, MSGRES.getString(CE_PROPERTY, "TamperProtectionDialog.error.emptyApplicationName"), MSGRES.getString(CE_PROPERTY, "OverridePolicySelectDlg.error"), 0);
            return false;
        }
        if (!this.validateInputFullCheck(gehFileName)) {
            return false;
        }
        ArrayList<String> existingData = this.isPermittedApplication() ? this.existingPermAppList : this.gehAddedPermittedApplicationList;
        String gehPrefixFileName = this.getPrefixFileName();
        if ((this.filePathTobeEdited == null || !this.filePathTobeEdited.equals(gehPrefixFileName)) && existingData.contains(gehPrefixFileName)) {
            JOptionPane.showMessageDialog(this, MSGRES.getString(CE_PROPERTY, "TamperProtectionDialog.error.alreayUsed"), MSGRES.getString(CE_PROPERTY, "OverridePolicySelectDlg.error"), 0);
            return false;
        }
        return true;
    }

    @Override
    protected void commit() {
        if (this.isPermittedApplication()) {
            this.permittedApplication = new PermittedApplicationUIObject(this.getFileName(), (String)this.prefixComboBox.getSelectedItem());
            this.applicationEventFilter = null;
        } else {
            this.applicationEventFilter = new ApplicationEventFilterUIObject();
            this.applicationEventFilter.setFilterName(this.getPrefixFileName());
            Calendar c = Utility.getCalendarInstance();
            c.set(10, 0);
            c.set(12, 0);
            c.set(13, 0);
            this.applicationEventFilter.setFilterDate(c.getTimeInMillis());
            this.applicationEventFilter.setApplicationName(this.getFileName());
            this.applicationEventFilter.setApplicationInclude(true);
            this.applicationEventFilter.setAnyApplication(false);
            this.applicationEventFilter.setPrefixApplication((String)this.prefixComboBox.getSelectedItem());
            this.applicationEventFilter.setAnyTarget(true);
            this.applicationEventFilter.setAnyEvent(true);
            this.permittedApplication = null;
        }
    }

    String getFileName() {
        String fileName = this.fileNameTextBox.getText().trim();
        if (fileName.contains("\\n")) {
            fileName = fileName.replace("\\n", "\\N");
        }
        return fileName;
    }

    String getPrefixFileName() {
        Object gehPrefixFileName = null;
        String prefix = (String)this.prefixComboBox.getSelectedItem();
        String fileName = this.getFileName();
        gehPrefixFileName = !prefix.trim().equalsIgnoreCase(ConstantValue.getDirKeysByIndex((int)0)) ? "%" + prefix.trim() + "%" + fileName : fileName;
        return gehPrefixFileName;
    }

    boolean isPermittedApplication() {
        return this.allowAccessCheckBox.isSelected();
    }

    PermittedApplicationUIObject getPermittedApplication() {
        return this.permittedApplication;
    }

    ApplicationEventFilterUIObject getApplicationEventFilter() {
        return this.applicationEventFilter;
    }

    private void createGUI(boolean isReadonly) {
        Container cont = this.getContentPane();
        cont.setLayout(new BorderLayout());
        JPanel editPanel = new JPanel(new GridBagLayout());
        editPanel.setBorder(BorderFactory.createEmptyBorder(0, 25, 10, 25));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 18;
        JLabel pLabel = new JLabel(MSGRES.getString(CE_PROPERTY, "TamperProtectionDialog.label.prefixVariable"));
        editPanel.add((Component)pLabel, constraints);
        JPanel prefixPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 2;
        c.weightx = 1.0;
        String[] values = ConstantValue.getDirKeys();
        this.prefixComboBox = new JComboBox<String>(values);
        this.prefixComboBox.setSelectedIndex(0);
        this.prefixComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                String selectedPrefix;
                if (event.getStateChange() == 1 && (selectedPrefix = String.valueOf(TamperProtectionDialog.this.prefixComboBox.getSelectedItem())).equalsIgnoreCase("[USER_PROFILE]")) {
                    String title = MSGRES.getString(TamperProtectionDialog.CE_PROPERTY, "TamperProtectionDialog.combobox.userprofileWarning");
                    String msg = MSGRES.getString(TamperProtectionDialog.CE_PROPERTY, "TamperProtectionDialog.combobox.userprofileWarningMessage");
                    JOptionPane.showMessageDialog(Manager.getFrame(), msg, title, 2);
                }
            }
        });
        prefixPanel.add(this.prefixComboBox, c);
        c.anchor = 17;
        c.gridx = 1;
        c.fill = 0;
        c.weightx = 0.0;
        prefixPanel.add(FolderPrefixGlossaryDialog.createFolderGlossaryButton());
        constraints.gridy = 1;
        editPanel.add((Component)prefixPanel, constraints);
        JLabel fLabel = new JLabel(MSGRES.getString(CE_PROPERTY, "TamperProtectionDialog.label.applicationName"));
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.insets.bottom = 0;
        constraints.insets.left = 10;
        constraints.anchor = 18;
        editPanel.add((Component)fLabel, constraints);
        this.fileNameTextBox = new JTextField();
        RestrictedPlainDocument doc = new RestrictedPlainDocument(1023);
        doc.setValidator(EXCLUDE, false);
        this.fileNameTextBox.setDocument(doc);
        constraints.gridy = 1;
        constraints.ipadx = 300;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        editPanel.add((Component)this.fileNameTextBox, constraints);
        constraints.insets.top = 10;
        constraints.insets.left = -5;
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 2;
        this.allowAccessCheckBox = new JCheckBox(MSGRES.getString(CE_PROPERTY, "TamperProtectionDialog.checkbox.allowAccess"), true);
        JPanel centerPanel = new JPanel(new VerticalFlowLayout(0, 0, 5, true, true));
        centerPanel.add(new AvTemplatePane(MSGRES.getString(CE_PROPERTY, "TamperProtectionDialog.heading"), MSGRES.getString(CE_PROPERTY, "TamperProtectionDialog.headingDesc")));
        centerPanel.add(editPanel);
        cont.add((Component)centerPanel, "Center");
        cont.add((Component)this.getButtonPanel(), "South");
        if (isReadonly) {
            UIUtilities.setContainerStatus(centerPanel, false);
            this.resetOKButton(false);
        }
        this.pack();
    }
}

