/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.override;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.policy.dialog.FolderPrefixGlossaryDialog;
import com.sygate.scm.console.ui.policy.override.PrefixSeparator;
import com.sygate.scm.console.ui.policy.override.logicobject.SysferFileControlExclusionUIObject;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.util.ConstantValue;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SysferFileControlExclusionDialog
extends DialogBase {
    private static final long serialVersionUID = 1L;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String GEH = "com.sygate.scm.console.ui.policy.override.override";
    JComboBox<String> gehPrefixComboBox;
    JTextField gehFileControlNameTextBox;
    String gehFileControlName;
    ArrayList<String> gehFileControlList;
    SysferFileControlExclusionUIObject gehSelectedFileExclusion;
    String gehFileControlNameTobeEdited;
    private static final String EXCLUDE = "<>,";

    public SysferFileControlExclusionDialog() {
        super(Manager.getFrame(), MSGRES.getString(GEH, "SysferFileControlExclusionDialog.title.fileControl"), true);
        this.initialize();
        UiUtilities.centerComponent((Component)this);
    }

    public SysferFileControlExclusionDialog(String fileControl) {
        super(Manager.getFrame(), MSGRES.getString(GEH, "SysferFileControlExclusionDialog.title.fileControlEdit"), true);
        this.gehFileControlName = fileControl;
        this.gehFileControlNameTobeEdited = fileControl;
        this.initialize();
        UiUtilities.centerComponent((Component)this);
    }

    private void initialize() {
        Container cont = this.getContentPane();
        cont.setLayout(new BorderLayout());
        JPanel newPanel = new JPanel();
        newPanel.setLayout(new BoxLayout(newPanel, 1));
        newPanel.add(new AvTemplatePane(MSGRES.getString(GEH, "SysferFileControlExclusionDialog.heading.label"), MSGRES.getString(GEH, "SysferFileControlExclusionDialog.heading.desc")));
        newPanel.add(Box.createVerticalStrut(10));
        newPanel.add(this.getEditPanel());
        newPanel.add(Box.createVerticalStrut(10));
        cont.add((Component)newPanel, "Center");
        cont.add((Component)this.getButtonPanel(), "South");
        this.pack();
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_geh_override_add_app_control";
    }

    JPanel getEditPanel() {
        if (this.gehPrefixComboBox == null) {
            String[] values = ConstantValue.getDirKeys();
            this.gehPrefixComboBox = new JComboBox<String>(values);
            this.gehPrefixComboBox.setSelectedIndex(0);
        }
        JPanel ePanel = new JPanel(new GridBagLayout());
        JLabel pLabel = new JLabel(MSGRES.getString(GEH, "SysferFileControlExclusionDialog.label.prefixVariable"));
        JLabel fLabel = new JLabel(MSGRES.getString(GEH, "SysferFileControlExclusionDialog.label.fileControl"));
        if (this.gehFileControlNameTextBox == null) {
            this.gehFileControlNameTextBox = new JTextField("", 20);
        }
        RestrictedPlainDocument doc = new RestrictedPlainDocument(256);
        doc.setValidator(EXCLUDE, false);
        this.gehFileControlNameTextBox.setDocument(doc);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        ePanel.add((Component)pLabel, constraints);
        constraints.gridy = 1;
        ePanel.add(this.gehPrefixComboBox, constraints);
        constraints.gridx = 1;
        ePanel.add((Component)FolderPrefixGlossaryDialog.createFolderGlossaryButton(), constraints);
        constraints.gridx = 2;
        constraints.gridy = 0;
        constraints.insets.left = 10;
        ePanel.add((Component)fLabel, constraints);
        constraints.gridy = 1;
        constraints.ipadx = 300;
        constraints.weightx = 1.0;
        constraints.fill = 2;
        ePanel.add((Component)this.gehFileControlNameTextBox, constraints);
        PrefixSeparator separator = new PrefixSeparator(this.gehFileControlName);
        String prefix = separator.getPrefix();
        if (prefix != null && !prefix.equals("")) {
            this.gehPrefixComboBox.setSelectedItem(prefix);
        }
        this.gehFileControlName = separator.getPath();
        this.gehFileControlNameTextBox.setText(this.gehFileControlName);
        ePanel.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 20));
        return ePanel;
    }

    boolean inPrefixList(String str) {
        String[] values = ConstantValue.getDirKeys();
        for (int i = 0; i < values.length; ++i) {
            if (!values[i].equals(str)) continue;
            return true;
        }
        return false;
    }

    public String getFileControlName() {
        return this.gehFileControlName;
    }

    public void setFileControlName(String fileControlName) {
        this.gehFileControlName = fileControlName;
    }

    public void setList(ArrayList<String> fileList) {
        this.gehFileControlList = fileList;
    }

    public SysferFileControlExclusionUIObject getSelectedFile() {
        return this.gehSelectedFileExclusion;
    }

    @Override
    protected boolean isValidate() {
        this.gehFileControlName = this.getFileControlNameText();
        if (this.gehFileControlName == null || this.gehFileControlName.trim().length() == 0) {
            JOptionPane.showMessageDialog(this, MSGRES.getString(GEH, "SysferFileControlExclusionDialog.error.emptyFileControlName"), MSGRES.getString(GEH, "OverridePolicySelectDlg.error"), 0);
            return false;
        }
        String prefix = (String)this.gehPrefixComboBox.getSelectedItem();
        if (!prefix.trim().equalsIgnoreCase(ConstantValue.getDirKeysByIndex((int)0))) {
            this.gehFileControlName = "%" + prefix.trim() + "%" + this.gehFileControlName;
        }
        if (this.gehFileControlList != null && (this.gehFileControlNameTobeEdited == null || !this.gehFileControlNameTobeEdited.equals(this.gehFileControlName)) && this.gehFileControlList.contains(this.gehFileControlName)) {
            this.gehFileControlName = null;
            JOptionPane.showMessageDialog(this, MSGRES.getString(GEH, "SysferFileControlExclusionDialog.error.alreayUsed"), MSGRES.getString(GEH, "OverridePolicySelectDlg.error"), 0);
            return false;
        }
        return true;
    }

    @Override
    protected void commit() {
        this.gehSelectedFileExclusion = new SysferFileControlExclusionUIObject(this.getFileControlNameText(), (String)this.gehPrefixComboBox.getSelectedItem());
    }

    String getFileControlNameText() {
        String fileControlName = this.gehFileControlNameTextBox.getText().trim();
        if (fileControlName.contains("\\n")) {
            fileControlName = fileControlName.replace("\\n", "\\N");
        }
        return fileControlName;
    }
}

