/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.override;

import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.schema.PolicyOverride;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.logicobject.AdminObject;
import com.sygate.scm.console.logicobject.AppliablePolicyPool;
import com.sygate.scm.console.logicobject.GroupPolicyObject;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.ui.policy.BasePolicyDialog;
import com.sygate.scm.console.ui.policy.PolicyHelper;
import com.sygate.scm.console.ui.policy.PolicyTabPanel;
import com.sygate.scm.console.ui.policy.common.PolicyInt;
import com.sygate.scm.console.ui.policy.override.EndpointRestrictionsPanel;
import com.sygate.scm.console.ui.policy.override.OverridePanel;
import com.sygate.scm.console.ui.policy.override.OverridePolicyTabPanel;
import com.sygate.scm.console.ui.policy.override.logicobject.OverridePolicyObject;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.CloudUtil;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.util.GUIDGenerator;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.Utility;
import java.awt.Component;
import java.awt.Container;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class OverridePolicyDialog
extends BasePolicyDialog {
    private static final long serialVersionUID = 432633359542634003L;
    private static final String GEH = "com.sygate.scm.console.ui.policy.override.override";
    private static final MessageResourcesFile TEMPLATE_RES = new MessageResourcesFile("com.sygate.scm.util.template.template_displayname");
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private OverridePanel gehOverridePanel;
    private EndpointRestrictionsPanel gehEndpointRestrictionsPanel;
    private PolicyOverride gehOverridePolicy = null;
    private Map<String, TopLevelObject> newObjList = new HashMap<String, TopLevelObject>();

    public OverridePolicyDialog(String name, GroupPolicyObject gpObj, Boolean ... isLocal) {
        super(128, name, gpObj, MSGRES.getString(GEH, "OverridePolicyDialog.title"), true, isLocal);
    }

    public OverridePolicyDialog(AbstractUIObject pool) {
        this(pool, false);
    }

    public OverridePolicyDialog(AbstractUIObject pool, boolean isCheckPolicyEnforcement) {
        super(128, pool, MSGRES.getString(GEH, "OverridePolicyDialog.title"), isCheckPolicyEnforcement, true);
    }

    public OverridePolicyDialog(AbstractUIObject pool, boolean isCheckPolicyEnforcement, boolean isCloudPolicy, String policySubType) {
        super(128, pool, MessageFormat.format(MSGRES.getString(GEH, "OverridePolicyDialog.title.format"), policySubType), isCheckPolicyEnforcement, true);
        this.setReadOnly(isCloudPolicy);
    }

    @Override
    public PolicyInt createNewPolicy(AppliablePolicyPool pool) {
        String newName;
        this.setNewPolicy(true);
        PolicyOverride policy = this.createOverridePolicy();
        OverridePolicyObject overrideObj = new OverridePolicyObject((TopLevelObject)policy);
        List<String> nameList = pool.getAllName();
        if (overrideObj.getName() != null && (newName = PolicyHandler.adjustName(overrideObj.getName(), nameList, 255)) != null) {
            overrideObj.setName(newName);
        }
        overrideObj.addNewObj((TopLevelObject)policy);
        overrideObj.addNewObj(this.newObjList);
        this.newObjList.clear();
        this.gehOverridePolicy = policy;
        this.setValues();
        return overrideObj;
    }

    @Override
    public PolicyInt createNewPolicy(TopLevelObject schema) {
        PolicyOverride policy = (PolicyOverride)schema;
        OverridePolicyObject overrideObj = new OverridePolicyObject((TopLevelObject)policy);
        this.gehOverridePolicy = policy;
        this.setValues();
        return overrideObj;
    }

    @Override
    protected void commit() {
        block3: {
            try {
                this.gehOverridePolicy.setName(this.getOverviewPanel().getPolicyName());
                this.gehOverridePolicy.setOptDescription(this.getOverviewPanel().getPolicyDesc());
                this.gehOverridePolicy.setOptExcludeExchangeServer(Boolean.valueOf("true"));
                this.getOverrideGEHPanel().save();
                this.getEndpointRestrictionsPanel().save();
                this.gehOverridePolicy.setOptEnable(Boolean.valueOf(this.getOverviewPanel().isPolicyEnabled()));
                if (LicenseObject.getInstance().isSBProduct()) {
                    PolicyHelper.refreshSerialNumber();
                }
            }
            catch (ConsoleException ex) {
                LoggerUtilities.logException((Throwable)ex);
                if (!ex.needRelogin()) break block3;
                Manager.getFrame().showLoginPanel();
            }
        }
    }

    @Override
    protected boolean isValidate() {
        boolean isDupsPresent = this.getOverrideGEHPanel().isDuplicateEntriesPresent();
        if (isDupsPresent) {
            UIUtilities.showErrorDialog(MSGRES.getString(GEH, "OverridePolicyDialog.duplicateEntriesWarning"));
        }
        return !isDupsPresent && this.isValidName((TopLevelObject)this.gehOverridePolicy, MSGRES.getString(GEH, "OverridePolicyDialog.nameIsARequirementField"), MSGRES.getString(GEH, "OverridePolicyDialog.theNameHasBeenUsed"), MSGRES.getString(GEH, "OverridePolicyDialog.invalidName"));
    }

    @Override
    protected PolicyTabPanel createTabPanel() {
        OverridePolicyTabPanel buttonPanel = new OverridePolicyTabPanel(this, "<html>" + MSGRES.getString(GEH, "OverridePolicyDialog.PolicyOverride") + "</html>", "policy_overides_32.png");
        buttonPanel.putClientProperty("cssClass", "OverridePolicyDialogTabPanel");
        return buttonPanel;
    }

    @Override
    protected void addPolicyEditorPanels(JPanel mainPanel) {
        super.addPolicyEditorPanels(mainPanel);
        mainPanel.add((Component)UIUtilities.createScrollPaneWithoutBoard(this.getOverrideGEHPanel()), MSGRES.getString(GEH, "OverridePolicyTabPanel.Override"));
        mainPanel.add((Component)UIUtilities.createScrollPaneWithoutBoard(this.getEndpointRestrictionsPanel()), MSGRES.getString(GEH, "OverridePolicyTabPanel.EndpointRestrictions"));
    }

    protected OverridePanel getOverrideGEHPanel() {
        if (this.gehOverridePanel == null) {
            boolean isCloudEnrolled = CloudUtil.isCloudEnrolled(Manager.getCurrentDomainId()) && CloudUtil.isPolicySyncEnabled(Manager.getCurrentDomainId());
            this.gehOverridePanel = new OverridePanel(isCloudEnrolled);
        }
        return this.gehOverridePanel;
    }

    protected EndpointRestrictionsPanel getEndpointRestrictionsPanel() {
        if (this.gehEndpointRestrictionsPanel == null) {
            this.gehEndpointRestrictionsPanel = new EndpointRestrictionsPanel();
        }
        return this.gehEndpointRestrictionsPanel;
    }

    @Override
    protected Container[] readOnlyContainers() {
        return new Container[]{this.getOverviewPanel(), this.getOverrideGEHPanel(), this.getEndpointRestrictionsPanel()};
    }

    private PolicyOverride createOverridePolicy() {
        try {
            if (this.gehOverridePolicy == null) {
                this.gehOverridePolicy = PolicyHandler.getDefaultPolicyOverride(this.newObjList);
            }
            if (this.gehOverridePolicy == null) {
                this.gehOverridePolicy = new PolicyOverride();
                String GUIDString = new GUIDGenerator().getGUIDString();
                this.gehOverridePolicy.setId(GUIDString);
                this.gehOverridePolicy.setOptCreator(AdminObject.retrieveCurrentAdminObject().getName());
                this.gehOverridePolicy.setName(TEMPLATE_RES.getString("$$I18N.DefaultSPlcyTp.NEW.POLICYOVERRIDE.POLICY$$"));
                MetadataAttributes mAttr = new MetadataAttributes();
                this.gehOverridePolicy.setMetadataAttributes(mAttr);
            }
        }
        catch (Exception e) {
            LoggerUtilities.logException((Throwable)e);
            JOptionPane.showMessageDialog(Manager.getFrame(), e.getMessage(), MSGRES.getString(GEH, "OverridePolicyDialog.error"), 0);
            Manager.getFrame().showLoginPanel();
        }
        return this.gehOverridePolicy;
    }

    private void setValues() {
        block2: {
            try {
                this.getOverviewPanel().setObject(new OverridePolicyObject((TopLevelObject)this.gehOverridePolicy));
                this.getOverrideGEHPanel().setPolicyOverride(this.gehOverridePolicy);
                this.getEndpointRestrictionsPanel().setPolicyOverride(this.gehOverridePolicy);
                this.getOverviewPanel().setPolicyEnabled(Utility.getBooleanValue((Boolean)this.gehOverridePolicy.getOptEnable(), (Boolean)this.gehOverridePolicy.getDefEnable()));
            }
            catch (ConsoleException ex) {
                LoggerUtilities.logException((Throwable)ex);
                if (!ex.needRelogin()) break block2;
                Manager.getFrame().showLoginPanel();
            }
        }
    }
}

