/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.override;

import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.schema.ApplicationEventFilter;
import com.sygate.scm.common.configobject.schema.CertificateOverride;
import com.sygate.scm.common.configobject.schema.DetectedProcesses;
import com.sygate.scm.common.configobject.schema.DirectoryOverride;
import com.sygate.scm.common.configobject.schema.DnsHostFileOverride;
import com.sygate.scm.common.configobject.schema.Event;
import com.sygate.scm.common.configobject.schema.Extension;
import com.sygate.scm.common.configobject.schema.FileOverride;
import com.sygate.scm.common.configobject.schema.HeuristicPolicyOverride;
import com.sygate.scm.common.configobject.schema.KnownRiskOverrride;
import com.sygate.scm.common.configobject.schema.NonPEFileOverride;
import com.sygate.scm.common.configobject.schema.OverrideItem;
import com.sygate.scm.common.configobject.schema.PermittedApplication;
import com.sygate.scm.common.configobject.schema.PolicyOverride;
import com.sygate.scm.common.configobject.schema.ProcessesToDetect;
import com.sygate.scm.common.configobject.schema.ProtectionTechnology;
import com.sygate.scm.common.configobject.schema.SecurityRiskOverride;
import com.sygate.scm.common.configobject.schema.SourceInfo;
import com.sygate.scm.common.configobject.schema.SysferExclusionFileControlOverride;
import com.sygate.scm.common.configobject.schema.TamperProtectionOverride;
import com.sygate.scm.common.configobject.schema.URLDomainOverride;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.common.util.Cast;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.ui.client.PlatformIconNameCellRenderer;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.policy.override.ApplicationExclusionDialog;
import com.sygate.scm.console.ui.policy.override.CertificateExclusionDialog;
import com.sygate.scm.console.ui.policy.override.DirectoryExclusionDialog;
import com.sygate.scm.console.ui.policy.override.ExtensionExclusionDialog;
import com.sygate.scm.console.ui.policy.override.FileExclusionDialog;
import com.sygate.scm.console.ui.policy.override.HPPDetectedProcessesDlg;
import com.sygate.scm.console.ui.policy.override.HPPProcessesToDetectDlg;
import com.sygate.scm.console.ui.policy.override.KnownSecurityRiskDlg;
import com.sygate.scm.console.ui.policy.override.MacFileFolderExclusionDialog;
import com.sygate.scm.console.ui.policy.override.NonPEFileExclusionDialog;
import com.sygate.scm.console.ui.policy.override.OverrideActionCheckboxItem;
import com.sygate.scm.console.ui.policy.override.PolicyOverrideConstants;
import com.sygate.scm.console.ui.policy.override.SysferFileControlExclusionDialog;
import com.sygate.scm.console.ui.policy.override.TamperProtectionDialog;
import com.sygate.scm.console.ui.policy.override.TrustedURLDomainExceptionDialog;
import com.sygate.scm.console.ui.policy.override.logicobject.ApplicationEventFilterUIObject;
import com.sygate.scm.console.ui.policy.override.logicobject.CertificateExclusionUIObject;
import com.sygate.scm.console.ui.policy.override.logicobject.DetectedProcessUIObject;
import com.sygate.scm.console.ui.policy.override.logicobject.DirectoryExclusionUIObject;
import com.sygate.scm.console.ui.policy.override.logicobject.DnsHostFileChangeExclusionUIObject;
import com.sygate.scm.console.ui.policy.override.logicobject.ExceptionUIObject;
import com.sygate.scm.console.ui.policy.override.logicobject.ExtensionExclusionUIObject;
import com.sygate.scm.console.ui.policy.override.logicobject.FileExclusionUIObject;
import com.sygate.scm.console.ui.policy.override.logicobject.KnownSecurityUIObject;
import com.sygate.scm.console.ui.policy.override.logicobject.MacFileFolderExclusionUIObject;
import com.sygate.scm.console.ui.policy.override.logicobject.NonPEFileExclusionUIObject;
import com.sygate.scm.console.ui.policy.override.logicobject.PermittedApplicationUIObject;
import com.sygate.scm.console.ui.policy.override.logicobject.PolicyExceptionUIObject;
import com.sygate.scm.console.ui.policy.override.logicobject.ProcessesToDetectUIObject;
import com.sygate.scm.console.ui.policy.override.logicobject.SysferFileControlExclusionUIObject;
import com.sygate.scm.console.ui.policy.override.logicobject.TrustedURLDomainUIObject;
import com.sygate.scm.console.ui.util.ReadOnlyTextArea;
import com.sygate.scm.console.ui.util.SortableTableModel;
import com.sygate.scm.console.ui.util.StripesTable;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.Env;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.ConstantValue;
import com.sygate.scm.util.ExceptionPolicyUtility;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class OverridePanel
extends JPanel
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = -4145637932051837145L;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String GEH = "com.sygate.scm.console.ui.policy.override.override";
    private PolicyOverride gehPolicyOverride;
    private JTextField gehNameField;
    private JTextArea gehDescField;
    JTable gehGroupTable;
    private JButton gehAddButton;
    private JButton gehEditButton;
    private JButton gehDeleteButton;
    private JButton gehCopyButton;
    private JButton gehPasteButton;
    private JPopupMenu gehMainRiskPopup = new JPopupMenu();
    private JPanel gehChangeablePanel;
    private JLabel gehPtDescLabel;
    private ReadOnlyTextArea gehOverrideDescLabel;
    private JLabel gehActionDescLabel;
    private JLabel[] gehOtherFieldName;
    private JLabel[] gehOtherFieldContent;
    private JMenuItem directoryMenu;
    private JMenuItem linuxDirectoryMenu;
    private JMenuItem extensionMenu;
    private JMenuItem linuxExtensionMenu;
    private static final int MAX_NUM_FIELDS = 6;
    private HashMap<String, Integer> gehActionStringToIntMap;
    private HashMap<Integer, String> gehActionIntToStringMap;
    private ArrayList<String> gehAddedKnownSecurityList;
    private ArrayList<String> gehAddedExtensionExclusionList;
    private ArrayList<String> gehAddedHppDetectedProcessList;
    private ArrayList<String> macAddedHppDetectedProcessList;
    private ArrayList<String> gehAddedHppProcessToDetectList;
    private ArrayList<String> gehAddedFileExclusionList;
    private HashMap<String, ArrayList<String>> gehAddedDirectoryExclusionMap;
    private HashMap<String, ArrayList<String>> gehAddedLinuxDirectoryExclusionMap;
    private ArrayList<String> gehAddedPermittedApplicationList;
    private ArrayList<String> gehAddedApplicationEventFilterMap;
    private ArrayList<String> macAddedFileFolderExclusionList;
    private ArrayList<String> gehAddedTrustedUrlDomainList;
    private ArrayList<String> gehAddedSysferFileControlList;
    private ArrayList<String> gehAddedDnsAndHostFileChangeExclusionList;
    private ArrayList<String> linuxGehAddedExtensionExclusionList;
    private Map<String, String> gehAddedCertificateExclusionMap;
    private ArrayList<String> gehNonPEFileExclusionList;
    private static final Icon downIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("standardArrow.gif")));
    private static final String[] TABLE_TITLE = new String[]{MSGRES.getString("com.sygate.scm.console.ui.policy.override.override", "OverridePanel.table.override"), MSGRES.getString("com.sygate.scm.console.ui.policy.override.override", "OverridePanel.table.platform"), MSGRES.getString("com.sygate.scm.console.ui.policy.override.override", "OverridePanel.table.protectionTechnology"), MSGRES.getString("com.sygate.scm.console.ui.policy.override.override", "OverridePanel.table.action"), MSGRES.getString("com.sygate.scm.console.ui.policy.override.override", "OverridePanel.table.source")};
    private static final float[] COL_SIZE = new float[]{0.5f, 0.1f, 0.25f, 0.05f, 0.1f};
    SortableTableModel gehGroupModel = null;
    JMenu add = new JMenu(UIText.get(5));
    private Action editAction = null;
    private Action deleteAction = null;
    private Action copyAction = null;
    private Action pasteAction = null;
    private boolean isReadonly;
    private final boolean isCloudEnrolled;
    boolean isCloudExceptionPolicy;
    private boolean isNotCloudEnrolledOrCloudPolicy;
    private boolean isNotCloudEnrolledOrSepPolicy;
    private static final OverrideActionCheckboxItem[] DETECTED_PROCESS_ACTIONS = new OverrideActionCheckboxItem[]{new OverrideActionCheckboxItem(MSGRES.getString("com.sygate.scm.console.ui.policy.override.override", "PolicyOverride.ignore"), MSGRES.getString("com.sygate.scm.console.ui.policy.override.override", "PolicyOverride.ignore")), new OverrideActionCheckboxItem(MSGRES.getString("com.sygate.scm.console.ui.policy.override.override", "PolicyOverride.logonly"), MSGRES.getString("com.sygate.scm.console.ui.policy.override.override", "PolicyOverride.logonly")), new OverrideActionCheckboxItem(MSGRES.getString("com.sygate.scm.console.ui.policy.override.override", "PolicyOverride.quarantine"), MSGRES.getString("com.sygate.scm.console.ui.policy.override.override", "PolicyOverride.quarantine")), new OverrideActionCheckboxItem(MSGRES.getString("com.sygate.scm.console.ui.policy.override.override", "PolicyOverride.block"), MSGRES.getString("com.sygate.scm.console.ui.policy.override.override", "PolicyOverride.block")), new OverrideActionCheckboxItem(MSGRES.getString("com.sygate.scm.console.ui.policy.override.override", "PolicyOverride.remove"), MSGRES.getString("com.sygate.scm.console.ui.policy.override.override", "PolicyOverride.remove"))};
    public static final OverrideActionCheckboxItem[] NON_PE_FILE_ACTIONS = new OverrideActionCheckboxItem[]{new OverrideActionCheckboxItem(MSGRES.getString("com.sygate.scm.console.ui.policy.override.override", "NonPEFileExclusionDialog.action.quarantine"), PolicyOverrideConstants.GEH_QUARANTINE), new OverrideActionCheckboxItem(MSGRES.getString("com.sygate.scm.console.ui.policy.override.override", "NonPEFileExclusionDialog.action.block"), PolicyOverrideConstants.GEH_BLOCK), new OverrideActionCheckboxItem(MSGRES.getString("com.sygate.scm.console.ui.policy.override.override", "NonPEFileExclusionDialog.action.logonly"), PolicyOverrideConstants.GEH_LOGONLY), new OverrideActionCheckboxItem(MSGRES.getString("com.sygate.scm.console.ui.policy.override.override", "NonPEFileExclusionDialog.action.ignore"), PolicyOverrideConstants.GEH_IGNORE)};
    private static final OverrideActionCheckboxItem[] DNS_HOSTFILE_CHANGE_ACTIONS = new OverrideActionCheckboxItem[]{new OverrideActionCheckboxItem(MSGRES.getString("com.sygate.scm.console.ui.policy.override.override", "PolicyOverride.ignore"), MSGRES.getString("com.sygate.scm.console.ui.policy.override.override", "PolicyOverride.ignore")), new OverrideActionCheckboxItem(MSGRES.getString("com.sygate.scm.console.ui.policy.override.override", "PolicyOverride.logonly"), MSGRES.getString("com.sygate.scm.console.ui.policy.override.override", "PolicyOverride.logonly")), new OverrideActionCheckboxItem(MSGRES.getString("com.sygate.scm.console.ui.policy.override.override", "PolicyOverride.prompt"), MSGRES.getString("com.sygate.scm.console.ui.policy.override.override", "PolicyOverride.prompt")), new OverrideActionCheckboxItem(MSGRES.getString("com.sygate.scm.console.ui.policy.override.override", "PolicyOverride.dnsHostBlock"), MSGRES.getString("com.sygate.scm.console.ui.policy.override.override", "PolicyOverride.block"))};
    private final String appTitleAdd = MSGRES.getString("com.sygate.scm.console.ui.policy.override.override", "HPPDetectedProcessesDlg.heading.add");
    private final String appTitleEdit = MSGRES.getString("com.sygate.scm.console.ui.policy.override.override", "HPPDetectedProcessesDlg.heading.edit");
    private final String appDescription = MSGRES.getString("com.sygate.scm.console.ui.policy.override.override", "HPPDetectedProcessesDlg.heading.desc");
    private final String dnsTitleAdd = MSGRES.getString("com.sygate.scm.console.ui.policy.override.override", "HPPDetectedProcessesDlg.dnshostfile.heading.add");
    private final String dnsTitleEdit = MSGRES.getString("com.sygate.scm.console.ui.policy.override.override", "HPPDetectedProcessesDlg.dnshostfile.heading.edit");

    public OverridePanel(boolean isCloudEnrolled) {
        this.isCloudEnrolled = isCloudEnrolled;
        this.isCloudExceptionPolicy = false;
        this.isNotCloudEnrolledOrCloudPolicy = !isCloudEnrolled || this.isCloudExceptionPolicy;
        this.isNotCloudEnrolledOrSepPolicy = !isCloudEnrolled || !this.isCloudExceptionPolicy;
        this.initialize();
        this.initAddedMaps();
        this.initActionMap();
    }

    private void initialize() {
        JPanel newPanel = new JPanel(new BorderLayout());
        JPanel exceptionsPanel = new JPanel();
        BoxLayout layout = new BoxLayout(exceptionsPanel, 1);
        exceptionsPanel.setLayout(layout);
        exceptionsPanel.add(new AvTemplatePane(MessageResources.getInstance().getString(GEH, "OverridePanel.title.policyOverrides"), MessageResources.getInstance().getString(GEH, "OverridePanel.textarea.overrideDesc")));
        exceptionsPanel.add(Box.createVerticalStrut(5));
        exceptionsPanel.add(this.getTablePanel());
        exceptionsPanel.add(Box.createVerticalStrut(5));
        exceptionsPanel.add(this.getButtonPanel());
        this.prepareAndSetPopupMenuItems(this.gehMainRiskPopup);
        newPanel.add((Component)exceptionsPanel, "Center");
        JPanel detailPanel = new JPanel();
        layout = new BoxLayout(detailPanel, 1);
        detailPanel.setLayout(layout);
        detailPanel.add(new AvTemplatePane(MSGRES.getString(GEH, "OverridePanel.heading.overrideDetails"), null));
        detailPanel.add(Box.createVerticalStrut(5));
        detailPanel.add(this.getChangeablePanel());
        detailPanel.add(Box.createVerticalStrut(20));
        newPanel.add((Component)detailPanel, "South");
        this.setLayout(new BorderLayout());
        this.add((Component)newPanel, "Center");
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_geh_override";
    }

    JPanel makePolicyPanel() {
        JLabel nameLabel = new JLabel(MSGRES.getString(GEH, "OverviewPanel.label.policyName"));
        this.gehNameField = new JTextField();
        GridBagConstraints g1 = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 10, 0);
        GridBagConstraints g2 = new GridBagConstraints(1, 0, 4, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 400, 0);
        GridBagConstraints g3 = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 10, 0);
        GridBagConstraints g4 = new GridBagConstraints(1, 1, 4, 3, 1.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 400, 0);
        JPanel panel1 = new JPanel();
        panel1.setLayout(new GridBagLayout());
        panel1.add((Component)nameLabel, g1);
        panel1.add((Component)this.gehNameField, g2);
        JLabel descLabel = new JLabel(MSGRES.getString(GEH, "OverviewPanel.label.description"));
        this.gehDescField = new JTextArea();
        this.gehDescField.setRows(5);
        panel1.add((Component)descLabel, g3);
        panel1.add((Component)this.gehDescField, g4);
        panel1.setBorder(BorderFactory.createEmptyBorder(0, 40, 0, 40));
        return panel1;
    }

    JPanel getTablePanel() {
        JPanel groupPanel = new JPanel();
        this.gehGroupModel = new SortableTableModel(){
            private static final long serialVersionUID = 5705805922857032904L;

            @Override
            public boolean isCellEditable(int row, int col) {
                return col == 3 ? true : super.isCellEditable(row, col);
            }
        };
        this.gehGroupModel.setColumnNames(TABLE_TITLE);
        this.gehGroupTable = new StripesTable(this.gehGroupModel, false, false);
        this.gehGroupModel.addMouseListenerToHeaderInTable(this.gehGroupTable);
        TableColumn useCol = this.gehGroupTable.getColumnModel().getColumn(3);
        useCol.setCellRenderer(new OverrideComboBoxEditor());
        useCol.setCellEditor(new OverrideComboBoxEditor());
        TableColumn platformCol = this.gehGroupTable.getColumnModel().getColumn(1);
        platformCol.setCellRenderer(new PlatformIconNameCellRenderer());
        Dimension size = this.gehGroupTable.getPreferredScrollableViewportSize();
        this.gehGroupTable.setPreferredScrollableViewportSize(new Dimension(size.width, (this.gehGroupTable.getRowHeight() + this.gehGroupTable.getRowMargin()) * 5));
        this.gehGroupTable.setShowGrid(true);
        UIUtilities.setTableColumnWidth(this.gehGroupTable, COL_SIZE, (int)this.gehGroupTable.getPreferredScrollableViewportSize().getWidth());
        this.gehGroupTable.addMouseListener(new OverrideTableCellListener());
        groupPanel.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 20));
        groupPanel.setLayout(new BorderLayout());
        JScrollPane pane = new JScrollPane();
        UiUtilities.setupScrollPane((JScrollPane)pane, (JTable)this.gehGroupTable);
        pane.getViewport().addMouseListener(new OverrideTableCellListener());
        this.gehGroupTable.getSelectionModel().addListSelectionListener(e -> {
            this.gehEditButton.setEnabled(this.isEnableEditAction());
            this.gehDeleteButton.setEnabled(this.isEnableDeleteAction());
            this.gehCopyButton.setEnabled(this.isEnableCopyAction());
            this.gehPasteButton.setEnabled(this.isEnablePasteAction());
            this.modifyChangeablePanel();
        });
        groupPanel.add((Component)pane, "Center");
        return groupPanel;
    }

    JPanel getButtonPanel() {
        JPanel bPanel = new JPanel(new FlowLayout(2));
        if (this.gehAddButton == null) {
            this.gehAddButton = new JButton(MSGRES.getString(GEH, "OverridePanel.button.add"));
            this.gehAddButton.setIcon(downIcon);
            this.gehAddButton.setHorizontalTextPosition(10);
            this.gehAddButton.addActionListener(e -> {
                this.gehAddButton.add(this.gehMainRiskPopup);
                this.gehMainRiskPopup.show(bPanel, this.gehAddButton.getX(), this.gehAddButton.getY() + this.gehAddButton.getHeight());
            });
        }
        if (this.gehEditButton == null) {
            this.gehEditButton = new JButton(UIText.get(1024));
        }
        this.gehEditButton.addActionListener(e -> this.editAction());
        if (this.gehDeleteButton == null) {
            this.gehDeleteButton = new JButton(MSGRES.getString(GEH, "OverridePanel.button.delete"));
        }
        this.gehDeleteButton.addActionListener(e -> {
            try {
                this.deleteAction();
            }
            catch (Exception e1) {
                LoggerUtilities.logException((Throwable)e1);
            }
        });
        if (this.gehPasteButton == null) {
            this.gehPasteButton = new JButton(UIText.get(3840));
        }
        this.gehPasteButton.addActionListener(e -> this.pasteObjects());
        if (this.gehCopyButton == null) {
            this.gehCopyButton = new JButton(UIText.get(520));
        }
        this.gehCopyButton.addActionListener(e -> {
            this.copyRules();
            this.gehPasteButton.setEnabled(this.isEnablePasteAction());
        });
        this.gehEditButton.setEnabled(this.isEnableEditAction());
        this.gehDeleteButton.setEnabled(this.isEnableDeleteAction());
        this.gehCopyButton.setEnabled(this.isEnableCopyAction());
        this.gehPasteButton.setEnabled(this.isEnablePasteAction());
        bPanel.add(this.gehAddButton);
        bPanel.add(this.gehEditButton);
        bPanel.add(this.gehDeleteButton);
        bPanel.add(this.gehCopyButton);
        bPanel.add(this.gehPasteButton);
        bPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 15));
        return bPanel;
    }

    private void copyRules() {
        int[] select = this.gehGroupTable.getSelectedRows();
        if (select.length <= 0) {
            ConsoleLogger.log("copyRules >> No rows are selected");
            return;
        }
        ArrayList<PolicyExceptionUIObject> copiedObjects = new ArrayList<PolicyExceptionUIObject>(select.length);
        for (int row : select) {
            copiedObjects.add((PolicyExceptionUIObject)this.gehGroupModel.getRow(row));
        }
        PolicyHandler.copyObjects(copiedObjects, PolicyExceptionUIObject.class.getName());
    }

    private void pasteObjects() {
        if (this.isCloudExceptionPolicy) {
            return;
        }
        List<?> copiedObjects = PolicyHandler.getPastedObjects(PolicyExceptionUIObject.class);
        int count = copiedObjects.size();
        ConsoleLogger.log("pasteObjects() size : " + count);
        if (count <= 0) {
            ConsoleLogger.log("Copied Objects doesn't match with paste request. Copy Clipboard is empty");
            return;
        }
        copiedObjects.stream().forEach(c -> this.gehGroupModel.addRow(new PolicyExceptionUIObject(c.getProtectionTechnology(), c.getPlatform(), c.getOverride(), c.getAction(), c.getRiskData(), null, c.getGehOverrideDisplayName())));
    }

    public boolean isDuplicateEntriesPresent() {
        List<TableRow> allRows = this.gehGroupModel.getAllRows();
        long allRowCount = allRows.size();
        ConsoleLogger.log("isDuplicateEntriesPresent >> allRowCount : " + allRowCount);
        if (allRows.size() > 0) {
            long distinctRowCount = allRows.stream().map(Object::toString).distinct().count();
            ConsoleLogger.log("isDuplicateEntriesPresent distinctRowCount >> " + distinctRowCount);
            return distinctRowCount != allRowCount;
        }
        return false;
    }

    void deleteAction() throws Exception {
        if (this.isCloudExceptionPolicy) {
            return;
        }
        int[] select = this.gehGroupTable.getSelectedRows();
        if (!Env.isUnitTest()) {
            int result;
            boolean hasExternalException = false;
            for (int row : select) {
                if (((PolicyExceptionUIObject)this.gehGroupModel.getRow(row)).isSepmUiDefinedException()) continue;
                hasExternalException = true;
                break;
            }
            if (hasExternalException ? 0 != (result = UIUtilities.deleteOptionDialog(MSGRES.getString(GEH, "OverridePanel.delete.warning.external.text"), MSGRES.getString(GEH, "OverridePanel.delete.warning.external.title"))) : 0 != (result = UIUtilities.deleteOptionDialog(MSGRES.getString(GEH, "OverridePanel.delete.warning.local.text"), MSGRES.getString(GEH, "OverridePanel.delete.warning.local.title")))) {
                return;
            }
        }
        int finalSelectedRow = -1;
        int deleteCount = 0;
        for (int i = 0; i < select.length; ++i) {
            select[i] = select[i] - deleteCount;
            PolicyExceptionUIObject obj = (PolicyExceptionUIObject)this.gehGroupModel.getRow(select[i]);
            ++deleteCount;
            ExceptionUIObject exceptionObj = obj.getRiskData();
            int riskType = exceptionObj.getRiskType();
            switch (riskType) {
                case 0: {
                    this.gehAddedKnownSecurityList.remove(obj.getOverride());
                    break;
                }
                case 3: {
                    if (PolicyExceptionUIObject.PLATFORM_LINUX.equals(obj.getPlatform())) {
                        this.linuxGehAddedExtensionExclusionList.remove(obj.getOverride());
                        break;
                    }
                    if (!PolicyExceptionUIObject.PLATFORM_WIN.equals(obj.getPlatform())) break;
                    this.gehAddedExtensionExclusionList.remove(obj.getOverride());
                    break;
                }
                case 1: {
                    if (PolicyExceptionUIObject.PLATFORM_WIN.equals(obj.getPlatform())) {
                        this.gehAddedHppDetectedProcessList.remove(obj.getOverride());
                        break;
                    }
                    if (!PolicyExceptionUIObject.PLATFORM_MAC.equals(obj.getPlatform())) break;
                    this.macAddedHppDetectedProcessList.remove(obj.getOverride());
                    break;
                }
                case 2: {
                    this.gehAddedHppProcessToDetectList.remove(obj.getOverride());
                    break;
                }
                case 4: {
                    this.gehAddedFileExclusionList.remove(obj.getOverride());
                    break;
                }
                case 5: {
                    String scanTypeStr = String.valueOf(((DirectoryExclusionUIObject)exceptionObj).getScanType());
                    if (PolicyExceptionUIObject.PLATFORM_LINUX.equals(obj.getPlatform())) {
                        if (scanTypeStr == null || this.gehAddedLinuxDirectoryExclusionMap == null || this.gehAddedLinuxDirectoryExclusionMap.get(scanTypeStr) == null) {
                            throw new Exception("scanTypeStr and gehAddedLinuxDirectoryExclusionMap.get(scanTypeStr) should not be null!");
                        }
                        this.gehAddedLinuxDirectoryExclusionMap.get(scanTypeStr).remove(DirectoryExclusionDialog.getProfileFormatLinuxDirectory(obj.getOverride()));
                        break;
                    }
                    if (!PolicyExceptionUIObject.PLATFORM_WIN.equals(obj.getPlatform())) break;
                    this.gehAddedDirectoryExclusionMap.get(scanTypeStr).remove(obj.getOverride());
                    break;
                }
                case 6: {
                    this.gehAddedPermittedApplicationList.remove(obj.getOverride());
                    break;
                }
                case 7: {
                    this.gehAddedApplicationEventFilterMap.remove(obj.getOverride());
                    break;
                }
                case 9: {
                    this.macAddedFileFolderExclusionList.remove(obj.getOverride());
                    break;
                }
                case 8: {
                    String urlDomain = obj.getOverride();
                    if (urlDomain == null) break;
                    this.gehAddedTrustedUrlDomainList.remove(urlDomain.toUpperCase());
                    break;
                }
                case 10: {
                    this.gehAddedSysferFileControlList.remove(obj.getOverride());
                    break;
                }
                case 11: {
                    this.gehAddedDnsAndHostFileChangeExclusionList.remove(obj.getOverride());
                    break;
                }
                case 12: {
                    if (!this.gehAddedCertificateExclusionMap.containsKey(obj.getOverride())) break;
                    this.gehAddedCertificateExclusionMap.remove(obj.getOverride());
                    break;
                }
                case 13: {
                    this.gehNonPEFileExclusionList.remove(obj.getOverride());
                    break;
                }
            }
            this.gehGroupModel.removeRow(select[i]);
            finalSelectedRow = select[i] - 1;
        }
        int rowCount = this.gehGroupModel.getRowCount();
        if (rowCount > 0) {
            if (finalSelectedRow > -1) {
                this.gehGroupTable.setRowSelectionInterval(finalSelectedRow, finalSelectedRow);
            } else {
                this.gehGroupTable.setRowSelectionInterval(0, 0);
            }
        }
    }

    void editAction() {
        int result;
        if (this.isCloudExceptionPolicy) {
            return;
        }
        int row = this.gehGroupTable.getSelectedRow();
        if (row < 0) {
            return;
        }
        PolicyExceptionUIObject obj = (PolicyExceptionUIObject)this.gehGroupModel.getRow(row);
        if (!Env.isUnitTest() && !obj.isSepmUiDefinedException() && (result = UIUtilities.confirmYesNoOptionDialog(MSGRES.getString(GEH, "OverridePanel.edit.warning.external.text"), MSGRES.getString(GEH, "OverridePanel.edit.warning.external.title"))) != 0) {
            return;
        }
        int riskType = obj.getRiskData().getRiskType();
        switch (riskType) {
            case 0: {
                break;
            }
            case 3: {
                this.editExtensionExclusionAction(row);
                break;
            }
            case 4: {
                this.editFileExclusionAction(row);
                break;
            }
            case 5: {
                try {
                    this.editDirectoryExclusionAction(row);
                }
                catch (Exception exception) {
                    LoggerUtilities.logException((Throwable)exception);
                }
                break;
            }
            case 1: {
                this.editHPPDetectedProcessAction(row);
                break;
            }
            case 2: {
                this.editHPPProcessesToDetectAction(row);
                break;
            }
            case 6: 
            case 7: {
                this.editTamperProtectionAction(row);
                break;
            }
            case 9: {
                this.editMacFileFolderExclusionAction(row);
                break;
            }
            case 8: {
                this.editTrustedURLDomainAction(row);
                break;
            }
            case 10: {
                this.editSysferFileControlAction(row);
                break;
            }
            case 11: {
                this.editDnsHostFileExclusionChangeAction(row);
                break;
            }
            case 12: {
                this.editCertificateExclusionAction(row);
                break;
            }
            case 13: {
                this.editNonFileExclusionAction(row);
                break;
            }
        }
    }

    void onKnownSecurityRiskDlgOk(KnownSecurityRiskDlg riskDialog, int row) {
        KnownSecurityUIObject[] selectedRisks = riskDialog.getSelectedKnowRisks();
        boolean log = riskDialog.getLog();
        int act = log ? 3 : 0;
        String actionV = this.gehActionIntToStringMap.get(act);
        for (int i = 0; i < selectedRisks.length; ++i) {
            String riskName = selectedRisks[i].getSecurityRisk();
            PolicyExceptionUIObject exceptionObj = new PolicyExceptionUIObject(MessageResources.getInstance().getString(GEH, "OverridePanel.risktype.knownRisk"), riskName, actionV, selectedRisks[i], null);
            if (row == -1) {
                this.gehGroupModel.addRow(exceptionObj);
            } else {
                this.gehGroupModel.insertRow(row + i + 1, exceptionObj);
            }
            this.gehAddedKnownSecurityList.add(riskName);
        }
        int rowNum = this.gehGroupTable.getRowCount();
        if (row == -1) {
            int beginRow = rowNum - selectedRisks.length;
            if (selectedRisks.length == 0) {
                --beginRow;
            }
            if (beginRow > 0 && rowNum > 0) {
                this.gehGroupTable.setRowSelectionInterval(beginRow, rowNum - 1);
            }
        } else {
            this.gehGroupTable.setRowSelectionInterval(row, row);
        }
        this.modifyChangeablePanel();
    }

    void editExtensionExclusionAction(int row) {
        PolicyExceptionUIObject obj = (PolicyExceptionUIObject)this.gehGroupModel.getRow(row);
        ExtensionExclusionUIObject extObj = (ExtensionExclusionUIObject)obj.getRiskData();
        String action = obj.getAction();
        String extension = extObj.getExtensionExclusion();
        ExtensionExclusionDialog extDlg = new ExtensionExclusionDialog(extObj, this.isReadonly, obj.getPlatform());
        extDlg.setVisible(true);
        if (extDlg.isOk()) {
            String riskName = extDlg.getExtension();
            PolicyExceptionUIObject policyObj = new PolicyExceptionUIObject(MSGRES.getString(GEH, "OverridePanel.risktype.extensionExclusion"), riskName, action, extDlg.getExtensionExclusionUIObject(), null);
            if (PolicyExceptionUIObject.PLATFORM_WIN.equals(obj.getPlatform())) {
                policyObj.setPlatform(PolicyExceptionUIObject.PLATFORM_WIN);
                this.gehAddedExtensionExclusionList.remove(extension);
                this.gehAddedExtensionExclusionList.add(riskName);
            } else if (PolicyExceptionUIObject.PLATFORM_LINUX.equals(obj.getPlatform())) {
                policyObj.setPlatform(PolicyExceptionUIObject.PLATFORM_LINUX);
                this.linuxGehAddedExtensionExclusionList.remove(extension);
                this.linuxGehAddedExtensionExclusionList.add(riskName);
            }
            this.gehGroupModel.setRow(row, policyObj);
            int addedRow = this.gehGroupTable.getRowCount() - 1;
            this.gehGroupTable.setRowSelectionInterval(addedRow, addedRow);
            this.modifyChangeablePanel();
        }
    }

    void editFileExclusionAction(int row) {
        PolicyExceptionUIObject extObj = (PolicyExceptionUIObject)this.gehGroupModel.getRow(row);
        String action = extObj.getAction();
        String oldFile = extObj.getOverride();
        FileExclusionDialog fileDlg = new FileExclusionDialog(extObj, this.isReadonly, LicenseObject.getInstance().isSBProduct(), this.isCloudExceptionPolicy, !this.isCloudExceptionPolicy);
        fileDlg.setApplicableScanTypes(extObj.getProtectionTechnology());
        fileDlg.setVisible(true);
        if (fileDlg.isOk()) {
            String rName = fileDlg.getFileName();
            if (rName != null) {
                FileExclusionUIObject exclusionObject = fileDlg.getSelectedFile();
                String technologies = this.getApplicableTechnologies(exclusionObject);
                this.gehGroupModel.setRow(row, new PolicyExceptionUIObject(technologies, fileDlg.getFileName(), action, fileDlg.getSelectedFile(), null));
                this.gehAddedFileExclusionList.remove(oldFile);
                this.gehAddedFileExclusionList.add(fileDlg.getFileName());
            }
            this.modifyChangeablePanel();
        }
    }

    void editSysferFileControlAction(int row) {
        PolicyExceptionUIObject extObj = (PolicyExceptionUIObject)this.gehGroupModel.getRow(row);
        String action = extObj.getAction();
        String fileControl = extObj.getOverride();
        SysferFileControlExclusionDialog fileControlDlg = new SysferFileControlExclusionDialog(fileControl);
        fileControlDlg.setList(this.gehAddedSysferFileControlList);
        fileControlDlg.setVisible(true);
        if (fileControlDlg.isOk()) {
            String riskName = fileControlDlg.getFileControlName();
            if (riskName != null) {
                this.gehGroupModel.setRow(row, new PolicyExceptionUIObject(MSGRES.getString(GEH, "OverridePanel.risktype.fileControlExclusion"), fileControlDlg.getFileControlName(), action, fileControlDlg.getSelectedFile(), null));
                this.gehAddedSysferFileControlList.remove(fileControl);
                this.gehAddedSysferFileControlList.add(fileControlDlg.getFileControlName());
            }
            this.modifyChangeablePanel();
        }
    }

    void editTamperProtectionAction(int row) {
        PolicyExceptionUIObject extObj = (PolicyExceptionUIObject)this.gehGroupModel.getRow(row);
        String action = extObj.getAction();
        String app = extObj.getOverride();
        TamperProtectionDialog appDlg = new TamperProtectionDialog(extObj, this.gehAddedPermittedApplicationList, this.gehAddedApplicationEventFilterMap, this.isReadonly);
        appDlg.setVisible(true);
        if (appDlg.isOk()) {
            if (extObj.getRiskData().getRiskType() == 6) {
                this.gehAddedPermittedApplicationList.remove(app);
            } else {
                this.gehAddedApplicationEventFilterMap.remove(app);
            }
            if (appDlg.isPermittedApplication()) {
                this.gehGroupModel.setRow(row, new PolicyExceptionUIObject(MSGRES.getString(GEH, "OverridePanel.risktype.tamperProtection"), appDlg.getPrefixFileName(), action, appDlg.getPermittedApplication(), null));
                this.gehAddedPermittedApplicationList.add(appDlg.getPrefixFileName());
            } else {
                ApplicationEventFilterUIObject uiObject = appDlg.getApplicationEventFilter();
                String rName = uiObject.getFilterName();
                this.gehGroupModel.setRow(row, new PolicyExceptionUIObject(MSGRES.getString(GEH, "OverridePanel.risktype.tamperProtection"), rName, action, uiObject, null));
                this.gehAddedApplicationEventFilterMap.add(rName);
            }
            this.modifyChangeablePanel();
        }
    }

    private void editTrustedURLDomainAction(int row) {
        PolicyExceptionUIObject extObj = (PolicyExceptionUIObject)this.gehGroupModel.getRow(row);
        String action = extObj.getAction();
        String oldDomainName = extObj.getOverride();
        TrustedURLDomainExceptionDialog domainDlg = new TrustedURLDomainExceptionDialog(oldDomainName);
        domainDlg.setList(this.gehAddedTrustedUrlDomainList);
        domainDlg.setVisible(true);
        if (domainDlg.isOk()) {
            TrustedURLDomainUIObject domainObj = domainDlg.getSelectedDomain();
            String domainName = domainObj.getURLDomainName();
            this.gehGroupModel.setRow(row, new PolicyExceptionUIObject(MSGRES.getString(GEH, "OverridePanel.risktype.domainExclusion"), domainName, action, domainObj, null));
            this.gehAddedTrustedUrlDomainList.remove(oldDomainName.toUpperCase());
            this.gehAddedTrustedUrlDomainList.add(domainName.toUpperCase());
            this.modifyChangeablePanel();
        }
    }

    void editDirectoryExclusionAction(int row) throws Exception {
        PolicyExceptionUIObject extObj = (PolicyExceptionUIObject)this.gehGroupModel.getRow(row);
        String action = extObj.getAction();
        String file = extObj.getOverride();
        int oldScanType = ((DirectoryExclusionUIObject)extObj.getRiskData()).getScanType();
        DirectoryExclusionDialog fileDlg = null;
        if (PolicyExceptionUIObject.PLATFORM_LINUX.equals(extObj.getPlatform())) {
            fileDlg = new DirectoryExclusionDialog(extObj, this.isReadonly, PolicyExceptionUIObject.PLATFORM_LINUX);
            fileDlg.setLinuxMap(this.gehAddedLinuxDirectoryExclusionMap);
        } else {
            fileDlg = new DirectoryExclusionDialog(extObj, this.isReadonly, PolicyExceptionUIObject.PLATFORM_WIN, this.isCloudExceptionPolicy, !this.isCloudExceptionPolicy);
            fileDlg.setMap(this.gehAddedDirectoryExclusionMap);
        }
        fileDlg.setVisible(true);
        if (fileDlg.isOk()) {
            String rName = fileDlg.getFileName();
            if (rName != null) {
                int newScanType = fileDlg.getScanType();
                PolicyExceptionUIObject policyObj = new PolicyExceptionUIObject(this.getDirScanType(newScanType), fileDlg.getFileName(), action, fileDlg.getSelectedDirectory(), null);
                if (PolicyExceptionUIObject.PLATFORM_LINUX.equals(extObj.getPlatform())) {
                    policyObj.setPlatform(PolicyExceptionUIObject.PLATFORM_LINUX);
                    String scanTypeStr = String.valueOf(newScanType);
                    if (this.gehAddedLinuxDirectoryExclusionMap == null || this.gehAddedLinuxDirectoryExclusionMap.get(scanTypeStr) == null) {
                        throw new Exception("gehAddedLinuxDirectoryExclusionMap.get(scanTypeStr) should not be null!");
                    }
                    this.gehAddedLinuxDirectoryExclusionMap.get(scanTypeStr).remove(DirectoryExclusionDialog.getProfileFormatLinuxDirectory(file));
                    this.addToLinuxDirectoryExclusionMap(newScanType, DirectoryExclusionDialog.getProfileFormatLinuxDirectory(fileDlg.getFileName()));
                } else if (PolicyExceptionUIObject.PLATFORM_WIN.equals(extObj.getPlatform())) {
                    policyObj.setPlatform(PolicyExceptionUIObject.PLATFORM_WIN);
                    String scanTypeStr = String.valueOf(oldScanType);
                    this.gehAddedDirectoryExclusionMap.get(scanTypeStr).remove(file);
                    this.addToDirectoryExclusionMap(newScanType, fileDlg.getFileName());
                }
                this.gehGroupModel.setRow(row, policyObj);
            }
            this.modifyChangeablePanel();
        }
    }

    private void editHPPManuallyAddedProcessAction(int row, DetectedProcessUIObject uiObject) {
        ApplicationExclusionDialog dialog = new ApplicationExclusionDialog(uiObject, DETECTED_PROCESS_ACTIONS, this.isReadonly);
        dialog.setVisible(true);
        if (dialog.isOk()) {
            DetectedProcessUIObject updatedUIObject = dialog.getSelectedFile();
            String platFormStr = null;
            ArrayList<String> detectedProcessList = null;
            if (uiObject.getOS() == DetectedProcesses.MAC.intValue()) {
                platFormStr = PolicyExceptionUIObject.PLATFORM_MAC;
                detectedProcessList = this.macAddedHppDetectedProcessList;
            } else if (uiObject.getOS() == DetectedProcesses.LINUX.intValue()) {
                platFormStr = PolicyExceptionUIObject.PLATFORM_LINUX;
            } else {
                platFormStr = PolicyExceptionUIObject.PLATFORM_WIN;
                detectedProcessList = this.gehAddedHppDetectedProcessList;
            }
            this.gehGroupModel.setRow(row, new PolicyExceptionUIObject(MSGRES.getString(GEH, "OverridePanel.risktype.hppDetectedProcesses"), platFormStr, updatedUIObject.getChecksum(), updatedUIObject.getAction(), updatedUIObject, null));
            if (detectedProcessList != null) {
                detectedProcessList.remove(uiObject.getChecksum());
                detectedProcessList.add(updatedUIObject.getChecksum());
            }
            this.modifyChangeablePanel();
        }
    }

    private void editHPPDetectedProcessAction(int row) {
        block5: {
            PolicyExceptionUIObject exceptionObj = (PolicyExceptionUIObject)this.gehGroupModel.getRow(row);
            DetectedProcessUIObject hppObj = (DetectedProcessUIObject)exceptionObj.getRiskData();
            hppObj.setAction(exceptionObj.getAction());
            if (PolicyExceptionUIObject.PLATFORM_MAC.equals(exceptionObj.getPlatform()) || hppObj.getCompany() == null && hppObj.getAltChecksum() == null) {
                this.editHPPManuallyAddedProcessAction(row, hppObj);
            } else {
                HPPDetectedProcessesDlg hppDlg = new HPPDetectedProcessesDlg(this, this.isReadonly, DETECTED_PROCESS_ACTIONS, this.appTitleEdit, this.appDescription, true);
                hppDlg.setList(this.gehAddedHppDetectedProcessList);
                try {
                    hppDlg.setData(hppObj);
                    hppDlg.setVisible(true);
                    if (hppDlg.isOk()) {
                        exceptionObj.setAction(hppObj.getAction());
                        this.gehGroupTable.updateUI();
                        this.modifyChangeablePanel();
                    }
                }
                catch (ConsoleException ex) {
                    LoggerUtilities.logException((Throwable)ex);
                    if (!ex.needRelogin()) break block5;
                    Manager.getFrame().showLoginPanel();
                }
            }
        }
    }

    private void editDnsHostFileExclusionChangeAction(int row) {
        block3: {
            PolicyExceptionUIObject exceptionObj = (PolicyExceptionUIObject)this.gehGroupModel.getRow(row);
            DnsHostFileChangeExclusionUIObject dnsObj = (DnsHostFileChangeExclusionUIObject)exceptionObj.getRiskData();
            dnsObj.setAction(exceptionObj.getAction());
            HPPDetectedProcessesDlg hppDlg = new HPPDetectedProcessesDlg(this, this.isReadonly, DNS_HOSTFILE_CHANGE_ACTIONS, this.dnsTitleEdit, this.appDescription, false);
            hppDlg.setList(this.gehAddedDnsAndHostFileChangeExclusionList);
            try {
                DetectedProcessUIObject dpUIObj = dnsObj.getDetectedProcessUIObject();
                hppDlg.setData(dpUIObj);
                hppDlg.setVisible(true);
                if (hppDlg.isOk()) {
                    dnsObj.setAction(dpUIObj.getAction());
                    exceptionObj.setAction(dnsObj.getAction());
                    this.gehGroupTable.updateUI();
                    this.modifyChangeablePanel();
                }
            }
            catch (ConsoleException ex) {
                LoggerUtilities.logException((Throwable)ex);
                if (!ex.needRelogin()) break block3;
                Manager.frame.showLoginPanel();
            }
        }
    }

    void editHPPProcessesToDetectAction(int row) {
        PolicyExceptionUIObject obj = (PolicyExceptionUIObject)this.gehGroupModel.getRow(row);
        ProcessesToDetectUIObject hppObj = (ProcessesToDetectUIObject)obj.getRiskData();
        String action = obj.getAction();
        String processName = hppObj.getDetectedProcess();
        HPPProcessesToDetectDlg hppDlg = new HPPProcessesToDetectDlg(processName, this.isReadonly);
        hppDlg.setList(this.gehAddedHppProcessToDetectList);
        hppDlg.setVisible(true);
        if (hppDlg.isOk()) {
            String rName = hppDlg.getProcessName();
            if (rName != null) {
                this.gehGroupModel.setRow(row, new PolicyExceptionUIObject(MSGRES.getString(GEH, "OverridePanel.risktype.hppProcessesToDetect"), hppDlg.getProcessName(), action, hppDlg.getSelectedHPPRisk(), null));
                this.gehAddedHppProcessToDetectList.remove(processName);
                this.gehAddedHppProcessToDetectList.add(hppDlg.getProcessName());
            }
            this.modifyChangeablePanel();
        }
    }

    void editMacFileFolderExclusionAction(int row) {
        PolicyExceptionUIObject extObj = (PolicyExceptionUIObject)this.gehGroupModel.getRow(row);
        String action = extObj.getAction();
        String file = extObj.getOverride();
        MacFileFolderExclusionDialog fileDlg = new MacFileFolderExclusionDialog(file, this.isReadonly);
        fileDlg.setList(this.macAddedFileFolderExclusionList);
        fileDlg.setApplicableScanTypes(extObj);
        fileDlg.setVisible(true);
        if (fileDlg.isOk()) {
            String rName = fileDlg.getFileName();
            if (rName != null) {
                String protectTechString = this.getMacProtectTechString(fileDlg.getSelectedFile());
                this.gehGroupModel.setRow(row, new PolicyExceptionUIObject(protectTechString, PolicyExceptionUIObject.PLATFORM_MAC, fileDlg.getFileName(), action, fileDlg.getSelectedFile(), null));
                this.macAddedFileFolderExclusionList.remove(file);
                this.macAddedFileFolderExclusionList.add(fileDlg.getFileName());
            }
            this.modifyChangeablePanel();
        }
    }

    private void editCertificateExclusionAction(int row) {
        PolicyExceptionUIObject extObj = (PolicyExceptionUIObject)this.gehGroupModel.getRow(row);
        String action = extObj.getAction();
        CertificateExclusionUIObject certObj = (CertificateExclusionUIObject)extObj.getRiskData();
        String oldThumbprint = extObj.getOverride();
        CertificateExclusionDialog certificateDlg = new CertificateExclusionDialog(certObj, this.isReadonly);
        certificateDlg.setHashMap(this.gehAddedCertificateExclusionMap);
        certificateDlg.setVisible(true);
        if (certificateDlg.isOk()) {
            CertificateExclusionUIObject certificateObj = certificateDlg.getSelectedCertificate();
            String certThumbprint = certificateObj.getThumbprint();
            String certThumbprintSha2 = certificateObj.getThumbprintSHA2();
            this.gehGroupModel.setRow(row, new PolicyExceptionUIObject(MSGRES.getString(GEH, "OverridePanel.risktype.certificateExclusion"), null, certThumbprint, action, certificateObj, null, certificateObj.getDisplayName()));
            if (this.gehAddedCertificateExclusionMap.containsKey(oldThumbprint)) {
                this.gehAddedCertificateExclusionMap.remove(oldThumbprint);
            }
            this.gehAddedCertificateExclusionMap.put(certThumbprint, certThumbprintSha2);
            this.modifyChangeablePanel();
        }
    }

    private void editNonFileExclusionAction(int row) {
        PolicyExceptionUIObject extObj = (PolicyExceptionUIObject)this.gehGroupModel.getRow(row);
        NonPEFileExclusionUIObject obj = (NonPEFileExclusionUIObject)extObj.getRiskData();
        obj.setAction(extObj.getAction());
        String oldFile = extObj.getOverride();
        NonPEFileExclusionDialog fileDlg = new NonPEFileExclusionDialog(obj, NON_PE_FILE_ACTIONS, this.isReadonly);
        fileDlg.setVisible(true);
        if (fileDlg.isOk()) {
            NonPEFileExclusionUIObject exclusionObject = fileDlg.getSelectedFile();
            this.gehGroupModel.setRow(row, new PolicyExceptionUIObject(MSGRES.getString(GEH, "OverridePanel.risktype.nonPEFileException"), exclusionObject.getOverride(), exclusionObject.getActionString(), exclusionObject, null));
            this.gehNonPEFileExclusionList.remove(oldFile);
            this.gehNonPEFileExclusionList.add(exclusionObject.getOverride());
            this.modifyChangeablePanel();
        }
    }

    void initAddedMaps() {
        this.gehAddedKnownSecurityList = new ArrayList();
        this.gehAddedHppDetectedProcessList = new ArrayList();
        this.macAddedHppDetectedProcessList = new ArrayList();
        this.gehAddedHppProcessToDetectList = new ArrayList();
        this.gehAddedExtensionExclusionList = new ArrayList();
        this.linuxGehAddedExtensionExclusionList = new ArrayList();
        this.gehAddedFileExclusionList = new ArrayList();
        this.gehAddedDirectoryExclusionMap = new HashMap();
        this.gehAddedLinuxDirectoryExclusionMap = new HashMap();
        this.gehAddedPermittedApplicationList = new ArrayList();
        this.gehAddedApplicationEventFilterMap = new ArrayList();
        this.macAddedFileFolderExclusionList = new ArrayList();
        this.gehAddedTrustedUrlDomainList = new ArrayList();
        this.gehAddedSysferFileControlList = new ArrayList();
        this.gehAddedDnsAndHostFileChangeExclusionList = new ArrayList();
        this.gehAddedCertificateExclusionMap = new HashMap<String, String>();
        this.gehNonPEFileExclusionList = new ArrayList();
    }

    void initActionMap() {
        this.gehActionStringToIntMap = new HashMap();
        this.gehActionStringToIntMap.put(MSGRES.getString(GEH, "PolicyOverride.ignore"), 0);
        this.gehActionStringToIntMap.put(MSGRES.getString(GEH, "PolicyOverride.block"), 1);
        this.gehActionStringToIntMap.put(MSGRES.getString(GEH, "PolicyOverride.quarantine"), 2);
        this.gehActionStringToIntMap.put(MSGRES.getString(GEH, "PolicyOverride.logonly"), 3);
        this.gehActionStringToIntMap.put(MSGRES.getString(GEH, "PolicyOverride.remove"), 4);
        this.gehActionStringToIntMap.put(MSGRES.getString(GEH, "PolicyOverride.prompt"), 5);
        this.gehActionIntToStringMap = new HashMap();
        this.gehActionIntToStringMap.put(0, MSGRES.getString(GEH, "PolicyOverride.ignore"));
        this.gehActionIntToStringMap.put(1, MSGRES.getString(GEH, "PolicyOverride.block"));
        this.gehActionIntToStringMap.put(2, MSGRES.getString(GEH, "PolicyOverride.quarantine"));
        this.gehActionIntToStringMap.put(3, MSGRES.getString(GEH, "PolicyOverride.logonly"));
        this.gehActionIntToStringMap.put(4, MSGRES.getString(GEH, "PolicyOverride.remove"));
        this.gehActionIntToStringMap.put(5, MSGRES.getString(GEH, "PolicyOverride.prompt"));
    }

    private void prepareAndSetPopupMenuItems(JComponent popupMenu) {
        JMenu windowsMenu = new JMenu(MSGRES.getString(GEH, "OverridePanel.menu.windowsEmbeddedExceptionsOverride"));
        JMenuItem knownRiskMenu = new JMenuItem(MSGRES.getString(GEH, "OverridePanel.menu.knownRisk"));
        knownRiskMenu.addActionListener(this.getKnownActionListener());
        this.extensionMenu = new JMenuItem(MSGRES.getString(GEH, "OverridePanel.menu.extension"));
        this.extensionMenu.addActionListener(this.getExtensionExclusionActionListener());
        JMenuItem fileMenu = new JMenuItem(MSGRES.getString(GEH, "OverridePanel.menu.file"));
        fileMenu.addActionListener(this.getFileExclusionActionListener());
        JMenuItem nonPEFileMenu = new JMenuItem(MSGRES.getString(GEH, "OverridePanel.menu.file.nonPE"));
        nonPEFileMenu.addActionListener(this.getNonPEFileExclusionActionListener());
        this.directoryMenu = new JMenuItem(MSGRES.getString(GEH, "OverridePanel.menu.directory"));
        this.directoryMenu.addActionListener(this.getDirectoryExclusionActionListener("Windows"));
        JMenuItem detectProcessMenu = new JMenuItem(MSGRES.getString(GEH, "OverridePanel.menu.application"));
        detectProcessMenu.addActionListener(this.getHPDetectedProcessesListener());
        JMenuItem processToDetectMenu = new JMenuItem(MSGRES.getString(GEH, "OverridePanel.menu.applicationToWatch"));
        processToDetectMenu.addActionListener(this.getHPProcessesToDetectListener());
        if (!this.isCloudEnrolled) {
            ((Container)windowsMenu).add(detectProcessMenu);
        }
        ((Container)windowsMenu).add(processToDetectMenu);
        ((Container)windowsMenu).add(this.extensionMenu);
        ((Container)windowsMenu).add(fileMenu);
        ((Container)windowsMenu).add(nonPEFileMenu);
        ((Container)windowsMenu).add(this.directoryMenu);
        ((Container)windowsMenu).add(knownRiskMenu);
        JMenuItem tamperProtectionMenu = new JMenuItem(MSGRES.getString(GEH, "OverridePanel.menu.tamperProtectionOverride"));
        tamperProtectionMenu.addActionListener(this.getTamperProtectionActionListener());
        JMenuItem trustedURLDomainMenu = new JMenuItem(MSGRES.getString(GEH, "OverridePanel.menu.domain"));
        trustedURLDomainMenu.addActionListener(this.getTrustedURLDomainActionListener());
        JMenuItem dnsHostFileExceptionMenu = new JMenuItem(MSGRES.getString(GEH, "OverridePanel.menu.dnsHostFileChange"));
        dnsHostFileExceptionMenu.addActionListener(this.getDnsHostFileExclusionListener());
        if (!this.isCloudEnrolled) {
            ((Container)windowsMenu).add(trustedURLDomainMenu);
        }
        ((Container)windowsMenu).add(tamperProtectionMenu);
        if (!LicenseObject.getInstance().isSBProduct()) {
            ((Container)windowsMenu).add(dnsHostFileExceptionMenu);
        }
        JMenuItem certificateMenu = new JMenuItem(MSGRES.getString(GEH, "OverridePanel.menu.certificate"));
        if (!this.isCloudEnrolled) {
            certificateMenu.addActionListener(this.getCertificateActionListener(new CertificateExclusionDialog()));
            ((Container)windowsMenu).add(certificateMenu);
        }
        JMenu macMenu = new JMenu(MSGRES.getString(GEH, "OverridePanel.menu.macExceptions"));
        JMenuItem macFileFolderMenu = new JMenuItem(MSGRES.getString(GEH, "OverridePanel.menu.macSecurityRiskOverride"));
        ((Container)macMenu).add(macFileFolderMenu);
        macFileFolderMenu.addActionListener(this.getMacFileFolderExclusionActionListener());
        JMenuItem macApplication = new JMenuItem(MSGRES.getString(GEH, "OverridePanel.menu.macApplication"));
        ((Container)macMenu).add(macApplication);
        macApplication.addActionListener(this.getApplicationExclusionActionListener(PolicyExceptionUIObject.PLATFORM_MAC));
        macApplication.setVisible(false);
        JMenu linuxMenu = new JMenu(MSGRES.getString(GEH, "OverridePanel.menu.linuxExceptionsOverride"));
        this.linuxDirectoryMenu = new JMenuItem(MSGRES.getString(GEH, "OverridePanel.menu.directory"));
        this.linuxDirectoryMenu.addActionListener(this.getDirectoryExclusionActionListener("Linux"));
        this.linuxExtensionMenu = new JMenuItem(MSGRES.getString(GEH, "OverridePanel.menu.extension"));
        this.linuxExtensionMenu.addActionListener(this.getLinuxExtensionExclusionActionListener());
        ((Container)linuxMenu).add(this.linuxDirectoryMenu);
        ((Container)linuxMenu).add(this.linuxExtensionMenu);
        popupMenu.add(windowsMenu);
        popupMenu.add(macMenu);
        if (!LicenseObject.getInstance().isSBProduct()) {
            popupMenu.add(linuxMenu);
        }
    }

    JPanel getChangeablePanel() {
        int i;
        if (this.gehChangeablePanel == null) {
            this.gehChangeablePanel = new JPanel();
        }
        JLabel ptLabel = new JLabel(MSGRES.getString(GEH, "OverridePanel.label.protectionTechnology"));
        JLabel overrideLabel = new JLabel(MSGRES.getString(GEH, "OverridePanel.label.override"));
        JLabel actionLabel = new JLabel(MSGRES.getString(GEH, "OverridePanel.label.action"));
        this.gehPtDescLabel = new JLabel("");
        this.gehOverrideDescLabel = new ReadOnlyTextArea(this);
        this.gehOverrideDescLabel.setText("");
        this.gehOverrideDescLabel.setColumns(60);
        this.gehActionDescLabel = new JLabel("");
        this.gehOtherFieldName = new JLabel[6];
        this.gehOtherFieldContent = new JLabel[6];
        for (int i2 = 0; i2 < 6; ++i2) {
            this.gehOtherFieldName[i2] = new JLabel("");
            this.gehOtherFieldContent[i2] = new JLabel("");
        }
        GridBagConstraints g1 = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0);
        GridBagConstraints g2 = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0);
        GridBagConstraints g5 = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0);
        GridBagConstraints g6 = new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0);
        GridBagConstraints g7 = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0);
        GridBagConstraints g8 = new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0);
        GridBagConstraints[] gc = new GridBagConstraints[12];
        int ij = 3;
        for (i = 0; i < 12; i += 2) {
            gc[i] = new GridBagConstraints(0, ij, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0);
            gc[i + 1] = new GridBagConstraints(1, ij, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0);
            ++ij;
        }
        this.gehChangeablePanel.setLayout(new GridBagLayout());
        this.gehChangeablePanel.add((Component)overrideLabel, g1);
        this.gehChangeablePanel.add((Component)this.gehOverrideDescLabel, g2);
        this.gehChangeablePanel.add((Component)actionLabel, g5);
        this.gehChangeablePanel.add((Component)this.gehActionDescLabel, g6);
        this.gehChangeablePanel.add((Component)ptLabel, g7);
        this.gehChangeablePanel.add((Component)this.gehPtDescLabel, g8);
        for (i = 0; i < 6; ++i) {
            int j = 2 * i;
            this.gehChangeablePanel.add((Component)this.gehOtherFieldName[i], gc[j]);
            this.gehChangeablePanel.add((Component)this.gehOtherFieldContent[i], gc[j + 1]);
            this.gehOtherFieldName[i].setVisible(false);
            this.gehOtherFieldContent[i].setVisible(false);
        }
        this.gehChangeablePanel.setBorder(BorderFactory.createEmptyBorder(0, 40, 0, 5));
        JPanel panel1 = new JPanel(new BorderLayout());
        panel1.add((Component)this.gehChangeablePanel, "West");
        return panel1;
    }

    private void cleanChangeablePanel() {
        for (int i = 0; i < 6; ++i) {
            this.gehOtherFieldName[i].setVisible(false);
            this.gehOtherFieldContent[i].setVisible(false);
        }
        this.gehPtDescLabel.setText("");
        this.gehOverrideDescLabel.setText("");
        this.gehActionDescLabel.setText("");
    }

    private void modifyChangeablePanel() {
        int i;
        int rowNo = this.gehGroupTable.getSelectedRow();
        PolicyExceptionUIObject rowData = null;
        if (rowNo < 0) {
            this.cleanChangeablePanel();
            return;
        }
        rowData = (PolicyExceptionUIObject)Cast.cast((Object)this.gehGroupModel.getRow(rowNo));
        if (rowData == null) {
            return;
        }
        ExceptionUIObject riskData = rowData.getRiskData();
        if (riskData == null) {
            return;
        }
        int actualNoOfFields = riskData.getNoOfFields();
        for (i = 0; i < 6; ++i) {
            this.gehOtherFieldName[i].setVisible(false);
            this.gehOtherFieldContent[i].setVisible(false);
        }
        this.gehPtDescLabel.setText(rowData.getProtectionTechnology());
        this.gehOverrideDescLabel.setText(rowData.getGehOverrideDisplayName());
        this.gehActionDescLabel.setText(this.getActionLabelString(rowData));
        for (i = 0; i < actualNoOfFields; ++i) {
            this.gehOtherFieldName[i].setText(riskData.getFieldName(i));
            this.gehOtherFieldContent[i].setText(riskData.getContent(i));
            this.gehOtherFieldName[i].setVisible(true);
            this.gehOtherFieldContent[i].setVisible(true);
        }
    }

    private String getActionLabelString(PolicyExceptionUIObject rowData) {
        String action;
        block3: {
            ExceptionUIObject riskData;
            block2: {
                riskData = rowData.getRiskData();
                action = rowData.getAction();
                if (riskData.getRiskType() != 11) break block2;
                for (OverrideActionCheckboxItem element : DNS_HOSTFILE_CHANGE_ACTIONS) {
                    if (!element.getValue().equalsIgnoreCase(action)) continue;
                    return element.getLabel();
                }
                break block3;
            }
            if (riskData.getRiskType() != 13) break block3;
            for (OverrideActionCheckboxItem element : NON_PE_FILE_ACTIONS) {
                if (!element.getValue().equalsIgnoreCase(action)) continue;
                return element.getLabel();
            }
        }
        return action;
    }

    ActionListener getKnownActionListener() {
        ActionListener knownAction = e -> {
            block3: {
                KnownSecurityRiskDlg knownDlg = new KnownSecurityRiskDlg();
                knownDlg.setList(this.gehAddedKnownSecurityList);
                try {
                    knownDlg.setData();
                    knownDlg.setVisible(true);
                    if (knownDlg.isOk()) {
                        this.onKnownSecurityRiskDlgOk(knownDlg, -1);
                    }
                }
                catch (ConsoleException ex) {
                    LoggerUtilities.logException((Throwable)ex);
                    if (!ex.needRelogin()) break block3;
                    Manager.getFrame().showLoginPanel();
                }
            }
        };
        return knownAction;
    }

    private ActionListener getDnsHostFileExclusionListener() {
        ActionListener hpdAction = e -> {
            block5: {
                HPPDetectedProcessesDlg hppDlg = new HPPDetectedProcessesDlg(this, false, DNS_HOSTFILE_CHANGE_ACTIONS, this.dnsTitleAdd, this.appDescription, false);
                hppDlg.setList(this.gehAddedDnsAndHostFileChangeExclusionList);
                try {
                    DetectedProcessUIObject[] detectedProcs;
                    hppDlg.setData(null);
                    hppDlg.setVisible(true);
                    if (hppDlg.isOk() && (detectedProcs = hppDlg.getSelectedHPPRisks()) != null) {
                        for (DetectedProcessUIObject dProc : detectedProcs) {
                            DnsHostFileChangeExclusionUIObject dnsHostFileUIObject = new DnsHostFileChangeExclusionUIObject(dProc, dProc.getAction());
                            dnsHostFileUIObject.setAction(dProc.getAction());
                            this.gehGroupModel.addRow(new PolicyExceptionUIObject(MSGRES.getString(GEH, "OverridePanel.risktype.dnsHostFileChangeExclusion"), MSGRES.getString(GEH, "OverridePanel.platform.windows"), dProc.getChecksum(), dnsHostFileUIObject.getAction(), dnsHostFileUIObject, null));
                            this.gehAddedDnsAndHostFileChangeExclusionList.add(dnsHostFileUIObject.getDetectedProcessUIObject().getChecksum());
                        }
                        int rowCount = this.gehGroupTable.getRowCount();
                        if (rowCount > 0) {
                            int addedRow = rowCount - 1;
                            this.gehGroupTable.setRowSelectionInterval(addedRow, addedRow);
                        }
                    }
                }
                catch (ConsoleException ex) {
                    LoggerUtilities.logException((Throwable)ex);
                    if (!ex.needRelogin()) break block5;
                    Manager.frame.showLoginPanel();
                }
            }
        };
        return hpdAction;
    }

    ActionListener getDirectoryExclusionActionListener(String platForm) {
        ActionListener dirAction = e -> {
            String rName;
            DirectoryExclusionDialog dirDlg = null;
            if ("Linux".equals(platForm)) {
                dirDlg = new DirectoryExclusionDialog(PolicyExceptionUIObject.PLATFORM_LINUX);
                dirDlg.setLinuxMap(this.gehAddedLinuxDirectoryExclusionMap);
            } else {
                dirDlg = new DirectoryExclusionDialog(PolicyExceptionUIObject.PLATFORM_WIN, this.isNotCloudEnrolledOrCloudPolicy, this.isNotCloudEnrolledOrSepPolicy);
                dirDlg.setMap(this.gehAddedDirectoryExclusionMap);
            }
            dirDlg.setVisible(true);
            if (dirDlg.isOk() && (rName = dirDlg.getFileName()) != null && rName.trim().length() > 0) {
                String action = PolicyOverrideConstants.GEH_IGNORE;
                int scanType = dirDlg.getScanType();
                PolicyExceptionUIObject policyObj = new PolicyExceptionUIObject(this.getDirScanType(scanType), dirDlg.getFileName(), action, dirDlg.getSelectedDirectory(), null);
                if ("Linux".equals(platForm)) {
                    this.addToLinuxDirectoryExclusionMap(scanType, DirectoryExclusionDialog.getProfileFormatLinuxDirectory(dirDlg.getFileName()));
                    policyObj.setPlatform(PolicyExceptionUIObject.PLATFORM_LINUX);
                } else if (PolicyExceptionUIObject.PLATFORM_WIN.equals(platForm)) {
                    this.addToDirectoryExclusionMap(scanType, dirDlg.getFileName());
                    policyObj.setPlatform(PolicyExceptionUIObject.PLATFORM_WIN);
                }
                this.gehGroupModel.addRow(policyObj);
                int addedRow = this.gehGroupTable.getRowCount() - 1;
                this.gehGroupTable.setRowSelectionInterval(addedRow, addedRow);
            }
        };
        return dirAction;
    }

    ActionListener getExtensionExclusionActionListener() {
        ActionListener extAction = e -> {
            if (this.gehAddedExtensionExclusionList.size() > 0) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES.getString(GEH, "ExtensionExclusionDialog.error.onlyOneEntry"), MSGRES.getString(GEH, "OverridePolicySelectDlg.warning"), 2);
                return;
            }
            ExtensionExclusionDialog extDlg = new ExtensionExclusionDialog();
            extDlg.setVisible(true);
            if (extDlg.isOk()) {
                String rName = extDlg.getExtension();
                String action = PolicyOverrideConstants.GEH_IGNORE;
                this.gehGroupModel.addRow(new PolicyExceptionUIObject(MSGRES.getString(GEH, "OverridePanel.risktype.extensionExclusion"), rName, action, extDlg.getExtensionExclusionUIObject(), null));
                this.gehAddedExtensionExclusionList.add(rName);
                int addedRow = this.gehGroupTable.getRowCount() - 1;
                this.gehGroupTable.setRowSelectionInterval(addedRow, addedRow);
            }
        };
        return extAction;
    }

    ActionListener getLinuxExtensionExclusionActionListener() {
        ActionListener extAction = e -> {
            if (this.linuxGehAddedExtensionExclusionList.size() > 0) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES.getString(GEH, "ExtensionExclusionDialog.error.onlyOneEntry"), MSGRES.getString(GEH, "OverridePolicySelectDlg.warning"), 2);
                return;
            }
            ExtensionExclusionDialog extDlg = new ExtensionExclusionDialog("Linux");
            extDlg.setVisible(true);
            if (extDlg.isOk()) {
                String rName = extDlg.getExtension();
                String action = PolicyOverrideConstants.GEH_IGNORE;
                this.gehGroupModel.addRow(new PolicyExceptionUIObject(MSGRES.getString(GEH, "OverridePanel.risktype.extensionExclusion"), PolicyExceptionUIObject.PLATFORM_LINUX, rName, action, extDlg.getExtensionExclusionUIObject(), null));
                this.linuxGehAddedExtensionExclusionList.add(rName);
                int addedRow = this.gehGroupTable.getRowCount() - 1;
                this.gehGroupTable.setRowSelectionInterval(addedRow, addedRow);
            }
        };
        return extAction;
    }

    ActionListener getFileExclusionActionListener() {
        ActionListener extAction = e -> {
            FileExclusionDialog fileDlg = new FileExclusionDialog(LicenseObject.getInstance().isSBProduct(), this.isCloudExceptionPolicy, !this.isCloudExceptionPolicy);
            fileDlg.setList(this.gehAddedFileExclusionList);
            fileDlg.setVisible(true);
            if (fileDlg.isOk() && fileDlg.getFileName() != null && fileDlg.getFileName().trim().length() > 0) {
                String action = PolicyOverrideConstants.GEH_IGNORE;
                FileExclusionUIObject exclusionObject = fileDlg.getSelectedFile();
                String technologies = this.getApplicableTechnologies(exclusionObject);
                this.gehGroupModel.addRow(new PolicyExceptionUIObject(technologies, fileDlg.getFileName(), action, exclusionObject, null));
                int addedRow = this.gehGroupTable.getRowCount() - 1;
                this.gehGroupTable.setRowSelectionInterval(addedRow, addedRow);
                this.gehAddedFileExclusionList.add(fileDlg.getFileName());
            }
        };
        return extAction;
    }

    ActionListener getNonPEFileExclusionActionListener() {
        ActionListener extAction = e -> {
            NonPEFileExclusionDialog fileDlg = new NonPEFileExclusionDialog(NON_PE_FILE_ACTIONS);
            fileDlg.setVisible(true);
            if (fileDlg.isOk()) {
                NonPEFileExclusionUIObject uiObject = fileDlg.getSelectedFile();
                this.gehGroupModel.addRow(new PolicyExceptionUIObject(MSGRES.getString(GEH, "OverridePanel.risktype.nonPEFileException"), uiObject.getOverride(), uiObject.getActionString(), uiObject, null));
                int addedRow = this.gehGroupTable.getRowCount() - 1;
                this.gehGroupTable.setRowSelectionInterval(addedRow, addedRow);
                this.gehNonPEFileExclusionList.add(uiObject.getOverride());
            }
        };
        return extAction;
    }

    ActionListener getSysferFileControlExclusionListener() {
        ActionListener extAction = e -> {
            String riskName;
            SysferFileControlExclusionDialog fileControlDlg = new SysferFileControlExclusionDialog();
            fileControlDlg.setList(this.gehAddedSysferFileControlList);
            fileControlDlg.setVisible(true);
            if (fileControlDlg.isOk() && (riskName = fileControlDlg.getFileControlName()) != null && riskName.trim().length() > 0) {
                String action = PolicyOverrideConstants.GEH_IGNORE;
                this.gehGroupModel.addRow(new PolicyExceptionUIObject(MSGRES.getString(GEH, "OverridePanel.risktype.fileControlExclusion"), fileControlDlg.getFileControlName(), action, fileControlDlg.getSelectedFile(), null));
                int addedRow = this.gehGroupTable.getRowCount() - 1;
                this.gehGroupTable.setRowSelectionInterval(addedRow, addedRow);
                this.gehAddedSysferFileControlList.add(fileControlDlg.getFileControlName());
            }
        };
        return extAction;
    }

    ActionListener getTamperProtectionActionListener() {
        ActionListener extAction = e -> {
            TamperProtectionDialog appDlg = new TamperProtectionDialog(this.gehAddedPermittedApplicationList, this.gehAddedApplicationEventFilterMap);
            appDlg.setVisible(true);
            if (appDlg.isOk()) {
                String action = PolicyOverrideConstants.GEH_IGNORE;
                if (appDlg.isPermittedApplication()) {
                    this.gehGroupModel.addRow(new PolicyExceptionUIObject(MSGRES.getString(GEH, "OverridePanel.risktype.tamperProtection"), appDlg.getPrefixFileName(), action, appDlg.getPermittedApplication(), null));
                    this.gehAddedPermittedApplicationList.add(appDlg.getPrefixFileName());
                } else {
                    ApplicationEventFilterUIObject uiObject = appDlg.getApplicationEventFilter();
                    String filterName = uiObject.getFilterName();
                    this.gehGroupModel.addRow(new PolicyExceptionUIObject(MSGRES.getString(GEH, "OverridePanel.risktype.tamperProtection"), filterName, action, uiObject, null));
                    this.gehAddedApplicationEventFilterMap.add(filterName);
                }
                int addedRow = this.gehGroupTable.getRowCount() - 1;
                this.gehGroupTable.setRowSelectionInterval(addedRow, addedRow);
            }
        };
        return extAction;
    }

    ActionListener getTrustedURLDomainActionListener() {
        ActionListener extAction = e -> {
            TrustedURLDomainExceptionDialog domainDlg = new TrustedURLDomainExceptionDialog();
            domainDlg.setList(this.gehAddedTrustedUrlDomainList);
            domainDlg.setVisible(true);
            if (domainDlg.isOk()) {
                TrustedURLDomainUIObject domainObj = domainDlg.getSelectedDomain();
                String domainName = domainObj.getURLDomainName();
                String action = PolicyOverrideConstants.GEH_IGNORE;
                this.gehGroupModel.addRow(new PolicyExceptionUIObject(MSGRES.getString(GEH, "OverridePanel.risktype.domainExclusion"), domainName, action, domainObj, null));
                int addedRow = this.gehGroupTable.getRowCount() - 1;
                this.gehGroupTable.setRowSelectionInterval(addedRow, addedRow);
                this.gehAddedTrustedUrlDomainList.add(domainName.toUpperCase());
            }
        };
        return extAction;
    }

    private ActionListener getCertificateActionListener(CertificateExclusionDialog certificateDlg) {
        return e -> {
            certificateDlg.setHashMap(this.gehAddedCertificateExclusionMap);
            certificateDlg.setVisible(true);
            if (certificateDlg.isOk()) {
                int result;
                CertificateExclusionUIObject certificateObj = certificateDlg.getSelectedCertificate();
                String certThumbprint = certificateObj.getThumbprint();
                if (this.gehAddedCertificateExclusionMap.containsKey(certThumbprint) && (result = UIUtilities.confirmYesNoOptionDialog(MSGRES.getString(GEH, "OverridePanel.add.warning.external.overwrittentext"), MSGRES.getString(GEH, "OverridePanel.add.warning.external.title"))) != 0) {
                    return;
                }
                this.addNewCertificate(certificateDlg);
            }
        };
    }

    private void addNewCertificate(CertificateExclusionDialog certificateDlg) {
        if (certificateDlg == null) {
            return;
        }
        CertificateExclusionUIObject certificateObj = certificateDlg.getSelectedCertificate();
        String certThumbprint = certificateObj.getThumbprint();
        String certThumbprintSha2 = certificateObj.getThumbprintSHA2();
        String action = PolicyOverrideConstants.GEH_IGNORE;
        PolicyExceptionUIObject policyExceptionUIObject = new PolicyExceptionUIObject(MSGRES.getString(GEH, "OverridePanel.risktype.certificateExclusion"), null, certThumbprint, action, certificateObj, null, certificateObj.getDisplayName());
        int row = this.findPolicyExceptionRowIndexBySha1(certThumbprint);
        if (row >= 0) {
            this.gehGroupModel.setRow(row, policyExceptionUIObject);
            this.gehGroupTable.setRowSelectionInterval(row, row);
            this.gehGroupTable.scrollRectToVisible(new Rectangle(this.gehGroupTable.getCellRect(row, 0, true)));
        } else {
            this.gehGroupModel.addRow(policyExceptionUIObject);
            int addedRow = this.gehGroupTable.getRowCount() - 1;
            this.gehGroupTable.setRowSelectionInterval(addedRow, addedRow);
            this.gehGroupTable.scrollRectToVisible(new Rectangle(this.gehGroupTable.getCellRect(addedRow, 0, true)));
        }
        this.gehAddedCertificateExclusionMap.put(certThumbprint, certThumbprintSha2);
        this.modifyChangeablePanel();
    }

    private int findPolicyExceptionRowIndexBySha1(String thumbprint) {
        int noOfRows = this.gehGroupTable.getRowCount();
        for (int i = 0; i < noOfRows; ++i) {
            CertificateExclusionUIObject certificateObj;
            PolicyExceptionUIObject obj = (PolicyExceptionUIObject)this.gehGroupModel.getRow(i);
            if (obj.getRiskData().getRiskType() != 12 || !(certificateObj = (CertificateExclusionUIObject)obj.getRiskData()).getThumbprint().equals(thumbprint)) continue;
            return i;
        }
        return -1;
    }

    private ActionListener getHPDetectedProcessesListener() {
        ActionListener hpdAction = e -> {
            block5: {
                HPPDetectedProcessesDlg hppDlg = new HPPDetectedProcessesDlg(this, false, DETECTED_PROCESS_ACTIONS, this.appTitleAdd, this.appDescription, true);
                hppDlg.setList(this.gehAddedHppDetectedProcessList);
                try {
                    DetectedProcessUIObject[] dProcs;
                    hppDlg.setData(null);
                    hppDlg.setVisible(true);
                    if (hppDlg.isOk() && (dProcs = hppDlg.getSelectedHPPRisks()) != null) {
                        for (DetectedProcessUIObject dProc : dProcs) {
                            this.gehGroupModel.addRow(new PolicyExceptionUIObject(MSGRES.getString(GEH, "OverridePanel.risktype.hppDetectedProcesses"), MSGRES.getString(GEH, "OverridePanel.platform.windows"), dProc.getChecksum(), dProc.getAction(), dProc, null));
                            this.gehAddedHppDetectedProcessList.add(dProc.getChecksum());
                        }
                        int rowCount = this.gehGroupTable.getRowCount();
                        if (rowCount > 0) {
                            int addedRow = rowCount - 1;
                            this.gehGroupTable.setRowSelectionInterval(addedRow, addedRow);
                        }
                    }
                }
                catch (ConsoleException ex) {
                    LoggerUtilities.logException((Throwable)ex);
                    if (!ex.needRelogin()) break block5;
                    Manager.getFrame().showLoginPanel();
                }
            }
        };
        return hpdAction;
    }

    ActionListener getHPProcessesToDetectListener() {
        ActionListener hpdAction = e -> {
            String rName;
            HPPProcessesToDetectDlg hppDlg = new HPPProcessesToDetectDlg();
            hppDlg.setList(this.gehAddedHppProcessToDetectList);
            hppDlg.setVisible(true);
            if (hppDlg.isOk() && (rName = hppDlg.getProcessName()) != null && rName.trim().length() > 0) {
                String action = PolicyOverrideConstants.GEH_LOGONLY;
                this.gehGroupModel.addRow(new PolicyExceptionUIObject(MSGRES.getString(GEH, "OverridePanel.risktype.hppProcessesToDetect"), hppDlg.getProcessName(), action, hppDlg.getSelectedHPPRisk(), null));
                int addedRow = this.gehGroupTable.getRowCount() - 1;
                this.gehGroupTable.setRowSelectionInterval(addedRow, addedRow);
                this.gehAddedHppProcessToDetectList.add(hppDlg.getProcessName());
            }
        };
        return hpdAction;
    }

    ActionListener getApplicationExclusionActionListener(String osPlatForm) {
        ActionListener extAction = e -> {
            ApplicationExclusionDialog fileDlg = new ApplicationExclusionDialog(DETECTED_PROCESS_ACTIONS, osPlatForm);
            fileDlg.setVisible(true);
            if (fileDlg.isOk()) {
                DetectedProcessUIObject uiObject = fileDlg.getSelectedFile();
                this.gehGroupModel.addRow(new PolicyExceptionUIObject(MSGRES.getString(GEH, "OverridePanel.risktype.hppDetectedProcesses"), osPlatForm, uiObject.getChecksum(), uiObject.getAction(), uiObject, null));
                int addedRow = this.gehGroupTable.getRowCount() - 1;
                this.gehGroupTable.setRowSelectionInterval(addedRow, addedRow);
                if (PolicyExceptionUIObject.PLATFORM_WIN.equals(osPlatForm)) {
                    this.gehAddedHppDetectedProcessList.add(uiObject.getChecksum());
                } else {
                    this.macAddedHppDetectedProcessList.add(uiObject.getChecksum());
                }
            }
        };
        return extAction;
    }

    ActionListener getMacFileFolderExclusionActionListener() {
        ActionListener macFileFolderAction = e -> {
            String rName;
            MacFileFolderExclusionDialog fileFolderDlg = new MacFileFolderExclusionDialog();
            fileFolderDlg.setList(this.macAddedFileFolderExclusionList);
            fileFolderDlg.setVisible(true);
            if (fileFolderDlg.isOk() && (rName = fileFolderDlg.getFileName()) != null && rName.trim().length() > 0) {
                String action = PolicyOverrideConstants.GEH_IGNORE;
                String techString = this.getMacProtectTechString(fileFolderDlg.getSelectedFile());
                this.gehGroupModel.addRow(new PolicyExceptionUIObject(techString, PolicyExceptionUIObject.PLATFORM_MAC, fileFolderDlg.getFileName(), action, fileFolderDlg.getSelectedFile(), null));
                int addedRow = this.gehGroupTable.getRowCount() - 1;
                this.gehGroupTable.setRowSelectionInterval(addedRow, addedRow);
                this.macAddedFileFolderExclusionList.add(fileFolderDlg.getFileName());
            }
        };
        return macFileFolderAction;
    }

    private String getMacProtectTechString(MacFileFolderExclusionUIObject selectedFile) {
        StringBuilder applicableTechnologies = new StringBuilder();
        applicableTechnologies.append(MSGRES.getString(GEH, "MacFileFolderExclusionDialog.heading.label"));
        applicableTechnologies.append(" - ");
        if (selectedFile.isSonarApplicable()) {
            applicableTechnologies.append(MSGRES.getString(GEH, "MacFileFolderExclusionDialog.scantype.sonar"));
            applicableTechnologies.append(";");
        }
        if (selectedFile.isSecurityRiskApplicable()) {
            applicableTechnologies.append(MSGRES.getString(GEH, "MacFileFolderExclusionDialog.scantype.securityrisk"));
            applicableTechnologies.append(";");
        }
        return applicableTechnologies.toString();
    }

    public boolean save() throws ConsoleException {
        int i;
        int noOfRows = this.gehGroupTable.getRowCount();
        int noOfItems = this.gehPolicyOverride.getOverrideItemCount();
        HashMap<String, String> backupMap = new HashMap<String, String>();
        for (i = noOfItems - 1; i >= 0; --i) {
            OverrideItem overItem = this.gehPolicyOverride.getOverrideItem(i);
            if (overItem != null && overItem.getOptSecurityRiskOverride() != null && overItem.getOptSecurityRiskOverride().getOptKnownRiskOverrride() != null) {
                KnownRiskOverrride objName = overItem.getOptSecurityRiskOverride().getOptKnownRiskOverrride();
                backupMap.put(objName.getSecurityRiskName(), objName.getOptPVID());
            }
            this.gehPolicyOverride.removeOverrideItem(overItem);
            if (overItem == null) continue;
            this.gehPolicyOverride.removeObsoleteItem(new ObsoleteItem(overItem.getI()));
        }
        for (i = 0; i < noOfRows; ++i) {
            String riskName;
            KnownSecurityUIObject ksObj;
            PolicyExceptionUIObject obj = (PolicyExceptionUIObject)this.gehGroupModel.getRow(i);
            OverrideItem item = null;
            if (obj.getRiskData().getRiskType() == 0 && ((ksObj = (KnownSecurityUIObject)obj.getRiskData()).getPVID() == null || ksObj.getPVID().trim().compareTo("") == 0) && backupMap.containsKey(riskName = ksObj.getSecurityRisk())) {
                String vid = ((String)backupMap.get(riskName)).toString();
                ksObj.setPVID(vid);
            }
            switch (obj.getRiskData().getRiskType()) {
                case 0: {
                    item = this.saveKnownRisk(obj);
                    break;
                }
                case 3: {
                    item = this.saveExtensionExclusion(obj);
                    break;
                }
                case 4: {
                    item = this.saveFileExclusion(obj);
                    break;
                }
                case 5: {
                    item = this.saveDirectoryExclusion(obj);
                    break;
                }
                case 1: {
                    item = this.saveHppDetectedProcesses(obj);
                    break;
                }
                case 2: {
                    item = this.saveHppProcessesToDetect(obj);
                    break;
                }
                case 6: {
                    item = this.savePermittedApplication(obj);
                    break;
                }
                case 7: {
                    item = this.saveApplicationEventFilter(obj);
                    break;
                }
                case 9: {
                    item = this.saveMacFileFolderExclusion(obj);
                    break;
                }
                case 8: {
                    item = this.saveTrustedURLDomain(obj);
                    break;
                }
                case 10: {
                    item = this.saveSysferFileControl(obj);
                    break;
                }
                case 11: {
                    item = this.saveDnsHostFileExclusion(obj);
                    break;
                }
                case 12: {
                    item = this.saveCertificateExclusion(obj);
                    break;
                }
                case 13: {
                    item = this.saveNonPEFileExclusion(obj);
                    break;
                }
            }
            String source = obj.getGehSource();
            if (null != source && item != null) {
                item.setOptSource(source);
            }
            this.gehPolicyOverride.addOverrideItem(item);
        }
        return true;
    }

    OverrideItem saveDnsHostFileExclusion(PolicyExceptionUIObject obj) throws ConsoleException {
        OverrideItem item = new OverrideItem();
        DnsHostFileChangeExclusionUIObject dnsObj = (DnsHostFileChangeExclusionUIObject)obj.getRiskData();
        DnsHostFileOverride dnsHostFileOverride = new DnsHostFileOverride();
        item.setOptDnsHostFileOverride(dnsHostFileOverride);
        DetectedProcessUIObject dpUIObj = null;
        dpUIObj = dnsObj.getDetectedProcessUIObject();
        DetectedProcesses process = new DetectedProcesses();
        process.setChecksum(dpUIObj.getChecksum());
        process.setOptAltChecksum(dpUIObj.getAltChecksum());
        process.setProcessName(dpUIObj.getDetectedProcess());
        process.setOptPath(dpUIObj.getFilePath());
        process.setOptCompany(dpUIObj.getCompany());
        process.setOptFileSize(dpUIObj.getFileSize());
        dnsHostFileOverride.setOptDetectedProcesses(process);
        try {
            item.setAction(this.gehActionStringToIntMap.get(obj.getAction()));
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        return item;
    }

    OverrideItem saveKnownRisk(PolicyExceptionUIObject obj) {
        OverrideItem item = new OverrideItem();
        KnownSecurityUIObject ksObj = (KnownSecurityUIObject)obj.getRiskData();
        SecurityRiskOverride srOver = new SecurityRiskOverride();
        item.setOptSecurityRiskOverride(srOver);
        KnownRiskOverrride knownRisk = new KnownRiskOverrride();
        srOver.setOptKnownRiskOverrride(knownRisk);
        knownRisk.setSecurityRiskName(obj.getOverride());
        knownRisk.setOptOverallRating(ksObj.getOverallRating());
        knownRisk.setOptPerformance(ksObj.getPerformance());
        knownRisk.setOptPrivacyImpact(ksObj.getPrivacyImpact());
        knownRisk.setOptPVID(ksObj.getPVID());
        System.out.println("!!!!!NOW the OverrideItem PVID value is: " + ksObj.getPVID() + "******!!!!\n");
        boolean log = ksObj.getWriteLog();
        knownRisk.setOptWriteLog(Boolean.valueOf(log));
        try {
            item.setAction(this.gehActionStringToIntMap.get(obj.getAction()));
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        return item;
    }

    OverrideItem saveExtensionExclusion(PolicyExceptionUIObject obj) throws ConsoleException {
        OverrideItem item = new OverrideItem();
        SecurityRiskOverride srOver = new SecurityRiskOverride();
        item.setOptSecurityRiskOverride(srOver);
        ExtensionExclusionUIObject extObj = (ExtensionExclusionUIObject)obj.getRiskData();
        Extension extension = extObj.getExtension();
        if (PolicyExceptionUIObject.PLATFORM_LINUX.equals(obj.getPlatform())) {
            extension.setOptOSType("Linux");
        } else if (PolicyExceptionUIObject.PLATFORM_WIN.equals(obj.getPlatform())) {
            extension.setOptOSType("Windows");
        }
        srOver.setOptExtension(extension);
        srOver.setOptScanCategories(Integer.valueOf(extObj.getGehScanCategories()));
        try {
            item.setAction(this.gehActionStringToIntMap.get(obj.getAction()));
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        return item;
    }

    OverrideItem saveFileExclusion(PolicyExceptionUIObject obj) throws ConsoleException {
        OverrideItem item = new OverrideItem();
        try {
            SecurityRiskOverride srOver = new SecurityRiskOverride();
            item.setOptSecurityRiskOverride(srOver);
            FileOverride file = new FileOverride();
            srOver.setOptFileOverride(file);
            FileExclusionUIObject fileObj = (FileExclusionUIObject)obj.getRiskData();
            file.setFilePath(fileObj.getFileExclusion());
            file.setPrefixVariable(fileObj.getPrefix());
            String technoligies = obj.getProtectionTechnology();
            if (technoligies != null) {
                technoligies = technoligies.substring(technoligies.indexOf(45) + 1).trim();
                StringTokenizer token = new StringTokenizer(technoligies, ";");
                while (token.hasMoreTokens()) {
                    ProtectionTechnology ptTech = new ProtectionTechnology();
                    String scanType = token.nextToken();
                    if (scanType.equals(MSGRES.getString(GEH, "FileExclusionDialog.scantype.applicationcontrol"))) {
                        ptTech.setScanType(ProtectionTechnology.GEPT_ADC);
                        ptTech.setOptACExcludeChildProcesses(Boolean.valueOf(fileObj.isACExcludeChildProcessesApplicable()));
                    } else if (scanType.equals(MSGRES.getString(GEH, "FileExclusionDialog.scantype.sonar"))) {
                        ptTech.setScanType(ProtectionTechnology.GEPT_HPP);
                    } else if (scanType.equals(MSGRES.getString(GEH, "FileExclusionDialog.scantype.securityrisk"))) {
                        ptTech.setScanType(ProtectionTechnology.GEPT_SECURITY_RISK);
                        srOver.setOptScanCategories(Integer.valueOf(fileObj.getGehScanCategories()));
                    }
                    file.addProtectionTechnology(ptTech);
                }
            }
            item.setAction(this.gehActionStringToIntMap.get(obj.getAction()));
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        return item;
    }

    OverrideItem saveSysferFileControl(PolicyExceptionUIObject obj) throws ConsoleException {
        OverrideItem item = new OverrideItem();
        try {
            SysferExclusionFileControlOverride fileControl = new SysferExclusionFileControlOverride();
            item.setOptSysferExclusionFileControlOverride(fileControl);
            SysferFileControlExclusionUIObject fileControlObj = (SysferFileControlExclusionUIObject)obj.getRiskData();
            fileControl.setFileControl(fileControlObj.getFileControlExclusion());
            fileControl.setPrefixVariable(fileControlObj.getPrefix());
            item.setAction(this.gehActionStringToIntMap.get(obj.getAction()));
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        return item;
    }

    OverrideItem saveTrustedURLDomain(PolicyExceptionUIObject obj) throws ConsoleException {
        OverrideItem item = new OverrideItem();
        try {
            URLDomainOverride doOver = new URLDomainOverride();
            item.setOptURLDomainOverride(doOver);
            TrustedURLDomainUIObject domainObj = (TrustedURLDomainUIObject)obj.getRiskData();
            doOver.setOptProtocolValue(domainObj.getProtocol());
            doOver.setHost(domainObj.getHost());
            item.setAction(this.gehActionStringToIntMap.get(obj.getAction()));
        }
        catch (ValidationException ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        return item;
    }

    OverrideItem savePermittedApplication(PolicyExceptionUIObject obj) throws ConsoleException {
        OverrideItem item = new OverrideItem();
        try {
            TamperProtectionOverride tamper = new TamperProtectionOverride();
            item.setOptTamperProtectionOverride(tamper);
            PermittedApplication app = new PermittedApplication();
            tamper.setOptPermittedApplication(app);
            PermittedApplicationUIObject appObj = (PermittedApplicationUIObject)obj.getRiskData();
            app.setApplicationName(appObj.getApplication());
            app.setPrefixVariable(appObj.getPrefix());
            item.setAction(this.gehActionStringToIntMap.get(obj.getAction()));
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        return item;
    }

    OverrideItem saveApplicationEventFilter(PolicyExceptionUIObject obj) throws ConsoleException {
        OverrideItem item = new OverrideItem();
        try {
            TamperProtectionOverride tamper = new TamperProtectionOverride();
            item.setOptTamperProtectionOverride(tamper);
            ApplicationEventFilter app = new ApplicationEventFilter();
            tamper.setOptApplicationEventFilter(app);
            ApplicationEventFilterUIObject appObj = (ApplicationEventFilterUIObject)obj.getRiskData();
            app.setFilterName(appObj.getFilterName());
            app.setOptFilterDate(Long.valueOf(appObj.getFilterDate()));
            app.setAnyApplication(Boolean.valueOf(appObj.getAnyApplication()));
            if (!appObj.getAnyApplication()) {
                app.setOptIncludeApplication(Boolean.valueOf(appObj.getApplicationInclude()));
                app.setOptApplicationName(appObj.getApplicationName());
                app.setOptApplicationPrefixVariable(appObj.getPrefixApplication());
            }
            app.setAnyTarget(Boolean.valueOf(appObj.getAnyTarget()));
            if (!appObj.getAnyTarget()) {
                app.setOptIncludeTarget(Boolean.valueOf(appObj.getTargetInclude()));
                app.setOptTargetName(appObj.getTargetName());
                app.setOptTargetPrefixVariable(appObj.getPrefixTarget());
            }
            app.setAnyEvent(Boolean.valueOf(appObj.getAnyEvent()));
            if (!app.getAnyEvent().booleanValue()) {
                Vector<String> events = appObj.getEventList();
                for (int i = 0; i < events.size(); ++i) {
                    Event ev = new Event();
                    ev.setContent(events.get(i));
                    app.addEvent(ev);
                }
            }
            item.setAction(this.gehActionStringToIntMap.get(obj.getAction()));
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        return item;
    }

    OverrideItem saveDirectoryExclusion(PolicyExceptionUIObject obj) throws ConsoleException {
        OverrideItem item = new OverrideItem();
        try {
            SecurityRiskOverride srOver = new SecurityRiskOverride();
            item.setOptSecurityRiskOverride(srOver);
            DirectoryExclusionUIObject dirObj = (DirectoryExclusionUIObject)obj.getRiskData();
            DirectoryOverride directoryOverride = dirObj.getDirectoryOverride();
            if (PolicyExceptionUIObject.PLATFORM_LINUX.equals(obj.getPlatform())) {
                directoryOverride.setOptOSType("Linux");
            } else if (PolicyExceptionUIObject.PLATFORM_WIN.equals(obj.getPlatform())) {
                directoryOverride.setOptOSType("Windows");
            }
            srOver.setOptDirectoryOverride(directoryOverride);
            srOver.setOptScanCategories(Integer.valueOf(dirObj.getGehScanCategories()));
            item.setAction(this.gehActionStringToIntMap.get(obj.getAction()));
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        return item;
    }

    OverrideItem saveHppDetectedProcesses(PolicyExceptionUIObject obj) throws ConsoleException {
        OverrideItem item = new OverrideItem();
        DetectedProcessUIObject detectedProcess = (DetectedProcessUIObject)obj.getRiskData();
        HeuristicPolicyOverride polOver = new HeuristicPolicyOverride();
        item.setOptHeuristicPolicyOverride(polOver);
        DetectedProcesses detProcess = new DetectedProcesses();
        polOver.setOptDetectedProcesses(detProcess);
        detProcess.setChecksum(obj.getOverride());
        detProcess.setOptAltChecksum(detectedProcess.getAltChecksum());
        detProcess.setProcessName(detectedProcess.getDetectedProcess());
        detProcess.setOptCompany(detectedProcess.getCompany());
        detProcess.setOptPath(detectedProcess.getFilePath());
        detProcess.setOptFileSize(detectedProcess.getFileSize());
        detProcess.setOptOS(Integer.valueOf(detectedProcess.getOS()));
        try {
            item.setAction(this.gehActionStringToIntMap.get(obj.getAction()));
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        return item;
    }

    OverrideItem saveMacFileFolderExclusion(PolicyExceptionUIObject obj) throws ConsoleException {
        OverrideItem item = new OverrideItem();
        try {
            SecurityRiskOverride securityOver = new SecurityRiskOverride();
            item.setOptSecurityRiskOverride(securityOver);
            FileOverride file = new FileOverride();
            securityOver.setOptFileOverride(file);
            MacFileFolderExclusionUIObject fileObj = (MacFileFolderExclusionUIObject)obj.getRiskData();
            file.setFilePath(fileObj.getFileExclusion());
            file.setPrefixVariable(fileObj.getPrefix());
            file.setOptOS(FileOverride.MAC);
            if (fileObj.isSonarApplicable()) {
                ProtectionTechnology sonarProtectTech = new ProtectionTechnology();
                sonarProtectTech.setScanType(ProtectionTechnology.GEPT_HPP);
                file.addProtectionTechnology(sonarProtectTech);
            }
            if (fileObj.isSecurityRiskApplicable()) {
                ProtectionTechnology securityRiskTech = new ProtectionTechnology();
                securityRiskTech.setScanType(ProtectionTechnology.GEPT_SECURITY_RISK);
                file.addProtectionTechnology(securityRiskTech);
                securityOver.setOptScanCategories(Integer.valueOf(fileObj.getGehScanCategories()));
            }
            item.setAction(this.gehActionStringToIntMap.get(obj.getAction()));
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        return item;
    }

    OverrideItem saveHppProcessesToDetect(PolicyExceptionUIObject obj) throws ConsoleException {
        OverrideItem item = new OverrideItem();
        HeuristicPolicyOverride hpolOver = new HeuristicPolicyOverride();
        item.setOptHeuristicPolicyOverride(hpolOver);
        ProcessesToDetect detProcess = new ProcessesToDetect();
        hpolOver.setOptProcessesToDetect(detProcess);
        detProcess.setProcessName(obj.getOverride());
        try {
            item.setAction(this.gehActionStringToIntMap.get(obj.getAction()));
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        return item;
    }

    OverrideItem saveCertificateExclusion(PolicyExceptionUIObject obj) throws ConsoleException {
        OverrideItem item = new OverrideItem();
        try {
            CertificateOverride certOverride = new CertificateOverride();
            item.setOptCertificateOverride(certOverride);
            CertificateExclusionUIObject certObj = (CertificateExclusionUIObject)obj.getRiskData();
            certOverride.setThumbprint(certObj.getThumbprint());
            certOverride.setOptThumbprintSHA2(certObj.getThumbprintSHA2());
            certOverride.setOptIssuer(certObj.getIssuer());
            certOverride.setOptSigner(certObj.getSigner());
            item.setAction(this.gehActionStringToIntMap.get(obj.getAction()));
        }
        catch (Exception ex) {
            ConsoleLogger.log(ex);
        }
        return item;
    }

    OverrideItem saveNonPEFileExclusion(PolicyExceptionUIObject obj) throws ConsoleException {
        OverrideItem item = new OverrideItem();
        try {
            NonPEFileOverride nonPEFileOverride = new NonPEFileOverride();
            item.setOptNonPEFileOverride(nonPEFileOverride);
            NonPEFileExclusionUIObject nonPEFileExclusionUIObject = (NonPEFileExclusionUIObject)obj.getRiskData();
            nonPEFileOverride.setOptActorType(nonPEFileExclusionUIObject.getActorType());
            nonPEFileOverride.setOptActor(nonPEFileExclusionUIObject.getActor());
            nonPEFileOverride.setOptName(nonPEFileExclusionUIObject.getFileName());
            nonPEFileOverride.setOptCheckSum(nonPEFileExclusionUIObject.getFileFingerPrint());
            nonPEFileOverride.setOptDescription(nonPEFileExclusionUIObject.getFileDescription());
            nonPEFileOverride.setOptFileSize(nonPEFileExclusionUIObject.getFileSize());
            item.setAction(this.gehActionStringToIntMap.get(obj.getAction()));
        }
        catch (Exception ex) {
            ConsoleLogger.log(ex);
        }
        return item;
    }

    static int convertActionStringtoInt(String acString) {
        if (acString.equalsIgnoreCase(PolicyOverrideConstants.GEH_IGNORE)) {
            return 0;
        }
        if (acString.equalsIgnoreCase(PolicyOverrideConstants.GEH_LOGONLY)) {
            return 3;
        }
        if (acString.equalsIgnoreCase(PolicyOverrideConstants.GEH_BLOCK)) {
            return 1;
        }
        if (acString.equalsIgnoreCase(PolicyOverrideConstants.GEH_QUARANTINE)) {
            return 2;
        }
        if (acString.equalsIgnoreCase(PolicyOverrideConstants.GEH_REMOVE)) {
            return 4;
        }
        if (acString.equalsIgnoreCase(PolicyOverrideConstants.GEH_PROMPT)) {
            return 5;
        }
        return -1;
    }

    String convertActionSchemaStringtoVal(String acString) {
        if (acString.equalsIgnoreCase(PolicyOverrideConstants.GEH_IGNORE)) {
            return PolicyOverrideConstants.GEH_IGNORE;
        }
        if (acString.equalsIgnoreCase(PolicyOverrideConstants.GEH_LOGONLY)) {
            return PolicyOverrideConstants.GEH_LOGONLY;
        }
        if (acString.equalsIgnoreCase(PolicyOverrideConstants.GEH_BLOCK)) {
            return PolicyOverrideConstants.GEH_BLOCK;
        }
        if (acString.equalsIgnoreCase(PolicyOverrideConstants.GEH_QUARANTINE)) {
            return PolicyOverrideConstants.GEH_QUARANTINE;
        }
        if (acString.equalsIgnoreCase(PolicyOverrideConstants.GEH_REMOVE)) {
            return PolicyOverrideConstants.GEH_REMOVE;
        }
        if (acString.equalsIgnoreCase(PolicyOverrideConstants.GEH_PROMPT)) {
            return PolicyOverrideConstants.GEH_PROMPT;
        }
        return null;
    }

    public void setPolicyOverride(PolicyOverride policyOverride) throws ConsoleException {
        block2: {
            this.gehPolicyOverride = policyOverride;
            try {
                this.updateValues();
            }
            catch (ConsoleException ex) {
                LoggerUtilities.logException((Throwable)ex);
                if (!ex.needRelogin()) break block2;
                Manager.getFrame().showLoginPanel();
            }
        }
    }

    protected void updateValues() throws ConsoleException {
        if (null == this.gehPolicyOverride) {
            return;
        }
        this.isCloudExceptionPolicy = false;
        Vector sources = this.gehPolicyOverride.getSourceInfo();
        for (SourceInfo sourceInfo : sources) {
            if (sourceInfo.getOptexclusiveEdit() == null || !sourceInfo.getOptexclusiveEdit().booleanValue()) continue;
            this.isCloudExceptionPolicy = true;
            break;
        }
        this.isNotCloudEnrolledOrCloudPolicy = !this.isCloudEnrolled || this.isCloudExceptionPolicy;
        this.isNotCloudEnrolledOrSepPolicy = !this.isCloudEnrolled || !this.isCloudExceptionPolicy;
        int noOfRisks = this.gehPolicyOverride.getOverrideItemCount();
        for (int i = 0; i < noOfRisks; ++i) {
            OverrideItem overItem = this.gehPolicyOverride.getOverrideItem(i);
            SecurityRiskOverride secRisk = null;
            HeuristicPolicyOverride heRisk = null;
            TamperProtectionOverride tamper = null;
            URLDomainOverride domain = null;
            SysferExclusionFileControlOverride control = null;
            DnsHostFileOverride dnsHostFileOverride = null;
            CertificateOverride certificateOverride = null;
            NonPEFileOverride nonPEFileOverride = null;
            if (this.isNotCloudEnrolledOrCloudPolicy) {
                domain = overItem.getOptURLDomainOverride();
                certificateOverride = overItem.getOptCertificateOverride();
            }
            if (this.isNotCloudEnrolledOrSepPolicy) {
                tamper = overItem.getOptTamperProtectionOverride();
                dnsHostFileOverride = overItem.getOptDnsHostFileOverride();
                control = overItem.getOptSysferExclusionFileControlOverride();
            }
            heRisk = overItem.getOptHeuristicPolicyOverride();
            secRisk = overItem.getOptSecurityRiskOverride();
            nonPEFileOverride = overItem.getOptNonPEFileOverride();
            if (secRisk != null) {
                this.updateSecurityRisk(overItem);
            }
            if (heRisk != null) {
                this.updateHeuristicPolicyOverride(overItem);
            }
            if (tamper != null) {
                this.updateTamperProtectionOverride(overItem);
            }
            if (domain != null) {
                this.updateURLDomainOverride(overItem);
            }
            if (control != null) {
                this.updateSysferFileControlOverride(overItem);
            }
            if (dnsHostFileOverride != null) {
                this.updateDnsHostFileChangeExclusion(overItem, dnsHostFileOverride);
            }
            if (certificateOverride != null) {
                this.updateCertificateOverride(overItem);
            }
            if (nonPEFileOverride == null) continue;
            this.updateNonPEFileOverride(overItem);
        }
        if (this.gehGroupTable.getRowCount() > 0) {
            this.gehGroupTable.setRowSelectionInterval(0, 0);
        }
    }

    void updateSecurityRisk(OverrideItem overItem) throws ConsoleException {
        SecurityRiskOverride sRisk = overItem.getOptSecurityRiskOverride();
        if (sRisk != null) {
            KnownRiskOverrride knRisk;
            Integer scanCategories = sRisk.getOptScanCategories();
            if (scanCategories == null) {
                scanCategories = sRisk.getDefScanCategories();
            }
            if ((knRisk = sRisk.getOptKnownRiskOverrride()) != null && this.isNotCloudEnrolledOrSepPolicy) {
                this.updateKnownSecurityRisk(overItem, knRisk);
                return;
            }
            FileOverride filOverride = sRisk.getOptFileOverride();
            if (filOverride != null) {
                if (FileOverride.MAC.equals(filOverride.getOptOS())) {
                    this.updateMacFileFolderExclusion(overItem, filOverride);
                    return;
                }
                this.updateFileExclusion(overItem, filOverride, scanCategories);
                return;
            }
            DirectoryOverride dirOverride = sRisk.getOptDirectoryOverride();
            if (dirOverride != null) {
                this.updateDirectoryExclusion(overItem, dirOverride, scanCategories);
                return;
            }
            Extension excl = sRisk.getOptExtension();
            if (excl != null && this.isNotCloudEnrolledOrSepPolicy) {
                this.updateExtensionExclusion(overItem, excl, scanCategories);
                return;
            }
        }
    }

    void updateTamperProtectionOverride(OverrideItem overItem) throws ConsoleException {
        TamperProtectionOverride tamper = overItem.getOptTamperProtectionOverride();
        PermittedApplication app = tamper.getOptPermittedApplication();
        if (app != null) {
            this.updatePermittedApplication(overItem, app);
            return;
        }
        ApplicationEventFilter appEvent = tamper.getOptApplicationEventFilter();
        if (appEvent != null) {
            this.updateApplicationEventFilter(overItem, appEvent);
            return;
        }
    }

    void updateURLDomainOverride(OverrideItem overItem) throws ConsoleException {
        URLDomainOverride domain = overItem.getOptURLDomainOverride();
        TrustedURLDomainUIObject domObj = new TrustedURLDomainUIObject();
        try {
            String protocol = domain.getOptProtocolValue();
            String host = domain.getHost();
            domObj.setProtocol(protocol);
            domObj.setHost(host);
            String actionV = this.gehActionIntToStringMap.get(overItem.getAction());
            String domainName = domObj.getURLDomainName();
            PolicyExceptionUIObject polObj = new PolicyExceptionUIObject(MSGRES.getString(GEH, "OverridePanel.risktype.domainExclusion"), domainName, actionV, domObj, overItem.getOptSource());
            this.gehGroupModel.addRow(polObj);
            this.gehAddedTrustedUrlDomainList.add(domainName.toUpperCase());
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    void updateExtensionExclusion(OverrideItem overItem, Extension ext, int scanCategories) throws ConsoleException {
        ExtensionExclusionUIObject exObj = new ExtensionExclusionUIObject(ext, scanCategories);
        try {
            String actionV = this.gehActionIntToStringMap.get(overItem.getAction());
            PolicyExceptionUIObject poObj = new PolicyExceptionUIObject(MSGRES.getString(GEH, "OverridePanel.risktype.extensionExclusion"), ext.getContent(), actionV, exObj, overItem.getOptSource());
            if ("Linux".equals(ext.getOptOSType())) {
                poObj.setPlatform(PolicyExceptionUIObject.PLATFORM_LINUX);
                this.linuxGehAddedExtensionExclusionList.add(ext.getContent());
            } else if ("Windows".equals(ext.getOptOSType()) || ext.getOptOSType() == null || ext.getOptOSType().length() <= 0) {
                poObj.setPlatform(PolicyExceptionUIObject.PLATFORM_WIN);
                this.gehAddedExtensionExclusionList.add(ext.getContent());
            }
            this.gehGroupModel.addRow(poObj);
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    void updateDnsHostFileChangeExclusion(OverrideItem oveItem, DnsHostFileOverride dnsHostFileOverride) throws ConsoleException {
        DnsHostFileChangeExclusionUIObject dnsObj = new DnsHostFileChangeExclusionUIObject();
        DetectedProcessUIObject detObj = new DetectedProcessUIObject();
        DetectedProcesses detProcess = dnsHostFileOverride.getOptDetectedProcesses();
        detObj.setChecksum(detProcess.getChecksum());
        if (detProcess.getProcessName() != null) {
            detObj.setDetectedProcess(detProcess.getProcessName());
        }
        if (detProcess.getProcessName() != null) {
            detObj.setProductName(detProcess.getProcessName());
        }
        if (detProcess.getOptPath() != null) {
            detObj.setFilePath(detProcess.getOptPath());
        }
        if (detProcess.getOptCompany() != null) {
            detObj.setCompany(detProcess.getOptCompany());
        }
        if (detProcess.getOptFileSize() != null) {
            detObj.setFileSize(detProcess.getOptFileSize());
        }
        if (detProcess.getOptAltChecksum() != null) {
            detObj.setAltChecksum(detProcess.getOptAltChecksum());
        }
        String actionV = this.gehActionIntToStringMap.get(oveItem.getAction());
        detObj.setAction(actionV);
        dnsObj.setAction(actionV);
        dnsObj.setDetectedProcessUIObject(detObj);
        try {
            PolicyExceptionUIObject polObj = new PolicyExceptionUIObject(MSGRES.getString(GEH, "OverridePanel.risktype.dnsHostFileChangeExclusion"), PolicyExceptionUIObject.PLATFORM_WIN, detObj.getChecksum(), actionV, dnsObj, oveItem.getOptSource());
            this.gehGroupModel.addRow(polObj);
            this.gehAddedDnsAndHostFileChangeExclusionList.add(detObj.getChecksum());
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    void updateDirectoryExclusion(OverrideItem overItem, DirectoryOverride dir, int scanCategories) throws ConsoleException {
        DirectoryExclusionUIObject dirObj = new DirectoryExclusionUIObject(dir, scanCategories);
        try {
            int scanType;
            String actionV = this.gehActionIntToStringMap.get(overItem.getAction());
            Object dirPath = dir.getOptDirectoryPath();
            String prefix = dir.getPrefixVariable();
            int n = scanType = dir.getOptScanType() == null ? DirectoryExclusionUIObject.SECURITY_RISK : dir.getOptScanType();
            if (!prefix.equalsIgnoreCase(ConstantValue.getDirKeysByIndex((int)0))) {
                dirPath = dirPath != null ? "%" + prefix + "%" + (String)dirPath : "%" + prefix + "%";
            }
            PolicyExceptionUIObject polObj = new PolicyExceptionUIObject(this.getDirScanType(scanType), (String)dirPath, actionV, dirObj, overItem.getOptSource());
            if ("Windows".equals(dir.getOptOSType()) || dir.getOptOSType() == null || dir.getOptOSType().length() <= 0) {
                if (scanType == DirectoryExclusionUIObject.ADC || !this.isCloudEnrolled || this.isCloudExceptionPolicy) {
                    polObj.setPlatform(PolicyExceptionUIObject.PLATFORM_WIN);
                    this.addToDirectoryExclusionMap(scanType, (String)dirPath);
                    this.gehGroupModel.addRow(polObj);
                }
            } else {
                if ("Linux".equals(dir.getOptOSType())) {
                    polObj.setPlatform(PolicyExceptionUIObject.PLATFORM_LINUX);
                    this.addToLinuxDirectoryExclusionMap(scanType, DirectoryExclusionDialog.getProfileFormatLinuxDirectory((String)dirPath));
                }
                this.gehGroupModel.addRow(polObj);
            }
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    private void updateCertificateOverride(OverrideItem overrideItem) throws ConsoleException {
        CertificateOverride certificateOverride = overrideItem.getOptCertificateOverride();
        CertificateExclusionUIObject certObj = new CertificateExclusionUIObject();
        try {
            String issuer = certificateOverride.getOptIssuer();
            String signer = certificateOverride.getOptSigner();
            String thumbprint = certificateOverride.getThumbprint();
            String thumbprintSHA2 = certificateOverride.getOptThumbprintSHA2();
            certObj.setIssuer(issuer);
            certObj.setSigner(signer);
            certObj.setThumbprint(thumbprint);
            certObj.setThumbprintSHA2(thumbprintSHA2);
            String actionV = this.gehActionIntToStringMap.get(overrideItem.getAction());
            PolicyExceptionUIObject pObj = new PolicyExceptionUIObject(MSGRES.getString(GEH, "OverridePanel.risktype.certificateExclusion"), null, thumbprint, actionV, certObj, overrideItem.getOptSource(), certObj.getDisplayName());
            this.gehGroupModel.addRow(pObj);
            this.gehAddedCertificateExclusionMap.put(thumbprint, thumbprintSHA2);
        }
        catch (Exception ex) {
            ConsoleLogger.log(ex);
        }
    }

    private void updateNonPEFileOverride(OverrideItem overrideItem) throws ConsoleException {
        NonPEFileOverride nonPEFileOverride = overrideItem.getOptNonPEFileOverride();
        NonPEFileExclusionUIObject uiObject = new NonPEFileExclusionUIObject(nonPEFileOverride);
        uiObject.setAction(overrideItem.getAction());
        try {
            String actionV = this.gehActionIntToStringMap.get(overrideItem.getAction());
            String override = uiObject.getOverride();
            uiObject.setAction(overrideItem.getAction());
            PolicyExceptionUIObject pObj = new PolicyExceptionUIObject(MSGRES.getString(GEH, "OverridePanel.risktype.nonPEFileException"), override, actionV, uiObject, overrideItem.getOptSource());
            this.gehGroupModel.addRow(pObj);
            this.gehNonPEFileExclusionList.add(override);
        }
        catch (Exception ex) {
            ConsoleLogger.log(ex);
        }
    }

    private void addToDirectoryExclusionMap(int scanType, String dirPath) {
        String scanTypeStr = String.valueOf(scanType);
        if (!this.gehAddedDirectoryExclusionMap.containsKey(scanTypeStr)) {
            ArrayList<String> strList = new ArrayList<String>();
            strList.add(dirPath);
            this.gehAddedDirectoryExclusionMap.put(scanTypeStr, strList);
        } else {
            ArrayList<String> dirList = this.gehAddedDirectoryExclusionMap.get(scanTypeStr);
            dirList.add(dirPath);
        }
    }

    private void addToLinuxDirectoryExclusionMap(int scanType, String dirPath) {
        String scanTypeStr = String.valueOf(scanType);
        if (!this.gehAddedLinuxDirectoryExclusionMap.containsKey(scanTypeStr)) {
            ArrayList<String> strList = new ArrayList<String>();
            strList.add(dirPath);
            this.gehAddedLinuxDirectoryExclusionMap.put(scanTypeStr, strList);
        } else {
            ArrayList<String> dirList = this.gehAddedLinuxDirectoryExclusionMap.get(scanTypeStr);
            dirList.add(dirPath);
        }
    }

    void updateFileExclusion(OverrideItem overItem, FileOverride file, int scanCategories) throws ConsoleException {
        FileExclusionUIObject dObj = new FileExclusionUIObject(file, scanCategories);
        try {
            String actionV = this.gehActionIntToStringMap.get(overItem.getAction());
            Object filePath = file.getFilePath();
            String prefix = file.getPrefixVariable();
            if (!prefix.equalsIgnoreCase(ConstantValue.getDirKeysByIndex((int)0))) {
                filePath = "%" + prefix + "%" + (String)filePath;
            }
            StringBuilder applicableTechnolies = new StringBuilder();
            applicableTechnolies.append(MSGRES.getString(GEH, "FileExclusionDialog.heading.label"));
            applicableTechnolies.append(" - ");
            int prTechCount = file.getProtectionTechnologyCount();
            if (prTechCount > 0) {
                for (int i = 0; i < prTechCount; ++i) {
                    ProtectionTechnology prTech = file.getProtectionTechnology(i);
                    if (prTech.getScanType().equals(ProtectionTechnology.GEPT_ADC)) {
                        if (!this.isNotCloudEnrolledOrSepPolicy) continue;
                        applicableTechnolies.append(MSGRES.getString(GEH, "FileExclusionDialog.scantype.applicationcontrol"));
                        applicableTechnolies.append(";");
                        if (prTech.getOptACExcludeChildProcesses() == null) continue;
                        dObj.setACExcludeChildProcessesApplicable(prTech.getOptACExcludeChildProcesses());
                        continue;
                    }
                    if (prTech.getScanType().equals(ProtectionTechnology.GEPT_SECURITY_RISK)) {
                        if (!this.isNotCloudEnrolledOrCloudPolicy) continue;
                        applicableTechnolies.append(MSGRES.getString(GEH, "FileExclusionDialog.scantype.securityrisk"));
                        applicableTechnolies.append(";");
                        continue;
                    }
                    if (!prTech.getScanType().equals(ProtectionTechnology.GEPT_HPP) || !this.isNotCloudEnrolledOrCloudPolicy) continue;
                    applicableTechnolies.append(MSGRES.getString(GEH, "FileExclusionDialog.scantype.sonar"));
                    applicableTechnolies.append(";");
                }
            } else if (this.isNotCloudEnrolledOrCloudPolicy) {
                applicableTechnolies.append(MSGRES.getString(GEH, "FileExclusionDialog.scantype.securityrisk"));
                applicableTechnolies.append(";");
            }
            PolicyExceptionUIObject prObj = new PolicyExceptionUIObject(applicableTechnolies.toString(), (String)filePath, actionV, dObj, overItem.getOptSource());
            this.gehGroupModel.addRow(prObj);
            this.gehAddedFileExclusionList.add((String)filePath);
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    void updateSysferFileControlOverride(OverrideItem ovItem) throws ConsoleException {
        SysferExclusionFileControlOverride deControl = ovItem.getOptSysferExclusionFileControlOverride();
        SysferFileControlExclusionUIObject deObj = new SysferFileControlExclusionUIObject();
        deObj.setFileControlExclusion(deControl.getFileControl());
        deObj.setPrefix(deControl.getPrefixVariable());
        try {
            String actionV = this.gehActionIntToStringMap.get(ovItem.getAction());
            Object fileControl = deControl.getFileControl();
            String prefix = deControl.getPrefixVariable();
            if (!prefix.equalsIgnoreCase(ConstantValue.getDirKeysByIndex((int)0))) {
                fileControl = "%" + prefix + "%" + (String)fileControl;
            }
            PolicyExceptionUIObject poObj = new PolicyExceptionUIObject(MSGRES.getString(GEH, "OverridePanel.risktype.fileControlExclusion"), (String)fileControl, actionV, deObj, ovItem.getOptSource());
            this.gehGroupModel.addRow(poObj);
            this.gehAddedSysferFileControlList.add((String)fileControl);
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    void updatePermittedApplication(OverrideItem overrideItem, PermittedApplication app) throws ConsoleException {
        PermittedApplicationUIObject deObj = new PermittedApplicationUIObject();
        deObj.setApplication(app.getApplicationName());
        deObj.setPrefix(app.getPrefixVariable());
        try {
            String actionV = this.gehActionIntToStringMap.get(overrideItem.getAction());
            Object filePath = app.getApplicationName();
            String prefix = app.getPrefixVariable();
            if (!prefix.equalsIgnoreCase(ConstantValue.getDirKeysByIndex((int)0))) {
                filePath = "%" + prefix + "%" + (String)filePath;
            }
            PolicyExceptionUIObject poObj = new PolicyExceptionUIObject(MSGRES.getString(GEH, "OverridePanel.risktype.tamperProtection"), (String)filePath, actionV, deObj, overrideItem.getOptSource());
            this.gehGroupModel.addRow(poObj);
            this.gehAddedPermittedApplicationList.add((String)filePath);
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    void updateApplicationEventFilter(OverrideItem ovItem, ApplicationEventFilter app) throws ConsoleException {
        ApplicationEventFilterUIObject deObj = new ApplicationEventFilterUIObject();
        deObj.setFilterName(app.getFilterName());
        Long dt = app.getOptFilterDate();
        if (dt != null) {
            deObj.setFilterDate(dt);
        } else {
            deObj.setFilterDate(System.currentTimeMillis());
        }
        deObj.setAnyApplication(app.getAnyApplication());
        if (!app.getAnyApplication().booleanValue()) {
            deObj.setApplicationName(app.getOptApplicationName());
            deObj.setPrefixApplication(app.getOptApplicationPrefixVariable());
            deObj.setApplicationInclude(app.getOptIncludeApplication());
        }
        deObj.setAnyTarget(app.getAnyTarget());
        if (!app.getAnyTarget().booleanValue()) {
            deObj.setTargetName(app.getOptTargetName());
            deObj.setPrefixTarget(app.getOptTargetPrefixVariable());
            deObj.setTargetInclude(app.getOptIncludeTarget());
        }
        deObj.setAnyEvent(app.getAnyEvent());
        if (!app.getAnyEvent().booleanValue()) {
            Vector<String> ev = new Vector<String>();
            for (int i = 0; i < app.getEventCount(); ++i) {
                ev.add(app.getEvent(i).getContent());
            }
            deObj.setEventList(ev);
        }
        try {
            String actionV = this.gehActionIntToStringMap.get(ovItem.getAction());
            PolicyExceptionUIObject poObj = new PolicyExceptionUIObject(MSGRES.getString(GEH, "OverridePanel.risktype.tamperProtection"), app.getFilterName(), actionV, deObj, ovItem.getOptSource());
            this.gehGroupModel.addRow(poObj);
            this.gehAddedApplicationEventFilterMap.add(app.getFilterName());
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    void updateKnownSecurityRisk(OverrideItem overrideItem, KnownRiskOverrride knownRisk) {
        KnownSecurityUIObject knObj = new KnownSecurityUIObject();
        knObj.setSecurityRisk(knownRisk.getSecurityRiskName());
        if (knownRisk.getOptOverallRating() != null) {
            knObj.setOverallRating(knownRisk.getOptOverallRating());
        }
        if (knownRisk.getOptPerformance() != null) {
            knObj.setPerformance(knownRisk.getOptPerformance());
        }
        if (knownRisk.getOptPrivacyImpact() != null) {
            knObj.setPrivacyImpact(knownRisk.getOptPrivacyImpact());
        }
        knObj.setPVID(knownRisk.getOptPVID());
        String actionV = this.gehActionIntToStringMap.get(overrideItem.getAction());
        PolicyExceptionUIObject poObj = new PolicyExceptionUIObject(MSGRES.getString(GEH, "OverridePanel.risktype.knownRisk"), knownRisk.getSecurityRiskName(), actionV, knObj, overrideItem.getOptSource());
        this.gehGroupModel.addRow(poObj);
        this.gehAddedKnownSecurityList.add(knownRisk.getSecurityRiskName());
    }

    void updateHeuristicPolicyOverride(OverrideItem ovItem) throws ConsoleException {
        HeuristicPolicyOverride heRisk = ovItem.getOptHeuristicPolicyOverride();
        if (heRisk == null) {
            return;
        }
        DetectedProcesses detectedProcess = heRisk.getOptDetectedProcesses();
        ProcessesToDetect prProcess = heRisk.getOptProcessesToDetect();
        if (detectedProcess != null && this.isNotCloudEnrolledOrCloudPolicy) {
            this.updateDetectedProcesses(ovItem, detectedProcess);
        }
        if (prProcess != null) {
            this.updateProcessesToDetect(ovItem, prProcess);
        }
    }

    void updateDetectedProcesses(OverrideItem overrideItem, DetectedProcesses deProcess) throws ConsoleException {
        DetectedProcessUIObject detectedObj = new DetectedProcessUIObject();
        detectedObj.setDetectedProcess(deProcess.getProcessName());
        detectedObj.setChecksum(deProcess.getChecksum());
        if (deProcess.getProcessName() != null) {
            detectedObj.setDetectedProcess(deProcess.getProcessName());
        }
        if (deProcess.getProcessName() != null) {
            detectedObj.setProductName(deProcess.getProcessName());
        }
        if (deProcess.getOptPath() != null) {
            detectedObj.setFilePath(deProcess.getOptPath());
        }
        if (deProcess.getOptCompany() != null) {
            detectedObj.setCompany(deProcess.getOptCompany());
        }
        if (deProcess.getOptFileSize() != null) {
            detectedObj.setFileSize(deProcess.getOptFileSize());
        }
        if (deProcess.getOptAltChecksum() != null) {
            detectedObj.setAltChecksum(deProcess.getOptAltChecksum());
        }
        if (deProcess.getOptOS() != null) {
            detectedObj.setOS(deProcess.getOptOS());
        }
        try {
            String actionV = this.gehActionIntToStringMap.get(overrideItem.getAction());
            PolicyExceptionUIObject poObj = new PolicyExceptionUIObject(MessageResources.getInstance().getString(GEH, "OverridePanel.risktype.hppDetectedProcesses"), detectedObj.getOSPlatFormString(), deProcess.getChecksum(), actionV, detectedObj, overrideItem.getOptSource());
            this.gehGroupModel.addRow(poObj);
            this.gehAddedHppDetectedProcessList.add(deProcess.getChecksum());
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    void updateProcessesToDetect(OverrideItem ovItem, ProcessesToDetect prProcess) throws ConsoleException {
        ProcessesToDetectUIObject deObj = new ProcessesToDetectUIObject();
        deObj.setDetectedProcess(prProcess.getProcessName());
        try {
            String actionV = this.gehActionIntToStringMap.get(ovItem.getAction());
            PolicyExceptionUIObject pObj = new PolicyExceptionUIObject(MSGRES.getString(GEH, "OverridePanel.risktype.hppProcessesToDetect"), prProcess.getProcessName(), actionV, deObj, ovItem.getOptSource());
            this.gehGroupModel.addRow(pObj);
            this.gehAddedHppProcessToDetectList.add(prProcess.getProcessName());
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    void updateMacFileFolderExclusion(OverrideItem oItem, FileOverride file) throws ConsoleException {
        MacFileFolderExclusionUIObject dObj = new MacFileFolderExclusionUIObject();
        dObj.setFileExclusion(file.getFilePath());
        dObj.setPrefix(file.getPrefixVariable());
        for (ProtectionTechnology pt : file.getProtectionTechnology()) {
            if (pt.getScanType() != null && pt.getScanType().equals(ProtectionTechnology.GEPT_HPP)) {
                dObj.setSonarApplicable(true);
            }
            if (pt.getScanType() == null || !pt.getScanType().equals(ProtectionTechnology.GEPT_SECURITY_RISK)) continue;
            dObj.setSecurityRiskApplicable(true);
            if (oItem.getOptSecurityRiskOverride() == null) continue;
            dObj.setGehScanCategories(oItem.getOptSecurityRiskOverride().getOptScanCategories());
        }
        try {
            String actionV = this.gehActionIntToStringMap.get(oItem.getAction());
            Object filePath = file.getFilePath();
            String prefix = file.getPrefixVariable();
            if (!prefix.equalsIgnoreCase(ConstantValue.getMacDirKeysByIndex((int)0))) {
                filePath = "%" + prefix + "%" + (String)filePath;
            }
            String protectTech = this.getMacProtectTechString(dObj);
            PolicyExceptionUIObject pObj = new PolicyExceptionUIObject(protectTech, PolicyExceptionUIObject.PLATFORM_MAC, (String)filePath, actionV, dObj, oItem.getOptSource());
            this.gehGroupModel.addRow(pObj);
            this.macAddedFileFolderExclusionList.add((String)filePath);
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    private boolean isEnableDeleteAction() {
        if (this.isReadonly || !this.gehGroupTable.isEnabled()) {
            return false;
        }
        if (this.isCloudExceptionPolicy) {
            return false;
        }
        return this.gehGroupTable.getSelectedRowCount() > 0;
    }

    private boolean isEnableEditAction() {
        if (this.isReadonly || !this.gehGroupTable.isEnabled()) {
            return false;
        }
        if (this.isCloudExceptionPolicy) {
            return false;
        }
        if (1 != this.gehGroupTable.getSelectedRowCount()) {
            return false;
        }
        int row = this.gehGroupTable.getSelectedRow();
        PolicyExceptionUIObject obj = (PolicyExceptionUIObject)this.gehGroupModel.getRow(row);
        return obj.getRiskData().getRiskType() != 0;
    }

    boolean isEnableCopyAction() {
        if (this.isCloudExceptionPolicy) {
            return false;
        }
        if (this.gehGroupTable.getSelectedRowCount() <= 0) {
            return false;
        }
        boolean hasNotCopyableKnownRisk = Arrays.stream(this.gehGroupTable.getSelectedRows()).mapToObj(row -> (PolicyExceptionUIObject)this.gehGroupModel.getRow(row)).filter(obj -> obj.getRiskData().getRiskType() == 0).map(PolicyExceptionUIObject::getRiskData).anyMatch(ksObj -> !ExceptionPolicyUtility.isValidKnownRisk((String)((KnownSecurityUIObject)ksObj).getPVID(), (String)((KnownSecurityUIObject)ksObj).getSecurityRisk()));
        if (hasNotCopyableKnownRisk) {
            ConsoleLogger.log("OverridePanel >> allowCopy: Known Risks are not allowed for copy!");
            return false;
        }
        return true;
    }

    private boolean isEnablePasteAction() {
        if (this.isReadonly || !this.gehGroupTable.isEnabled()) {
            return false;
        }
        if (this.isCloudExceptionPolicy) {
            return false;
        }
        return PolicyHandler.hasCopiedObjects(PolicyExceptionUIObject.class);
    }

    private String getDirScanType(int scanType) {
        String riskTypeStr = MSGRES.getString(GEH, "OverridePanel.risktype.dirSecurityRiskExclusion");
        if (scanType == DirectoryExclusionUIObject.SECURITY_RISK) {
            riskTypeStr = MSGRES.getString(GEH, "OverridePanel.risktype.dirSecurityRiskExclusion");
        } else if (scanType == DirectoryExclusionUIObject.TRUSCAN) {
            riskTypeStr = MSGRES.getString(GEH, "OverridePanel.risktype.dirTruscanExclusion");
        } else if (scanType == DirectoryExclusionUIObject.ALL) {
            riskTypeStr = MSGRES.getString(GEH, "OverridePanel.risktype.dirAllExclusion");
        } else if (scanType == DirectoryExclusionUIObject.ADC) {
            riskTypeStr = MSGRES.getString(GEH, "OverridePanel.risktype.adcExclusion");
        }
        return riskTypeStr;
    }

    String getApplicableTechnologies(FileExclusionUIObject exclusionObject) {
        StringBuilder applicableTechnologies = new StringBuilder();
        applicableTechnologies.append(MSGRES.getString(GEH, "FileExclusionDialog.heading.label"));
        applicableTechnologies.append(" - ");
        if (this.isNotCloudEnrolledOrSepPolicy && exclusionObject.isAdcApplicable()) {
            applicableTechnologies.append(MSGRES.getString(GEH, "FileExclusionDialog.scantype.applicationcontrol"));
            applicableTechnologies.append(";");
        }
        if (this.isNotCloudEnrolledOrCloudPolicy) {
            if (exclusionObject.isSonarApplicable()) {
                applicableTechnologies.append(MSGRES.getString(GEH, "FileExclusionDialog.scantype.sonar"));
                applicableTechnologies.append(";");
            }
            if (exclusionObject.isSecurityRiskApplicable()) {
                applicableTechnologies.append(MSGRES.getString(GEH, "FileExclusionDialog.scantype.securityrisk"));
                applicableTechnologies.append(";");
            }
        }
        return applicableTechnologies.toString();
    }

    private class OverrideTableCellMenu
    extends JPopupMenu {
        private static final long serialVersionUID = 1L;

        public OverrideTableCellMenu() {
            this.initialize();
        }

        private void initialize() {
            OverridePanel.this.add.removeAll();
            OverridePanel.this.prepareAndSetPopupMenuItems(OverridePanel.this.add);
            if (OverridePanel.this.deleteAction == null) {
                OverridePanel.this.deleteAction = new AbstractAction(UIText.get(769)){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void actionPerformed(ActionEvent e2) {
                        try {
                            OverridePanel.this.deleteAction();
                        }
                        catch (Exception e1) {
                            LoggerUtilities.logException((Throwable)e1);
                        }
                    }
                };
            }
            if (OverridePanel.this.editAction == null) {
                OverridePanel.this.editAction = new AbstractAction(UIText.get(1024)){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void actionPerformed(ActionEvent e1) {
                        OverridePanel.this.editAction();
                    }
                };
            }
            if (OverridePanel.this.copyAction == null) {
                OverridePanel.this.copyAction = new AbstractAction(UIText.get(520)){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        OverridePanel.this.copyRules();
                        OverridePanel.this.pasteAction.setEnabled(OverridePanel.this.isEnablePasteAction());
                    }
                };
            }
            if (OverridePanel.this.pasteAction == null) {
                OverridePanel.this.pasteAction = new AbstractAction(UIText.get(3840)){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        OverridePanel.this.pasteObjects();
                    }
                };
            }
            OverridePanel.this.deleteAction.setEnabled(OverridePanel.this.isEnableDeleteAction());
            OverridePanel.this.editAction.setEnabled(OverridePanel.this.isEnableEditAction());
            OverridePanel.this.copyAction.setEnabled(OverridePanel.this.isEnableCopyAction());
            OverridePanel.this.pasteAction.setEnabled(OverridePanel.this.isEnablePasteAction());
            this.add(OverridePanel.this.add);
            this.add(OverridePanel.this.editAction);
            this.add(OverridePanel.this.deleteAction);
            this.add(OverridePanel.this.copyAction);
            this.add(OverridePanel.this.pasteAction);
        }
    }

    private class OverrideTableCellListener
    extends MouseAdapter {
        private OverrideTableCellListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e1) {
            int row = OverridePanel.this.gehGroupTable.rowAtPoint(e1.getPoint());
            if (row < 0) {
                OverridePanel.this.gehGroupTable.clearSelection();
            }
            if (OverridePanel.this.isEnableEditAction() && (e1.getModifiers() & 0x10) != 0 && e1.getClickCount() == 2) {
                OverridePanel.this.editAction();
            } else if (OverridePanel.this.isNotCloudEnrolledOrSepPolicy && (e1.getModifiers() & 4) != 0) {
                OverrideTableCellMenu popupMenu = new OverrideTableCellMenu();
                popupMenu.show(e1.getComponent(), e1.getX(), e1.getY());
            }
        }
    }

    private class OverrideComboBoxEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    TableCellRenderer {
        private static final long serialVersionUID = 1L;
        JComboBox<Object> actionComboBox = new JComboBox();
        JLabel actionLbl = new JLabel();
        String[] actionStringsRisk = new String[]{MSGRES.getString("com.sygate.scm.console.ui.policy.override.override", "PolicyOverride.ignore"), MSGRES.getString("com.sygate.scm.console.ui.policy.override.override", "PolicyOverride.logonly")};
        String[] actionStringsIgnBlQuLog = new String[]{MSGRES.getString("com.sygate.scm.console.ui.policy.override.override", "PolicyOverride.ignore"), MSGRES.getString("com.sygate.scm.console.ui.policy.override.override", "PolicyOverride.block"), MSGRES.getString("com.sygate.scm.console.ui.policy.override.override", "PolicyOverride.quarantine"), MSGRES.getString("com.sygate.scm.console.ui.policy.override.override", "PolicyOverride.logonly"), MSGRES.getString("com.sygate.scm.console.ui.policy.override.override", "PolicyOverride.remove")};
        String[] actionStringsHPP = new String[]{MSGRES.getString("com.sygate.scm.console.ui.policy.override.override", "PolicyOverride.ignore")};
        String[] actionStringsRiskIgnore = new String[]{MSGRES.getString("com.sygate.scm.console.ui.policy.override.override", "PolicyOverride.ignore")};
        String[] actionStringsRiskLogonly = new String[]{MSGRES.getString("com.sygate.scm.console.ui.policy.override.override", "PolicyOverride.logonly")};
        String[] actionStringsDomainIgnore = new String[]{MSGRES.getString("com.sygate.scm.console.ui.policy.override.override", "PolicyOverride.ignore")};

        public OverrideComboBoxEditor() {
            PopupMenuListener pml = new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                    OverrideComboBoxEditor.this.stopCellEditing();
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                }
            };
            this.actionComboBox.addPopupMenuListener(pml);
            this.actionComboBox.setBorder(null);
            this.actionComboBox.addItemListener(e -> OverridePanel.this.modifyChangeablePanel());
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.actionComboBox.removeAllItems();
            PolicyExceptionUIObject rowData = (PolicyExceptionUIObject)OverridePanel.this.gehGroupModel.getRow(row);
            ExceptionUIObject rObj = rowData.getRiskData();
            int riskType = rObj.getRiskType();
            switch (riskType) {
                case 0: {
                    this.addItemInComboBox(this.actionStringsRisk);
                    this.actionComboBox.setSelectedItem(rowData.getAction());
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 9: 
                case 10: {
                    this.actionLbl.setText(this.actionStringsRiskIgnore[0]);
                    return this.actionLbl;
                }
                case 1: {
                    if (PolicyExceptionUIObject.PLATFORM_WIN.equals(rowData.getPlatform())) {
                        this.addItemInComboBox(this.actionStringsIgnBlQuLog);
                        this.actionComboBox.setSelectedItem(rowData.getAction());
                        break;
                    }
                    this.actionLbl.setText(this.actionStringsRiskIgnore[0]);
                    return this.actionLbl;
                }
                case 2: {
                    this.actionLbl.setText(this.actionStringsRiskLogonly[0]);
                    return this.actionLbl;
                }
                case 6: 
                case 7: {
                    this.actionLbl.setText(this.actionStringsHPP[0]);
                    return this.actionLbl;
                }
                case 8: 
                case 12: {
                    this.actionLbl.setText(this.actionStringsDomainIgnore[0]);
                    return this.actionLbl;
                }
                case 11: {
                    this.addItemInComboBox(DNS_HOSTFILE_CHANGE_ACTIONS);
                    this.setActionComboBoxSelectedItem(rowData.getAction());
                    break;
                }
                case 13: {
                    this.addItemInComboBox(NON_PE_FILE_ACTIONS);
                    this.setActionComboBoxSelectedItem(rowData.getAction());
                    break;
                }
            }
            if (OverridePanel.this.isCloudExceptionPolicy) {
                this.actionComboBox.setEnabled(false);
            }
            return this.actionComboBox;
        }

        void addItemInComboBox(String[] items) {
            this.actionComboBox.removeAllItems();
            for (String item : items) {
                this.actionComboBox.addItem(item);
            }
        }

        void addItemInComboBox(OverrideActionCheckboxItem[] items) {
            this.actionComboBox.removeAllItems();
            for (OverrideActionCheckboxItem item : items) {
                this.actionComboBox.addItem(item);
            }
        }

        void setActionComboBoxSelectedItem(String value) {
            for (int i = 0; i < this.actionComboBox.getItemCount(); ++i) {
                Object obj = this.actionComboBox.getItemAt(i);
                String itemValue = "";
                if (obj instanceof OverrideActionCheckboxItem) {
                    OverrideActionCheckboxItem item = (OverrideActionCheckboxItem)obj;
                    itemValue = item.getValue();
                } else {
                    itemValue = (String)obj;
                }
                if (!itemValue.equalsIgnoreCase(value)) continue;
                this.actionComboBox.setSelectedIndex(i);
                return;
            }
            this.actionComboBox.setSelectedIndex(0);
        }

        @Override
        public Object getCellEditorValue() {
            if (this.actionComboBox.getItemCount() == 0) {
                return this.actionLbl.getText();
            }
            if (this.actionComboBox.getSelectedItem() instanceof OverrideActionCheckboxItem) {
                OverrideActionCheckboxItem item = (OverrideActionCheckboxItem)this.actionComboBox.getSelectedItem();
                return item.getValue();
            }
            return this.actionComboBox.getSelectedItem();
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return this.getTableCellEditorComponent(table, value, isSelected, row, column);
        }
    }
}

