/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.override;

import com.sygate.scm.common.configobject.schema.NonPEFileOverride;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.policy.override.OverrideActionCheckboxItem;
import com.sygate.scm.console.ui.policy.override.OverridePanel;
import com.sygate.scm.console.ui.policy.override.logicobject.NonPEFileExclusionUIObject;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.StringUtilities;
import com.sygate.scm.util.Utility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.apache.commons.io.FilenameUtils;

public class NonPEFileExclusionDialog
extends DialogBase {
    private static final long serialVersionUID = -4258588702767497095L;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String GEH = "com.sygate.scm.console.ui.policy.override.override";
    private static final Pattern MATCH_ALL_PATTERN = Pattern.compile("[*\\?]*");
    private static final int SHA256_LENGTH = 64;
    private static final int MD5_LENGTH = 32;
    private JPanel mainPanel;
    private JRadioButton gehActorTypeNameRadioButton;
    private JRadioButton gehActorTypeFingerPrintRadioButton;
    private JCheckBox gehActorCheckBox;
    private JTextField gehActorTextBox;
    private JLabel gehFileDescriptionLabel;
    private JTextField gehFileDescriptionTextBox;
    private JCheckBox gehFileNameCheckBox;
    private JTextField gehFileNameTextBox;
    private JLabel gehFileCheckSumLabel;
    private JTextField gehFileCheckSumTextBox;
    private JCheckBox gehFileSizeCheckBox;
    private JTextField gehFileSizeTextBox;
    private JLabel gehActionLabel;
    private JLabel gehActionNoteLabel;
    private JComboBox<OverrideActionCheckboxItem> gehActionComboBox;
    private JLabel gehWildCardSupportedLabel;
    private NonPEFileExclusionUIObject uiObject;

    public NonPEFileExclusionDialog(OverrideActionCheckboxItem[] supportedActions) {
        super(Manager.getFrame(), MSGRES.getString(GEH, "NonPEFileExclusionDialog.title.nonPE"), true);
        this.initialize(false, supportedActions);
        this.setDefaults();
        UiUtilities.centerComponent((Component)this);
    }

    public NonPEFileExclusionDialog(NonPEFileExclusionUIObject extObj, OverrideActionCheckboxItem[] supportedActions, boolean isReadonly) {
        super(Manager.getFrame(), MSGRES.getString(GEH, "NonPEFileExclusionDialog.title.nonPE.edit"), true);
        this.initialize(isReadonly, supportedActions);
        this.uiObject = extObj;
        this.updateData();
        UiUtilities.centerComponent((Component)this);
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_geh_override_add_non_pe";
    }

    private void initialize(boolean isReadonly, OverrideActionCheckboxItem[] supportedActions) {
        Container cont = this.getContentPane();
        cont.setLayout(new BorderLayout());
        JPanel newPanel = new JPanel();
        newPanel.setLayout(new BoxLayout(newPanel, 1));
        newPanel.add(new AvTemplatePane(MSGRES.getString(GEH, "NonPEFileExclusionDialog.heading.label"), MSGRES.getString(GEH, "NonPEFileExclusionDialog.heading.desc")));
        newPanel.add(Box.createVerticalStrut(10));
        newPanel.add(this.createMainPanel(supportedActions));
        newPanel.add(Box.createVerticalStrut(10));
        cont.add((Component)newPanel, "Center");
        cont.add((Component)this.getButtonPanel(), "South");
        if (isReadonly) {
            UIUtilities.setContainerStatus(newPanel, false);
            this.resetOKButton(false);
        }
        this.pack();
    }

    private JPanel createMainPanel(OverrideActionCheckboxItem[] supportedActions) {
        int textFieldWidth = 42;
        ActionListener actorTypeActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NonPEFileExclusionDialog.this.handleActorTypeChange();
            }
        };
        this.gehActorTypeNameRadioButton = new JRadioButton(MSGRES.getString(GEH, "NonPEFileExclusionDialog.label.actor.type.name"));
        this.gehActorTypeNameRadioButton.addActionListener(actorTypeActionListener);
        this.gehActorTypeFingerPrintRadioButton = new JRadioButton(MSGRES.getString(GEH, "NonPEFileExclusionDialog.label.actor.type.checksum"));
        this.gehActorTypeFingerPrintRadioButton.addActionListener(actorTypeActionListener);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.gehActorTypeNameRadioButton);
        buttonGroup.add(this.gehActorTypeFingerPrintRadioButton);
        this.gehActorCheckBox = new JCheckBox(MSGRES.getString(GEH, "NonPEFileExclusionDialog.label.actor.description"), false);
        this.gehActorCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NonPEFileExclusionDialog.this.handleActorCheckBoxChange();
            }
        });
        this.gehActionNoteLabel = new JLabel(MSGRES.getString(GEH, "NonPEFileExclusionDialog.label.actor.note"));
        this.gehActorTextBox = new JTextField(textFieldWidth);
        this.gehFileNameCheckBox = new JCheckBox(MSGRES.getString(GEH, "NonPEFileExclusionDialog.label.file.name"), false);
        this.gehFileNameCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NonPEFileExclusionDialog.this.handleFileNameCheckBoxChange();
            }
        });
        this.gehFileNameTextBox = new JTextField(textFieldWidth);
        RestrictedPlainDocument doc = new RestrictedPlainDocument(1023);
        doc.setValidator("\"<>|", false);
        this.gehFileNameTextBox.setDocument(doc);
        this.gehFileCheckSumLabel = new JLabel(MSGRES.getString(GEH, "NonPEFileExclusionDialog.label.file.checksum"));
        this.gehFileCheckSumTextBox = new JTextField(textFieldWidth);
        RestrictedPlainDocument checkSumDoc = new RestrictedPlainDocument(64);
        this.gehFileCheckSumTextBox.setDocument(checkSumDoc);
        this.gehFileSizeCheckBox = new JCheckBox(MSGRES.getString(GEH, "NonPEFileExclusionDialog.label.file.filesize"), true);
        this.gehFileSizeCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NonPEFileExclusionDialog.this.handleFileSizeCheckBoxChange();
            }
        });
        this.gehFileSizeTextBox = new JTextField(20);
        RestrictedPlainDocument fileSizeDocumentValidator = new RestrictedPlainDocument(16);
        fileSizeDocumentValidator.setValidator("0123456789", true);
        this.gehFileSizeTextBox.setDocument(fileSizeDocumentValidator);
        this.gehFileDescriptionLabel = new JLabel(MSGRES.getString(GEH, "NonPEFileExclusionDialog.label.file.description"));
        this.gehFileDescriptionTextBox = new JTextField(textFieldWidth);
        this.gehActionLabel = new JLabel(MSGRES.getString(GEH, "NonPEFileExclusionDialog.label.action"));
        this.gehActionComboBox = new JComboBox<OverrideActionCheckboxItem>(supportedActions);
        this.gehActionComboBox.setSelectedIndex(0);
        AvTemplatePane otherAttributePanel = new AvTemplatePane("", MSGRES.getString(GEH, "NonPEFileExclusionDialog.label.other.file.attributes.description"), false, 70);
        this.gehWildCardSupportedLabel = new JLabel(MSGRES.getString(GEH, "NonPEFileExclusionDialog.error.wildcard.support"));
        this.mainPanel = new JPanel(new GridBagLayout());
        int y = 0;
        int leftPadding = 10;
        int topPadding = 10;
        int rightPadding = leftPadding;
        this.mainPanel.add((Component)this.gehFileDescriptionLabel, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(topPadding, leftPadding, 0, 0), 0, 0));
        this.mainPanel.add((Component)this.gehFileDescriptionTextBox, new GridBagConstraints(1, y, 2, 1, 0.0, 0.0, 17, 0, new Insets(topPadding, leftPadding, 0, 0), 0, 0));
        this.mainPanel.add((Component)this.gehActionLabel, new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 17, 0, new Insets(topPadding, leftPadding, 0, 0), 0, 0));
        this.mainPanel.add(this.gehActionComboBox, new GridBagConstraints(1, y, 2, 1, 0.0, 0.0, 17, 0, new Insets(topPadding, leftPadding, 0, 0), 0, 0));
        this.mainPanel.add((Component)this.gehFileCheckSumLabel, new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 17, 0, new Insets(topPadding, leftPadding, 0, 0), 0, 0));
        this.mainPanel.add((Component)this.gehFileCheckSumTextBox, new GridBagConstraints(1, y, 2, 1, 0.0, 0.0, 17, 0, new Insets(topPadding, leftPadding, 0, 0), 0, 0));
        this.mainPanel.add((Component)otherAttributePanel, new GridBagConstraints(0, ++y, 3, 1, 0.0, 0.0, 17, 0, new Insets(topPadding, leftPadding - 10, 0, 0), 0, 0));
        this.mainPanel.add((Component)this.gehFileSizeCheckBox, new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 17, 0, new Insets(topPadding, leftPadding, 0, 0), 0, 0));
        this.mainPanel.add((Component)this.gehFileSizeTextBox, new GridBagConstraints(1, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(topPadding, leftPadding, 0, 0), 0, 0));
        this.mainPanel.add((Component)this.gehFileNameCheckBox, new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 17, 0, new Insets(topPadding, leftPadding, 0, 0), 0, 0));
        this.mainPanel.add((Component)this.gehFileNameTextBox, new GridBagConstraints(1, y, 2, 1, 0.0, 0.0, 17, 0, new Insets(topPadding, leftPadding, 0, rightPadding), 0, 0));
        this.mainPanel.add((Component)this.gehActorCheckBox, new GridBagConstraints(0, ++y, 3, 1, 0.0, 0.0, 17, 0, new Insets(topPadding, leftPadding, 0, 0), 0, 0));
        this.mainPanel.add((Component)this.gehActorTypeNameRadioButton, new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 17, 0, new Insets(topPadding, leftPadding + 10, 0, 0), 0, 0));
        this.mainPanel.add((Component)this.gehActorTypeFingerPrintRadioButton, new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 17, 0, new Insets(topPadding, leftPadding + 10, 0, 0), 0, 0));
        this.mainPanel.add((Component)this.gehActionNoteLabel, new GridBagConstraints(0, ++y, 2, 1, 0.0, 0.0, 17, 0, new Insets(topPadding, leftPadding + 30, 0, 0), 0, 0));
        this.mainPanel.add((Component)this.gehActorTextBox, new GridBagConstraints(0, ++y, 2, 1, 0.0, 0.0, 17, 0, new Insets(topPadding, leftPadding + 30, 0, 0), 0, 0));
        this.mainPanel.add((Component)this.gehWildCardSupportedLabel, new GridBagConstraints(0, ++y, 3, 1, 0.0, 0.0, 17, 0, new Insets(topPadding, leftPadding, 0, 0), 0, 0));
        this.handleFileSizeCheckBoxChange();
        this.handleFileNameCheckBoxChange();
        this.handleActorCheckBoxChange();
        return this.mainPanel;
    }

    private void handleActorCheckBoxChange() {
        if (this.gehActorCheckBox.isSelected()) {
            this.gehActorTypeFingerPrintRadioButton.setEnabled(true);
            this.gehActorTypeNameRadioButton.setEnabled(true);
            this.gehActorTextBox.setEnabled(true);
            this.gehActionNoteLabel.setEnabled(true);
        } else {
            this.gehActorTypeFingerPrintRadioButton.setEnabled(false);
            this.gehActorTypeNameRadioButton.setEnabled(false);
            this.gehActorTextBox.setEnabled(false);
            this.gehActorTextBox.setText("");
            this.gehActionNoteLabel.setEnabled(false);
        }
    }

    private void handleFileSizeCheckBoxChange() {
        if (this.gehFileSizeCheckBox.isSelected()) {
            this.gehFileSizeTextBox.setEnabled(true);
        } else {
            this.gehFileSizeTextBox.setEnabled(false);
            this.gehFileSizeTextBox.setText("");
        }
    }

    private void handleFileNameCheckBoxChange() {
        if (this.gehFileNameCheckBox.isSelected()) {
            this.gehFileNameTextBox.setEnabled(true);
        } else {
            this.gehFileNameTextBox.setEnabled(false);
            this.gehFileNameTextBox.setText("");
        }
    }

    private void handleActorTypeChange() {
        if (this.gehActorTypeNameRadioButton.isSelected()) {
            RestrictedPlainDocument doc = new RestrictedPlainDocument(1023);
            doc.setValidator("\"<>|", false);
            this.gehActorTextBox.setDocument(doc);
        } else if (this.gehActorTypeFingerPrintRadioButton.isSelected()) {
            RestrictedPlainDocument doc = new RestrictedPlainDocument(64);
            this.gehActorTextBox.setDocument(doc);
        }
    }

    private void setDefaults() {
        this.gehActorTypeFingerPrintRadioButton.setSelected(true);
        this.handleActorTypeChange();
        this.gehFileCheckSumTextBox.requestFocus();
    }

    private void updateData() {
        if (!StringUtilities.isEmpty((String)this.uiObject.getFileName())) {
            this.gehFileNameTextBox.setText(this.uiObject.getFileName());
            this.gehFileNameCheckBox.setSelected(true);
        } else {
            this.gehFileNameCheckBox.setSelected(false);
        }
        if (!StringUtilities.isEmpty((String)this.uiObject.getFileFingerPrint())) {
            this.gehFileCheckSumTextBox.setText(this.uiObject.getFileFingerPrint());
        }
        if (!StringUtilities.isEmpty((String)this.uiObject.getFileDescription())) {
            this.gehFileDescriptionTextBox.setText(this.uiObject.getFileDescription());
        }
        if (this.uiObject.getFileSize() != null) {
            this.gehFileSizeTextBox.setText(Long.toString(this.uiObject.getFileSize()));
            this.gehFileSizeCheckBox.setSelected(true);
        } else {
            this.gehFileSizeCheckBox.setSelected(false);
        }
        if (NonPEFileOverride.NAME.equals(this.uiObject.getActorType())) {
            this.gehActorTypeNameRadioButton.setSelected(true);
        } else {
            this.gehActorTypeFingerPrintRadioButton.setSelected(true);
        }
        this.handleActorTypeChange();
        if (!StringUtilities.isEmpty((String)this.uiObject.getActor())) {
            this.gehActorCheckBox.setSelected(true);
            this.gehActorTextBox.setText(this.uiObject.getActor());
        } else {
            this.gehActorCheckBox.setSelected(false);
        }
        Integer action = this.uiObject.getAction();
        if (action == null) {
            action = 0;
        }
        switch (action) {
            case 2: {
                this.gehActionComboBox.setSelectedIndex(0);
                break;
            }
            case 1: {
                this.gehActionComboBox.setSelectedIndex(1);
                break;
            }
            case 3: {
                this.gehActionComboBox.setSelectedIndex(2);
                break;
            }
            default: {
                this.gehActionComboBox.setSelectedIndex(3);
            }
        }
        this.gehFileCheckSumTextBox.requestFocus();
        this.handleFileSizeCheckBoxChange();
        this.handleFileNameCheckBoxChange();
        this.handleActorCheckBoxChange();
    }

    public NonPEFileExclusionUIObject getSelectedFile() {
        return this.uiObject;
    }

    @Override
    protected boolean isValidate() {
        String fileName;
        String extension;
        Matcher matcher;
        boolean isFileCheckSumEmpty = StringUtilities.isEmpty((String)this.gehFileCheckSumTextBox.getText());
        boolean isFileNameEmpty = StringUtilities.isEmpty((String)this.gehFileNameTextBox.getText());
        boolean isActorEmpty = StringUtilities.isEmpty((String)this.gehActorTextBox.getText());
        boolean isFileSizeEmpty = StringUtilities.isEmpty((String)this.gehFileSizeTextBox.getText());
        if (isFileCheckSumEmpty) {
            JOptionPane.showMessageDialog(this, MSGRES.getString(GEH, "NonPEFileExclusionDialog.error.file.checksum.required"), MSGRES.getString(GEH, "OverridePolicySelectDlg.error"), 0);
            this.gehFileCheckSumTextBox.requestFocus();
            return false;
        }
        if (!this.isValidCheckSum(this.gehFileCheckSumTextBox)) {
            return false;
        }
        if (isActorEmpty && isFileNameEmpty && isFileSizeEmpty) {
            JOptionPane.showMessageDialog(this, MSGRES.getString(GEH, "NonPEFileExclusionDialog.error.atleast.one"), MSGRES.getString(GEH, "OverridePolicySelectDlg.error"), 0);
            this.gehFileNameTextBox.requestFocus();
            return false;
        }
        if (this.gehActorTypeFingerPrintRadioButton.isSelected() && !isActorEmpty && !this.isValidCheckSum(this.gehActorTextBox)) {
            return false;
        }
        if (!isFileNameEmpty && (matcher = MATCH_ALL_PATTERN.matcher(extension = FilenameUtils.getExtension((String)(fileName = this.gehFileNameTextBox.getText().trim())))).matches()) {
            JOptionPane.showMessageDialog(this, MSGRES.getString(GEH, "NonPEFileExclusionDialog.error.no.file.extention"), MSGRES.getString(GEH, "OverridePolicySelectDlg.error"), 0);
            this.gehFileNameTextBox.requestFocus();
            return false;
        }
        if (this.gehActorTypeNameRadioButton.isSelected() && !isActorEmpty) {
            String actorName = this.gehActorTextBox.getText().trim();
            extension = FilenameUtils.getExtension((String)actorName);
            Matcher extensionMatcher = MATCH_ALL_PATTERN.matcher(extension);
            if (extensionMatcher.matches()) {
                JOptionPane.showMessageDialog(this, MSGRES.getString(GEH, "NonPEFileExclusionDialog.error.no.actor.extention"), MSGRES.getString(GEH, "OverridePolicySelectDlg.error"), 0);
                this.gehActorTextBox.requestFocus();
                return false;
            }
            String baseName = FilenameUtils.getBaseName((String)actorName);
            Matcher nameMatcher = MATCH_ALL_PATTERN.matcher(baseName);
            if (nameMatcher.matches()) {
                JOptionPane.showMessageDialog(this, MSGRES.getString(GEH, "NonPEFileExclusionDialog.error.moredetails.application"), MSGRES.getString(GEH, "OverridePolicySelectDlg.error"), 0);
                this.gehActorTextBox.requestFocus();
                return false;
            }
        }
        return true;
    }

    private boolean isValidCheckSum(JTextField textField) {
        boolean isValidCheckSum = false;
        if (textField.getText().length() != 64 && textField.getText().length() != 32) {
            isValidCheckSum = false;
        } else {
            try {
                Utility.toByteArray((String)textField.getText());
                isValidCheckSum = true;
            }
            catch (Exception ex) {
                LoggerUtilities.logException((Throwable)ex);
                isValidCheckSum = false;
            }
        }
        if (!isValidCheckSum) {
            JOptionPane.showMessageDialog(this, MSGRES.getString(GEH, "NonPEFileExclusionDialog.error.invalid.checksum"), MSGRES.getString(GEH, "OverridePolicySelectDlg.error"), 0);
            textField.requestFocusInWindow();
        }
        return isValidCheckSum;
    }

    @Override
    protected void commit() {
        boolean isActorEmpty = StringUtilities.isEmpty((String)this.gehActorTextBox.getText());
        int actorType = 0;
        actorType = this.gehActorTypeNameRadioButton.isSelected() || isActorEmpty ? NonPEFileOverride.NAME.intValue() : NonPEFileOverride.HASH.intValue();
        Long fileSize = null;
        if (!StringUtilities.isEmpty((String)this.gehFileSizeTextBox.getText())) {
            fileSize = Long.parseLong(this.gehFileSizeTextBox.getText());
        }
        OverrideActionCheckboxItem selectedItem = (OverrideActionCheckboxItem)this.gehActionComboBox.getSelectedItem();
        this.uiObject = new NonPEFileExclusionUIObject();
        this.uiObject.setActorType(actorType);
        this.uiObject.setActor(this.gehActorTextBox.getText());
        this.uiObject.setFileName(this.gehFileNameTextBox.getText());
        this.uiObject.setFileFingerPrint(this.gehFileCheckSumTextBox.getText());
        this.uiObject.setFileSize(fileSize);
        this.uiObject.setFileDescription(this.gehFileDescriptionTextBox.getText());
        this.uiObject.setAction(OverridePanel.convertActionStringtoInt(selectedItem.getValue()));
    }
}

