/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.override;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.policy.dialog.FolderPrefixGlossaryDialog;
import com.sygate.scm.console.ui.policy.override.PrefixSeparator;
import com.sygate.scm.console.ui.policy.override.logicobject.MacFileFolderExclusionUIObject;
import com.sygate.scm.console.ui.policy.override.logicobject.PolicyExceptionUIObject;
import com.sygate.scm.console.ui.policy.override.logicobject.SecurityRiskScanCategoryUIObject;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.util.ConstantValue;
import com.sygate.scm.util.StringUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class MacFileFolderExclusionDialog
extends DialogBase {
    private static final long serialVersionUID = 1L;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String GEH = "com.sygate.scm.console.ui.policy.override.override";
    private SecurityRiskScanCategoryUIObject scanCatObj = SecurityRiskScanCategoryUIObject.DEFAULT_CATEGORY_UI_OBJECT;
    private JComboBox<String> gehPrefixComboBox;
    private JTextField gehFileNameTextBox;
    private String gehFileName;
    private JLabel gehSubFoldersLabel;
    private JLabel gehSubFoldersLabel1;
    JLabel specifyScansLabel = new JLabel(MSGRES.getString("com.sygate.scm.console.ui.policy.override.override", "MacFileFolderExclusionDialog.label.specifyscans"));
    JLabel riskScanCatLabel = new JLabel(MSGRES.getString("com.sygate.scm.console.ui.policy.override.override", "MacFileFolderExclusionDialog.label.ScanCat"));
    JComboBox<SecurityRiskScanCategoryUIObject> gehScanCatComboBox = new JComboBox<SecurityRiskScanCategoryUIObject>(SecurityRiskScanCategoryUIObject.values());
    JCheckBox gehSecurityRiskBox;
    JCheckBox gehSonarBox;
    private List<String> gehFileList = new ArrayList<String>();
    private MacFileFolderExclusionUIObject macSelectedFileFolderExclusion;
    private String gehFilePathNameTobeEdited;
    private Pattern macFilePathPattern = Pattern.compile("(.*)(//)(.*)");

    public MacFileFolderExclusionDialog() {
        super(Manager.getFrame(), MSGRES.getString(GEH, "MacFileFolderExclusionDialog.title.file"), true);
        this.initialize(false);
        UiUtilities.centerComponent((Component)this);
    }

    public MacFileFolderExclusionDialog(String file, boolean isReadonly) {
        super(Manager.getFrame(), MSGRES.getString(GEH, "MacFileFolderExclusionDialog.title.fileEdit"), true);
        this.gehFileName = file;
        this.gehFilePathNameTobeEdited = file;
        this.initialize(isReadonly);
        UiUtilities.centerComponent((Component)this);
    }

    private void initialize(boolean isReadonly) {
        Container cont = this.getContentPane();
        cont.setLayout(new BorderLayout());
        JPanel newPanel = new JPanel();
        newPanel.setLayout(new BoxLayout(newPanel, 1));
        newPanel.add(new AvTemplatePane(MSGRES.getString(GEH, "MacFileFolderExclusionDialog.heading.label"), MSGRES.getString(GEH, "MacFileFolderExclusionDialog.heading.desc")));
        newPanel.add(Box.createVerticalStrut(10));
        newPanel.add(this.getEditPanel());
        newPanel.add(Box.createVerticalStrut(10));
        cont.add((Component)newPanel, "Center");
        cont.add((Component)this.getButtonPanel(), "South");
        if (isReadonly) {
            UIUtilities.setContainerStatus(newPanel, false);
            this.resetOKButton(false);
        }
        this.pack();
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "mac_sesm_policies_dialog_geh_override_add_sro_file_or_folder";
    }

    private JPanel getEditPanel() {
        JPanel ePanel = new JPanel(new GridBagLayout());
        JLabel pLabel = new JLabel(MSGRES.getString(GEH, "MacFileFolderExclusionDialog.label.prefixVariable"));
        JLabel fLabel = new JLabel(MSGRES.getString(GEH, "MacFileFolderExclusionDialog.label.file"));
        if (this.gehPrefixComboBox == null) {
            String[] values = ConstantValue.getMacDirKeys();
            this.gehPrefixComboBox = new JComboBox<String>(values);
            this.gehPrefixComboBox.setSelectedIndex(0);
        }
        if (this.gehFileNameTextBox == null) {
            this.gehFileNameTextBox = new JTextField("", 20);
        }
        RestrictedPlainDocument doc = new RestrictedPlainDocument(1023);
        doc.setValidator(":", false);
        this.gehFileNameTextBox.setDocument(doc);
        this.gehFileNameTextBox.putClientProperty("ajaxswing.textfield.documentListener", Boolean.TRUE);
        if (this.gehSubFoldersLabel == null) {
            this.gehSubFoldersLabel = new JLabel(MSGRES.getString(GEH, "MacFileFolderExclusionDialog.label.includeSubfolders"));
        }
        if (this.gehSubFoldersLabel1 == null) {
            this.gehSubFoldersLabel1 = new JLabel(MSGRES.getString(GEH, "MacFileFolderExclusionDialog.label.includeSubfolders1"));
        }
        if (this.gehSecurityRiskBox == null) {
            this.gehSecurityRiskBox = new JCheckBox(MSGRES.getString(GEH, "MacFileFolderExclusionDialog.scantype.securityrisk"));
        }
        this.gehSecurityRiskBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MacFileFolderExclusionDialog.this.showScanCatComponents(MacFileFolderExclusionDialog.this.gehSecurityRiskBox.isSelected());
            }
        });
        if (this.gehSonarBox == null) {
            this.gehSonarBox = new JCheckBox(MSGRES.getString(GEH, "MacFileFolderExclusionDialog.scantype.sonar"));
        }
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        ePanel.add((Component)pLabel, constraints);
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        ePanel.add(this.gehPrefixComboBox, constraints);
        constraints.gridx = 1;
        constraints.gridwidth = 1;
        ePanel.add((Component)FolderPrefixGlossaryDialog.createFolderGlossaryButton(ConstantValue.getMacDirKeys()), constraints);
        constraints.gridx = 2;
        constraints.gridy = 0;
        constraints.insets.left = 10;
        ePanel.add((Component)fLabel, constraints);
        constraints.gridy = 1;
        constraints.ipadx = 200;
        constraints.weightx = 1.0;
        constraints.fill = 2;
        ePanel.add((Component)this.gehFileNameTextBox, constraints);
        constraints.gridy = 2;
        ePanel.add((Component)this.gehSubFoldersLabel, constraints);
        constraints.gridy = 3;
        ePanel.add((Component)this.gehSubFoldersLabel1, constraints);
        constraints.gridx = 0;
        constraints.gridwidth = 3;
        constraints.insets.left = 0;
        constraints.insets.top = 10;
        constraints.gridwidth = 3;
        constraints.gridy = 4;
        ePanel.add((Component)this.specifyScansLabel, constraints);
        constraints.gridwidth = 2;
        constraints.insets.top = 0;
        constraints.gridy = 5;
        ePanel.add((Component)this.gehSecurityRiskBox, constraints);
        constraints.gridy = 6;
        ePanel.add((Component)this.gehSonarBox, constraints);
        ePanel.add((Component)this.riskScanCatLabel, new GridBagConstraints(2, 5, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        ePanel.add(this.gehScanCatComboBox, new GridBagConstraints(2, 6, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.riskScanCatLabel.setVisible(false);
        this.gehScanCatComboBox.setVisible(false);
        PrefixSeparator separator = new PrefixSeparator(this.gehFileName, ConstantValue.getMacDirKeys());
        String prefix = separator.getPrefix();
        if (prefix != null && !prefix.equals("")) {
            this.gehPrefixComboBox.setSelectedItem(prefix);
        }
        this.gehFileName = separator.getPath();
        this.gehFileNameTextBox.setText(this.gehFileName);
        ePanel.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 20));
        return ePanel;
    }

    private void showScanCatComponents(boolean visible) {
        this.riskScanCatLabel.setVisible(visible);
        this.gehScanCatComboBox.setVisible(visible);
    }

    public String getFileName() {
        return this.gehFileName;
    }

    public void setFileName(String fileName) {
        this.gehFileName = fileName;
    }

    public void setList(List<String> fileList) {
        this.gehFileList = fileList;
    }

    public MacFileFolderExclusionUIObject getSelectedFile() {
        return this.macSelectedFileFolderExclusion;
    }

    @Override
    protected boolean isValidate() {
        String prefix;
        this.gehFileName = this.getFileNameText();
        if (StringUtilities.isEmpty((String)this.gehFileName) && ConstantValue.getMacDirKeysByIndex((int)0).equals(this.gehPrefixComboBox.getSelectedItem())) {
            JOptionPane.showMessageDialog(this, MSGRES.getString(GEH, "MacFileFolderExclusionDialog.error.emptyFileName"), MSGRES.getString(GEH, "OverridePolicySelectDlg.error"), 0);
            return false;
        }
        Matcher m = this.macFilePathPattern.matcher(this.gehFileName);
        if (m.matches()) {
            this.gehFileName = null;
            JOptionPane.showMessageDialog(this, MSGRES.getString(GEH, "MacFileFolderExclusionDialog.error.invalidPath"), MSGRES.getString(GEH, "OverridePolicySelectDlg.error"), 0);
            return false;
        }
        if (!StringUtilities.isEmpty((String)this.getFileNameText()) && this.getFileNameText().trim().contains("\\")) {
            JOptionPane.showMessageDialog(this, MSGRES.getString(GEH, "MacFileFolderExclusionDialog.error.provideRelativePath"), MSGRES.getString(GEH, "OverridePolicySelectDlg.error"), 0);
            return false;
        }
        if (ConstantValue.getMacDirKeysByIndex((int)0).equals(this.gehPrefixComboBox.getSelectedItem())) {
            if (!this.getFileNameText().startsWith("/")) {
                this.gehFileName = null;
                JOptionPane.showMessageDialog(this, MSGRES.getString(GEH, "MacFileFolderExclusionDialog.error.provideAbsolutePath"), MSGRES.getString(GEH, "OverridePolicySelectDlg.error"), 0);
                return false;
            }
        } else if (!StringUtilities.isEmpty((String)this.gehFileName) && this.getFileNameText().startsWith("/")) {
            this.gehFileName = null;
            JOptionPane.showMessageDialog(this, MSGRES.getString(GEH, "MacFileFolderExclusionDialog.error.pathAtPrefix"), MSGRES.getString(GEH, "OverridePolicySelectDlg.error"), 0);
            return false;
        }
        if (!(prefix = (String)this.gehPrefixComboBox.getSelectedItem()).trim().equalsIgnoreCase(ConstantValue.getMacDirKeysByIndex((int)0))) {
            this.gehFileName = "%" + prefix.trim() + "%" + this.gehFileName;
        }
        if (this.gehFileList != null && (this.gehFilePathNameTobeEdited == null || !this.gehFilePathNameTobeEdited.equals(this.gehFileName)) && this.gehFileList.contains(this.gehFileName)) {
            this.gehFileName = null;
            JOptionPane.showMessageDialog(this, MSGRES.getString(GEH, "MacFileFolderExclusionDialog.error.alreayUsed"), MSGRES.getString(GEH, "OverridePolicySelectDlg.error"), 0);
            return false;
        }
        if (!this.gehSecurityRiskBox.isSelected() && !this.gehSonarBox.isSelected()) {
            JOptionPane.showMessageDialog(this, MSGRES.getString(GEH, "MacFileFolderExclusionDialog.error.noProtectionTechnologySelected"), MSGRES.getString(GEH, "OverridePolicySelectDlg.error"), 0);
            return false;
        }
        return true;
    }

    @Override
    protected void commit() {
        this.macSelectedFileFolderExclusion = new MacFileFolderExclusionUIObject(this.getFileNameText(), (String)this.gehPrefixComboBox.getSelectedItem(), this.gehScanCatComboBox.getSelectedIndex());
        this.macSelectedFileFolderExclusion.setSecurityRiskApplicable(this.gehSecurityRiskBox.isSelected());
        this.macSelectedFileFolderExclusion.setSonarApplicable(this.gehSonarBox.isSelected());
        if (this.gehSecurityRiskBox.isSelected()) {
            this.macSelectedFileFolderExclusion.setGehScanCategories(this.gehScanCatComboBox.getSelectedIndex());
        }
    }

    public void setApplicableScanTypes(PolicyExceptionUIObject extObj) {
        String applicableTechnologies = extObj.getProtectionTechnology();
        if (extObj.getRiskData() != null) {
            this.scanCatObj = SecurityRiskScanCategoryUIObject.fromInteger(((MacFileFolderExclusionUIObject)extObj.getRiskData()).getGehScanCategories());
        }
        if (applicableTechnologies != null && applicableTechnologies.indexOf(MSGRES.getString(GEH, "MacFileFolderExclusionDialog.scantype.sonar")) >= 0) {
            this.gehSonarBox.setSelected(true);
        } else {
            this.gehSonarBox.setSelected(false);
        }
        if (applicableTechnologies != null && applicableTechnologies.indexOf(MSGRES.getString(GEH, "MacFileFolderExclusionDialog.scantype.securityrisk")) >= 0) {
            this.gehSecurityRiskBox.setSelected(true);
            this.riskScanCatLabel.setVisible(true);
            this.gehScanCatComboBox.setVisible(true);
            this.gehScanCatComboBox.setSelectedItem((Object)this.scanCatObj);
        } else {
            this.gehSecurityRiskBox.setSelected(false);
            this.riskScanCatLabel.setVisible(false);
            this.gehScanCatComboBox.setVisible(false);
        }
    }

    private String getFileNameText() {
        String fileName = this.gehFileNameTextBox.getText().trim();
        return fileName;
    }
}

