/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.override;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.HtmlEnabledJTable;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.help.HelpUtil;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.policy.override.logicobject.KnownSecurityUIObject;
import com.sygate.scm.console.ui.util.CustomTableModel;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.SortableTableModel;
import com.sygate.scm.console.ui.util.renderer.CheckBoxEditor;
import com.sygate.scm.console.ui.util.renderer.CheckBoxRenderer;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URISyntaxException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class KnownSecurityRiskDlg
extends DialogBase {
    private static final long serialVersionUID = 1L;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String GEH = "com.sygate.scm.console.ui.policy.override.override";
    HtmlEnabledJTable gehRiskTable = null;
    JCheckBox gehLogCheckBox = null;
    private static final String[] TABLE_TITLE = new String[]{"", MSGRES.getString("com.sygate.scm.console.ui.policy.override.override", "KnownSecurityRiskDlg.table.securityRisk"), MSGRES.getString("com.sygate.scm.console.ui.policy.override.override", "KnownSecurityRiskDlg.table.riskCategory"), MSGRES.getString("com.sygate.scm.console.ui.policy.override.override", "KnownSecurityRiskDlg.table.overallRating"), MSGRES.getString("com.sygate.scm.console.ui.policy.override.override", "KnownSecurityRiskDlg.table.privacyImpact"), MSGRES.getString("com.sygate.scm.console.ui.policy.override.override", "KnownSecurityRiskDlg.table.performance"), MSGRES.getString("com.sygate.scm.console.ui.policy.override.override", "KnownSecurityRiskDlg.table.stealth"), MSGRES.getString("com.sygate.scm.console.ui.policy.override.override", "KnownSecurityRiskDlg.table.removal"), MSGRES.getString("com.sygate.scm.console.ui.policy.override.override", "KnownSecurityRiskDlg.table.dependency")};
    private boolean gehLogOnly = false;
    private KnownSecurityUIObject[] selectedKnowRisks;
    ArrayList<String> gehKnownRiskList;
    SortableTableModel riskModel = null;

    public KnownSecurityRiskDlg() {
        super(Manager.getFrame(), MSGRES.getString(GEH, "KnownSecurityRiskDlg.title"), true);
        this.initialize();
        UiUtilities.centerComponent((Component)this);
    }

    public KnownSecurityRiskDlg(String securityRiskName) {
        super(Manager.getFrame(), MSGRES.getString(GEH, "KnownSecurityRiskDlg.title.edit"), true);
        this.initialize();
        UiUtilities.centerComponent((Component)this);
    }

    public void setList(ArrayList<String> knownRiskList) {
        this.gehKnownRiskList = knownRiskList;
    }

    void setData() throws ConsoleException {
        ArrayList<KnownSecurityUIObject> appl = PolicyHandler.getKnownSecurityRisks();
        for (int i = 0; i < appl.size(); ++i) {
            KnownSecurityUIObject kObj = appl.get(i);
            if (this.gehKnownRiskList.contains(kObj.getSecurityRisk())) continue;
            this.riskModel.addRow(kObj);
        }
        if (this.gehRiskTable.getRowCount() > 0) {
            this.gehRiskTable.setRowSelectionInterval(0, 0);
        }
        this.riskModel.sortTable(1, true);
    }

    private void initialize() {
        Container cont = this.getContentPane();
        cont.setLayout(new BorderLayout());
        JPanel newPanel = new JPanel();
        BoxLayout layout = new BoxLayout(newPanel, 1);
        newPanel.setLayout(layout);
        newPanel.add(new AvTemplatePane(MSGRES.getString(GEH, "KnownSecurityRiskDlg.heading.label"), MSGRES.getString(GEH, "KnownSecurityRiskDlg.heading.desc")));
        newPanel.add(Box.createVerticalStrut(10));
        newPanel.add(this.getTablePanel());
        newPanel.add(Box.createVerticalStrut(10));
        newPanel.add(this.getCheckBoxPanel());
        newPanel.add(Box.createVerticalStrut(10));
        cont.add((Component)newPanel, "Center");
        cont.add((Component)this.getButtonPanel(), "South");
        this.pack();
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_geh_override_add_sro_kr";
    }

    JPanel getTablePanel() {
        JPanel groupPanel = new JPanel();
        this.riskModel = new HTMLSortableTableModel(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCellEditable(int row, int col) {
                if (col == 0) {
                    return true;
                }
                return super.isCellEditable(row, col);
            }
        };
        this.riskModel.setColumnNames(TABLE_TITLE);
        this.riskModel.setEditMode(false);
        this.gehRiskTable = new HtmlEnabledJTable((TableModel)this.riskModel);
        this.riskModel.addMouseListenerToHeaderInTable((JTable)this.gehRiskTable);
        this.gehRiskTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                int column;
                int selRow = KnownSecurityRiskDlg.this.gehRiskTable.rowAtPoint(e.getPoint());
                if (selRow != -1 && (column = KnownSecurityRiskDlg.this.gehRiskTable.columnAtPoint(e.getPoint())) != -1 && TABLE_TITLE[1].equals(KnownSecurityRiskDlg.this.gehRiskTable.getColumnName(column))) {
                    KnownSecurityRiskDlg.this.showURL(selRow);
                }
            }
        });
        TableColumn column = this.gehRiskTable.getColumnModel().getColumn(0);
        CheckBoxRenderer renderer = new CheckBoxRenderer(true);
        column.setCellRenderer(renderer);
        column.setCellEditor(new CheckBoxEditor((JTable)this.gehRiskTable){
            private static final long serialVersionUID = 1L;

            @Override
            protected void updateModel(TableModel tableModel, int selIndex) {
            }
        });
        column.setMaxWidth(renderer.getPreferredSize().width);
        column = this.gehRiskTable.getColumnModel().getColumn(1);
        JNameCellRenderer nameRenderer = new JNameCellRenderer();
        column.setCellRenderer(nameRenderer);
        JLabel testLabel = new JLabel(TABLE_TITLE[1]);
        column.setMinWidth(testLabel.getPreferredSize().width * 2);
        testLabel = new JLabel(TABLE_TITLE[2]);
        column = this.gehRiskTable.getColumnModel().getColumn(2);
        column.setMinWidth((int)((double)testLabel.getPreferredSize().width * 1.4));
        testLabel = new JLabel(TABLE_TITLE[3]);
        column = this.gehRiskTable.getColumnModel().getColumn(3);
        column.setMinWidth((int)((double)testLabel.getPreferredSize().width * 1.4));
        testLabel = new JLabel(TABLE_TITLE[4]);
        column = this.gehRiskTable.getColumnModel().getColumn(4);
        column.setMinWidth((int)((double)testLabel.getPreferredSize().width * 1.4));
        testLabel = new JLabel(TABLE_TITLE[5]);
        column = this.gehRiskTable.getColumnModel().getColumn(5);
        column.setMinWidth((int)((double)testLabel.getPreferredSize().width * 1.4));
        testLabel = new JLabel(TABLE_TITLE[6]);
        column = this.gehRiskTable.getColumnModel().getColumn(6);
        column.setMinWidth((int)((double)testLabel.getPreferredSize().width * 1.4));
        testLabel = new JLabel(TABLE_TITLE[7]);
        column = this.gehRiskTable.getColumnModel().getColumn(7);
        column.setMinWidth((int)((double)testLabel.getPreferredSize().width * 1.4));
        ((DefaultTableCellRenderer)this.gehRiskTable.getTableHeader().getDefaultRenderer()).setHorizontalAlignment(0);
        ((JLabel)((Object)this.gehRiskTable.getDefaultRenderer(this.gehRiskTable.getColumnClass(2)))).setHorizontalAlignment(0);
        int width = this.gehRiskTable.getColumnModel().getTotalColumnWidth();
        Dimension size = new Dimension((int)((double)width * 0.47), (this.gehRiskTable.getRowHeight() + this.gehRiskTable.getRowMargin()) * 10);
        this.gehRiskTable.setPreferredScrollableViewportSize(size);
        this.gehRiskTable.setAutoResizeMode(0);
        this.gehRiskTable.setRowSelectionAllowed(false);
        this.gehRiskTable.putClientProperty((Object)"disableEditableTableScrolling", (Object)"false");
        groupPanel.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 20));
        groupPanel.setLayout(new BorderLayout());
        JScrollPane pane = new JScrollPane((Component)this.gehRiskTable);
        groupPanel.add((Component)pane, "Center");
        return groupPanel;
    }

    private void showURL(int selRow) {
        KnownSecurityUIObject rowObject = (KnownSecurityUIObject)this.riskModel.getRow(selRow);
        try {
            HelpUtil.showKnownSecurityUIObject(rowObject);
        }
        catch (URISyntaxException e) {
            LoggerUtilities.logException((Throwable)e);
        }
    }

    JPanel getCheckBoxPanel() {
        JPanel newPanel = new JPanel();
        BoxLayout layout = new BoxLayout(newPanel, 0);
        newPanel.setLayout(layout);
        if (this.gehLogCheckBox == null) {
            this.gehLogCheckBox = new JCheckBox(MSGRES.getString(GEH, "KnownSecurityRiskDlg.checkbox"));
        }
        newPanel.add(this.gehLogCheckBox);
        JPanel bPanel = new JPanel(new BorderLayout());
        bPanel.add((Component)newPanel, "West");
        bPanel.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 20));
        return bPanel;
    }

    public KnownSecurityUIObject[] getSelectedKnowRisks() {
        KnownSecurityUIObject[] tempSelectedKnowRisks = this.selectedKnowRisks == null ? null : (KnownSecurityUIObject[])this.selectedKnowRisks.clone();
        return tempSelectedKnowRisks;
    }

    public boolean getLog() {
        return this.gehLogOnly;
    }

    public void setLog(boolean log) {
        this.gehLogOnly = log;
    }

    @Override
    protected void commit() {
        if (this.gehRiskTable == null) {
            return;
        }
        int count = 0;
        for (int index = 0; index < this.riskModel.getRowCount(); ++index) {
            KnownSecurityUIObject risk = (KnownSecurityUIObject)this.riskModel.getRow(index);
            if (!risk.isSelected()) continue;
            ++count;
        }
        this.selectedKnowRisks = new KnownSecurityUIObject[count];
        if (count <= 0) {
            return;
        }
        int selectedIndex = 0;
        for (int index = 0; index < this.riskModel.getRowCount() && selectedIndex < count; ++index) {
            KnownSecurityUIObject risk = (KnownSecurityUIObject)this.riskModel.getRow(index);
            if (!risk.isSelected()) continue;
            this.selectedKnowRisks[selectedIndex] = risk;
            ++selectedIndex;
        }
        this.gehLogOnly = this.gehLogCheckBox.isSelected();
    }

    private int stringCompare(String source, String target, boolean isCaseSensitive) {
        Locale locale = Locale.getDefault();
        String language = locale.getLanguage();
        if ("en".equalsIgnoreCase(language)) {
            if (isCaseSensitive) {
                return source.compareTo(target);
            }
            return source.compareToIgnoreCase(target);
        }
        Collator collator = Collator.getInstance();
        if (isCaseSensitive) {
            collator.setStrength(2);
        } else {
            collator.setStrength(1);
        }
        return collator.compare(source, target);
    }

    class HTMLRowComparator
    implements Comparator<TableRow> {
        private boolean ascending;

        public HTMLRowComparator(CustomTableModel model, int column, boolean ascending) {
            this.ascending = ascending;
        }

        @Override
        public int compare(TableRow row1, TableRow row2) {
            int ret = this.compareInternal(row1, row2);
            if (!this.ascending) {
                ret = -ret;
            }
            return ret;
        }

        public int compareInternal(TableRow row1, TableRow row2) {
            if (row1 == null && row2 == null) {
                return 0;
            }
            if (row1 == null) {
                return -1;
            }
            if (row2 == null) {
                return 1;
            }
            Object o1 = ((KnownSecurityUIObject)row1).getNonHTMLValueAt();
            Object o2 = ((KnownSecurityUIObject)row2).getNonHTMLValueAt();
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            int result = 0;
            result = KnownSecurityRiskDlg.this.stringCompare((String)o1, (String)o2, false);
            if (result < 0) {
                return -1;
            }
            if (result > 0) {
                return 1;
            }
            return 0;
        }
    }

    private class HTMLSortableTableModel
    extends SortableTableModel {
        private static final long serialVersionUID = 1L;

        HTMLSortableTableModel() {
            super(false);
        }

        @Override
        public void sortTable(int columnViewIndex, boolean isAscending) {
            int column = KnownSecurityRiskDlg.this.gehRiskTable.convertColumnIndexToModel(columnViewIndex);
            if (column != 1) {
                super.sortTable(column, isAscending);
            } else {
                if (this.getDataVector() == null || column > this.getColumnCount()) {
                    return;
                }
                this.isAscending = isAscending;
                this.sortedColumn = column;
                Vector<TableRow> data = this.getDataVector();
                Collections.sort(data, new HTMLRowComparator(this, column, isAscending));
                this.setDataVector(data);
                this.fireTableDataChanged();
            }
        }
    }

    public static class JNameCellRenderer
    extends JLabel
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setText((String)value);
            return this;
        }
    }
}

