/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.override;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.policy.override.logicobject.ProcessesToDetectUIObject;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.ui.util.VerticalFlowLayout;
import com.sygate.scm.console.util.UIText;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class HPPProcessesToDetectDlg
extends DialogBase {
    private static final long serialVersionUID = 5690389435389425689L;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String GEH = "com.sygate.scm.console.ui.policy.override.override";
    private final VerticalFlowLayout gehLayout = new VerticalFlowLayout(0, 0, 5, true, true);
    JTextField gehProcessTextBox;
    String gehProcessName;
    ArrayList<String> gehProcessToDetectList;
    String gehProcessNameToEdit;
    ProcessesToDetectUIObject _selectedProcessToDetect;

    public HPPProcessesToDetectDlg() {
        super(Manager.getFrame(), MSGRES.getString(GEH, "HPPProcessesToDetect.title.addProcessExcept"), true);
        this.initialize(false);
        UiUtilities.centerComponent((Component)this);
    }

    public HPPProcessesToDetectDlg(String processName, boolean isReadonly) {
        super(Manager.getFrame(), MSGRES.getString(GEH, "HPPProcessesToDetect.title.editProcessExcept"), true);
        this.gehProcessName = processName;
        this.gehProcessNameToEdit = processName;
        this.initialize(isReadonly);
        UiUtilities.centerComponent((Component)this);
    }

    @Override
    protected String getOkButtonText() {
        return UIText.get(0);
    }

    private void initialize(boolean isReadonly) {
        Container cont = this.getContentPane();
        cont.setLayout(new BorderLayout());
        JPanel newPanel = new JPanel(this.gehLayout);
        newPanel.add(new AvTemplatePane(MSGRES.getString(GEH, "HPPProcessesToDetect.title.processToDetect"), MSGRES.getString(GEH, "HPPProcessesToDetect.heading.desc")));
        newPanel.add(this.getEditPanel());
        DescriptionTextArea noticeArea = new DescriptionTextArea(MSGRES.getString(GEH, "HPPProcessesToDetect.label.notice"));
        JPanel pan = new JPanel(new GridBagLayout());
        pan.add((Component)noticeArea, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(2, 20, 0, 4), 0, 0));
        newPanel.add(pan);
        cont.add((Component)newPanel, "Center");
        cont.add((Component)this.getButtonPanel(), "South");
        if (isReadonly) {
            UIUtilities.setContainerStatus(newPanel, false);
            this.resetOKButton(false);
        }
        this.pack();
        this.setSize(new Dimension(Math.max(this.getSize().width, 580), this.getSize().height - 15));
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_geh_override_add_hpo_ptd";
    }

    JPanel getEditPanel() {
        JPanel ePanel = new JPanel(new GridBagLayout());
        if (this.gehProcessTextBox == null) {
            this.gehProcessTextBox = new JTextField();
            RestrictedPlainDocument doc = new RestrictedPlainDocument(1023);
            this.gehProcessTextBox.setDocument(doc);
        }
        this.gehProcessTextBox.setPreferredSize(new Dimension(300, 25));
        ePanel.add((Component)this.gehProcessTextBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 20, 0, 4), 0, 0));
        if (this.gehProcessName != null) {
            this.gehProcessTextBox.setText(this.gehProcessName);
        }
        DescriptionTextArea exampleArea = new DescriptionTextArea(MSGRES.getString(GEH, "HPPProcessesToDetect.label.example"));
        ePanel.add(exampleArea);
        ePanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 20));
        return ePanel;
    }

    public String getProcessName() {
        return this.gehProcessName;
    }

    public void setProcessName(String processName) {
        this.gehProcessName = processName;
    }

    public void setList(ArrayList<String> processesToDetect) {
        this.gehProcessToDetectList = processesToDetect;
    }

    public ProcessesToDetectUIObject getSelectedHPPRisk() {
        return this._selectedProcessToDetect;
    }

    @Override
    protected boolean isValidate() {
        this.gehProcessName = this.getFileNameText();
        if (this.gehProcessName == null || this.gehProcessName.trim().length() == 0) {
            JOptionPane.showMessageDialog(this, MSGRES.getString(GEH, "HPPProcessesToDetect.error.emptyProcessName"), MSGRES.getString(GEH, "OverridePolicySelectDlg.error"), 0);
            return false;
        }
        if (!this.validateInputFullCheck(this.gehProcessName)) {
            return false;
        }
        if (!this.gehProcessName.endsWith(".exe")) {
            this.gehProcessName = this.gehProcessName + ".exe";
        }
        if ((this.gehProcessNameToEdit == null || !this.gehProcessNameToEdit.equalsIgnoreCase(this.gehProcessName)) && this.gehProcessToDetectList != null && this.gehProcessToDetectList.contains(this.gehProcessName)) {
            this.gehProcessName = null;
            JOptionPane.showMessageDialog(this, MSGRES.getString(GEH, "HPPProcessesToDetect.error.alreayUsed"), MSGRES.getString(GEH, "OverridePolicySelectDlg.error"), 0);
            return false;
        }
        return true;
    }

    @Override
    protected void commit() {
        this.gehProcessName = this.getFileNameText();
        if (!this.gehProcessName.toLowerCase().endsWith(".exe")) {
            this.gehProcessName = this.gehProcessName + ".exe";
        }
        this._selectedProcessToDetect = new ProcessesToDetectUIObject(this.gehProcessName);
    }

    String getFileNameText() {
        String fileName = this.gehProcessTextBox.getText().trim();
        if (fileName.contains("\\n")) {
            fileName = fileName.replace("\\n", "\\N");
        }
        return fileName;
    }
}

