/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.override;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.policy.override.OverrideActionCheckboxItem;
import com.sygate.scm.console.ui.policy.override.OverridePanel;
import com.sygate.scm.console.ui.policy.override.logicobject.DetectedProcessUIObject;
import com.sygate.scm.console.ui.policy.override.logicobject.PolicyExceptionUIObject;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.ui.util.SortableTableModel;
import com.sygate.scm.console.ui.util.StripesTable;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.util.query.DropdownItem;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JViewport;

public class HPPDetectedProcessesDlg
extends DialogBase {
    private static final long serialVersionUID = 3112903216100915971L;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String GEH = "com.sygate.scm.console.ui.policy.override.override";
    JTable gehRiskTable;
    JComboBox<OverrideActionCheckboxItem> gehActionComboBox;
    JComboBox<DropdownItem> gehViewTypeComboBox;
    JTextField gehAppNameSearchField;
    JButton gehAppSearchButton;
    private static final String[] TABLE_TITLE = new String[]{MSGRES.getString("com.sygate.scm.console.ui.policy.override.override", "HPPDetectedProcessesDlg.table.detectedApplication"), MSGRES.getString("com.sygate.scm.console.ui.policy.override.override", "HPPDetectedProcessesDlg.table.filePath"), MSGRES.getString("com.sygate.scm.console.ui.policy.override.override", "HPPDetectedProcessesDlg.table.productName"), MSGRES.getString("com.sygate.scm.console.ui.policy.override.override", "HPPDetectedProcessesDlg.table.company"), MSGRES.getString("com.sygate.scm.console.ui.policy.override.override", "HPPDetectedProcessesDlg.table.checksum")};
    private final DropdownItem ALL = new DropdownItem(MSGRES.getString("com.sygate.scm.console.ui.policy.override.override", "HPPDetectedProcessesDlg.All"), (Object)0);
    private final DropdownItem WATCHEDAPP = new DropdownItem(MSGRES.getString("com.sygate.scm.console.ui.policy.override.override", "HPPDetectedProcessesDlg.WatchedApp"), (Object)1);
    private final DropdownItem REQUESTEDAPP = new DropdownItem(MSGRES.getString("com.sygate.scm.console.ui.policy.override.override", "HPPDetectedProcessesDlg.RequestedApp"), (Object)2);
    private DetectedProcessUIObject[] gehSelectedDetectedProcess = null;
    ArrayList<String> detectedProcessList = new ArrayList();
    OverridePanel parentPanel;
    private static final float[] COL_SIZE = new float[]{0.2f, 0.2f, 0.25f, 0.175f, 0.175f};
    SortableTableModel gehRiskModel = null;
    private boolean isApplicationDialog = true;

    public HPPDetectedProcessesDlg(OverridePanel parentPanel, boolean isReadonly, OverrideActionCheckboxItem[] supportedActions, String title, String description, boolean isApplicationDialog) {
        super(Manager.getFrame(), title, true);
        this.parentPanel = parentPanel;
        this.isApplicationDialog = isApplicationDialog;
        this.initialize(isReadonly, supportedActions, title, description);
        UiUtilities.centerComponent((Component)this);
    }

    public void setList(ArrayList<String> detectedProcs) {
        this.detectedProcessList = detectedProcs;
    }

    private void initialize(boolean isReadonly, OverrideActionCheckboxItem[] supportedActions, String title, String description) {
        Container cont = this.getContentPane();
        cont.setLayout(new BorderLayout());
        JPanel newPanel = new JPanel();
        BoxLayout layout = new BoxLayout(newPanel, 1);
        newPanel.setLayout(layout);
        newPanel.add(new AvTemplatePane(title, description));
        newPanel.add(this.getViewTypePanel());
        newPanel.add(Box.createVerticalStrut(10));
        newPanel.add(this.getTablePanel());
        newPanel.add(Box.createVerticalStrut(10));
        newPanel.add(this.getComboBoxPanel(supportedActions));
        newPanel.add(Box.createVerticalStrut(10));
        cont.add((Component)newPanel, "Center");
        cont.add((Component)this.getButtonPanel(), "South");
        if (isReadonly) {
            UIUtilities.setContainerStatus(newPanel, false);
            this.resetOKButton(false);
        }
        this.pack();
    }

    @Override
    public String getContentSensitiveHelpToken() {
        if (this.isApplicationDialog) {
            return "sesm_policies_dialog_geh_override_add_hpo_dp";
        }
        return "sesm_policies_dialog_geh_add_dnshostfile";
    }

    private JPanel getTablePanel() {
        JPanel groupPanel = new JPanel();
        this.gehRiskModel = new SortableTableModel(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCellEditable(int row, int col) {
                return super.isCellEditable(row, col);
            }
        };
        this.gehRiskModel.setColumnNames(TABLE_TITLE);
        this.gehRiskTable = new StripesTable(this.gehRiskModel){
            private static final long serialVersionUID = 1L;

            public boolean getScrollableTracksViewportWidth() {
                Container parent;
                if (this.autoResizeMode == 0 && (parent = this.getParent()) instanceof JViewport) {
                    return parent.getSize().getWidth() > this.getPreferredSize().getWidth();
                }
                return super.getScrollableTracksViewportWidth();
            }
        };
        this.gehRiskTable.setAutoResizeMode(0);
        this.gehRiskModel.addMouseListenerToHeaderInTable(this.gehRiskTable);
        Dimension size = this.gehRiskTable.getPreferredScrollableViewportSize();
        this.gehRiskTable.setPreferredScrollableViewportSize(new Dimension(size.width + 300, (this.gehRiskTable.getRowHeight() + this.gehRiskTable.getRowMargin()) * 5));
        UIUtilities.setTableColumnWidth(this.gehRiskTable, COL_SIZE, (int)this.gehRiskTable.getPreferredScrollableViewportSize().getWidth());
        this.gehRiskTable.getSelectionModel().setSelectionMode(2);
        groupPanel.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 20));
        groupPanel.setLayout(new BorderLayout());
        JScrollPane pane = new JScrollPane(this.gehRiskTable, 20, 32);
        groupPanel.add((Component)pane, "Center");
        return groupPanel;
    }

    void setData(DetectedProcessUIObject exceptionObj) throws ConsoleException {
        if (exceptionObj == null) {
            DropdownItem viewTypeItem = (DropdownItem)this.gehViewTypeComboBox.getSelectedItem();
            ArrayList<DetectedProcessUIObject> appl = PolicyHandler.getHPPApplication(Integer.parseInt(String.valueOf(viewTypeItem.getValue())), this.gehAppNameSearchField.getText());
            for (int i = 0; i < appl.size(); ++i) {
                DetectedProcessUIObject obj = appl.get(i);
                if (obj.getChecksum() == null || obj.getChecksum().trim().equals("") || obj.getDetectedProcess() == null || obj.getDetectedProcess().trim().equals("") || this.detectedProcessList.contains(obj.getChecksum())) continue;
                this.gehRiskModel.addRow(obj);
            }
        } else {
            this.gehRiskModel.addRow(exceptionObj);
            this.setActionComboBoxSelectedItem(exceptionObj.getAction());
            this.gehViewTypeComboBox.setEnabled(false);
            this.gehAppNameSearchField.setEnabled(false);
            this.gehAppSearchButton.setEnabled(false);
        }
        if (this.gehRiskTable.getRowCount() > 0) {
            this.gehRiskTable.setRowSelectionInterval(0, 0);
        }
    }

    private void setActionComboBoxSelectedItem(String value) {
        for (int i = 0; i < this.gehActionComboBox.getItemCount(); ++i) {
            OverrideActionCheckboxItem item = this.gehActionComboBox.getItemAt(i);
            if (!item.getValue().equalsIgnoreCase(value)) continue;
            this.gehActionComboBox.setSelectedIndex(i);
            return;
        }
        this.gehActionComboBox.setSelectedIndex(0);
    }

    private JPanel getComboBoxPanel(OverrideActionCheckboxItem[] supportedActions) {
        JPanel panel = new JPanel(new BorderLayout());
        JPanel newPanel = new JPanel(new FlowLayout(0));
        if (this.gehActionComboBox == null) {
            this.gehActionComboBox = new JComboBox<OverrideActionCheckboxItem>(supportedActions);
            this.gehActionComboBox.setSelectedIndex(1);
        }
        newPanel.add(new JLabel(MSGRES.getString(GEH, "HPPDetectedProcessesDlg.combobox")));
        newPanel.add(this.gehActionComboBox);
        panel.add((Component)newPanel, "Before");
        JPanel btPanel = new JPanel(new FlowLayout(0));
        if (this.isApplicationDialog) {
            JButton appExclusionButton = new JButton(MSGRES.getString(GEH, "ApplicationExclusionDialog.button.add.aplication"));
            appExclusionButton.addActionListener(this.parentPanel.getApplicationExclusionActionListener(PolicyExceptionUIObject.PLATFORM_WIN));
            btPanel.add(appExclusionButton);
        }
        JButton button = new JButton(MSGRES.getString(GEH, "HPPDetectedProcessesDlg.button.addmonitor"));
        button.addActionListener(this.parentPanel.getHPProcessesToDetectListener());
        btPanel.add(button);
        panel.add((Component)btPanel, "After");
        panel.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 20));
        return panel;
    }

    private JPanel getViewTypePanel() {
        JPanel newPanel = new JPanel(new FlowLayout(0));
        if (this.gehViewTypeComboBox == null) {
            DropdownItem[] items = new DropdownItem[]{this.ALL, this.WATCHEDAPP, this.REQUESTEDAPP};
            this.gehViewTypeComboBox = new JComboBox<DropdownItem>(items);
            this.gehViewTypeComboBox.setSelectedIndex(0);
            ActionListener listener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    block2: {
                        try {
                            HPPDetectedProcessesDlg.this.gehRiskModel.removeAll();
                            HPPDetectedProcessesDlg.this.setData(null);
                        }
                        catch (ConsoleException ex) {
                            ConsoleLogger.log(ex);
                            if (!ex.needRelogin()) break block2;
                            Manager.getFrame().showLoginPanel();
                        }
                    }
                }
            };
            this.gehViewTypeComboBox.addActionListener(listener);
            this.gehAppNameSearchField = new JTextField("*");
            this.gehAppNameSearchField.setColumns(20);
            RestrictedPlainDocument doc = new RestrictedPlainDocument(260);
            doc.setValidator("\"<>|", false);
            this.gehAppNameSearchField.setDocument(doc);
            this.gehAppSearchButton = new JButton(MSGRES.getString(GEH, "HPPDetectedProcessesDlg.button.appsearch"));
            this.gehAppSearchButton.addActionListener(listener);
        }
        newPanel.add(new JLabel(MSGRES.getString(GEH, "HPPDetectedProcessesDlg.viewtype")));
        newPanel.add(this.gehViewTypeComboBox);
        newPanel.add(this.gehAppNameSearchField);
        newPanel.add(this.gehAppSearchButton);
        newPanel.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 20));
        return newPanel;
    }

    public DetectedProcessUIObject[] getSelectedHPPRisks() {
        DetectedProcessUIObject[] tempHPPRisks = this.gehSelectedDetectedProcess == null ? null : (DetectedProcessUIObject[])this.gehSelectedDetectedProcess.clone();
        return tempHPPRisks;
    }

    @Override
    protected void commit() {
        if (this.gehRiskTable == null) {
            return;
        }
        int[] rows = this.gehRiskTable.getSelectedRows();
        this.gehSelectedDetectedProcess = new DetectedProcessUIObject[rows.length];
        OverrideActionCheckboxItem actionItem = (OverrideActionCheckboxItem)this.gehActionComboBox.getSelectedItem();
        for (int i = 0; i < rows.length; ++i) {
            this.gehSelectedDetectedProcess[i] = (DetectedProcessUIObject)this.gehRiskModel.getRow(rows[i]);
            this.gehSelectedDetectedProcess[i].setAction(actionItem.getValue());
        }
    }
}

