/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.override;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.policy.dialog.FolderPrefixGlossaryDialog;
import com.sygate.scm.console.ui.policy.override.PrefixSeparator;
import com.sygate.scm.console.ui.policy.override.logicobject.FileExclusionUIObject;
import com.sygate.scm.console.ui.policy.override.logicobject.PolicyExceptionUIObject;
import com.sygate.scm.console.ui.policy.override.logicobject.SecurityRiskScanCategoryUIObject;
import com.sygate.scm.console.ui.policy.util.PolicyUtil;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.CloudUtil;
import com.sygate.scm.util.ConstantValue;
import com.sygate.scm.util.StringUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class FileExclusionDialog
extends DialogBase {
    private static final long serialVersionUID = -7710913258608949663L;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String GEH = "com.sygate.scm.console.ui.policy.override.override";
    JComboBox<String> gehPrefixComboBox;
    JTextField gehFileNameTextBox;
    String gehFileName;
    ArrayList<String> gehFileList;
    FileExclusionUIObject gehSelectedFileExclusion;
    String gehFilePathNameTobeEdited;
    JLabel riskScanCatLabel = new JLabel(MSGRES.getString("com.sygate.scm.console.ui.policy.override.override", "FileExclusionDialog.label.ScanCat"));
    JComboBox<SecurityRiskScanCategoryUIObject> gehScanCatComboBox = new JComboBox<SecurityRiskScanCategoryUIObject>(SecurityRiskScanCategoryUIObject.values());
    private SecurityRiskScanCategoryUIObject scanCatObj = SecurityRiskScanCategoryUIObject.DEFAULT_CATEGORY_UI_OBJECT;
    JCheckBox gehSecurityRiskBox;
    JCheckBox gehSONARBox;
    JCheckBox gehADCBox;
    private JCheckBox gehACExcludeChildProcessesBox;
    private JLabel excludeChildProcessesLabel;
    private boolean gehACExcludeChildProcesses = false;
    private boolean isCloudEnrolled = CloudUtil.isCloudEnrolled(Manager.getCurrentDomainId()) && CloudUtil.isPolicySyncEnabled(Manager.getCurrentDomainId());
    private boolean isCloudExceptionPolicy = false;
    private boolean isSEPExceptionPolicy = true;

    public FileExclusionDialog(boolean isSBE) {
        super(Manager.getFrame(), MSGRES.getString(GEH, "FileExclusionDialog.title.file"), true);
        this.initialize(false, isSBE);
        this.updateData();
        UiUtilities.centerComponent((Component)this);
    }

    public FileExclusionDialog(boolean isSBE, boolean isCloudExceptionPolicy, boolean isSEPExceptionPolicy) {
        super(Manager.getFrame(), MSGRES.getString(GEH, "FileExclusionDialog.title.file"), true);
        this.isCloudExceptionPolicy = isCloudExceptionPolicy;
        this.isSEPExceptionPolicy = isSEPExceptionPolicy;
        this.initialize(false, isSBE);
        this.updateData();
        UiUtilities.centerComponent((Component)this);
    }

    public FileExclusionDialog(PolicyExceptionUIObject extObj, boolean isReadonly, boolean isSBE, boolean isCloudExceptionPolicy, boolean isSEPExceptionPolicy) {
        super(Manager.getFrame(), MSGRES.getString(GEH, "FileExclusionDialog.title.fileEdit"), true);
        this.isCloudExceptionPolicy = isCloudExceptionPolicy;
        this.isSEPExceptionPolicy = isSEPExceptionPolicy;
        this.gehFilePathNameTobeEdited = this.gehFileName = extObj.getOverride();
        this.scanCatObj = SecurityRiskScanCategoryUIObject.fromInteger(((FileExclusionUIObject)extObj.getRiskData()).getGehScanCategories());
        this.gehACExcludeChildProcesses = ((FileExclusionUIObject)extObj.getRiskData()).isACExcludeChildProcessesApplicable();
        this.initialize(isReadonly, isSBE);
        this.updateData();
        UiUtilities.centerComponent((Component)this);
    }

    private void initialize(boolean isReadonly, boolean isSBE) {
        Container cont = this.getContentPane();
        cont.setLayout(new BorderLayout());
        JPanel newPanel = new JPanel();
        newPanel.setLayout(new BoxLayout(newPanel, 1));
        newPanel.add(new AvTemplatePane(MSGRES.getString(GEH, "FileExclusionDialog.heading.label"), MSGRES.getString(GEH, "FileExclusionDialog.heading.desc")));
        newPanel.add(Box.createVerticalStrut(10));
        newPanel.add(this.getEditPanel(isSBE));
        newPanel.add(Box.createVerticalStrut(10));
        cont.add((Component)newPanel, "Center");
        cont.add((Component)this.getButtonPanel(), "South");
        if (isReadonly) {
            UIUtilities.setContainerStatus(newPanel, false);
            this.resetOKButton(false);
        }
        this.pack();
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_geh_override_add_sro_file";
    }

    private void showScanCatComponents(boolean visible) {
        this.riskScanCatLabel.setVisible(visible);
        this.gehScanCatComboBox.setVisible(visible);
    }

    private void showhACExcludeChildProcessesBox(boolean visible) {
        this.gehACExcludeChildProcessesBox.setVisible(visible);
        this.excludeChildProcessesLabel.setVisible(visible);
    }

    JPanel getEditPanel(boolean isSBE) {
        if (this.gehPrefixComboBox == null) {
            String[] values = ConstantValue.getDirKeys();
            this.gehPrefixComboBox = new JComboBox<String>(values);
            this.gehPrefixComboBox.setSelectedIndex(0);
        }
        JPanel ePanel = new JPanel(new GridBagLayout());
        JLabel pLabel = new JLabel(MSGRES.getString(GEH, "FileExclusionDialog.label.prefixVariable"));
        JLabel fLabel = new JLabel(MSGRES.getString(GEH, "FileExclusionDialog.label.file"));
        if (this.gehFileNameTextBox == null) {
            this.gehFileNameTextBox = new JTextField("", 20);
        }
        RestrictedPlainDocument doc = new RestrictedPlainDocument(1023);
        this.gehFileNameTextBox.setDocument(doc);
        JLabel specifyScansLabel = new JLabel(MSGRES.getString(GEH, "FileExclusionDialog.label.specifyscans"));
        this.gehSecurityRiskBox = new JCheckBox(MSGRES.getString(GEH, "FileExclusionDialog.scantype.securityrisk"));
        this.gehSecurityRiskBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileExclusionDialog.this.showScanCatComponents(FileExclusionDialog.this.gehSecurityRiskBox.isSelected());
            }
        });
        this.gehSONARBox = new JCheckBox(MSGRES.getString(GEH, "FileExclusionDialog.scantype.sonar"));
        this.gehADCBox = new JCheckBox(MSGRES.getString(GEH, "FileExclusionDialog.scantype.applicationcontrol"));
        this.gehADCBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileExclusionDialog.this.showhACExcludeChildProcessesBox(FileExclusionDialog.this.gehADCBox.isSelected());
            }
        });
        this.gehACExcludeChildProcessesBox = new JCheckBox(MSGRES.getString(GEH, "FileExclusionDialog.scantype.applicationcontrol.excludechildprocesses"));
        this.gehACExcludeChildProcessesBox.setVisible(false);
        this.excludeChildProcessesLabel = new JLabel(MSGRES.getString(GEH, "FileExclusionDialog.label.excludechildprocesses"));
        this.excludeChildProcessesLabel.setVisible(false);
        ePanel.add((Component)pLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        ePanel.add(this.gehPrefixComboBox, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        ePanel.add((Component)FolderPrefixGlossaryDialog.createFolderGlossaryButton(), new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        ePanel.add((Component)fLabel, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 0, 0), 0, 0));
        ePanel.add((Component)this.gehFileNameTextBox, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 0, 0), 300, 0));
        ePanel.add((Component)this.gehACExcludeChildProcessesBox, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 0, 0), 0, 0));
        ePanel.add((Component)this.excludeChildProcessesLabel, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 40, 10, 0), 0, 0));
        ePanel.add((Component)specifyScansLabel, new GridBagConstraints(0, 2, 3, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        if (!this.isCloudEnrolled) {
            ePanel.add((Component)this.gehSecurityRiskBox, new GridBagConstraints(0, 4, 3, 1, 0.0, 0.0, 17, 0, new Insets(2, 0, 0, 0), 0, 0));
            ePanel.add((Component)this.gehSONARBox, new GridBagConstraints(0, 5, 3, 1, 0.0, 0.0, 17, 0, new Insets(2, 0, 0, 0), 0, 0));
            ePanel.add((Component)this.gehADCBox, new GridBagConstraints(0, 3, 3, 1, 0.0, 0.0, 17, 0, new Insets(2, 0, 0, 0), 0, 0));
        } else if (this.isCloudExceptionPolicy) {
            ePanel.add((Component)this.gehSecurityRiskBox, new GridBagConstraints(0, 4, 3, 1, 0.0, 0.0, 17, 0, new Insets(2, 0, 0, 0), 0, 0));
            ePanel.add((Component)this.gehSONARBox, new GridBagConstraints(0, 5, 3, 1, 0.0, 0.0, 17, 0, new Insets(2, 0, 0, 0), 0, 0));
        } else if (this.isSEPExceptionPolicy) {
            ePanel.add((Component)this.gehADCBox, new GridBagConstraints(0, 3, 3, 1, 0.0, 0.0, 17, 0, new Insets(2, 0, 0, 0), 0, 0));
        }
        ePanel.add((Component)this.riskScanCatLabel, new GridBagConstraints(3, 4, 2, 1, 0.0, 0.0, 17, 0, new Insets(10, 20, 0, 0), 0, 0));
        ePanel.add(this.gehScanCatComboBox, new GridBagConstraints(3, 5, 2, 1, 0.0, 0.0, 17, 0, new Insets(2, 20, 0, 0), 0, 0));
        ePanel.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 20));
        if (isSBE) {
            this.gehSONARBox.setVisible(false);
            this.gehADCBox.setVisible(false);
        }
        return ePanel;
    }

    private void updateData() {
        if (!StringUtilities.isEmpty((String)this.gehFileName)) {
            PrefixSeparator separator = new PrefixSeparator(this.gehFileName);
            String prefix = separator.getPrefix();
            if (prefix != null && !prefix.equals("")) {
                this.gehPrefixComboBox.setSelectedItem(prefix);
            }
            this.gehFileName = separator.getPath();
            this.gehFileNameTextBox.setText(this.gehFileName);
        }
        this.showScanCatComponents(this.gehSecurityRiskBox.isSelected());
        this.showhACExcludeChildProcessesBox(this.gehADCBox.isSelected());
    }

    boolean inPrefixList(String str) {
        String[] values = ConstantValue.getDirKeys();
        for (int i = 0; i < values.length; ++i) {
            if (!values[i].equals(str)) continue;
            return true;
        }
        return false;
    }

    public String getFileName() {
        return this.gehFileName;
    }

    public void setFileName(String fileName) {
        this.gehFileName = fileName;
    }

    public void setList(ArrayList<String> fileList) {
        this.gehFileList = fileList;
    }

    public FileExclusionUIObject getSelectedFile() {
        return this.gehSelectedFileExclusion;
    }

    @Override
    protected boolean isValidate() {
        this.gehFileName = this.getFileNameText();
        if (this.gehFileName == null || this.gehFileName.trim().length() == 0) {
            JOptionPane.showMessageDialog(this, MSGRES.getString(GEH, "FileExclusionDialog.error.emptyFileName"), MSGRES.getString(GEH, "OverridePolicySelectDlg.error"), 0);
            return false;
        }
        if (!this.validateInputFullCheck(this.gehFileName)) {
            this.gehFileNameTextBox.requestFocus();
            return false;
        }
        String prefix = (String)this.gehPrefixComboBox.getSelectedItem();
        if (!prefix.trim().equalsIgnoreCase(ConstantValue.getDirKeysByIndex((int)0))) {
            this.gehFileName = "%" + prefix.trim() + "%" + this.gehFileName;
        }
        if (this.gehFileList != null && (this.gehFilePathNameTobeEdited == null || !this.gehFilePathNameTobeEdited.equals(this.gehFileName)) && this.isFilePathAlreadyPresent(this.gehFileName)) {
            this.gehFileName = null;
            JOptionPane.showMessageDialog(this, MSGRES.getString(GEH, "FileExclusionDialog.error.alreayUsed"), MSGRES.getString(GEH, "OverridePolicySelectDlg.error"), 0);
            return false;
        }
        if (!(this.gehSecurityRiskBox.isSelected() || this.gehSONARBox.isSelected() || this.gehADCBox.isSelected())) {
            JOptionPane.showMessageDialog(this, MSGRES.getString(GEH, "FileExclusionDialog.error.noProtectionTechnologySelected"), MSGRES.getString(GEH, "OverridePolicySelectDlg.error"), 0);
            return false;
        }
        boolean filePathValid = true;
        String invalidCharacterMsg = "";
        String wildcardsNotAllowedMsg = "";
        if (this.gehFileName.matches(PolicyUtil.getRegex("\"<>|"))) {
            filePathValid = false;
            invalidCharacterMsg = MessageFormat.format(MSGRES.getString(GEH, "FileExclusionDialog.error.invalidCharactersNotAllowed"), "\"<>|");
        }
        if ((this.gehSONARBox.isSelected() || this.gehADCBox.isSelected()) && this.gehFileName.matches(PolicyUtil.getRegex("*?"))) {
            filePathValid = false;
            wildcardsNotAllowedMsg = MSGRES.getString(GEH, "FileExclusionDialog.error.wildCardsNotAllowed");
        }
        if (!filePathValid) {
            JOptionPane.showMessageDialog(this, MessageFormat.format(MSGRES.getString(GEH, "FileExclusionDialog.error.invalidCharactersContainedInFilePath"), invalidCharacterMsg, wildcardsNotAllowedMsg), MSGRES.getString(GEH, "OverridePolicySelectDlg.error"), 0);
            return false;
        }
        return true;
    }

    public void setApplicableScanTypes(String applicableTechnologies) {
        if (applicableTechnologies.indexOf(MSGRES.getString(GEH, "FileExclusionDialog.scantype.applicationcontrol")) >= 0) {
            this.gehADCBox.setSelected(true);
            this.showhACExcludeChildProcessesBox(true);
            this.gehACExcludeChildProcessesBox.setSelected(this.gehACExcludeChildProcesses);
        } else {
            this.gehADCBox.setSelected(false);
        }
        if (applicableTechnologies.indexOf(MSGRES.getString(GEH, "FileExclusionDialog.scantype.sonar")) >= 0) {
            this.gehSONARBox.setSelected(true);
        } else {
            this.gehSONARBox.setSelected(false);
        }
        if (applicableTechnologies.indexOf(MSGRES.getString(GEH, "FileExclusionDialog.scantype.securityrisk")) >= 0) {
            this.gehSecurityRiskBox.setSelected(true);
        } else {
            this.gehSecurityRiskBox.setSelected(false);
        }
        this.gehScanCatComboBox.setSelectedItem((Object)this.scanCatObj);
        this.showScanCatComponents(this.gehSecurityRiskBox.isSelected());
    }

    private boolean isFilePathAlreadyPresent(String filePath) {
        boolean result = false;
        if (null != this.gehFileList) {
            String strTmp = null;
            for (String existingPath : this.gehFileList) {
                strTmp = existingPath;
                if (!strTmp.equals(filePath)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    @Override
    protected void commit() {
        this.gehSelectedFileExclusion = new FileExclusionUIObject(this.getFileNameText(), (String)this.gehPrefixComboBox.getSelectedItem(), ((SecurityRiskScanCategoryUIObject)((Object)this.gehScanCatComboBox.getSelectedItem())).getGehScanCategories());
        if (this.gehSecurityRiskBox.isSelected()) {
            this.gehSelectedFileExclusion.setSecurityRiskApplicable(true);
        } else {
            this.gehSelectedFileExclusion.setSecurityRiskApplicable(false);
        }
        if (this.gehSONARBox.isSelected()) {
            this.gehSelectedFileExclusion.setSonarApplicable(true);
        } else {
            this.gehSelectedFileExclusion.setSonarApplicable(false);
        }
        if (this.gehADCBox.isSelected()) {
            this.gehSelectedFileExclusion.setAdcApplicable(true);
            if (this.gehACExcludeChildProcessesBox.isSelected()) {
                this.gehSelectedFileExclusion.setACExcludeChildProcessesApplicable(true);
            }
        } else {
            this.gehSelectedFileExclusion.setAdcApplicable(false);
            this.gehSelectedFileExclusion.setACExcludeChildProcessesApplicable(false);
        }
    }

    String getFileNameText() {
        String fileName = this.gehFileNameTextBox.getText().trim();
        if (fileName.contains("\\n")) {
            fileName = fileName.replace("\\n", "\\N");
        }
        return fileName;
    }

    boolean isSecurityRiskBoxSelected() {
        return this.gehSecurityRiskBox.isSelected();
    }

    boolean isADCBoxSelected() {
        return this.gehADCBox.isSelected();
    }

    boolean isSONARBoxSelected() {
        return this.gehSONARBox.isSelected();
    }
}

