/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.override;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.ClientAgent;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.policy.override.logicobject.ExtensionExclusionUIObject;
import com.sygate.scm.console.ui.policy.override.logicobject.SecurityRiskScanCategoryUIObject;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.util.StringUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ExtensionExclusionDialog
extends DialogBase {
    private static final long serialVersionUID = 3688389337742222405L;
    private static final int MAX_LENGTH = 4000;
    private static final String EXCLUDE = " <>,:/|.\"\\";
    private static final String GEH = "com.sygate.scm.console.ui.policy.override.override";
    private static final String EXTENSION_SEPERATOR = ",";
    private static final MessageResources MSGRES = MessageResources.getInstance();
    JTextField gehExtensionTextBox;
    String gehExtension;
    private String platformType = "Windows";
    private JPanel extPanel;
    private JButton addExtButton;
    private JButton removeExtButton;
    private DefaultListModel<String> listModel;
    private JList<String> extList;
    private JTextField extField = new JTextField(8);
    JLabel riskScanCatLabel = new JLabel(MSGRES.getString("com.sygate.scm.console.ui.policy.override.override", "ExtensionExclusionDialog.label.ScanCat"));
    JComboBox<SecurityRiskScanCategoryUIObject> gehScanCatComboBox = new JComboBox<SecurityRiskScanCategoryUIObject>(SecurityRiskScanCategoryUIObject.values());
    private SecurityRiskScanCategoryUIObject scanCatObj = SecurityRiskScanCategoryUIObject.DEFAULT_CATEGORY_UI_OBJECT;

    public ExtensionExclusionDialog() {
        super(Manager.getFrame(), MSGRES.getString(GEH, "ExtensionExclusionDialog.title"), true);
        this.initialize(false);
        this.updateData();
        this.pack();
        UiUtilities.centerComponent((Component)this);
    }

    public ExtensionExclusionDialog(String platformType) {
        this();
        this.platformType = platformType;
    }

    public ExtensionExclusionDialog(ExtensionExclusionUIObject extUO, boolean isReadonly) {
        super(Manager.getFrame(), MSGRES.getString(GEH, "ExtensionExclusionDialog.titleEdit"), true);
        this.gehExtension = extUO.getExtensionExclusion();
        this.scanCatObj = SecurityRiskScanCategoryUIObject.fromInteger(extUO.getGehScanCategories());
        this.initialize(isReadonly);
        this.updateData();
        this.pack();
        UiUtilities.centerComponent((Component)this);
    }

    public ExtensionExclusionDialog(ExtensionExclusionUIObject extUO, boolean isReadonly, String platformType) {
        this(extUO, isReadonly);
        this.platformType = platformType;
    }

    public void updateControls() {
        this.removeExtButton.setEnabled(this.extList.getSelectedValuesList().toArray().length > 0);
    }

    public String generateExtensionString(List<String> list) {
        StringBuffer extString = new StringBuffer();
        int count = list.size();
        for (int i = 0; i < count; ++i) {
            extString.append(list.get(i).toString()).append(EXTENSION_SEPERATOR);
        }
        String appendedString = extString.toString();
        if (count > 0) {
            appendedString = extString.substring(0, extString.length() - 1);
        }
        return appendedString;
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_geh_override_add_sro_ext";
    }

    @Override
    protected boolean isValidate() {
        this.gehExtension = this.generateExtensionString(this.getSelectedExtensionList());
        if (this.gehExtension.length() == 0) {
            JOptionPane.showMessageDialog(this, MSGRES.getString(GEH, "ExtensionExclusionDialog.error.noActiveSelection"), MSGRES.getString(GEH, "OverridePolicySelectDlg.error"), 0);
            return false;
        }
        if (this.gehExtension.length() > 4000) {
            JOptionPane.showMessageDialog(this, MSGRES.getString(GEH, "ExtensionExclusionDialog.error.maxLength"), MSGRES.getString(GEH, "OverridePolicySelectDlg.error"), 0);
            return false;
        }
        return true;
    }

    private void initialize(boolean isReadonly) {
        Container cont = this.getContentPane();
        cont.setLayout(new BorderLayout());
        RestrictedPlainDocument doc = new RestrictedPlainDocument(3999);
        doc.setValidator(EXCLUDE, false);
        this.extField.setDocument(doc);
        this.extField.addKeyListener(new extensionTextKeyListener());
        JPanel newPanel = new JPanel(new GridBagLayout());
        newPanel.add((Component)new AvTemplatePane(MSGRES.getString(GEH, "ExtensionExclusionDialog.heading.label"), MSGRES.getString(GEH, "ExtensionExclusionDialog.heading.desc")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        newPanel.add((Component)this.getExtensionPanel(), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        newPanel.add((Component)this.riskScanCatLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 0, 0), 0, 0));
        newPanel.add(this.gehScanCatComboBox, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 0, 0), 0, 0));
        cont.add((Component)newPanel, "Center");
        cont.add((Component)this.getButtonPanel(), "South");
        if (isReadonly) {
            UIUtilities.setContainerStatus(newPanel, false);
            this.resetOKButton(false);
        }
    }

    private void updateData() {
        this.listModel.removeAllElements();
        List<String> activeList = ExtensionExclusionDialog.convertExtStringToList(this.gehExtension);
        for (int i = 0; i < activeList.size(); ++i) {
            if (activeList.get(i) == null) continue;
            this.listModel.addElement(activeList.get(i));
        }
        this.gehScanCatComboBox.setSelectedItem((Object)this.scanCatObj);
    }

    private static List<String> convertExtStringToList(String extString) {
        ArrayList<String> extList = new ArrayList<String>();
        if (!StringUtilities.isEmpty((String)extString)) {
            StringTokenizer st = new StringTokenizer(extString, EXTENSION_SEPERATOR);
            while (st.hasMoreTokens()) {
                String ext = st.nextToken();
                extList.add(ext.trim());
            }
        }
        return extList;
    }

    private JList<String> getExtensionList() {
        if (this.extList == null) {
            this.listModel = new DefaultListModel();
            this.extList = new JList<String>(this.listModel);
            this.extList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    ExtensionExclusionDialog.this.updateControls();
                }
            });
        }
        return this.extList;
    }

    private void handleAddAction() {
        String newExt = this.extField.getText().trim();
        if (newExt.length() <= 0) {
            return;
        }
        if (this.listModel.contains(newExt)) {
            JOptionPane.showMessageDialog(null, MSGRES.getString(GEH, "ExtensionExclusionDialog.error.nodupext"), MSGRES.getString(GEH, "ExtensionExclusionDialog.error.dupext"), 0);
            return;
        }
        if (this.isFound(newExt)) {
            JOptionPane.showMessageDialog(null, MSGRES.getString(GEH, "ExtensionExclusionDialog.error.nodupext"), MSGRES.getString(GEH, "ExtensionExclusionDialog.error.dupext"), 0);
            return;
        }
        if (!this.isValid(newExt)) {
            JOptionPane.showMessageDialog(null, MSGRES.getString(GEH, "ExtensionExclusionDialog.error.noInvalidExt"), MSGRES.getString(GEH, "ExtensionExclusionDialog.error.invalidExt"), 0);
            return;
        }
        this.listModel.add(0, newExt);
        this.extField.setText("");
        if (!AjaxSwingCommonUtil.isAjaxSwingRunning()) {
            this.addExtButton.setEnabled(false);
        } else {
            ClientAgent.getCurrentInstance().getHTMLPage().setComponentDirty((Component)this.extField, true);
        }
    }

    private boolean isFound(String newExt) {
        Object[] arExt = new String[this.listModel.size()];
        this.listModel.copyInto(arExt);
        for (int index = 0; index < arExt.length; ++index) {
            if (!newExt.equals(arExt[index])) continue;
            return true;
        }
        return false;
    }

    private boolean isValid(String newExt) {
        return !"Windows".equals(this.platformType) || !newExt.contains("*") || newExt.indexOf("*") == newExt.length() - 1;
    }

    private JButton getAddButton() {
        if (this.addExtButton == null) {
            this.addExtButton = new JButton(MSGRES.getString(GEH, "ExtensionExclusionDialog.addButton"));
            this.addExtButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExtensionExclusionDialog.this.handleAddAction();
                }
            });
        }
        return this.addExtButton;
    }

    private JButton getRemoveExtButton() {
        if (this.removeExtButton == null) {
            this.removeExtButton = new JButton(MSGRES.getString(GEH, "ExtensionExclusionDialog.removeButton"));
            this.removeExtButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Object[] selected = ExtensionExclusionDialog.this.extList.getSelectedValuesList().toArray();
                    if (selected.length < 1) {
                        return;
                    }
                    for (int i = 0; i < selected.length; ++i) {
                        ExtensionExclusionDialog.this.listModel.removeElement(selected[i]);
                    }
                }
            });
        }
        return this.removeExtButton;
    }

    private JPanel getExtensionPanel() {
        if (this.extPanel == null) {
            this.extPanel = new JPanel(new GridBagLayout());
            this.extPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createTitledBorder(MSGRES.getString(GEH, "ExtensionExclusionDialog.extPanel.title"))));
            JPanel contentPanel = new JPanel(new GridBagLayout());
            contentPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 10));
            JScrollPane jsp = new JScrollPane();
            UiUtilities.setupScrollPane((JScrollPane)jsp, this.getExtensionList());
            jsp.setMinimumSize(new Dimension(250, 150));
            jsp.setPreferredSize(new Dimension(250, 150));
            contentPanel.add((Component)jsp, new GridBagConstraints(0, 0, 1, 2, 0.5, 1.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
            contentPanel.add((Component)this.getRemoveExtButton(), new GridBagConstraints(1, 0, 1, 1, 0.25, 0.0, 10, 0, new Insets(5, 10, 0, 0), 0, 0));
            this.extField.setPreferredSize(new Dimension((int)jsp.getPreferredSize().getWidth(), (int)this.extField.getPreferredSize().getHeight()));
            contentPanel.add((Component)this.extField, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
            contentPanel.add((Component)this.getAddButton(), new GridBagConstraints(1, 2, 1, 1, 0.25, 1.0, 10, 0, new Insets(5, 10, 0, 0), 0, 0));
            this.extPanel.add((Component)contentPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 5, 0, 0), 0, 0));
            UIUtilities.fitJComponent(new JButton[]{this.getRemoveExtButton(), this.getAddButton()});
        }
        this.getRemoveExtButton().setEnabled(false);
        if (!AjaxSwingCommonUtil.isAjaxSwingRunning()) {
            this.getAddButton().setEnabled(false);
        }
        return this.extPanel;
    }

    private List<String> getSelectedExtensionList() {
        ArrayList<String> extList = new ArrayList<String>();
        for (int i = 0; i < this.listModel.size(); ++i) {
            String o = this.listModel.getElementAt(i);
            if (extList.contains(o)) continue;
            extList.add(this.listModel.getElementAt(i));
        }
        return extList;
    }

    public String getExtension() {
        return this.gehExtension;
    }

    public ExtensionExclusionUIObject getExtensionExclusionUIObject() {
        return new ExtensionExclusionUIObject(this.gehExtension, ((SecurityRiskScanCategoryUIObject)((Object)this.gehScanCatComboBox.getSelectedItem())).getGehScanCategories());
    }

    private class extensionTextKeyListener
    extends KeyAdapter {
        private extensionTextKeyListener() {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (e.getSource() == ExtensionExclusionDialog.this.extField) {
                if (ExtensionExclusionDialog.this.extField.getText().length() > 0) {
                    ExtensionExclusionDialog.this.addExtButton.setEnabled(true);
                } else {
                    ExtensionExclusionDialog.this.addExtButton.setEnabled(false);
                }
            }
        }
    }
}

