/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.override;

import com.sygate.scm.common.configobject.schema.PolicyOverride;
import com.sygate.scm.common.configobject.schema.SourceInfo;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.util.CloudUtil;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class EndpointRestrictionsPanel
extends JPanel
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = -6913884199935806154L;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String GEH = "com.sygate.scm.console.ui.policy.override.override";
    JCheckBox lockKnownRisk;
    JCheckBox lockExtension;
    JCheckBox lockFile;
    JCheckBox lockDirectory;
    JCheckBox lockDirForSecurityRisk;
    JCheckBox lockDirForTruScan;
    JCheckBox lockDetectedProcesses;
    JCheckBox lockUrlDomain;
    JCheckBox lockCertificate;
    JCheckBox lockDnsHostFileChange;
    JPanel locksPanel;
    private PolicyOverride gehPolicyOverride;
    public boolean isCloudEnrolled = CloudUtil.isCloudEnrolled(Manager.getCurrentDomainId()) && CloudUtil.isPolicySyncEnabled(Manager.getCurrentDomainId());
    private boolean isCloudExceptionPolicy = false;
    private boolean isSepExceptionPolicy = !this.isCloudExceptionPolicy;

    public EndpointRestrictionsPanel() {
        this.initialize();
    }

    void initialize() {
        if (this.gehPolicyOverride != null) {
            Vector sources = this.gehPolicyOverride.getSourceInfo();
            for (SourceInfo sourceInfo : sources) {
                if (sourceInfo.getOptexclusiveEdit() == null || !sourceInfo.getOptexclusiveEdit().booleanValue()) continue;
                this.isCloudExceptionPolicy = true;
                this.isSepExceptionPolicy = !this.isCloudExceptionPolicy;
            }
        }
        JPanel newPanel = new JPanel();
        BoxLayout layout = new BoxLayout(newPanel, 1);
        newPanel.setLayout(layout);
        newPanel.add(new AvTemplatePane(MSGRES.getString(GEH, "EndpointRestrictionsPanel.title"), MSGRES.getString(GEH, "EndpointRestrictionsPanel.description")));
        newPanel.add(Box.createVerticalStrut(5));
        newPanel.add(this.getLocksPanel());
        newPanel.add(Box.createVerticalStrut(5));
        this.setLayout(new BorderLayout());
        this.add((Component)newPanel, "North");
    }

    JPanel getLocksPanel() {
        this.createLocks();
        this.locksPanel = new JPanel(new GridBagLayout());
        int gridyPos = 0;
        boolean isNotCloudEnrolledOrCloudPolicy = !this.isCloudEnrolled || this.isCloudEnrolled && this.isCloudExceptionPolicy;
        boolean isNotCloudEnrolledOrSepPolicy = !this.isCloudEnrolled || this.isCloudEnrolled && this.isSepExceptionPolicy;
        this.locksPanel.add((Component)new JLabel(MSGRES.getString(GEH, "EndpointRestrictionsPanel.choiceDescLabel")), new GridBagConstraints(0, gridyPos++, 0, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
        if (isNotCloudEnrolledOrCloudPolicy) {
            this.locksPanel.add((Component)this.lockDetectedProcesses, new GridBagConstraints(0, gridyPos++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
        if (isNotCloudEnrolledOrSepPolicy) {
            this.locksPanel.add((Component)this.lockExtension, new GridBagConstraints(0, gridyPos++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
        if (isNotCloudEnrolledOrCloudPolicy) {
            this.locksPanel.add((Component)this.lockFile, new GridBagConstraints(0, gridyPos++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.locksPanel.add((Component)this.lockDirectory, new GridBagConstraints(0, gridyPos++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.locksPanel.add((Component)this.lockDirForSecurityRisk, new GridBagConstraints(0, gridyPos++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 0, 0), 0, 0));
            this.locksPanel.add((Component)this.lockDirForTruScan, new GridBagConstraints(0, gridyPos++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 0, 0), 0, 0));
        }
        if (isNotCloudEnrolledOrSepPolicy) {
            this.locksPanel.add((Component)this.lockKnownRisk, new GridBagConstraints(0, gridyPos++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
        if (isNotCloudEnrolledOrCloudPolicy) {
            this.locksPanel.add((Component)this.lockUrlDomain, new GridBagConstraints(0, gridyPos++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
        if (isNotCloudEnrolledOrSepPolicy && !LicenseObject.getInstance().isSBProduct()) {
            this.locksPanel.add((Component)this.lockDnsHostFileChange, new GridBagConstraints(0, gridyPos++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
        if (isNotCloudEnrolledOrCloudPolicy) {
            this.locksPanel.add((Component)this.lockCertificate, new GridBagConstraints(0, gridyPos++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.locksPanel.setBorder(BorderFactory.createEmptyBorder(10, 20, 0, 0));
        return this.locksPanel;
    }

    void createLocks() {
        this.lockKnownRisk = new JCheckBox(MSGRES.getString(GEH, "EndpointRestrictionsPanel.KnownRisk"));
        this.lockExtension = new JCheckBox(MSGRES.getString(GEH, "EndpointRestrictionsPanel.Extension"));
        this.lockFile = new JCheckBox(MSGRES.getString(GEH, "EndpointRestrictionsPanel.File"));
        this.lockDirectory = new JCheckBox(MSGRES.getString(GEH, "EndpointRestrictionsPanel.Directory"));
        this.lockDirectory.addActionListener(event -> this.setDirectoryExceptionLocks());
        this.lockDirForSecurityRisk = new JCheckBox(MSGRES.getString(GEH, "EndpointRestrictionsPanel.DirForSecurityRisk"));
        this.lockDirForSecurityRisk.addActionListener(event -> this.updateLockDirectory());
        this.lockDirForTruScan = new JCheckBox(MSGRES.getString(GEH, "EndpointRestrictionsPanel.DirForTruScan"));
        this.lockDirForTruScan.addActionListener(event -> this.updateLockDirectory());
        this.lockDetectedProcesses = new JCheckBox(MSGRES.getString(GEH, "EndpointRestrictionsPanel.ProactiveThreatProtectionOverride"));
        this.lockUrlDomain = new JCheckBox(MSGRES.getString(GEH, "EndpointRestrictionsPanel.Domain"));
        this.lockDnsHostFileChange = new JCheckBox(MSGRES.getString(GEH, "EndpointRestrictionsPanel.DnsOrHostFileChange"));
        this.lockCertificate = new JCheckBox(MSGRES.getString(GEH, "EndpointRestrictionsPanel.Certificate"));
    }

    void updateLockDirectory() {
        this.lockDirectory.setSelected(this.lockDirForSecurityRisk.isSelected() || this.lockDirForTruScan.isSelected());
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_geh_endpointres";
    }

    public void setPolicyOverride(PolicyOverride policyOverride) throws ConsoleException {
        block2: {
            this.gehPolicyOverride = policyOverride;
            try {
                ConsoleLogger.log("Updating EndpointRestrictionsPanel");
                this.removeAll();
                this.initialize();
                this.validate();
                this.repaint();
                ConsoleLogger.log("Updating EndpointRestrictionsPanel done");
                this.updateValues();
            }
            catch (ConsoleException ex) {
                LoggerUtilities.logException((Throwable)ex);
                if (!ex.needRelogin()) break block2;
                Manager.getFrame().showLoginPanel();
            }
        }
    }

    void setDirectoryExceptionLocks() {
        boolean state = this.lockDirectory.isSelected();
        this.lockDirForSecurityRisk.setSelected(state);
        this.lockDirForTruScan.setSelected(state);
    }

    protected void updateValues() throws ConsoleException {
        if (this.gehPolicyOverride.getOptLockKnownRisk() != null) {
            this.lockKnownRisk.setSelected(this.gehPolicyOverride.getOptLockKnownRisk() == false);
        }
        if (this.gehPolicyOverride.getOptLockFile() != null) {
            this.lockFile.setSelected(this.gehPolicyOverride.getOptLockFile() == false);
        }
        if (this.gehPolicyOverride.getOptLockExtension() != null) {
            this.lockExtension.setSelected(this.gehPolicyOverride.getOptLockExtension() == false);
        }
        if (this.gehPolicyOverride.getOptLockDirectory() != null) {
            this.lockDirForSecurityRisk.setSelected(this.gehPolicyOverride.getOptLockDirectory() == false);
        }
        if (this.gehPolicyOverride.getOptLockDirectoryForTruScan() != null) {
            this.lockDirForTruScan.setSelected(this.gehPolicyOverride.getOptLockDirectoryForTruScan() == false);
        }
        this.lockDirectory.setSelected(this.lockDirForSecurityRisk.isSelected() || this.lockDirForTruScan.isSelected());
        if (this.gehPolicyOverride.getOptLockDetectedProcesses() != null) {
            this.lockDetectedProcesses.setSelected(this.gehPolicyOverride.getOptLockDetectedProcesses() == false);
        }
        if (this.gehPolicyOverride.getOptLockURLDomain() != null) {
            this.lockUrlDomain.setSelected(this.gehPolicyOverride.getOptLockURLDomain() == false);
        }
        if (this.gehPolicyOverride.getOptLockCertificate() != null) {
            this.lockCertificate.setSelected(this.gehPolicyOverride.getOptLockCertificate() == false);
        }
        if (this.gehPolicyOverride != null) {
            boolean select = false;
            select = this.gehPolicyOverride.getOptLockDnsOrHostFileChange() != null ? this.gehPolicyOverride.getOptLockDnsOrHostFileChange().booleanValue() : this.gehPolicyOverride.getDefLockDnsOrHostFileChange().booleanValue();
            this.lockDnsHostFileChange.setSelected(!select);
        }
    }

    public void save() throws ConsoleException {
        this.gehPolicyOverride.setOptLockDetectedProcesses(Boolean.valueOf(!this.lockDetectedProcesses.isSelected()));
        this.gehPolicyOverride.setOptLockKnownRisk(Boolean.valueOf(!this.lockKnownRisk.isSelected()));
        this.gehPolicyOverride.setOptLockFile(Boolean.valueOf(!this.lockFile.isSelected()));
        this.gehPolicyOverride.setOptLockExtension(Boolean.valueOf(!this.lockExtension.isSelected()));
        this.gehPolicyOverride.setOptLockDirectory(Boolean.valueOf(!this.lockDirForSecurityRisk.isSelected()));
        this.gehPolicyOverride.setOptLockDirectoryForTruScan(Boolean.valueOf(!this.lockDirForTruScan.isSelected()));
        this.gehPolicyOverride.setOptLockURLDomain(Boolean.valueOf(!this.lockUrlDomain.isSelected()));
        this.gehPolicyOverride.setOptLockDnsOrHostFileChange(Boolean.valueOf(!this.lockDnsHostFileChange.isSelected()));
        this.gehPolicyOverride.setOptLockCertificate(Boolean.valueOf(!this.lockCertificate.isSelected()));
    }

    public void setReadOnly() {
        this.lockKnownRisk.setEnabled(false);
        this.lockExtension.setEnabled(false);
        this.lockFile.setEnabled(false);
        this.lockDirectory.setEnabled(false);
        this.lockDirForSecurityRisk.setEnabled(false);
        this.lockDirForTruScan.setEnabled(false);
        this.lockDetectedProcesses.setEnabled(false);
        this.lockUrlDomain.setEnabled(false);
        this.lockCertificate.setEnabled(false);
    }
}

