/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.override;

import com.sygate.scm.common.configobject.schema.DirectoryOverride;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.policy.dialog.FolderPrefixGlossaryDialog;
import com.sygate.scm.console.ui.policy.override.PrefixSeparator;
import com.sygate.scm.console.ui.policy.override.logicobject.DirectoryExclusionUIObject;
import com.sygate.scm.console.ui.policy.override.logicobject.PolicyExceptionUIObject;
import com.sygate.scm.console.ui.policy.override.logicobject.SecurityRiskScanCategoryUIObject;
import com.sygate.scm.console.ui.policy.util.PolicyUtil;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.CloudUtil;
import com.sygate.scm.console.util.Env;
import com.sygate.scm.util.ConstantValue;
import com.sygate.scm.util.StringUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class DirectoryExclusionDialog
extends DialogBase {
    private String gehPlatform = MSGRES.getString("com.sygate.scm.console.ui.policy.override.override", "OverridePanel.platform.windows");
    private static final long serialVersionUID = 7940420884599458908L;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String GEH = "com.sygate.scm.console.ui.policy.override.override";
    private static final String LINUX_FILESEPARATOR = "/";
    private static final int SCANTYP_SECURITYRISK_INDEX = 0;
    private static final int SCANTYP_TRUSCAN_INDEX = 1;
    private static final int SCANTYP_ALL_INDEX = 3;
    private static final int SCANTYP_ADC_INDEX = 2;
    private static final int SBE_SCANTYP_SECURITYRISK_INDEX = 0;
    private static final int SBE_SCANTYP_TRUSCAN_INDEX = 1;
    private static final int SBE_SCANTYP_ALL_INDEX = 2;
    private static final int CLOUDENROLLED_SEP_SCANTYP_ADC_INDEX = 0;
    private boolean isCloudEnrolled = CloudUtil.isCloudEnrolled(Manager.getCurrentDomainId()) && CloudUtil.isPolicySyncEnabled(Manager.getCurrentDomainId());
    private boolean isCloudExceptionPolicy = false;
    private boolean isSEPExceptionPolicy = true;
    private static String[] scanTypesCloud = new String[]{MSGRES.getString("com.sygate.scm.console.ui.policy.override.override", "DirectoryExclusionDialog.scanType.applicationControl")};
    private static String[] scanTypes = new String[]{MSGRES.getString("com.sygate.scm.console.ui.policy.override.override", "DirectoryExclusionDialog.scanType.securityRisk"), MSGRES.getString("com.sygate.scm.console.ui.policy.override.override", "DirectoryExclusionDialog.scanType.truScan"), MSGRES.getString("com.sygate.scm.console.ui.policy.override.override", "DirectoryExclusionDialog.scanType.applicationControl"), MSGRES.getString("com.sygate.scm.console.ui.policy.override.override", "DirectoryExclusionDialog.scanType.all")};
    private static String[] scanTypesSB = new String[]{MSGRES.getString("com.sygate.scm.console.ui.policy.override.override", "DirectoryExclusionDialog.scanType.securityRisk"), MSGRES.getString("com.sygate.scm.console.ui.policy.override.override", "DirectoryExclusionDialog.scanType.truScan"), MSGRES.getString("com.sygate.scm.console.ui.policy.override.override", "DirectoryExclusionDialog.scanType.all")};
    JComboBox<String> gehPrefixComboBox;
    JComboBox<String> gehScanTypeComboBox;
    JLabel riskScanCatLabel = new JLabel(MSGRES.getString("com.sygate.scm.console.ui.policy.override.override", "DirectoryExclusionDialog.label.ScanCat"));
    JLabel exampleLabel = new JLabel(MSGRES.getString("com.sygate.scm.console.ui.policy.override.override", "DirectoryExclusionDialog.label.exampleLabel"));
    JLabel linuxexampleLabel = new JLabel(MSGRES.getString("com.sygate.scm.console.ui.policy.override.override", "DirectoryExclusionDialog.label.linux.exampleLabel"));
    JComboBox<SecurityRiskScanCategoryUIObject> gehScanCatComboBox = new JComboBox<SecurityRiskScanCategoryUIObject>(SecurityRiskScanCategoryUIObject.values());
    private SecurityRiskScanCategoryUIObject scanCatObj = SecurityRiskScanCategoryUIObject.DEFAULT_CATEGORY_UI_OBJECT;
    JTextField gehFileNameTextBox;
    JCheckBox gehExcludeCheckBox;
    JLabel gehExcludeLinuxIcon;
    String gehDirectoryName;
    DirectoryOverride dOver = new DirectoryOverride();
    boolean gehExcludeSubdirectories = this.dOver.getDefExcludeSubDirectories();
    int gehScanType = DirectoryExclusionUIObject.SECURITY_RISK;
    ArrayList<String> gehFileList;
    HashMap<String, ArrayList<String>> gehFileMap;
    HashMap<String, ArrayList<String>> gehFileLinuxMap;
    DirectoryExclusionUIObject gehSelectedDirectoryExclusion;
    String gehFilePathNameTobeEdited;
    String gehExtensionList;
    ArrayList<String> gehAddedExtensionExclusionMap;

    public DirectoryExclusionDialog(String platform) {
        super(Manager.getFrame(), MSGRES.getString(GEH, "DirectoryExclusionDialog.title.add"), true);
        this.gehPlatform = platform;
        this.initialize(false);
        this.updateData();
        this.pack();
        UiUtilities.centerComponent((Component)this);
    }

    public DirectoryExclusionDialog(String platform, boolean isCloudExceptionPolicy, boolean isSEPExceptionPolicy) {
        super(Manager.getFrame(), MSGRES.getString(GEH, "DirectoryExclusionDialog.title.add"), true);
        this.isCloudExceptionPolicy = isCloudExceptionPolicy;
        this.isSEPExceptionPolicy = isSEPExceptionPolicy;
        this.gehPlatform = platform;
        this.initialize(false);
        this.updateData();
        this.pack();
        UiUtilities.centerComponent((Component)this);
    }

    public DirectoryExclusionDialog(PolicyExceptionUIObject exObj, boolean isReadonly, String platform) {
        super(Manager.getFrame(), MSGRES.getString(GEH, "DirectoryExclusionDialog.title.edit"), true);
        this.gehPlatform = platform;
        this.gehFilePathNameTobeEdited = this.gehDirectoryName = exObj.getOverride();
        this.gehExtensionList = ((DirectoryExclusionUIObject)exObj.getRiskData()).getExtensionList();
        this.gehExcludeSubdirectories = ((DirectoryExclusionUIObject)exObj.getRiskData()).getExcludeSubdirectory();
        this.gehScanType = ((DirectoryExclusionUIObject)exObj.getRiskData()).getScanType();
        this.scanCatObj = SecurityRiskScanCategoryUIObject.fromInteger(((DirectoryExclusionUIObject)exObj.getRiskData()).getGehScanCategories());
        this.initialize(isReadonly);
        this.updateData();
        this.pack();
        UiUtilities.centerComponent((Component)this);
    }

    public DirectoryExclusionDialog(PolicyExceptionUIObject exObj, boolean isReadonly, String platform, boolean isCloudExceptionPolicy, boolean isSEPExceptionPolicy) {
        super(Manager.getFrame(), MSGRES.getString(GEH, "DirectoryExclusionDialog.title.edit"), true);
        this.isCloudExceptionPolicy = isCloudExceptionPolicy;
        this.isSEPExceptionPolicy = isSEPExceptionPolicy;
        this.gehPlatform = platform;
        this.gehFilePathNameTobeEdited = this.gehDirectoryName = exObj.getOverride();
        this.gehExtensionList = ((DirectoryExclusionUIObject)exObj.getRiskData()).getExtensionList();
        this.gehExcludeSubdirectories = ((DirectoryExclusionUIObject)exObj.getRiskData()).getExcludeSubdirectory();
        this.gehScanType = ((DirectoryExclusionUIObject)exObj.getRiskData()).getScanType();
        this.scanCatObj = SecurityRiskScanCategoryUIObject.fromInteger(((DirectoryExclusionUIObject)exObj.getRiskData()).getGehScanCategories());
        this.initialize(isReadonly);
        this.updateData();
        this.pack();
        UiUtilities.centerComponent((Component)this);
    }

    private void initialize(boolean isReadonly) {
        if (this.gehAddedExtensionExclusionMap == null) {
            this.gehAddedExtensionExclusionMap = new ArrayList();
        }
        Container cont = this.getContentPane();
        cont.setLayout(new BorderLayout());
        JPanel newPanel = new JPanel();
        newPanel.setLayout(new BoxLayout(newPanel, 1));
        newPanel.add(new AvTemplatePane(MSGRES.getString(GEH, "DirectoryExclusionDialog.heading.label"), MSGRES.getString(GEH, "DirectoryExclusionDialog.heading.desc")));
        newPanel.add(Box.createVerticalStrut(10));
        newPanel.add(this.getEditPanel());
        newPanel.add(Box.createVerticalStrut(10));
        cont.add((Component)newPanel, "Center");
        cont.add((Component)this.getButtonPanel(), "South");
        if (isReadonly) {
            UIUtilities.setContainerStatus(newPanel, false);
            this.resetOKButton(false);
        }
    }

    @Override
    public String getContentSensitiveHelpToken() {
        if (PolicyExceptionUIObject.PLATFORM_LINUX.equals(this.gehPlatform)) {
            return "linux_sesm_policies_dialog_geh_override_add_sro_dir";
        }
        return "sesm_policies_dialog_geh_override_add_sro_dir";
    }

    void updateData() {
        if (!StringUtilities.isEmpty((String)this.gehDirectoryName) || Env.isUnitTest()) {
            String prefix;
            if (StringUtilities.isEmpty((String)this.gehDirectoryName) && Env.isUnitTest()) {
                this.gehDirectoryName = "TestDirectory" + System.currentTimeMillis();
            }
            PrefixSeparator separator = new PrefixSeparator(this.gehDirectoryName);
            if (PolicyExceptionUIObject.PLATFORM_LINUX.equals(this.gehPlatform)) {
                separator = new PrefixSeparator(this.gehDirectoryName, ConstantValue.getLinuxDirKeys());
            }
            if ((prefix = separator.getPrefix()) != null && !prefix.equals("")) {
                this.gehPrefixComboBox.setSelectedItem(prefix);
            }
            this.gehDirectoryName = separator.getPath();
            this.gehFileNameTextBox.setText(this.gehDirectoryName);
        }
        this.gehExcludeCheckBox.setSelected(!this.gehExcludeSubdirectories);
        this.gehScanTypeComboBox.setSelectedIndex(this.getIndexFromScantype(this.gehScanType));
        this.showScanCatComponents(this.isShowScanCatComponents());
        this.gehScanCatComboBox.setSelectedItem((Object)this.scanCatObj);
    }

    private boolean isShowScanCatComponents() {
        if (PolicyExceptionUIObject.PLATFORM_LINUX.equals(this.gehPlatform)) {
            return true;
        }
        boolean showScanCatComponents = false;
        showScanCatComponents = this.isCloudEnrolled && this.isSEPExceptionPolicy ? false : this.gehScanTypeComboBox.getSelectedIndex() == 0;
        return showScanCatComponents;
    }

    private void showScanCatComponents(boolean visible) {
        this.riskScanCatLabel.setVisible(visible);
        this.gehScanCatComboBox.setVisible(visible);
    }

    private void changeExampleLabel() {
        boolean isNoneSelected;
        boolean bl = isNoneSelected = this.gehPrefixComboBox.getSelectedIndex() == 0;
        if (isNoneSelected) {
            this.linuxexampleLabel.setVisible(false);
            this.exampleLabel.setVisible(true);
        } else {
            this.linuxexampleLabel.setVisible(true);
            this.exampleLabel.setVisible(false);
        }
    }

    private JPanel getEditPanel() {
        if (this.gehPrefixComboBox == null) {
            String[] values = ConstantValue.getDirKeys();
            if (PolicyExceptionUIObject.PLATFORM_LINUX.equals(this.gehPlatform)) {
                values = ConstantValue.getLinuxDirKeys();
            }
            this.gehPrefixComboBox = new JComboBox<String>(values);
            if (PolicyExceptionUIObject.PLATFORM_LINUX.equals(this.gehPlatform)) {
                this.gehPrefixComboBox.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DirectoryExclusionDialog.this.changeExampleLabel();
                    }
                });
            }
            this.gehPrefixComboBox.setSelectedIndex(0);
        }
        if (this.gehExcludeCheckBox == null) {
            this.gehExcludeCheckBox = new JCheckBox(MSGRES.getString(GEH, "DirectoryExclusionDialog.checkbox.excludeSubdirectories"));
            if (PolicyExceptionUIObject.PLATFORM_LINUX.equals(this.gehPlatform)) {
                this.gehExcludeLinuxIcon = new JLabel(UIUtilities.DEPRECATED_LINUX_ICON);
                this.gehExcludeLinuxIcon.setToolTipText(UIUtilities.NOT_SUPPORTED_ON_NEW_LINUX_TIP);
            }
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (DirectoryExclusionDialog.this.gehExcludeCheckBox.isSelected()) {
                        int nRet = UIUtilities.confirmYesNoOptionDialog(MSGRES.getString(DirectoryExclusionDialog.GEH, "DirectoryExclusionDialog.excludeSubdirectoriesWarning"), MSGRES.getString(DirectoryExclusionDialog.GEH, "DirectoryExclusionDialog.excludeSubdirectoriesConfirmDialog.title"));
                        if (0 == nRet) {
                            DirectoryExclusionDialog.this.gehExcludeCheckBox.setSelected(true);
                        } else {
                            DirectoryExclusionDialog.this.gehExcludeCheckBox.setSelected(false);
                        }
                    }
                }
            };
            this.gehExcludeCheckBox.addActionListener(actionListener);
        }
        if (this.gehScanTypeComboBox == null) {
            this.gehScanTypeComboBox = LicenseObject.getInstance().isSBProduct() ? new JComboBox<String>(scanTypesSB) : (!this.isCloudEnrolled || PolicyExceptionUIObject.PLATFORM_LINUX.equals(this.gehPlatform) ? new JComboBox<String>(scanTypes) : (this.isSEPExceptionPolicy ? new JComboBox<String>(scanTypesCloud) : (this.isCloudExceptionPolicy ? new JComboBox<String>(scanTypesSB) : new JComboBox<String>(scanTypes))));
            this.gehScanTypeComboBox.setSelectedIndex(this.getIndexFromScantype(DirectoryExclusionUIObject.SECURITY_RISK));
            this.gehScanTypeComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DirectoryExclusionDialog.this.showScanCatComponents(DirectoryExclusionDialog.this.isShowScanCatComponents());
                }
            });
        }
        JPanel ePanel = new JPanel(new GridBagLayout());
        JLabel pLabel = new JLabel(MSGRES.getString(GEH, "FileExclusionDialog.label.prefixVariable"));
        JLabel fLabel = new JLabel(MSGRES.getString(GEH, "DirectoryExclusionDialog.label.directory"));
        JLabel sLabel = new JLabel(MSGRES.getString(GEH, "DirectoryExclusionDialog.label.scanType"));
        if (this.gehFileNameTextBox == null) {
            this.gehFileNameTextBox = new JTextField();
        }
        RestrictedPlainDocument nameDoc = new RestrictedPlainDocument(1023);
        this.gehFileNameTextBox.setDocument(nameDoc);
        ePanel.add((Component)pLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        ePanel.add(this.gehPrefixComboBox, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        if (PolicyExceptionUIObject.PLATFORM_WIN.equals(this.gehPlatform)) {
            ePanel.add((Component)FolderPrefixGlossaryDialog.createFolderGlossaryButton(), new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
        ePanel.add((Component)fLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 30, 0, 0), 0, 0));
        ePanel.add((Component)this.gehFileNameTextBox, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 30, 0, 0), 300, 0));
        if (PolicyExceptionUIObject.PLATFORM_LINUX.equals(this.gehPlatform)) {
            ePanel.add((Component)this.exampleLabel, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 30, 0, 0), 0, 0));
            ePanel.add((Component)this.linuxexampleLabel, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 30, 0, 0), 0, 0));
            this.linuxexampleLabel.setVisible(false);
            ePanel.add((Component)this.gehExcludeCheckBox, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 30, 0, 0), 0, 0));
            ePanel.add((Component)this.gehExcludeLinuxIcon, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 30, 0, 7), 0, 0));
        } else {
            ePanel.add((Component)this.gehExcludeCheckBox, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 30, 0, 0), 0, 0));
        }
        if (PolicyExceptionUIObject.PLATFORM_WIN.equals(this.gehPlatform)) {
            ePanel.add((Component)sLabel, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
            ePanel.add(this.gehScanTypeComboBox, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 17, 0, new Insets(2, 0, 0, 0), 0, 0));
            ePanel.add((Component)this.riskScanCatLabel, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 30, 0, 0), 0, 0));
            ePanel.add(this.gehScanCatComboBox, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 30, 0, 0), 0, 0));
        } else if (PolicyExceptionUIObject.PLATFORM_LINUX.equals(this.gehPlatform)) {
            ePanel.add((Component)this.riskScanCatLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
            ePanel.add(this.gehScanCatComboBox, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 0, 0, 0), 0, 0));
        }
        ePanel.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 20));
        return ePanel;
    }

    public String getFileName() {
        return this.gehDirectoryName;
    }

    public void setFileName(String fileName) {
        this.gehDirectoryName = fileName;
    }

    public int getScanType() {
        return this.gehScanType;
    }

    public void setList(ArrayList<String> dirList) {
        this.gehFileList = dirList;
    }

    public void setMap(HashMap<String, ArrayList<String>> dirMap) {
        this.gehFileMap = dirMap;
    }

    public void setLinuxMap(HashMap<String, ArrayList<String>> dirMap) {
        this.gehFileLinuxMap = dirMap;
    }

    public DirectoryExclusionUIObject getSelectedDirectory() {
        return this.gehSelectedDirectoryExclusion;
    }

    public static String getProfileFormatLinuxDirectory(String fullDirectoryName) {
        Object result = fullDirectoryName;
        if (!StringUtilities.isEmpty((String)fullDirectoryName)) {
            result = DirectoryExclusionDialog.removeLastFileSeparator(fullDirectoryName);
            for (int i = 0; i < ConstantValue.getLinuxDirKeys().length; ++i) {
                String key = "%" + ConstantValue.getLinuxDirKeys()[i] + "%";
                if (!((String)result).startsWith(key) || ((String)result).length() <= key.length()) continue;
                String folderName = ((String)result).substring(key.length());
                folderName = DirectoryExclusionDialog.removeFirstFileSeparator(folderName);
                String profilePrefix = ConstantValue.getLinuxProfileDirKeys((String)ConstantValue.getLinuxDirKeys()[i]);
                result = profilePrefix + folderName;
                break;
            }
        }
        return result;
    }

    private static String removeLastFileSeparator(String fullDirectoryName) {
        String result = fullDirectoryName;
        if (!StringUtilities.isEmpty((String)fullDirectoryName) && fullDirectoryName.endsWith(LINUX_FILESEPARATOR) && fullDirectoryName.length() > 1) {
            result = fullDirectoryName.substring(0, fullDirectoryName.length() - 1);
        }
        return result;
    }

    private static String removeFirstFileSeparator(String fullDirectoryName) {
        String result = fullDirectoryName;
        if (!StringUtilities.isEmpty((String)fullDirectoryName) && fullDirectoryName.startsWith(LINUX_FILESEPARATOR) && fullDirectoryName.length() > 1) {
            result = fullDirectoryName.substring(LINUX_FILESEPARATOR.length());
        }
        return result;
    }

    private boolean isBeingUsed(String gehDirectoryName, String scanType, String gehPlatform) {
        boolean result = false;
        if (PolicyExceptionUIObject.PLATFORM_LINUX.equals(gehPlatform)) {
            if (this.gehFileLinuxMap != null && (this.gehFilePathNameTobeEdited == null || !DirectoryExclusionDialog.getProfileFormatLinuxDirectory(this.gehFilePathNameTobeEdited).equals(DirectoryExclusionDialog.getProfileFormatLinuxDirectory(gehDirectoryName))) && (this.gehFileLinuxMap.containsKey(scanType) && this.gehFileLinuxMap.get(scanType).contains(DirectoryExclusionDialog.getProfileFormatLinuxDirectory(gehDirectoryName)) || this.checkForAllScanType(scanType, DirectoryExclusionDialog.getProfileFormatLinuxDirectory(gehDirectoryName), this.gehFileLinuxMap))) {
                result = true;
            }
        } else if (this.gehFileMap != null && (this.gehFilePathNameTobeEdited == null || !this.gehFilePathNameTobeEdited.equals(gehDirectoryName)) && (this.gehFileMap.containsKey(scanType) && this.gehFileMap.get(scanType).contains(gehDirectoryName) || this.checkForAllScanType(scanType, gehDirectoryName, this.gehFileMap))) {
            result = true;
        }
        return result;
    }

    @Override
    protected boolean isValidate() {
        String prefix = (String)this.gehPrefixComboBox.getSelectedItem();
        boolean hasPrefix = !prefix.trim().equalsIgnoreCase(ConstantValue.getDirKeysByIndex((int)0));
        this.gehDirectoryName = this.getFileNameText();
        if (!(hasPrefix || this.gehDirectoryName != null && this.gehDirectoryName.trim().length() != 0)) {
            JOptionPane.showMessageDialog(this, MSGRES.getString(GEH, "DirectoryExclusionDialog.error.emptyDirName"), MSGRES.getString(GEH, "OverridePolicySelectDlg.error"), 0);
            return false;
        }
        if (!this.validateInputFullCheck(this.getFileNameText())) {
            return false;
        }
        if (PolicyExceptionUIObject.PLATFORM_LINUX.equals(this.gehPlatform)) {
            if (!StringUtilities.isEmpty((String)this.gehDirectoryName) && this.gehDirectoryName.trim().contains("\\")) {
                this.gehDirectoryName = null;
                JOptionPane.showMessageDialog(this, MSGRES.getString(GEH, "DirectoryExclusionDialog.error.provideRelativePath"), MSGRES.getString(GEH, "OverridePolicySelectDlg.error"), 0);
                return false;
            }
            if (!hasPrefix) {
                if (!StringUtilities.isEmpty((String)this.gehDirectoryName) && !this.gehDirectoryName.startsWith(LINUX_FILESEPARATOR)) {
                    this.gehDirectoryName = null;
                    JOptionPane.showMessageDialog(this, MSGRES.getString(GEH, "DirectoryExclusionDialog.error.pathMissingAtPrefix"), MSGRES.getString(GEH, "OverridePolicySelectDlg.error"), 0);
                    return false;
                }
            } else if (!StringUtilities.isEmpty((String)this.gehDirectoryName) && this.gehDirectoryName.startsWith(LINUX_FILESEPARATOR)) {
                this.gehDirectoryName = null;
                JOptionPane.showMessageDialog(this, MSGRES.getString(GEH, "DirectoryExclusionDialog.error.pathAtPrefix"), MSGRES.getString(GEH, "OverridePolicySelectDlg.error"), 0);
                return false;
            }
        }
        String scanType = String.valueOf(this.getScantypeFromIndex(this.gehScanTypeComboBox.getSelectedIndex()));
        if (hasPrefix) {
            this.gehDirectoryName = "%" + prefix.trim() + "%" + this.gehDirectoryName;
        }
        if (this.isBeingUsed(this.gehDirectoryName, scanType, this.gehPlatform)) {
            this.gehDirectoryName = null;
            JOptionPane.showMessageDialog(this, MSGRES.getString(GEH, "DirectoryExclusionDialog.error.alreayUsed"), MSGRES.getString(GEH, "OverridePolicySelectDlg.error"), 0);
            return false;
        }
        this.gehScanType = this.getScantypeFromIndex(this.gehScanTypeComboBox.getSelectedIndex());
        if (this.gehScanType != DirectoryExclusionUIObject.SECURITY_RISK) {
            this.gehScanCatComboBox.setSelectedItem((Object)SecurityRiskScanCategoryUIObject.GESC_ALL);
        }
        boolean folderPathValid = true;
        String invalidCharacterMsg = "";
        String wildcardsNotAllowedMsg = "";
        if (this.gehDirectoryName.matches(PolicyUtil.getRegex("\"|<>/"))) {
            folderPathValid = false;
            invalidCharacterMsg = MessageFormat.format(MSGRES.getString(GEH, "DirectoryExclusionDialog.error.invalidCharactersNotAllowed"), "\"|<>/");
        }
        if (this.gehScanType != DirectoryExclusionUIObject.SECURITY_RISK && this.gehDirectoryName.matches(PolicyUtil.getRegex("*?"))) {
            folderPathValid = false;
            wildcardsNotAllowedMsg = MSGRES.getString(GEH, "DirectoryExclusionDialog.error.wildCardsNotAllowed");
        }
        if (!PolicyExceptionUIObject.PLATFORM_LINUX.equals(this.gehPlatform) && !folderPathValid) {
            JOptionPane.showMessageDialog(this, MessageFormat.format(MSGRES.getString(GEH, "DirectoryExclusionDialog.error.invalidCharactersContainedInFolderPath"), invalidCharacterMsg, wildcardsNotAllowedMsg), MSGRES.getString(GEH, "OverridePolicySelectDlg.error"), 0);
            return false;
        }
        return true;
    }

    private boolean checkForAllScanType(String scanType, String gehDirectoryName, HashMap<String, ArrayList<String>> gehFileMap) {
        boolean result = false;
        String scanTypeAll = String.valueOf(DirectoryExclusionUIObject.ALL);
        if (scanType.equals(scanTypeAll)) {
            String[] strList;
            for (String str : strList = new String[]{String.valueOf(DirectoryExclusionUIObject.SECURITY_RISK), String.valueOf(DirectoryExclusionUIObject.TRUSCAN), String.valueOf(DirectoryExclusionUIObject.ADC)}) {
                if (!gehFileMap.containsKey(str) || !gehFileMap.get(str).contains(gehDirectoryName)) continue;
                result = true;
                break;
            }
        } else if (gehFileMap.containsKey(scanTypeAll) && gehFileMap.get(scanTypeAll).contains(gehDirectoryName)) {
            result = true;
        }
        return result;
    }

    @Override
    protected void commit() {
        this.gehExcludeSubdirectories = !this.gehExcludeCheckBox.isSelected();
        this.gehExtensionList = this.getExtensionList();
        this.gehSelectedDirectoryExclusion = new DirectoryExclusionUIObject(this.getFileNameText(), (String)this.gehPrefixComboBox.getSelectedItem(), this.gehExtensionList, this.gehExcludeSubdirectories, this.gehScanType, ((SecurityRiskScanCategoryUIObject)((Object)this.gehScanCatComboBox.getSelectedItem())).getGehScanCategories());
    }

    String getExtensionList() {
        String extList = "";
        return extList;
    }

    String getFileNameText() {
        String fileName = this.gehFileNameTextBox.getText().trim();
        if (fileName.contains("\\n")) {
            fileName = fileName.replace("\\n", "\\N");
        }
        if (!PolicyExceptionUIObject.PLATFORM_LINUX.equals(this.gehPlatform) && fileName.length() != 0 && !fileName.endsWith("\\")) {
            String lastPath;
            int lastSlash = fileName.lastIndexOf(92);
            String string = lastPath = lastSlash == -1 ? fileName : fileName.substring(lastSlash + 1);
            if (!lastPath.contains("*") && !lastPath.contains("?")) {
                fileName = fileName.concat("\\");
            }
        }
        return fileName;
    }

    private Integer getScantypeFromIndex(int actionIndex) {
        Integer scanTypeInt = null;
        if (PolicyExceptionUIObject.PLATFORM_LINUX.equals(this.gehPlatform)) {
            if (actionIndex == 0) {
                scanTypeInt = DirectoryExclusionUIObject.SECURITY_RISK;
            } else if (actionIndex == 1) {
                scanTypeInt = DirectoryExclusionUIObject.TRUSCAN;
            } else if (actionIndex == 3) {
                scanTypeInt = DirectoryExclusionUIObject.ALL;
            }
        } else if (LicenseObject.getInstance().isSBProduct()) {
            if (actionIndex == 0) {
                scanTypeInt = DirectoryExclusionUIObject.SECURITY_RISK;
            } else if (actionIndex == 1) {
                scanTypeInt = DirectoryExclusionUIObject.TRUSCAN;
            } else if (actionIndex == 2) {
                scanTypeInt = DirectoryExclusionUIObject.ALL;
            }
        } else if (!this.isCloudEnrolled) {
            if (actionIndex == 0) {
                scanTypeInt = DirectoryExclusionUIObject.SECURITY_RISK;
            } else if (actionIndex == 1) {
                scanTypeInt = DirectoryExclusionUIObject.TRUSCAN;
            } else if (actionIndex == 3) {
                scanTypeInt = DirectoryExclusionUIObject.ALL;
            } else if (actionIndex == 2) {
                scanTypeInt = DirectoryExclusionUIObject.ADC;
            }
        } else if (this.isSEPExceptionPolicy) {
            if (actionIndex == 0) {
                scanTypeInt = DirectoryExclusionUIObject.ADC;
            }
        } else if (this.isCloudExceptionPolicy) {
            if (actionIndex == 0) {
                scanTypeInt = DirectoryExclusionUIObject.SECURITY_RISK;
            } else if (actionIndex == 1) {
                scanTypeInt = DirectoryExclusionUIObject.TRUSCAN;
            } else if (actionIndex == 2) {
                scanTypeInt = DirectoryExclusionUIObject.ALL;
            }
        }
        return scanTypeInt;
    }

    private int getIndexFromScantype(Integer scanInt) {
        if (scanInt == null) {
            return 0;
        }
        int scanTypeIndex = 0;
        if (PolicyExceptionUIObject.PLATFORM_LINUX.equals(this.gehPlatform)) {
            scanTypeIndex = 0;
        } else if (LicenseObject.getInstance().isSBProduct()) {
            if (scanInt.equals(DirectoryExclusionUIObject.SECURITY_RISK)) {
                scanTypeIndex = 0;
            } else if (scanInt.equals(DirectoryExclusionUIObject.TRUSCAN)) {
                scanTypeIndex = 1;
            } else if (scanInt.equals(DirectoryExclusionUIObject.ALL)) {
                scanTypeIndex = 2;
            }
        } else if (!this.isCloudEnrolled) {
            if (scanInt.equals(DirectoryExclusionUIObject.SECURITY_RISK)) {
                scanTypeIndex = 0;
            } else if (scanInt.equals(DirectoryExclusionUIObject.TRUSCAN)) {
                scanTypeIndex = 1;
            } else if (scanInt.equals(DirectoryExclusionUIObject.ALL)) {
                scanTypeIndex = 3;
            } else if (scanInt.equals(DirectoryExclusionUIObject.ADC)) {
                scanTypeIndex = 2;
            }
        } else if (this.isSEPExceptionPolicy) {
            if (scanInt.equals(DirectoryExclusionUIObject.ADC)) {
                scanTypeIndex = 0;
            }
        } else if (this.isCloudExceptionPolicy) {
            if (scanInt.equals(DirectoryExclusionUIObject.SECURITY_RISK)) {
                scanTypeIndex = 0;
            } else if (scanInt.equals(DirectoryExclusionUIObject.TRUSCAN)) {
                scanTypeIndex = 1;
            } else if (scanInt.equals(DirectoryExclusionUIObject.ALL)) {
                scanTypeIndex = 2;
            }
        }
        return scanTypeIndex;
    }
}

