/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.override;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.CustomLookAndFeel;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.policy.override.logicobject.CertificateExclusionUIObject;
import com.sygate.scm.console.ui.policy.override.logicobject.CertificateExclusionUIObjectHelper;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.ui.util.Utilities;
import com.sygate.scm.console.util.AjaxSwingUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileNameExtensionFilter;

public class CertificateExclusionDialog
extends DialogBase {
    private static final long serialVersionUID = 8930253565215633180L;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String GEH = "com.sygate.scm.console.ui.policy.override.override";
    private JPanel mainPanel;
    private JTextField gehFileNameTextBox;
    private JButton browseButton;
    private JTextField gehIssuerDescLabel;
    private JTextField gehSignerDescLabel;
    private JTextField gehThumbprintDescLabel;
    private JTextField gehThumbprintDescLabelSHA2;
    private File certificateFile;
    private Map<String, String> gehCertThumbprintMap;
    private CertificateExclusionUIObject gehSelectedCertExclusion;

    public CertificateExclusionDialog() {
        super(Manager.getFrame(), MSGRES.getString(GEH, "CertificateExceptionDialog.title.certificate"), true);
        this.initialize(false);
        UiUtilities.centerComponent((Component)this);
    }

    public CertificateExclusionDialog(CertificateExclusionUIObject extObj, boolean isReadonly) {
        super(Manager.getFrame(), MSGRES.getString(GEH, "CertificateExceptionDialog.title.certificateEdit"), true);
        this.initialize(isReadonly);
        this.gehSelectedCertExclusion = extObj;
        this.refreshCertInfo();
        UiUtilities.centerComponent((Component)this);
    }

    public void setHashMap(Map<String, String> thumbprintMap) {
        this.gehCertThumbprintMap = thumbprintMap;
    }

    public CertificateExclusionUIObject getSelectedCertificate() {
        return this.gehSelectedCertExclusion;
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_geh_override_add_certificate";
    }

    private void initialize(boolean isReadonly) {
        Container cont = this.getContentPane();
        cont.setLayout(new BorderLayout());
        JPanel newPanel = new JPanel();
        newPanel.setLayout(new BoxLayout(newPanel, 1));
        newPanel.add(new AvTemplatePane(MSGRES.getString(GEH, "CertificateExceptionDialog.heading.label"), MSGRES.getString(GEH, "CertificateExceptionDialog.heading.desc")));
        newPanel.add(Box.createVerticalStrut(10));
        newPanel.add(this.createMainPanel());
        newPanel.add(Box.createVerticalStrut(10));
        cont.add((Component)newPanel, "Center");
        cont.add((Component)this.getButtonPanel(), "South");
        if (isReadonly) {
            UIUtilities.setContainerStatus(newPanel, false);
            this.resetOKButton(false);
            if (null != this.browseButton) {
                this.browseButton.setEnabled(false);
            }
            if (null != this.gehFileNameTextBox) {
                this.gehFileNameTextBox.setEditable(false);
            }
        }
        this.gehCertThumbprintMap = new HashMap<String, String>();
        this.pack();
        this.setResizable(false);
        this.setIconImage(CustomLookAndFeel.TITLE_LOGO_IMAGE);
    }

    private JPanel createMainPanel() {
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 1));
        this.mainPanel.add(this.createCertFileLocationPanel());
        this.mainPanel.add(Box.createVerticalStrut(10));
        this.mainPanel.add(this.createCertInformationPanel());
        this.mainPanel.add(Box.createVerticalStrut(10));
        return this.mainPanel;
    }

    private JPanel createCertFileLocationPanel() {
        JPanel certFileLocationPanel = new JPanel();
        certFileLocationPanel.setLayout(new FlowLayout(0));
        certFileLocationPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10), BorderFactory.createTitledBorder(MSGRES.getString(GEH, "CertificateExceptionDialog.filelocation.label"))));
        JLabel fileLabel = new JLabel(MSGRES.getString(GEH, "CertificateExceptionDialog.label.file"));
        this.gehFileNameTextBox = new JTextField("", 35);
        this.browseButton = new JButton(MSGRES.getString(GEH, "CertificateExceptionDialog.button.browse"));
        this.browseButton.addActionListener(this.getBrowseButtonListener());
        certFileLocationPanel.add(fileLabel);
        certFileLocationPanel.add(this.gehFileNameTextBox);
        certFileLocationPanel.add(this.browseButton);
        RestrictedPlainDocument doc = new RestrictedPlainDocument(1023);
        doc.setValidator("\"<>*?|", false);
        doc.addDocumentListener(this.getFileLocationTextChangeListener());
        this.gehFileNameTextBox.setDocument(doc);
        return certFileLocationPanel;
    }

    private JPanel createCertInformationPanel() {
        JPanel certInformationPanel = new JPanel(new BorderLayout());
        certInformationPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10), BorderFactory.createTitledBorder(MSGRES.getString(GEH, "CertificateExceptionDialog.certdetails.label"))));
        JPanel innerCertInfoPanel = new JPanel();
        innerCertInfoPanel.setLayout(new BoxLayout(innerCertInfoPanel, 1));
        innerCertInfoPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 5, 5));
        JPanel issuerPanel = new JPanel(new BorderLayout());
        JLabel issuerLabel = new JLabel(MSGRES.getString(GEH, "CertificateExceptionDialog.label.issuer"));
        issuerLabel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        this.gehIssuerDescLabel = new JTextField("", 25);
        this.gehIssuerDescLabel.setEditable(false);
        issuerPanel.add((Component)issuerLabel, "West");
        issuerPanel.add((Component)this.gehIssuerDescLabel, "East");
        JPanel signerPanel = new JPanel(new BorderLayout());
        JLabel signerLabel = new JLabel(MSGRES.getString(GEH, "CertificateExceptionDialog.label.signer"));
        signerLabel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        this.gehSignerDescLabel = new JTextField("", 25);
        this.gehSignerDescLabel.setEditable(false);
        signerPanel.add((Component)signerLabel, "West");
        signerPanel.add((Component)this.gehSignerDescLabel, "East");
        JPanel thumbprintPanel = new JPanel(new BorderLayout());
        JLabel thumbprintLabel = new JLabel(MSGRES.getString(GEH, "CertificateExceptionDialog.label.thumbprint"));
        thumbprintLabel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        this.gehThumbprintDescLabel = new JTextField("", 50);
        this.gehThumbprintDescLabel.setEditable(false);
        thumbprintPanel.add((Component)thumbprintLabel, "West");
        thumbprintPanel.add((Component)this.gehThumbprintDescLabel, "East");
        JPanel thumbprintPanelSHA2 = new JPanel(new BorderLayout());
        JLabel thumbprintLabelSHA2 = new JLabel(MSGRES.getString(GEH, "CertificateExceptionDialog.label.thumbprintSHA2"));
        thumbprintLabelSHA2.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        this.gehThumbprintDescLabelSHA2 = new JTextField("", 50);
        this.gehThumbprintDescLabelSHA2.setEditable(false);
        thumbprintPanelSHA2.add((Component)thumbprintLabelSHA2, "West");
        thumbprintPanelSHA2.add((Component)this.gehThumbprintDescLabelSHA2, "East");
        innerCertInfoPanel.add(issuerPanel);
        innerCertInfoPanel.add(Box.createVerticalStrut(10));
        innerCertInfoPanel.add(signerPanel);
        innerCertInfoPanel.add(Box.createVerticalStrut(10));
        innerCertInfoPanel.add(thumbprintPanel);
        innerCertInfoPanel.add(Box.createVerticalStrut(10));
        innerCertInfoPanel.add(thumbprintPanelSHA2);
        certInformationPanel.add((Component)innerCertInfoPanel, "West");
        return certInformationPanel;
    }

    private ActionListener getBrowseButtonListener() {
        ActionListener browseButtonAction = e -> {
            JFileChooser fileDlg = new JFileChooser();
            FileNameExtensionFilter certFilter = new FileNameExtensionFilter(MSGRES.getString(GEH, "CertificateExceptionDialog.browseFileDialog.filter"), "cer");
            fileDlg.addChoosableFileFilter(certFilter);
            fileDlg.setAcceptAllFileFilterUsed(true);
            fileDlg.setFileFilter(certFilter);
            fileDlg.setMultiSelectionEnabled(false);
            int dlgResult = fileDlg.showOpenDialog(this.mainPanel);
            if (dlgResult != 0) {
                return;
            }
            this.certificateFile = fileDlg.getSelectedFile();
            if (null != this.gehFileNameTextBox && null != this.certificateFile) {
                this.gehFileNameTextBox.setText(AjaxSwingUtil.getDisplayFileName(this.certificateFile));
            }
        };
        return browseButtonAction;
    }

    private DocumentListener getFileLocationTextChangeListener() {
        return new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent event) {
                CertificateExclusionDialog.this.onCertificateFileChosen();
            }

            @Override
            public void removeUpdate(DocumentEvent event) {
                CertificateExclusionDialog.this.onCertificateFileChosen();
            }

            @Override
            public void changedUpdate(DocumentEvent event) {
                CertificateExclusionDialog.this.onCertificateFileChosen();
            }
        };
    }

    private void onCertificateFileChosen() {
        this.gehSelectedCertExclusion = null;
        this.refreshCertInfo();
        if (null == this.gehFileNameTextBox) {
            return;
        }
        if (this.certificateFile == null) {
            return;
        }
        if (!this.certificateFile.exists() || this.certificateFile.isDirectory()) {
            return;
        }
        CertificateExclusionUIObject certObj = CertificateExclusionUIObjectHelper.getCertificateExclusionUIObject(this.certificateFile.getAbsolutePath());
        if (null == certObj) {
            JOptionPane.showMessageDialog(this.mainPanel, MSGRES.getString(GEH, "CertificateExceptionDialog.message.invalidCertFile"), MSGRES.getString(GEH, "CertificateExceptionDialog.message.error"), 0);
            return;
        }
        this.gehSelectedCertExclusion = certObj;
        this.refreshCertInfo();
    }

    private void refreshCertInfo() {
        String issuer = "";
        String signer = "";
        String thumbprint = "";
        String thumbprintSHA2 = "";
        if (null != this.gehSelectedCertExclusion) {
            if (null != this.gehSelectedCertExclusion.getIssuer()) {
                issuer = this.gehSelectedCertExclusion.getIssuer();
            }
            if (null != this.gehSelectedCertExclusion.getSigner()) {
                signer = this.gehSelectedCertExclusion.getSigner();
            }
            if (null != this.gehSelectedCertExclusion.getThumbprint()) {
                thumbprint = this.gehSelectedCertExclusion.getThumbprint();
            }
            if (null != this.gehSelectedCertExclusion.getThumbprintSHA2()) {
                thumbprintSHA2 = this.gehSelectedCertExclusion.getThumbprintSHA2();
            }
        }
        if (null != this.gehIssuerDescLabel) {
            this.gehIssuerDescLabel.setText(issuer);
        }
        if (null != this.gehSignerDescLabel) {
            this.gehSignerDescLabel.setText(signer);
        }
        if (null != this.gehThumbprintDescLabel) {
            this.gehThumbprintDescLabel.setText(thumbprint);
        }
        if (null != this.gehThumbprintDescLabelSHA2) {
            this.gehThumbprintDescLabelSHA2.setText(thumbprintSHA2);
        }
    }

    @Override
    protected boolean isValidate() {
        if (!CertificateExclusionUIObjectHelper.isValidCertificateExclusionObject(this.gehSelectedCertExclusion)) {
            JOptionPane.showMessageDialog(this.mainPanel, MSGRES.getString(GEH, "CertificateExceptionDialog.message.invalidThumbprint"), MSGRES.getString(GEH, "CertificateExceptionDialog.message.error"), 0);
            return false;
        }
        if (this.isCertAlreadyPresent(this.gehSelectedCertExclusion.getThumbprint(), this.gehSelectedCertExclusion.getThumbprintSHA2())) {
            JOptionPane.showMessageDialog(this.mainPanel, MSGRES.getString(GEH, "CertificateExceptionDialog.message.duplicateCert"), MSGRES.getString(GEH, "CertificateExceptionDialog.message.error"), 0);
            return false;
        }
        return true;
    }

    private boolean isCertAlreadyPresent(String certThumbprint, String certThumbprintSha2) {
        if (!this.gehCertThumbprintMap.containsKey(certThumbprint)) {
            return false;
        }
        String sha256 = this.gehCertThumbprintMap.get(certThumbprint);
        return !Utilities.isStrNullOrEmpty(sha256) && sha256.equals(certThumbprintSha2);
    }

    @Override
    protected void commit() {
    }
}

