/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.override;

import com.sygate.scm.common.configobject.schema.DetectedProcesses;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.policy.override.OverrideActionCheckboxItem;
import com.sygate.scm.console.ui.policy.override.PolicyOverrideConstants;
import com.sygate.scm.console.ui.policy.override.logicobject.DetectedProcessUIObject;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.StringUtilities;
import com.sygate.scm.util.Utility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ApplicationExclusionDialog
extends DialogBase {
    private static final long serialVersionUID = -4258588702767497095L;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String GEH = "com.sygate.scm.console.ui.policy.override.override";
    private static final int SHA256_LENGTH = 64;
    private JPanel mainPanel;
    private JLabel gehFileNameLabel;
    private JTextField gehFileNameTextBox;
    private JLabel gehFileCheckSumLabel;
    private JTextField gehFileCheckSumTextBox;
    private JLabel gehActionLabel;
    private JComboBox<OverrideActionCheckboxItem> gehActionComboBox;
    private int platForm;
    private DetectedProcessUIObject uiObject;

    public ApplicationExclusionDialog(OverrideActionCheckboxItem[] supportedActions, String osPlatForm) {
        super(Manager.getFrame(), MSGRES.getString(GEH, "ApplicationExclusionDialog.title.add.appplication"), true);
        this.platForm = DetectedProcessUIObject.getOSPlatForm(osPlatForm);
        this.initialize(false, supportedActions);
        this.setDefaults();
        UiUtilities.centerComponent((Component)this);
    }

    public ApplicationExclusionDialog(DetectedProcessUIObject extObj, OverrideActionCheckboxItem[] supportedActions, boolean isReadonly) {
        super(Manager.getFrame(), MSGRES.getString(GEH, "ApplicationExclusionDialog.title.edit.appplication"), true);
        this.platForm = extObj.getOS();
        this.uiObject = extObj;
        this.initialize(isReadonly, supportedActions);
        this.updateData();
        UiUtilities.centerComponent((Component)this);
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_geh_override_add_hpo_manual";
    }

    private void initialize(boolean isReadonly, OverrideActionCheckboxItem[] supportedActions) {
        Container cont = this.getContentPane();
        cont.setLayout(new BorderLayout());
        JPanel newPanel = new JPanel();
        newPanel.setLayout(new BoxLayout(newPanel, 1));
        newPanel.add(new AvTemplatePane(MSGRES.getString(GEH, "ApplicationExclusionDialog.heading.label"), MSGRES.getString(GEH, "ApplicationExclusionDialog.heading.desc")));
        newPanel.add(Box.createVerticalStrut(10));
        newPanel.add(this.createMainPanel(supportedActions));
        newPanel.add(Box.createVerticalStrut(10));
        cont.add((Component)newPanel, "Center");
        cont.add((Component)this.getButtonPanel(), "South");
        if (isReadonly) {
            UIUtilities.setContainerStatus(newPanel, false);
            this.resetOKButton(false);
        }
        this.pack();
    }

    private JPanel createMainPanel(OverrideActionCheckboxItem[] supportedActions) {
        int textFieldWidth = 42;
        this.gehFileNameLabel = new JLabel(MSGRES.getString(GEH, "ApplicationExclusionDialog.label.file.name"));
        this.gehFileNameTextBox = new JTextField(textFieldWidth);
        RestrictedPlainDocument doc = new RestrictedPlainDocument(1023);
        if (DetectedProcesses.WINDOWS != this.platForm) {
            doc.setValidator(":", false);
        } else {
            doc.setValidator("\\/:*?\"<>|", false);
        }
        this.gehFileNameTextBox.setDocument(doc);
        this.gehFileCheckSumLabel = new JLabel(MSGRES.getString(GEH, "ApplicationExclusionDialog.label.file.checksum"));
        this.gehFileCheckSumTextBox = new JTextField(textFieldWidth);
        RestrictedPlainDocument checkSumDoc = new RestrictedPlainDocument(64);
        this.gehFileCheckSumTextBox.setDocument(checkSumDoc);
        this.gehActionLabel = new JLabel(MSGRES.getString(GEH, "ApplicationExclusionDialog.label.action"));
        this.gehActionComboBox = new JComboBox<OverrideActionCheckboxItem>(supportedActions);
        this.gehActionComboBox.setSelectedIndex(0);
        this.mainPanel = new JPanel(new GridBagLayout());
        int y = 0;
        int leftPadding = 10;
        int topPadding = 10;
        int rightPadding = leftPadding;
        this.mainPanel.add((Component)this.gehFileCheckSumLabel, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(topPadding, leftPadding, 0, 0), 0, 0));
        this.mainPanel.add((Component)this.gehFileCheckSumTextBox, new GridBagConstraints(1, y, 2, 1, 0.0, 0.0, 17, 0, new Insets(topPadding, leftPadding, 0, 0), 0, 0));
        this.mainPanel.add((Component)this.gehFileNameLabel, new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 17, 0, new Insets(topPadding, leftPadding, 0, 0), 0, 0));
        this.mainPanel.add((Component)this.gehFileNameTextBox, new GridBagConstraints(1, y, 2, 1, 0.0, 0.0, 17, 0, new Insets(topPadding, leftPadding, 0, rightPadding), 0, 0));
        this.mainPanel.add((Component)this.gehActionLabel, new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 17, 0, new Insets(topPadding, leftPadding, 0, 0), 0, 0));
        this.mainPanel.add(this.gehActionComboBox, new GridBagConstraints(1, y, 2, 1, 0.0, 0.0, 17, 0, new Insets(topPadding, leftPadding, 0, 0), 0, 0));
        if (DetectedProcesses.WINDOWS != this.platForm) {
            this.gehActionLabel.setVisible(false);
            this.gehActionComboBox.setVisible(false);
        }
        return this.mainPanel;
    }

    private void setDefaults() {
        this.gehFileCheckSumTextBox.requestFocus();
    }

    private void updateData() {
        String action;
        String checkSum;
        if (!StringUtilities.isEmpty((String)this.uiObject.getDetectedProcess())) {
            this.gehFileNameTextBox.setText(this.uiObject.getDetectedProcess());
        }
        if (!StringUtilities.isEmpty((String)(checkSum = this.uiObject.getChecksum()))) {
            String[] parts = checkSum.split(":");
            switch (parts.length) {
                case 1: {
                    if (checkSum.endsWith(":")) break;
                    this.gehFileCheckSumTextBox.setText(parts[0]);
                    break;
                }
                case 2: {
                    this.gehFileCheckSumTextBox.setText(parts[1]);
                    break;
                }
            }
        }
        if ((action = this.uiObject.getAction()) == null) {
            action = PolicyOverrideConstants.GEH_IGNORE;
        }
        for (int i = 0; i < this.gehActionComboBox.getItemCount(); ++i) {
            OverrideActionCheckboxItem item = this.gehActionComboBox.getItemAt(i);
            if (!item.getValue().equalsIgnoreCase(action)) continue;
            this.gehActionComboBox.setSelectedIndex(i);
            break;
        }
        this.gehFileCheckSumTextBox.requestFocus();
    }

    public DetectedProcessUIObject getSelectedFile() {
        return this.uiObject;
    }

    @Override
    protected boolean isValidate() {
        boolean isFileCheckSumEmpty = StringUtilities.isEmpty((String)this.gehFileCheckSumTextBox.getText());
        if (isFileCheckSumEmpty) {
            JOptionPane.showMessageDialog(this, MSGRES.getString(GEH, "NonPEFileExclusionDialog.error.file.checksum.required"), MSGRES.getString(GEH, "OverridePolicySelectDlg.error"), 0);
            this.gehFileCheckSumTextBox.requestFocus();
            return false;
        }
        return this.isValidCheckSum(this.gehFileCheckSumTextBox);
    }

    private boolean isValidCheckSum(JTextField textField) {
        boolean isValidCheckSum = false;
        if (textField.getText().length() != 64) {
            isValidCheckSum = false;
        } else {
            try {
                Utility.toByteArray((String)textField.getText());
                isValidCheckSum = true;
            }
            catch (Exception ex) {
                LoggerUtilities.logException((Throwable)ex);
                isValidCheckSum = false;
            }
        }
        if (!isValidCheckSum) {
            JOptionPane.showMessageDialog(this, MSGRES.getString(GEH, "NonPEFileExclusionDialog.error.invalid.checksum"), MSGRES.getString(GEH, "OverridePolicySelectDlg.error"), 0);
            textField.requestFocusInWindow();
        }
        return isValidCheckSum;
    }

    @Override
    protected void commit() {
        OverrideActionCheckboxItem selectedItem = (OverrideActionCheckboxItem)this.gehActionComboBox.getSelectedItem();
        this.uiObject = new DetectedProcessUIObject();
        this.uiObject.setDetectedProcess(this.gehFileNameTextBox.getText().strip());
        this.uiObject.setChecksum("2:" + this.gehFileCheckSumTextBox.getText());
        this.uiObject.setAction(selectedItem.getValue());
        this.uiObject.setCompany(null);
        this.uiObject.setAltChecksum(null);
        this.uiObject.setOS(this.platForm);
    }
}

