/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.osprotect.logicobject;

import com.sygate.scm.common.configobject.schema.OpFileAccess;
import com.sygate.scm.common.configobject.schema.OpModuleAccess;
import com.sygate.scm.common.configobject.schema.OpPermissionList;
import com.sygate.scm.common.configobject.schema.OpProcessAccess;
import com.sygate.scm.common.configobject.schema.OpRegistryAccess;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class OpPermissionListObject
extends AbstractUIObject {
    private OpPermissionList permissionList;
    private int launchProcessCount;

    public OpPermissionListObject(OpPermissionList permissionList) {
        this.permissionList = permissionList;
        this.initializeLaunchProcessCount();
    }

    public OpPermissionList getOpPermissionList() {
        return this.permissionList;
    }

    public static List<String> getAllPermissionNames(OpPermissionList pList) {
        int i;
        ArrayList<String> names = new ArrayList<String>();
        for (i = 0; i < pList.getOpRegistryAccessCount(); ++i) {
            names.add(pList.getOpRegistryAccess(i).getName());
        }
        for (i = 0; i < pList.getOpFileAccessCount(); ++i) {
            names.add(pList.getOpFileAccess(i).getName());
        }
        for (i = 0; i < pList.getOpProcessAccessCount(); ++i) {
            names.add(pList.getOpProcessAccess(i).getName());
        }
        for (i = 0; i < pList.getOpModuleAccessCount(); ++i) {
            names.add(pList.getOpModuleAccess(i).getName());
        }
        return names;
    }

    public int addOpRegistryAccess(OpRegistryAccess regAccess) {
        this.permissionList.addOpRegistryAccess(regAccess);
        return this.getOpRegistryAccessCount() - 1;
    }

    public int getOpRegistryAccessCount() {
        return this.permissionList.getOpRegistryAccessCount();
    }

    public Vector<OpRegistryAccess> getOpRegistryAccess() {
        return this.permissionList.getOpRegistryAccess();
    }

    public OpRegistryAccess getOpRegistryAccess(int index) {
        return this.permissionList.getOpRegistryAccess(index);
    }

    public void setOpRegistryAccess(int index, OpRegistryAccess regAccess) {
        this.permissionList.setOpRegistryAccess(index, regAccess);
    }

    public void removeOpRegistryAccess(OpRegistryAccess regAccess) {
        this.permissionList.removeOpRegistryAccess(regAccess);
    }

    public int indexOfOpRegistryAccess(OpRegistryAccess regAccess) {
        return this.getOpRegistryAccess().indexOf(regAccess);
    }

    public int addOpFileAccess(OpFileAccess fileAccess) {
        this.permissionList.addOpFileAccess(fileAccess);
        return this.getOpRegistryAccessCount() + this.getOpFileAccessCount() - 1;
    }

    public int getOpFileAccessCount() {
        return this.permissionList.getOpFileAccessCount();
    }

    public Vector<OpFileAccess> getOpFileAccess() {
        return this.permissionList.getOpFileAccess();
    }

    public OpFileAccess getOpFileAccess(int index) {
        return this.permissionList.getOpFileAccess(index);
    }

    public void setOpFileAccess(int index, OpFileAccess fileAccess) {
        this.permissionList.setOpFileAccess(index - this.getOpRegistryAccessCount(), fileAccess);
    }

    public void removeOpFileAccess(OpFileAccess fileAccess) {
        this.permissionList.removeOpFileAccess(fileAccess);
    }

    public int indexOfOpFileAccess(OpFileAccess fileAccess) {
        return this.getOpFileAccess().indexOf(fileAccess);
    }

    public int addLaunchProcessAccess(OpProcessAccess processAccess) {
        this.insertOpProcessAccess(this.launchProcessCount, processAccess);
        ++this.launchProcessCount;
        return this.getOpRegistryAccessCount() + this.getOpFileAccessCount() + this.launchProcessCount - 1;
    }

    public int getLaunchProcessAccessCount() {
        return this.launchProcessCount;
    }

    public Vector<OpProcessAccess> getLaunchProcessAccess() {
        Vector<OpProcessAccess> allProcess = this.getOpProcessAccess();
        allProcess.setSize(this.launchProcessCount);
        return allProcess;
    }

    public OpProcessAccess getLaunchProcessAccess(int index) {
        return this.getOpProcessAccess(index);
    }

    public void setLaunchProcessAccess(int index, OpProcessAccess processAccess) {
        this.setOpProcessAccess(index - this.getOpRegistryAccessCount() - this.getOpFileAccessCount(), processAccess);
    }

    public void removeLaunchProcessAccess(OpProcessAccess processAccess) {
        this.removeOpProcessAccess(processAccess);
        --this.launchProcessCount;
    }

    public int indexOfLaunchProcessAccess(OpProcessAccess processAccess) {
        return this.getLaunchProcessAccess().indexOf(processAccess);
    }

    public int addTerminateProcessAccess(OpProcessAccess processAccess) {
        this.addOpProcessAccess(processAccess);
        return this.getOpRegistryAccessCount() + this.getOpFileAccessCount() + this.getOpProcessAccessCount() - 1;
    }

    public int getTerminateProcessAccessCount() {
        return this.getOpProcessAccessCount() - this.launchProcessCount;
    }

    public List<OpProcessAccess> getTerminateProcessAccess() {
        Vector<OpProcessAccess> allProcess = this.getOpProcessAccess();
        return allProcess.subList(this.launchProcessCount, allProcess.size());
    }

    public OpProcessAccess getTerminateProcessAccess(int index) {
        return this.getOpProcessAccess(index + this.launchProcessCount);
    }

    public void setTerminateProcessAccess(int index, OpProcessAccess processAccess) {
        this.setOpProcessAccess(index - this.getOpRegistryAccessCount() - this.getOpFileAccessCount(), processAccess);
    }

    public void removeTerminateProcessAccess(OpProcessAccess processAccess) {
        this.removeOpProcessAccess(processAccess);
    }

    public int indexOfTerminateProcessAccess(OpProcessAccess processAccess) {
        return this.getTerminateProcessAccess().indexOf(processAccess);
    }

    public int addOpModuleAccess(OpModuleAccess moduleAccess) {
        this.permissionList.addOpModuleAccess(moduleAccess);
        return this.getOpRegistryAccessCount() + this.getOpFileAccessCount() + this.getOpProcessAccessCount() + this.getOpModuleAccessCount() - 1;
    }

    public int getOpModuleAccessCount() {
        return this.permissionList.getOpModuleAccessCount();
    }

    public Vector<OpModuleAccess> getOpModuleAccess() {
        return this.permissionList.getOpModuleAccess();
    }

    public OpModuleAccess getOpModuleAccess(int index) {
        return this.permissionList.getOpModuleAccess(index);
    }

    public void setOpModuleAccess(int index, OpModuleAccess moduleAccess) {
        this.permissionList.setOpModuleAccess(index - this.getOpRegistryAccessCount() - this.getOpFileAccessCount() - this.getOpProcessAccessCount(), moduleAccess);
    }

    public void removeOpModuleAccess(OpModuleAccess moduleAccess) {
        this.permissionList.removeOpModuleAccess(moduleAccess);
    }

    public int indexOfOpModuleAccess(OpModuleAccess moduleAccess) {
        return this.getOpModuleAccess().indexOf(moduleAccess);
    }

    private void addOpProcessAccess(OpProcessAccess processAccess) {
        this.permissionList.addOpProcessAccess(processAccess);
    }

    private int getOpProcessAccessCount() {
        return this.permissionList.getOpProcessAccessCount();
    }

    private Vector<OpProcessAccess> getOpProcessAccess() {
        return this.permissionList.getOpProcessAccess();
    }

    private OpProcessAccess getOpProcessAccess(int index) {
        return this.permissionList.getOpProcessAccess(index);
    }

    private void setOpProcessAccess(int index, OpProcessAccess processAccess) {
        this.permissionList.setOpProcessAccess(index, processAccess);
    }

    private void removeOpProcessAccess(OpProcessAccess processAccess) {
        this.permissionList.removeOpProcessAccess(processAccess);
    }

    private void insertOpProcessAccess(int index, OpProcessAccess processAccess) {
        if (index == this.getOpProcessAccessCount()) {
            this.addOpProcessAccess(processAccess);
        } else {
            this.addOpProcessAccess(this.getOpProcessAccess(this.getOpProcessAccessCount() - 1));
            for (int i = this.getOpProcessAccessCount() - 2; i >= index; --i) {
                this.setOpProcessAccess(i + 1, this.getOpProcessAccess(i));
            }
            this.setOpProcessAccess(index, processAccess);
        }
    }

    private void initializeLaunchProcessCount() {
        for (OpProcessAccess opProcessAccess : this.getOpProcessAccess()) {
            if (opProcessAccess.getOptOpCreateProcess() == null) continue;
            ++this.launchProcessCount;
        }
    }
}

