/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.osprotect.logicobject;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.configobject.schema.OpAppProtBlockEntity;
import com.sygate.scm.common.configobject.schema.OpAppProtTemplate;
import com.sygate.scm.common.configobject.schema.OpAppProtectionBlock;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.WashIDHandler;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.ui.policy.common.CopitableObject;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.util.LoggerUtilities;
import java.util.HashMap;

public class OpAppProtBlockEntityObject
extends AbstractUIObject
implements TableRow,
CopitableObject {
    public static final String MODE_NORMAL = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "OpAppProtBlockEntityObject.ModeNormal");
    public static final String MODE_TEST_ONLY = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "OpAppProtBlockEntityObject.ModeTestOnly");
    private OpAppProtBlockEntity ospBlockEntity;

    public OpAppProtBlockEntityObject(OpAppProtBlockEntity ospBlockEntity) {
        this.ospBlockEntity = ospBlockEntity;
        this.setOspBlockEntityDefaultMode();
    }

    public OpAppProtBlockEntityObject(OpAppProtectionBlock ospBlock) {
        this.ospBlockEntity = new OpAppProtBlockEntity();
        this.setOspBlockEntityDefaultMode();
        this.setOpAppProtectionBlock(ospBlock);
    }

    public OpAppProtBlockEntityObject(OpAppProtTemplate ospTemplate) {
        this.ospBlockEntity = new OpAppProtBlockEntity();
        this.setOspBlockEntityDefaultMode();
        this.setOpAppProtectionBlock(ospTemplate);
    }

    public OpAppProtBlockEntity getOpAppProtBlockEntity() {
        return this.ospBlockEntity;
    }

    public void setOpAppProtBlockEntity(OpAppProtBlockEntity ospBlockEntity) {
        this.ospBlockEntity = ospBlockEntity;
    }

    public String getName() {
        return this.getOpAppProtectionBlock().getName();
    }

    public void setName(String name) {
        OpAppProtectionBlock ospBlock = this.ospBlockEntity.getOptOpAppProtectionBlock();
        if (ospBlock != null) {
            ospBlock.setName(name);
        } else {
            try {
                OpAppProtBlockEntityObject ospBlockEntityObj = (OpAppProtBlockEntityObject)this.getPastedObject();
                ospBlock = ospBlockEntityObj.getOpAppProtectionBlock();
                ospBlock.setName(name);
                this.setOpAppProtectionBlock(ospBlock);
            }
            catch (ConsoleException ex) {
                LoggerUtilities.logException((Throwable)ex);
            }
        }
    }

    public OpAppProtectionBlock getOpAppProtectionBlock() {
        OpAppProtectionBlock ospBlock = this.ospBlockEntity.getOptOpAppProtectionBlock();
        if (ospBlock != null) {
            return ospBlock;
        }
        ObjReference objRef = this.ospBlockEntity.getOptObjReference();
        try {
            OpAppProtTemplate ospTemplate = (OpAppProtTemplate)DataobjectManager.getInstance().getObjectByGUID(objRef.getTargetType(), objRef.getTargetId());
            return ospTemplate.getOpAppProtectionBlock();
        }
        catch (ConsoleException ex) {
            LoggerUtilities.logException((Throwable)ex);
            return null;
        }
    }

    public void setOpAppProtectionBlock(OpAppProtectionBlock ospBlock) {
        this.ospBlockEntity.setOptOpAppProtectionBlock(ospBlock);
        this.ospBlockEntity.setOptObjReference(null);
    }

    public void setOpAppProtectionBlock(OpAppProtTemplate ospTemplate) {
        ObjReference objRef = new ObjReference();
        objRef.setName("AppProtTemplateLink");
        objRef.setTargetType("OpAppProtTemplate");
        objRef.setTargetId(ospTemplate.getId());
        this.ospBlockEntity.setOptObjReference(objRef);
        this.ospBlockEntity.setOptOpAppProtectionBlock(null);
    }

    @Override
    public Object getValueAt(int colIndex) {
        switch (colIndex) {
            case 0: {
                Boolean enable = this.ospBlockEntity.getOptEnable();
                if (enable == null) {
                    enable = this.ospBlockEntity.getDefEnable();
                }
                return enable;
            }
            case 1: {
                return this.getOpAppProtectionBlock().getName();
            }
            case 2: {
                Integer mode = this.ospBlockEntity.getOptMode();
                return mode == null || mode.equals(OpAppProtBlockEntity.TEST) ? MODE_TEST_ONLY : MODE_NORMAL;
            }
        }
        return "";
    }

    @Override
    public Class<?> getValueTypeAt(int colIndex) {
        switch (colIndex) {
            case 0: {
                return Boolean.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
        }
        return String.class;
    }

    @Override
    public void setValueAt(Object obj, int colIndex) {
        switch (colIndex) {
            case 0: {
                this.ospBlockEntity.setOptEnable((Boolean)obj);
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                this.ospBlockEntity.setOptMode(obj.equals(MODE_NORMAL) ? OpAppProtBlockEntity.NORMAL : OpAppProtBlockEntity.TEST);
                break;
            }
        }
    }

    @Override
    public CopitableObject getPastedObject() throws ConsoleException {
        try {
            WashIDHandler washer = new WashIDHandler();
            OpAppProtectionBlock ospBlock = this.getOpAppProtectionBlock();
            OpAppProtectionBlock newOspBlock = (OpAppProtectionBlock)washer.duplicateObject((ConfigObject)ospBlock, new HashMap<String, TopLevelObject>());
            OpAppProtBlockEntityObject newObj = new OpAppProtBlockEntityObject(newOspBlock);
            newObj.getOpAppProtBlockEntity().setOptEnable(this.ospBlockEntity.getOptEnable());
            newObj.getOpAppProtBlockEntity().setOptMode(this.ospBlockEntity.getOptMode());
            return newObj;
        }
        catch (Exception ex) {
            throw new ConsoleException(ex);
        }
    }

    private void setOspBlockEntityDefaultMode() {
        Integer mode = this.ospBlockEntity.getOptMode();
        if (mode == null) {
            this.ospBlockEntity.setOptMode(OpAppProtBlockEntity.TEST);
        }
    }
}

