/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.osprotect.dialog;

import com.sygate.scm.common.configobject.schema.OpFileChecksumMatchEntity;
import com.sygate.scm.common.configobject.schema.OpFileNameMatchEntity;
import com.sygate.scm.common.configobject.schema.OpProcessArgumentMatchEntity;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.DeviceObject;
import com.sygate.scm.console.ui.policy.dialog.DeviceSelectDlg;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.BadFormatException;
import com.sygate.scm.util.IntegerSet;
import com.sygate.scm.util.Utility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class StringConditionEditorDlg
extends DialogBase {
    private static final long serialVersionUID = -6264034646631995656L;
    public static final int RULE_APP = 0;
    public static final int FILE = 1;
    public static final int LAUNCH_PROCESS = 2;
    public static final int TERMINATE_PROCESS = 3;
    public static final int MODULE = 4;
    public static final int FILE_ONLY = 5;
    private static final String FIXED_DISK = "1";
    private static final String CD = "2";
    private static final String RAM_DISK = "3";
    private static final String REMOTE = "4";
    private static final String REMOVABLE_DISK = "5";
    private static final String NOTE = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "StringConditionEditorDlg.NameContentsDesc");
    private static final int NAME_MATCH_LENGTH = 255;
    private JPanel contentPane = new JPanel();
    private JTextArea jTANote = new DescriptionTextArea(NOTE, 2, 40);
    private JTextField jTFKeyMatch = new JTextField(new RestrictedPlainDocument(255), "", 40);
    private JRadioButton jRBName = new JRadioButton("", true);
    private JRadioButton jRBNormal = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "StringConditionEditorDlg.radio.UseNormalStr"), true);
    private JRadioButton jRBRegEx = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "StringConditionEditorDlg.radio.UseRegex"));
    private JCheckBox jCbxDriveType = new JCheckBox();
    private JCheckBox jCbxFixedDisk = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "StringConditionEditorDlg.checkbox.FixedDisk"), true);
    private JCheckBox jCbxCD = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "StringConditionEditorDlg.checkbox.OpticalDrives"), true);
    private JCheckBox jCbxRAM = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "StringConditionEditorDlg.checkbox.RAMDisk"), true);
    private JCheckBox jCbxRemote = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "StringConditionEditorDlg.checkbox.NetDrive"), true);
    private JCheckBox jCbxRemoveDisk = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "StringConditionEditorDlg.checkbox.RemovableDisk"), true);
    private JCheckBox jCbxDeviceClassType = new JCheckBox();
    private JCheckBox jCbxDeviceInstanceType = new JCheckBox();
    private JTextField jTFClassId = new JTextField(80);
    private JTextField jTFInstanceId = new JTextField(80);
    private JButton jBDeviceClass = new JButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "StringConditionEditorDlg.button.DeviceClassSelect"));
    private JButton jBDeviceInstance = new JButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "StringConditionEditorDlg.button.DeviceInstanceSelect"));
    private JButton jBOption = new JButton(UIText.get(3073));
    private JRadioButton jRBChecksum = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "StringConditionEditorDlg.radio.MatchFingerprint"));
    private JTextField jTFChecksumMatch = new JTextField(new RestrictedPlainDocument(64), "", 64);
    private JCheckBox jCbxArgument = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "StringConditionEditorDlg.checkbox.MatchProcWithArgs"));
    private JTextField jTFArguMatch = new JTextField();
    private JRadioButton jRBExact = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "StringConditionEditorDlg.radio.MatchExactly"), true);
    private JRadioButton jRBArguRegEx = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "StringConditionEditorDlg.radio.UseRegex"));
    private JPanel optionPanel;
    private int type;
    private OpFileNameMatchEntity nameEntity;
    private OpFileChecksumMatchEntity checksumEntity;
    private OpProcessArgumentMatchEntity arguEntity;
    private JPanel matchPanel;

    public StringConditionEditorDlg(int type) {
        this(type, null, null, null, false);
    }

    public StringConditionEditorDlg(int type, OpFileNameMatchEntity nameEntity, OpFileChecksumMatchEntity checksumEntity, OpProcessArgumentMatchEntity arguEntity, boolean isReadonly) {
        super(Manager.getFrame(), "", true);
        this.type = type;
        this.nameEntity = nameEntity;
        this.checksumEntity = checksumEntity;
        this.arguEntity = arguEntity;
        this.setTitle(this.getTitle(type));
        this.initialize(isReadonly);
        this.initData();
        if (!isReadonly) {
            this.driveTypeStateChanged(false);
            this.matchTypeChanged();
            this.processArgumentChanged();
        }
        UiUtilities.centerComponent((Component)this);
        this.setVisible(true);
    }

    @Override
    protected boolean isValidate() {
        if (this.jRBName.isSelected()) {
            String nameMatch = this.jTFKeyMatch.getText().trim();
            if (nameMatch.length() == 0) {
                JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "StringConditionEditorDlg.error.EnterStrToMatch"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "StringConditionEditorDlg.title.Error"), 0);
                this.jTFKeyMatch.requestFocusInWindow();
                return false;
            }
            if (!this.jRBRegEx.isSelected() && !this.isValidNormalMatch(nameMatch)) {
                JOptionPane.showMessageDialog(this, MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "StringConditionEditorDlg.error.InvalidMatchStr"), this.getMatchNameErrorText()), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "StringConditionEditorDlg.title.Error"), 0);
                this.jTFKeyMatch.requestFocusInWindow();
                return false;
            }
            if (this.jCbxDeviceClassType.isSelected() && this.jTFClassId.getText().trim().length() <= 0) {
                JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "StringConditionEditorDlg.warn.PleaseInputDeviceClassID"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "StringConditionEditorDlg.title.Error"), 0);
                this.jTFClassId.requestFocusInWindow();
                return false;
            }
            if (this.jCbxDeviceInstanceType.isSelected() && this.jTFInstanceId.getText().trim().length() <= 0) {
                JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "StringConditionEditorDlg.warn.PleaseInputDeviceInstanceID"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "StringConditionEditorDlg.title.Error"), 0);
                this.jTFInstanceId.requestFocusInWindow();
                return false;
            }
        }
        if (this.hasChecksumPanel() && this.jRBChecksum.isSelected()) {
            String checksum = this.jTFChecksumMatch.getText().trim();
            if (checksum.length() == 0) {
                JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "StringConditionEditorDlg.EnterFingerprint"));
                this.jTFChecksumMatch.requestFocusInWindow();
                return false;
            }
            if (!Utility.isValidChecksum((String)checksum)) {
                JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "StringConditionEditorDlg.error.InvalidFingerprint"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "StringConditionEditorDlg.title.InvalidFingerprint"), 0);
                this.jTFChecksumMatch.requestFocusInWindow();
                return false;
            }
        }
        return true;
    }

    @Override
    protected void commit() {
        this.updateData();
    }

    @Override
    public String getContentSensitiveHelpToken() {
        switch (this.type) {
            case 0: {
                return "sesm_policies_dialog_hdp_hardware_device_protection_add_rule_definition_add";
            }
            case 1: 
            case 5: {
                return "sesm_policies_dialog_hdp_hardware_device_protection_add_file_definition_add";
            }
            case 2: 
            case 3: {
                return "sesm_policies_dialog_hdp_hardware_device_protection_add_process_definition_add";
            }
        }
        return "sesm_policies_dialog_hdp_hardware_device_protection_add_dll_definition_add";
    }

    private void initialize(boolean isReadonly) {
        ButtonGroup group = new ButtonGroup();
        group.add(this.jRBName);
        group.add(this.jRBChecksum);
        this.jCbxArgument.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StringConditionEditorDlg.this.processArgumentChanged();
            }
        });
        this.jBOption.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StringConditionEditorDlg.this.optionChanged();
            }
        });
        this.contentPane.setLayout(new GridBagLayout());
        if (this.hasChecksumPanel()) {
            this.contentPane.add((Component)this.jRBName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 12, 0, 5), 0, 0));
        }
        JPanel match = this.getMatchPanel();
        this.contentPane.add((Component)match, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        if (this.hasChecksumPanel() || this.hasArgumentPanel()) {
            this.contentPane.add((Component)this.jBOption, new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 13, 0, new Insets(0, 5, 5, 5), 0, 0));
        }
        this.contentPane.add((Component)this.getButtonPanel(), new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.optionPanel = this.getOptionPanel();
        this.getContentPane().add(new JScrollPane(this.contentPane));
        if (isReadonly) {
            this.jRBName.setEnabled(false);
            UIUtilities.setContainerStatus(match, false);
            this.jBOption.setEnabled(false);
            UIUtilities.setContainerStatus(this.optionPanel, false);
            this.jBOption.setEnabled(true);
            this.resetOKButton(false);
        }
        this.validate();
        this.pack();
        this.jTFKeyMatch.requestFocusInWindow();
    }

    private JPanel getMatchPanel() {
        this.jRBName.setText(this.getMatchNameText());
        this.jRBName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StringConditionEditorDlg.this.matchTypeChanged();
            }
        });
        ButtonGroup group = new ButtonGroup();
        group.add(this.jRBRegEx);
        group.add(this.jRBNormal);
        this.jCbxDriveType.setText(this.getDriveTypeText());
        this.jCbxDriveType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StringConditionEditorDlg.this.driveTypeStateChanged(true);
            }
        });
        this.jCbxFixedDisk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StringConditionEditorDlg.this.resetDriveTypeWhenNoDriveSelected();
            }
        });
        this.jCbxCD.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StringConditionEditorDlg.this.resetDriveTypeWhenNoDriveSelected();
            }
        });
        this.jCbxRAM.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StringConditionEditorDlg.this.resetDriveTypeWhenNoDriveSelected();
            }
        });
        this.jCbxRemote.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StringConditionEditorDlg.this.resetDriveTypeWhenNoDriveSelected();
            }
        });
        this.jCbxRemoveDisk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StringConditionEditorDlg.this.resetDriveTypeWhenNoDriveSelected();
            }
        });
        this.jCbxDeviceClassType.setText(this.getDeviceClassTypeText());
        this.jCbxDeviceInstanceType.setText(this.getDeviceInstanceTypeText());
        this.jCbxDeviceClassType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StringConditionEditorDlg.this.deviceClassTypeStateChanged();
            }
        });
        this.jCbxDeviceInstanceType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StringConditionEditorDlg.this.deviceInstanceTypeStateChanged();
            }
        });
        this.jBDeviceClass.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StringConditionEditorDlg.this.deviceClassSelect();
            }
        });
        this.jBDeviceInstance.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StringConditionEditorDlg.this.deviceInstanceSelect();
            }
        });
        if (this.matchPanel == null) {
            this.matchPanel = new JPanel(new GridBagLayout());
            this.matchPanel.setBorder(BorderFactory.createTitledBorder(this.getMatchPanelTitle()));
            this.matchPanel.add((Component)this.jTANote, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 11, 1, new Insets(0, 5, 0, 5), 0, 0));
            this.matchPanel.add((Component)this.jTFKeyMatch, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
            this.matchPanel.add((Component)this.jRBNormal, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 12, 0, 5), 0, 0));
            this.matchPanel.add((Component)this.jRBRegEx, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 12, 0, 5), 0, 0));
            this.matchPanel.add((Component)this.jCbxDriveType, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 12, 0, 5), 0, 0));
            this.matchPanel.add((Component)this.getDriveTypePanel(), new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.matchPanel.add((Component)this.jCbxDeviceInstanceType, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 12, 0, 5), 0, 0));
            this.matchPanel.add((Component)this.getDeviceInstanceTypePanel(), new GridBagConstraints(0, 6, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        }
        return this.matchPanel;
    }

    private JPanel getDriveTypePanel() {
        JPanel panel = new JPanel(new GridLayout(3, 2));
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(" "), BorderFactory.createEmptyBorder(5, 20, 5, 20)));
        panel.add(this.jCbxFixedDisk);
        panel.add(this.jCbxRemote);
        panel.add(this.jCbxCD);
        panel.add(this.jCbxRemoveDisk);
        panel.add(this.jCbxRAM);
        return panel;
    }

    private JPanel getDeviceInstanceTypePanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 2));
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(" "), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        panel.add(this.jTFInstanceId);
        this.jTFInstanceId.setMaximumSize(this.jTFInstanceId.getPreferredSize());
        panel.add(Box.createRigidArea(new Dimension(5, 0)));
        panel.add(this.jBDeviceInstance);
        return panel;
    }

    private JPanel getChecksumPanel() {
        this.jRBChecksum.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StringConditionEditorDlg.this.matchTypeChanged();
            }
        });
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(" "), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        panel.add((Component)this.jTFChecksumMatch, "Center");
        return panel;
    }

    private JPanel getArgumentPanel() {
        ButtonGroup group = new ButtonGroup();
        group.add(this.jRBExact);
        group.add(this.jRBArguRegEx);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder(" "));
        panel.add((Component)this.jTFArguMatch, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        panel.add((Component)this.jRBExact, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 12, 0, 5), 0, 0));
        panel.add((Component)this.jRBArguRegEx, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 12, 5, 5), 0, 0));
        return panel;
    }

    private JPanel getOptionPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        if (this.hasChecksumPanel()) {
            panel.add((Component)this.jRBChecksum, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 12, 0, 5), 0, 0));
            panel.add((Component)this.getChecksumPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        }
        if (this.hasArgumentPanel()) {
            panel.add((Component)this.jCbxArgument, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 12, 0, 5), 0, 0));
            panel.add((Component)this.getArgumentPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        }
        return panel;
    }

    private String getTitle(int type) {
        String edit = "";
        if (this.nameEntity != null || this.checksumEntity != null || this.arguEntity != null) {
            edit = ".edit";
        }
        switch (type) {
            case 0: {
                return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "StringConditionEditorDlg.title.ProgDefn" + edit);
            }
            case 1: {
                return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "StringConditionEditorDlg.title.TgtFileDefn" + edit);
            }
            case 5: {
                return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "StringConditionEditorDlg.title.TgtFileOnlyDefn" + edit);
            }
            case 2: 
            case 3: {
                return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "StringConditionEditorDlg.title.TgtProcDefn" + edit);
            }
        }
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "StringConditionEditorDlg.title.TgtDLLDefn" + edit);
    }

    private String getMatchNameText() {
        switch (this.type) {
            case 0: 
            case 2: 
            case 3: {
                return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "StringConditionEditorDlg.ProcNameToMatch");
            }
            case 4: {
                return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "StringConditionEditorDlg.DLLNameToMatch");
            }
        }
        return "";
    }

    private String getMatchPanelTitle() {
        if (this.type == 1) {
            return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "StringConditionEditorDlg.FileNameToMatch");
        }
        if (this.type == 5) {
            return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "StringConditionEditorDlg.FileOnlyNameToMatch");
        }
        return " ";
    }

    private String getDriveTypeText() {
        switch (this.type) {
            case 0: 
            case 2: 
            case 3: {
                return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "StringConditionEditorDlg.MatchProcsForDriveTypes");
            }
            case 1: 
            case 5: {
                return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "StringConditionEditorDlg.MatchFilesForDriveTypes");
            }
        }
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "StringConditionEditorDlg.MatchDLLsForDriveTypes");
    }

    private String getDeviceInstanceTypeText() {
        switch (this.type) {
            case 0: 
            case 2: 
            case 3: {
                return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "StringConditionEditorDlg.label.OnlyMatchProcessesByInstanceID");
            }
            case 1: 
            case 5: {
                return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "StringConditionEditorDlg.label.OnlyMatchFilesByInstanceID");
            }
        }
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "StringConditionEditorDlg.label.OnlyMatchDLLsByInstanceID");
    }

    private String getDeviceClassTypeText() {
        switch (this.type) {
            case 0: 
            case 2: 
            case 3: {
                return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "StringConditionEditorDlg.label.OnlyMatchProcessesByClassID");
            }
            case 1: 
            case 5: {
                return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "StringConditionEditorDlg.label.OnlyMatchFilesByClassID");
            }
        }
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "StringConditionEditorDlg.label.OnlyMatchDLLsByClassID");
    }

    private String getMatchNameErrorText() {
        switch (this.type) {
            case 0: 
            case 2: 
            case 3: {
                return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "StringConditionEditorDlg.ProcName");
            }
            case 4: {
                return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "StringConditionEditorDlg.DLLName");
            }
        }
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "StringConditionEditorDlg.FileName");
    }

    private boolean hasChecksumPanel() {
        return this.type != 1 && this.type != 5;
    }

    private boolean hasArgumentPanel() {
        return this.type == 0 || this.type == 2;
    }

    private void initData() {
        if (this.nameEntity != null) {
            this.jRBName.setSelected(this.isNameEntityEnabled());
            this.jTFKeyMatch.setText(this.nameEntity.getKeyString());
            this.jRBNormal.setSelected(this.getNameEntityMethod().equals(OpFileNameMatchEntity.NORMAL));
            this.jRBRegEx.setSelected(!this.getNameEntityMethod().equals(OpFileNameMatchEntity.NORMAL));
            this.jCbxDriveType.setSelected(this.isNameEntityEnableDriveTypes());
            try {
                IntegerSet driveTypes = new IntegerSet(this.nameEntity.getOptDriveTypes());
                this.jCbxFixedDisk.setSelected(driveTypes.contains(FIXED_DISK, 10));
                this.jCbxCD.setSelected(driveTypes.contains(CD, 10));
                this.jCbxRAM.setSelected(driveTypes.contains(RAM_DISK, 10));
                this.jCbxRemote.setSelected(driveTypes.contains(REMOTE, 10));
                this.jCbxRemoveDisk.setSelected(driveTypes.contains(REMOVABLE_DISK, 10));
            }
            catch (BadFormatException ex) {
                System.err.println("StringConditionEditor->initData(): Bad Format for drive type.");
            }
            this.jCbxDeviceClassType.setSelected(this.isNameEntityEnableDeviceClassTypes());
            this.jCbxDeviceInstanceType.setSelected(this.isNameEntityEnableDeviceInstanceTypes());
            this.jTFClassId.setText(this.nameEntity.getOptDeviceClassTypes());
            this.jTFInstanceId.setText(this.nameEntity.getOptDeviceInstanceTypes());
        }
        if (this.checksumEntity != null) {
            this.jRBChecksum.setSelected(this.isChecksumEntityEnable());
            this.jTFChecksumMatch.setText(this.checksumEntity.getFileChecksum());
        }
        if (this.arguEntity != null) {
            this.jCbxArgument.setSelected(this.isArguEntityEnable());
            this.jRBExact.setSelected(this.getArguEntityMethod().equals(OpProcessArgumentMatchEntity.NORMAL));
            this.jRBArguRegEx.setSelected(!this.getArguEntityMethod().equals(OpProcessArgumentMatchEntity.NORMAL));
            this.jTFArguMatch.setText(this.arguEntity.getKeyString());
        }
    }

    private void updateData() {
        if (this.nameEntity == null) {
            this.nameEntity = new OpFileNameMatchEntity();
        }
        if (this.jRBName.isSelected() != this.isNameEntityEnabled()) {
            this.nameEntity.setOptEnable(Boolean.valueOf(this.jRBName.isSelected()));
        }
        if (this.jRBNormal.isSelected() && !this.getNameEntityMethod().equals(OpFileNameMatchEntity.NORMAL)) {
            this.nameEntity.setOptMethod(OpFileNameMatchEntity.NORMAL);
        } else if (this.jRBRegEx.isSelected() && !this.getNameEntityMethod().equals(OpFileNameMatchEntity.REG_EX)) {
            this.nameEntity.setOptMethod(OpFileNameMatchEntity.REG_EX);
        }
        this.nameEntity.setKeyString(this.jTFKeyMatch.getText().trim());
        if (this.jCbxDriveType.isSelected() != this.isNameEntityEnableDriveTypes()) {
            this.nameEntity.setOptEnableDriveTypes(Boolean.valueOf(this.jCbxDriveType.isSelected()));
        }
        IntegerSet driveSet = new IntegerSet();
        if (this.jCbxFixedDisk.isSelected()) {
            driveSet.add(FIXED_DISK);
        }
        if (this.jCbxCD.isSelected()) {
            driveSet.add(CD);
        }
        if (this.jCbxRAM.isSelected()) {
            driveSet.add(RAM_DISK);
        }
        if (this.jCbxRemote.isSelected()) {
            driveSet.add(REMOTE);
        }
        if (this.jCbxRemoveDisk.isSelected()) {
            driveSet.add(REMOVABLE_DISK);
        }
        this.nameEntity.setOptDriveTypes(driveSet.toString(10, true));
        this.nameEntity.setOptEnableDeviceClassTypes(Boolean.valueOf(this.jCbxDeviceClassType.isSelected()));
        if (this.jCbxDeviceClassType.isSelected() && this.jCbxDeviceClassType.isEnabled()) {
            this.nameEntity.setOptDeviceClassTypes(this.jTFClassId.getText().trim());
        } else {
            this.nameEntity.setOptDeviceClassTypes("");
            this.nameEntity.setOptEnableDeviceClassTypes(Boolean.valueOf(false));
        }
        this.nameEntity.setOptEnableDeviceInstanceTypes(Boolean.valueOf(this.jCbxDeviceInstanceType.isSelected()));
        if (this.jCbxDeviceInstanceType.isSelected() && this.jCbxDeviceInstanceType.isEnabled()) {
            this.nameEntity.setOptDeviceInstanceTypes(this.jTFInstanceId.getText().trim());
        } else {
            this.nameEntity.setOptDeviceInstanceTypes("");
            this.nameEntity.setOptEnableDeviceInstanceTypes(Boolean.valueOf(false));
        }
        if (this.hasChecksumPanel()) {
            if (this.checksumEntity == null) {
                this.checksumEntity = new OpFileChecksumMatchEntity();
            }
            if (this.jRBChecksum.isSelected() != this.isChecksumEntityEnable()) {
                this.checksumEntity.setOptEnable(Boolean.valueOf(this.jRBChecksum.isSelected()));
            }
            this.checksumEntity.setFileChecksum(this.jTFChecksumMatch.getText().trim());
        }
        if (this.hasArgumentPanel()) {
            if (this.arguEntity == null) {
                this.arguEntity = new OpProcessArgumentMatchEntity();
            }
            if (this.jCbxArgument.isSelected() != this.isArguEntityEnable()) {
                this.arguEntity.setOptEnable(Boolean.valueOf(this.jCbxArgument.isSelected()));
            }
            if (this.jRBExact.isSelected() && !this.getArguEntityMethod().equals(OpProcessArgumentMatchEntity.NORMAL)) {
                this.arguEntity.setOptMethod(OpProcessArgumentMatchEntity.NORMAL);
            } else if (this.jRBArguRegEx.isSelected() && !this.getArguEntityMethod().equals(OpProcessArgumentMatchEntity.REG_EX)) {
                this.arguEntity.setOptMethod(OpProcessArgumentMatchEntity.REG_EX);
            }
            this.arguEntity.setKeyString(this.jTFArguMatch.getText().trim());
        }
    }

    private void matchTypeChanged() {
        boolean isNameType = this.jRBName.isSelected();
        this.jTANote.setEnabled(isNameType);
        this.jTFKeyMatch.setEnabled(isNameType);
        this.jRBNormal.setEnabled(isNameType);
        this.jRBRegEx.setEnabled(isNameType);
        this.jCbxDriveType.setEnabled(isNameType);
        this.driveTypeStateChanged(false);
        this.jCbxDeviceClassType.setEnabled(isNameType);
        this.jCbxDeviceInstanceType.setEnabled(isNameType);
        this.deviceClassTypeStateChanged();
        this.deviceInstanceTypeStateChanged();
        this.jTFChecksumMatch.setEnabled(!isNameType);
    }

    private void driveTypeStateChanged(boolean resetValue) {
        boolean isSelected = this.jCbxDriveType.isSelected() && this.jCbxDriveType.isEnabled();
        this.jCbxFixedDisk.setEnabled(isSelected);
        this.jCbxCD.setEnabled(isSelected);
        this.jCbxRAM.setEnabled(isSelected);
        this.jCbxRemote.setEnabled(isSelected);
        this.jCbxRemoveDisk.setEnabled(isSelected);
        if (resetValue) {
            this.jCbxFixedDisk.setSelected(isSelected);
            this.jCbxCD.setSelected(isSelected);
            this.jCbxRAM.setSelected(isSelected);
            this.jCbxRemote.setSelected(isSelected);
            this.jCbxRemoveDisk.setSelected(isSelected);
        }
    }

    private void resetDriveTypeWhenNoDriveSelected() {
        if (!(this.jCbxFixedDisk.isSelected() || this.jCbxCD.isSelected() || this.jCbxRAM.isSelected() || this.jCbxRemote.isSelected() || this.jCbxRemoveDisk.isSelected())) {
            this.jCbxDriveType.setSelected(false);
            this.driveTypeStateChanged(false);
        }
    }

    private void deviceClassTypeStateChanged() {
        boolean isSelected = this.jCbxDeviceClassType.isSelected() && this.jCbxDeviceClassType.isEnabled();
        this.jTFClassId.setEnabled(isSelected);
        this.jBDeviceClass.setEnabled(isSelected);
    }

    private void deviceInstanceTypeStateChanged() {
        boolean isSelected = this.jCbxDeviceInstanceType.isSelected() && this.jCbxDeviceInstanceType.isEnabled();
        this.jTFInstanceId.setEnabled(isSelected);
        this.jBDeviceInstance.setEnabled(isSelected);
    }

    private void deviceClassSelect() {
        String[] tableColumnName = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "StringConditionEditorDlg.DeviceClassSelectDlg.column.DeviceClassName"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "StringConditionEditorDlg.DeviceClassSelectDlg.column.DeviceClassID")};
        int[] tableColumnMap = new int[]{0, 2};
        float[] tableColumnWidth = new float[]{1.0f, 1.0f};
        String sTile = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "StringConditionEditorDlg.DeviceClassSelectDlg.title");
        DeviceSelectDlg dlg = new DeviceSelectDlg(sTile, tableColumnName, tableColumnMap, tableColumnWidth, null, "Class", 0);
        if (!dlg.isCancel()) {
            for (DeviceObject selectedObject : dlg.getSelection()) {
                if (selectedObject == null) continue;
                this.jTFClassId.setText(selectedObject.getDeviceClassId());
            }
        }
    }

    private void deviceInstanceSelect() {
        String[] tableColumnName = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "StringConditionEditorDlg.DeviceInstanceSelectDlg.column.DeviceInstanceName"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "StringConditionEditorDlg.DeviceInstanceSelectDlg.column.DeviceInstanceID")};
        int[] tableColumnMap = new int[]{0, 2};
        float[] tableColumnWidth = new float[]{1.0f, 1.0f};
        String sTile = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "StringConditionEditorDlg.DeviceClassSelectDlg.title");
        DeviceSelectDlg dlg = new DeviceSelectDlg(sTile, tableColumnName, tableColumnMap, tableColumnWidth, null, "Instance", 0);
        if (!dlg.isCancel()) {
            for (DeviceObject selectedObject : dlg.getSelection()) {
                if (selectedObject == null) continue;
                this.jTFInstanceId.setText(selectedObject.getDeviceInstanceId());
            }
        }
    }

    private void processArgumentChanged() {
        boolean isSelected = this.jCbxArgument.isSelected();
        this.jTFArguMatch.setEnabled(isSelected);
        this.jRBExact.setEnabled(isSelected);
        this.jRBArguRegEx.setEnabled(isSelected);
    }

    private void optionChanged() {
        if (this.optionPanel.getParent() != null) {
            this.contentPane.remove(this.optionPanel);
            this.jBOption.setText(UIText.get(3073));
        } else {
            this.contentPane.add((Component)this.optionPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 5, 0), 0, 0));
            this.jBOption.setText(UIText.get(2817));
        }
        this.validate();
        this.pack();
    }

    private boolean isValidNormalMatch(String conditionStr) {
        int count1 = 0;
        int count2 = 0;
        for (int i = 0; i < conditionStr.length(); ++i) {
            count1 += conditionStr.charAt(i) == '#' ? 1 : 0;
            count2 += conditionStr.charAt(i) == '%' ? 1 : 0;
        }
        return count1 % 2 == 0 && count2 % 2 == 0;
    }

    private boolean isNameEntityEnabled() {
        Boolean enable = this.nameEntity.getOptEnable();
        if (enable == null) {
            enable = this.nameEntity.getDefEnable();
        }
        return enable;
    }

    private Integer getNameEntityMethod() {
        Integer method = this.nameEntity.getOptMethod();
        if (method == null) {
            method = this.nameEntity.getDefMethod();
        }
        return method;
    }

    private boolean isNameEntityEnableDriveTypes() {
        Boolean enable = this.nameEntity.getOptEnableDriveTypes();
        if (enable == null) {
            enable = this.nameEntity.getDefEnableDriveTypes();
        }
        return enable;
    }

    private boolean isNameEntityEnableDeviceClassTypes() {
        Boolean enable = this.nameEntity.getOptEnableDeviceClassTypes();
        if (enable == null) {
            enable = this.nameEntity.getDefEnableDeviceClassTypes();
        }
        return enable;
    }

    private boolean isNameEntityEnableDeviceInstanceTypes() {
        Boolean enable = this.nameEntity.getOptEnableDeviceInstanceTypes();
        if (enable == null) {
            enable = this.nameEntity.getDefEnableDeviceInstanceTypes();
        }
        return enable;
    }

    private boolean isChecksumEntityEnable() {
        Boolean enable = this.checksumEntity.getOptEnable();
        if (enable == null) {
            enable = this.checksumEntity.getDefEnable();
        }
        return enable;
    }

    private boolean isArguEntityEnable() {
        Boolean enable = this.arguEntity.getOptEnable();
        if (enable == null) {
            enable = this.arguEntity.getDefEnable();
        }
        return enable;
    }

    private Integer getArguEntityMethod() {
        Integer method = this.arguEntity.getOptMethod();
        if (method == null) {
            method = this.arguEntity.getDefMethod();
        }
        return method;
    }

    public OpFileNameMatchEntity getFileNameMatchEntity() {
        return this.nameEntity;
    }

    public OpFileChecksumMatchEntity getFileChecksumMatchEntity() {
        return this.checksumEntity;
    }

    public OpProcessArgumentMatchEntity getProcessArgumentMatchEntity() {
        return this.arguEntity;
    }

    public void setMatchPanelTitle(String title) {
        this.matchPanel.setBorder(BorderFactory.createTitledBorder(title));
        this.matchPanel.repaint();
    }
}

