/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.osprotect.dialog;

import com.sygate.scm.common.configobject.schema.OpAppProtectionBlock;
import com.sygate.scm.common.configobject.schema.OpAppRule;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.ui.policy.osprotect.AddRulePermissionMenu;
import com.sygate.scm.console.ui.policy.osprotect.FilePanel;
import com.sygate.scm.console.ui.policy.osprotect.LaunchProcessPanel;
import com.sygate.scm.console.ui.policy.osprotect.ModulePanel;
import com.sygate.scm.console.ui.policy.osprotect.OSProtectionBlockPanel;
import com.sygate.scm.console.ui.policy.osprotect.OSProtectionTreeModel;
import com.sygate.scm.console.ui.policy.osprotect.OSProtectionTreePopupMenu;
import com.sygate.scm.console.ui.policy.osprotect.OSProtectionTreeUserObject;
import com.sygate.scm.console.ui.policy.osprotect.RegistryPanel;
import com.sygate.scm.console.ui.policy.osprotect.RulePanel;
import com.sygate.scm.console.ui.policy.osprotect.TerminateProcessPanel;
import com.sygate.scm.console.ui.policy.osprotect.logicobject.OpAppProtectionBlockObject;
import com.sygate.scm.console.ui.policy.osprotect.logicobject.OpPermissionListObject;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.ui.util.renderer.CustomTreeCellRenderer;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.Utility;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class RuleEditorDlg
extends DialogBase {
    private static final long serialVersionUID = 6505945005214433527L;
    private static final int VISIBLE_TREE_VIEW_COUNT = 4;
    private JTextField jTFName = new JTextField();
    private JTextArea jTADesc = new JTextArea(2, 40);
    private JCheckBox jCbxLog = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "RuleEditorDlg.checkbox.DisableLogging"));
    private JTree jTRule = new JTree();
    private JPanel jEditorPanel = new JPanel(new CardLayout());
    private JButton jBAdd = new JButton(UIText.get(5));
    private JButton jBDelete = new JButton(UIText.get(769));
    private JButton jBUp = new JButton(UIText.get(3075));
    private JButton jBDown = new JButton(UIText.get(3074));
    private RulePanel rulePanel;
    private RegistryPanel registryPanel;
    private FilePanel filePanel;
    private LaunchProcessPanel launchPanel;
    private TerminateProcessPanel terminatePanel;
    private ModulePanel modulePanel;
    private OpAppProtectionBlock protectBlock;
    private List<String> compoundRuleNames;
    private TreePath currentTreePath;
    private int currentUIKey;
    private boolean isReadonly;

    public RuleEditorDlg(OpAppProtectionBlock protectBlock, Vector<String> compoundRuleNames, String title, boolean isReadonly) {
        super(Manager.getFrame(), title, true);
        this.protectBlock = protectBlock;
        this.compoundRuleNames = new ArrayList<String>(compoundRuleNames);
        this.isReadonly = isReadonly;
        this.initialize();
        this.initData();
        this.jTFName.requestFocusInWindow();
        this.jTFName.setSelectionStart(0);
        this.jTFName.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                RuleEditorDlg.this.summaryChange();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                RuleEditorDlg.this.summaryChange();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                RuleEditorDlg.this.summaryChange();
            }
        });
        this.pack();
        UiUtilities.centerComponent((Component)this);
        this.setVisible(true);
    }

    public void deleteTreeNode() {
        int retCode = JOptionPane.showConfirmDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "RuleEditorDlg.ConfirmDelRules"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "RuleEditorDlg.title.Delete"), 0, 3);
        if (retCode != 0) {
            return;
        }
        TreePath[] selPaths = this.jTRule.getSelectionPaths();
        int i = selPaths.length;
        while (--i >= 0) {
            DefaultMutableTreeNode selNode = (DefaultMutableTreeNode)selPaths[i].getLastPathComponent();
            if (((OSProtectionTreeModel)this.jTRule.getModel()).canDelete(selNode)) {
                this.jTRule.setSelectionPath(((OSProtectionTreeModel)this.jTRule.getModel()).deleteNode(selNode));
                continue;
            }
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "RuleEditorDlg.error.DelLastRule"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "RuleEditorDlg.title.Delete"), 0);
        }
    }

    public void moveUpTreeNode() {
        DefaultMutableTreeNode selNode = (DefaultMutableTreeNode)this.jTRule.getLastSelectedPathComponent();
        DefaultMutableTreeNode prevNode = selNode.getPreviousSibling();
        boolean isExpanded = this.isNodeExpanded(selNode);
        ((OSProtectionTreeModel)this.jTRule.getModel()).swapNode(prevNode, selNode);
        this.jTRule.setSelectionPath(new TreePath(selNode.getPath()));
        if (isExpanded) {
            UIUtilities.expandTreeByDepth(this.jTRule, selNode, 1);
        }
    }

    public void moveDownTreeNode() {
        DefaultMutableTreeNode selNode = (DefaultMutableTreeNode)this.jTRule.getLastSelectedPathComponent();
        DefaultMutableTreeNode nextNode = selNode.getNextSibling();
        boolean isExpanded = this.isNodeExpanded(nextNode);
        ((OSProtectionTreeModel)this.jTRule.getModel()).swapNode(selNode, nextNode);
        this.checkTreeButtons();
        if (isExpanded) {
            UIUtilities.expandTreeByDepth(this.jTRule, nextNode, 1);
        }
    }

    @Override
    protected boolean isValidate() {
        String protectBlockName = this.jTFName.getText().trim();
        if (protectBlockName.length() == 0) {
            JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "RuleEditorDlg.error.EmptyName"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "RuleEditorDlg.title.Error"), 0);
            this.jTFName.requestFocusInWindow();
            return false;
        }
        for (String ruleName : this.compoundRuleNames) {
            if (!protectBlockName.equalsIgnoreCase(ruleName)) continue;
            JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "RuleEditorDlg.error.CompRuleNameInUse"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "RuleEditorDlg.title.Error"), 0);
            this.jTFName.requestFocusInWindow();
            return false;
        }
        return this.commitCurrentPanel();
    }

    @Override
    protected void commit() {
        this.protectBlock.setName(this.jTFName.getText().trim());
        this.protectBlock.setOptDescription(this.jTADesc.getText().trim());
        this.protectBlock.setOptEnableLog(Boolean.valueOf(this.jCbxLog.isSelected()));
    }

    @Override
    public String getContentSensitiveHelpToken() {
        Object curComp = null;
        for (int i = 0; i < this.jEditorPanel.getComponentCount(); ++i) {
            Component comp = this.jEditorPanel.getComponent(i);
            if (!comp.isVisible()) continue;
            curComp = comp;
        }
        if (curComp != null) {
            System.err.println("OSP Class: " + curComp.getClass().getName());
            if (curComp instanceof ContentSensitiveHelpPage) {
                return ((ContentSensitiveHelpPage)curComp).getContentSensitiveHelpToken();
            }
        }
        return null;
    }

    private void initialize() {
        JPanel top = this.getTopPanel();
        this.getContentPane().add((Component)top, "North");
        this.getContentPane().add((Component)this.getProtectBlockPanel(), "Center");
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
        if (this.isReadonly) {
            UIUtilities.setContainerStatus(top, false);
            this.jBAdd.setEnabled(false);
            this.resetOKButton(false);
        }
        this.setSize(this.getPreferredSize().width + 100, this.getPreferredSize().height + 100);
        this.jTFName.setSelectionEnd(this.jTFName.getText().length());
    }

    private JPanel getTopPanel() {
        RestrictedPlainDocument nameDoc = new RestrictedPlainDocument(255);
        nameDoc.setValidator("\"/\\*?<>|:", false);
        this.jTFName.setDocument(nameDoc);
        RestrictedPlainDocument descDoc = new RestrictedPlainDocument(1023);
        descDoc.setValidator("\"`", false);
        this.jTADesc.setDocument(descDoc);
        this.jTADesc.setWrapStyleWord(true);
        this.jTADesc.setLineWrap(true);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "RuleEditorDlg.label.ProtName")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)this.jTFName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.jCbxLog, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 20, 0, 5), 0, 0));
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "RuleEditorDlg.label.Desc")), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 0, 0), 0, 0));
        JScrollPane scroll = new JScrollPane();
        UiUtilities.setupScrollPane((JScrollPane)scroll, (JTextArea)this.jTADesc);
        panel.add((Component)scroll, new GridBagConstraints(1, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 5), 0, 0));
        return panel;
    }

    private void summaryChange() {
        if (this.rulePanel != null) {
            this.rulePanel.stateChanged(new ChangeEvent(this));
        }
    }

    private JPanel getProtectBlockPanel() {
        this.initializeEditorPanel();
        JPanel treePanel = this.getTreePanel();
        treePanel.setMinimumSize(new Dimension(100, treePanel.getMinimumSize().height));
        this.jEditorPanel.setMinimumSize(new Dimension(100, this.jEditorPanel.getMinimumSize().height));
        JSplitPane pane = new JSplitPane(1, treePanel, this.jEditorPanel);
        pane.setOneTouchExpandable(true);
        pane.setDividerLocation(260);
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        panel.add(pane);
        return panel;
    }

    private JPanel getTreePanel() {
        this.initializeTree();
        this.jBAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddRulePermissionMenu menu = new AddRulePermissionMenu(RuleEditorDlg.this.jTRule);
                RuleEditorDlg.this.jBAdd.add(menu);
                menu.show(RuleEditorDlg.this.jBAdd, RuleEditorDlg.this.jBAdd.getX(), 0);
            }
        });
        this.jBDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RuleEditorDlg.this.deleteTreeNode();
            }
        });
        this.jBUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RuleEditorDlg.this.moveUpTreeNode();
            }
        });
        this.jBDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RuleEditorDlg.this.moveDownTreeNode();
            }
        });
        UIUtilities.fitJComponent(new JButton[]{this.jBAdd, this.jBDelete, this.jBUp, this.jBDown});
        JScrollPane pane = new JScrollPane(this.jTRule);
        pane.addMouseListener(new TreeMouseListener());
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "RuleEditorDlg.title.ProtContent")));
        panel.add((Component)pane, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.jBAdd, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.jBDelete, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 2, 0, 0), 0, 0));
        panel.add((Component)this.jBUp, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 0, 0, 0), 0, 0));
        panel.add((Component)this.jBDown, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 0, 0), 0, 0));
        return panel;
    }

    private void initData() {
        this.jTFName.setText(this.protectBlock.getName());
        this.jTADesc.setText(this.protectBlock.getOptDescription());
        this.jCbxLog.setSelected(Utility.getBooleanValue((Boolean)this.protectBlock.getOptEnableLog(), (Boolean)this.protectBlock.getDefEnableLog()));
        this.compoundRuleNames.remove(this.protectBlock.getName());
        this.treeSelectionChanged();
    }

    private void initializeTree() {
        this.jTRule.setModel(new OSProtectionTreeModel(this.protectBlock));
        this.jTRule.setRootVisible(false);
        this.jTRule.putClientProperty("JTree.lineStyle", "Angled");
        this.jTRule.setCellRenderer(new CustomTreeCellRenderer());
        this.jTRule.setVisibleRowCount(4);
        this.jTRule.setSelectionRow(0);
        this.jTRule.addMouseListener(new TreeMouseListener());
        this.jTRule.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                RuleEditorDlg.this.treeSelectionChanged();
            }
        });
        UIUtilities.expandAllNodesInTree(this.jTRule);
    }

    private void initializeEditorPanel() {
        this.rulePanel = new RulePanel(this.isReadonly);
        this.registryPanel = new RegistryPanel(this.isReadonly);
        this.filePanel = new FilePanel(this.isReadonly);
        this.launchPanel = new LaunchProcessPanel(this.isReadonly);
        this.terminatePanel = new TerminateProcessPanel(this.isReadonly);
        this.modulePanel = new ModulePanel(this.isReadonly);
        this.jEditorPanel.add((Component)this.rulePanel, String.valueOf(94));
        this.jEditorPanel.add((Component)this.registryPanel, String.valueOf(95));
        this.jEditorPanel.add((Component)this.filePanel, String.valueOf(96));
        this.jEditorPanel.add((Component)this.launchPanel, String.valueOf(97));
        this.jEditorPanel.add((Component)this.terminatePanel, String.valueOf(98));
        this.jEditorPanel.add((Component)this.modulePanel, String.valueOf(99));
    }

    private void treeSelectionChanged() {
        this.checkTreeButtons();
        TreePath selPath = this.jTRule.getSelectionPath();
        if (this.currentTreePath != null) {
            DefaultMutableTreeNode lastNode = (DefaultMutableTreeNode)this.currentTreePath.getLastPathComponent();
            if (selPath != null && lastNode.getParent() != null && lastNode != selPath.getLastPathComponent() && !this.commitCurrentPanel()) {
                this.jTRule.setSelectionPath(this.currentTreePath);
                return;
            }
        }
        if (selPath != null) {
            DefaultMutableTreeNode selNode = (DefaultMutableTreeNode)this.jTRule.getLastSelectedPathComponent();
            OSProtectionTreeUserObject userObj = (OSProtectionTreeUserObject)selNode.getUserObject();
            this.currentUIKey = userObj.getUIKey();
            this.currentTreePath = selPath;
            this.getCurrentPanel().initData(userObj.getUserObject());
            ((CardLayout)this.jEditorPanel.getLayout()).show(this.jEditorPanel, String.valueOf(this.currentUIKey));
        }
    }

    private boolean commitCurrentPanel() {
        OSProtectionBlockPanel currentPanel = this.getCurrentPanel();
        boolean isValidate = currentPanel.isValidate(this.getExistingNames());
        if (isValidate) {
            currentPanel.commitData();
            ((OSProtectionTreeModel)this.jTRule.getModel()).nodeChanged((TreeNode)this.currentTreePath.getLastPathComponent());
        }
        return isValidate;
    }

    private OSProtectionBlockPanel getCurrentPanel() {
        switch (this.currentUIKey) {
            case 94: {
                return this.rulePanel;
            }
            case 95: {
                return this.registryPanel;
            }
            case 96: {
                return this.filePanel;
            }
            case 97: {
                return this.launchPanel;
            }
            case 98: {
                return this.terminatePanel;
            }
        }
        return this.modulePanel;
    }

    private List<String> getExistingNames() {
        if (this.currentUIKey == 94) {
            return new OpAppProtectionBlockObject(this.protectBlock).getAllRuleNames();
        }
        OpAppRule opAppRule = this.getOpAppRule();
        return OpPermissionListObject.getAllPermissionNames(opAppRule.getOpPermissionList());
    }

    private OpAppRule getOpAppRule() {
        DefaultMutableTreeNode selNode = (DefaultMutableTreeNode)this.currentTreePath.getLastPathComponent();
        OSProtectionTreeUserObject userObj = (OSProtectionTreeUserObject)selNode.getUserObject();
        if (userObj.getUIKey() != 94) {
            selNode = (DefaultMutableTreeNode)selNode.getParent();
        }
        return (OpAppRule)((OSProtectionTreeUserObject)selNode.getUserObject()).getUserObject();
    }

    private void maybeShowPopup(MouseEvent e) {
        if (!e.isPopupTrigger()) {
            return;
        }
        if (!this.commitCurrentPanel()) {
            return;
        }
        int selRow = this.jTRule.getRowForLocation(e.getX(), e.getY());
        if (selRow != -1) {
            this.jTRule.setSelectionRow(selRow);
        }
        new OSProtectionTreePopupMenu(this, this.jTRule, this.isReadonly).show(e.getComponent(), e.getX(), e.getY());
    }

    private void checkTreeButtons() {
        DefaultMutableTreeNode selNode = (DefaultMutableTreeNode)this.jTRule.getLastSelectedPathComponent();
        this.jBDelete.setEnabled(selNode != null && !this.isReadonly);
        this.jBUp.setEnabled(false);
        this.jBDown.setEnabled(false);
        if (!this.isReadonly && selNode != null && this.jTRule.getSelectionCount() == 1) {
            OSProtectionTreeModel model = (OSProtectionTreeModel)this.jTRule.getModel();
            this.jBUp.setEnabled(model.canMoveUp(selNode));
            this.jBDown.setEnabled(model.canMoveDown(selNode));
        }
    }

    private boolean isNodeExpanded(DefaultMutableTreeNode node) {
        return this.jTRule.isExpanded(new TreePath(node.getPath()));
    }

    @Override
    public boolean isResizable() {
        return true;
    }

    private class TreeMouseListener
    extends MouseAdapter {
        private TreeMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            RuleEditorDlg.this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            RuleEditorDlg.this.maybeShowPopup(e);
        }
    }
}

