/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.osprotect.dialog;

import com.sygate.scm.common.configobject.schema.OpFileNameMatchEntity;
import com.sygate.scm.common.configobject.schema.OpRegistryMatchEntity;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.Utility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class RegistryPathEditorDlg
extends DialogBase {
    private static final long serialVersionUID = -5571781150974030393L;
    private JLabel jLValue = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "RegistryPathEditorDlg.label.RegValName"));
    private JLabel jLData = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "RegistryPathEditorDlg.label.RegValData"));
    private JLabel jLValueNote = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "RegistryPathEditorDlg.label.ValsAffectRegWrites"));
    private JLabel jLDataNote = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "RegistryPathEditorDlg.label.ValsAffectRegWrites"));
    private JTextField jTFKey = new JTextField(50);
    private JTextField jTFValueName = new JTextField();
    private JTextField jTFValueData = new JTextField();
    private JRadioButton jRBNormal = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "RegistryPathEditorDlg.radio.UseNormalStr"), true);
    private JRadioButton jRBRegEx = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "RegistryPathEditorDlg.radio.UseRegex"));
    private OpRegistryMatchEntity regEntity;

    public RegistryPathEditorDlg() {
        this((OpRegistryMatchEntity)null, false);
    }

    public RegistryPathEditorDlg(OpRegistryMatchEntity regEntity, boolean isReadonly) {
        super(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "RegistryPathEditorDlg.title.TargetregKeyDefn"), true);
        if (regEntity != null) {
            this.setTitle(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "RegistryPathEditorDlg.title.TargetregKeyDefnEdit"));
        }
        this.regEntity = regEntity;
        this.initialize(isReadonly);
        this.initData();
        UiUtilities.centerComponent((Component)this);
        this.setVisible(true);
    }

    public OpRegistryMatchEntity getRegistryMatchEntity() {
        return this.regEntity;
    }

    @Override
    public boolean isResizable() {
        return true;
    }

    @Override
    protected boolean isValidate() {
        String regKey = this.jTFKey.getText().trim();
        if (regKey.length() == 0) {
            JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "RegistryPathEditorDlg.EnterRegKeyToMatch"));
            this.jTFKey.requestFocusInWindow();
            return false;
        }
        if (!this.isValidKey(regKey)) {
            JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "RegistryPathEditorDlg.error.InvalidRegKey"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "RegistryPathEditorDlg.title.InvalidRegKey"), 0);
            this.jTFKey.requestFocusInWindow();
            return false;
        }
        if (this.jRBRegEx.isSelected() && !this.isValidRegEx(regKey)) {
            JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "RegistryPathEditorDlg.error.InvalidRegex"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "RegistryPathEditorDlg.title.InvalidRegex"), 0);
            this.jTFKey.requestFocusInWindow();
            return false;
        }
        String name = this.jTFValueName.getText().trim();
        String data = this.jTFValueData.getText().trim();
        if (data.length() > 0 && name.length() == 0) {
            JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "RegistryPathEditorDlg.error.ValNameForValData"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "RegistryPathEditorDlg.title.InvalidRegex"), 0);
            this.jTFValueName.requestFocusInWindow();
            return false;
        }
        return true;
    }

    @Override
    protected void commit() {
        if (this.regEntity == null) {
            this.regEntity = new OpRegistryMatchEntity();
        }
        this.regEntity.setRegKey(this.jTFKey.getText().trim());
        this.regEntity.setOptRegValueName(this.jTFValueName.getText().trim());
        this.regEntity.setOptRegValueData(this.jTFValueData.getText().trim());
        if (this.jRBNormal.isSelected() && !this.getRegistryMethod().equals(OpFileNameMatchEntity.NORMAL)) {
            this.regEntity.setOptMethod(OpFileNameMatchEntity.NORMAL);
        } else if (this.jRBRegEx.isSelected() && !this.getRegistryMethod().equals(OpFileNameMatchEntity.REG_EX)) {
            this.regEntity.setOptMethod(OpFileNameMatchEntity.REG_EX);
        }
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_hdp_hardware_device_protection_add_registry_definition_add";
    }

    private void initialize(boolean isReadonly) {
        this.jTFKey.setDocument(new RestrictedPlainDocument(256));
        this.jTFValueName.setDocument(new RestrictedPlainDocument(32768));
        ButtonGroup group = new ButtonGroup();
        group.add(this.jRBRegEx);
        group.add(this.jRBNormal);
        RestrictedPlainDocument doc = new RestrictedPlainDocument(16300);
        doc.setValidator("\n", false);
        this.jTFValueData.setDocument(doc);
        JPanel regPanel = this.getRegistryPanel();
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)regPanel, "North");
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
        this.pack();
        if (isReadonly) {
            UIUtilities.setContainerStatus(regPanel, false);
            this.resetOKButton(false);
        }
        this.jTFKey.requestFocusInWindow();
    }

    private JPanel getRegistryPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "RegistryPathEditorDlg.label.RegKey")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        panel.add((Component)this.jTFKey, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)this.jLValue, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(25, 5, 0, 5), 0, 0));
        panel.add((Component)this.jTFValueName, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)this.jLValueNote, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)this.jLData, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(25, 5, 0, 5), 0, 0));
        panel.add((Component)this.jTFValueData, new GridBagConstraints(0, 6, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)this.jLDataNote, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)this.jRBNormal, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 17, 0, new Insets(25, 10, 0, 5), 0, 0));
        panel.add((Component)this.jRBRegEx, new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 5), 0, 0));
        return panel;
    }

    private void initData() {
        if (this.regEntity == null) {
            return;
        }
        this.jTFKey.setText(this.regEntity.getRegKey());
        this.jTFValueName.setText(this.regEntity.getOptRegValueName());
        this.jTFValueData.setText(this.regEntity.getOptRegValueData());
        this.jRBNormal.setSelected(this.getRegistryMethod().equals(OpRegistryMatchEntity.NORMAL));
        this.jRBRegEx.setSelected(!this.getRegistryMethod().equals(OpRegistryMatchEntity.NORMAL));
    }

    private Integer getRegistryMethod() {
        Integer method = this.regEntity.getOptMethod();
        if (method == null) {
            method = this.regEntity.getDefMethod();
        }
        return method;
    }

    private boolean isValidKey(String key) {
        return key.equals("*\\") || Utility.isValidRegistryKey((String)key);
    }

    private boolean isValidRegEx(String str) {
        try {
            Pattern.compile(str);
        }
        catch (PatternSyntaxException e) {
            LoggerUtilities.logException((Throwable)e);
            return false;
        }
        return true;
    }
}

