/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.osprotect.dialog;

import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.schema.OpAppProtectionPolicy;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.logicobject.AppProtectionPolicyObject;
import com.sygate.scm.console.logicobject.AppliablePolicyPool;
import com.sygate.scm.console.logicobject.GroupPolicyObject;
import com.sygate.scm.console.ui.policy.BasePolicyDialog;
import com.sygate.scm.console.ui.policy.PolicyTabPanel;
import com.sygate.scm.console.ui.policy.common.PolicyInt;
import com.sygate.scm.console.ui.policy.osprotect.DeviceBlockPanel;
import com.sygate.scm.console.ui.policy.osprotect.MacDeviceBlockPanel;
import com.sygate.scm.console.ui.policy.osprotect.OSProtectionPanel;
import com.sygate.scm.console.ui.policy.osprotect.OspPolicyTabPanel;
import com.sygate.scm.console.ui.util.UIUtilities;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.util.List;
import javax.swing.JPanel;

public class OspPolicyDialog
extends BasePolicyDialog {
    private static final long serialVersionUID = 4597718895907477355L;
    private AppProtectionPolicyObject opObj;
    private OSProtectionPanel osProtectionPanel;
    private DeviceBlockPanel deviceBlockPanel;
    private MacDeviceBlockPanel macDeviceBlockPanel;

    public OspPolicyDialog(String name, GroupPolicyObject gpObj, Boolean ... isLocal) {
        super(63, name, gpObj, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "OspPolicyDialog.title"), true, isLocal);
    }

    public OspPolicyDialog(AbstractUIObject pool) {
        this(pool, false);
    }

    public OspPolicyDialog(AbstractUIObject pool, boolean isCheckPolicyEnforcement) {
        super(63, pool, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "OspPolicyDialog.title"), isCheckPolicyEnforcement, true);
    }

    @Override
    public PolicyInt createNewPolicy(AppliablePolicyPool pool) {
        this.setNewPolicy(true);
        this.opObj = new AppProtectionPolicyObject();
        this.opObj.createNewAppProtectionPolicy();
        List<String> nameList = pool.getAllName();
        String newName = PolicyHandler.adjustName(this.opObj.getName(), nameList, 255);
        if (newName != null) {
            this.opObj.setName(newName);
        }
        this.updatePanel();
        return this.opObj;
    }

    @Override
    public PolicyInt createNewPolicy(TopLevelObject schema) {
        this.opObj = new AppProtectionPolicyObject(schema);
        this.updatePanel();
        return this.opObj;
    }

    @Override
    protected void commit() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.opObj.setName(this.getOverviewPanel().getPolicyName());
        this.opObj.setOptDescription(this.getOverviewPanel().getPolicyDesc());
        this.opObj.setEnabled(this.getOverviewPanel().isPolicyEnabled());
        this.getOsProtectionPanel().save(this.opObj);
        this.getDeviceBlockPanel().updateOpDeviceBlocker((OpAppProtectionPolicy)this.opObj.getSchemaObj());
        this.getMacDeviceBlockPanel().updateOpDeviceBlocker((OpAppProtectionPolicy)this.opObj.getSchemaObj());
        this.setCursor(Cursor.getDefaultCursor());
    }

    @Override
    protected boolean isValidate() {
        return this.isValidName(this.opObj.getSchemaObj(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "OspPolicyDialog.error.EmptyName"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "OspPolicyDialog.error.PolicyNameInUse"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "OspPolicyDialog.error.invalidName"));
    }

    @Override
    protected PolicyTabPanel createTabPanel() {
        OspPolicyTabPanel panel = new OspPolicyTabPanel(this, "<html>" + MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "OspPolicyDialog.OSProtectionPolicy") + "</html>", "hardware_policy_32.png");
        panel.putClientProperty("cssClass", "OspPolicyDialogTabPanel");
        return panel;
    }

    @Override
    protected void addPolicyEditorPanels(JPanel mainPanel) {
        super.addPolicyEditorPanels(mainPanel);
        mainPanel.add((Component)UIUtilities.createScrollPaneWithoutBoard(this.getOsProtectionPanel()), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "OspPolicyTabPanel.OSProtection"));
        mainPanel.add((Component)UIUtilities.createScrollPaneWithoutBoard(this.getDeviceBlockPanel()), "Windows Device Control");
        mainPanel.add((Component)UIUtilities.createScrollPaneWithoutBoard(this.getMacDeviceBlockPanel()), "Mac Device Control");
    }

    @Override
    protected Container[] readOnlyContainers() {
        return new Container[]{this.getOverviewPanel(), this.getOsProtectionPanel(), this.getDeviceBlockPanel(), this.getMacDeviceBlockPanel()};
    }

    private OSProtectionPanel getOsProtectionPanel() {
        if (this.osProtectionPanel == null) {
            this.osProtectionPanel = new OSProtectionPanel();
        }
        return this.osProtectionPanel;
    }

    private DeviceBlockPanel getDeviceBlockPanel() {
        if (this.deviceBlockPanel == null) {
            this.deviceBlockPanel = new DeviceBlockPanel();
        }
        return this.deviceBlockPanel;
    }

    private MacDeviceBlockPanel getMacDeviceBlockPanel() {
        if (this.macDeviceBlockPanel == null) {
            this.macDeviceBlockPanel = new MacDeviceBlockPanel();
        }
        return this.macDeviceBlockPanel;
    }

    private void updatePanel() {
        this.getOverviewPanel().setObject(this.opObj);
        this.getOsProtectionPanel().updatePanel(this.opObj);
        this.getDeviceBlockPanel().initDeviceData(this.opObj);
        this.getMacDeviceBlockPanel().initDeviceData(this.opObj);
        this.getOverviewPanel().setPolicyEnabled(this.opObj.getEnabled());
    }
}

