/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.osprotect.dialog;

import com.sygate.scm.common.acl.AdminACLUtils;
import com.sygate.scm.common.acl.PrivilegeContext;
import com.sygate.scm.common.configobject.schema.OpDevice;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.UsbDeviceHandler;
import com.sygate.scm.console.logicobject.DeviceObject;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class DeviceEditorDialog
extends DialogBase {
    private static final long serialVersionUID = -601083553422885581L;
    private JTextField jTFName = new JTextField(30);
    private JTextField jTFId = new JTextField(30);
    private JTextField jTFInstanceId = new JTextField(30);
    private JRadioButton jRBClassID = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "DeviceEditorDialog.radio.ClassID"), true);
    private JRadioButton jRBInstanceID = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "DeviceEditorDialog.radio.InstanceID"), true);
    private DeviceObject dvObj;
    private JComboBox<String> jCBOsTypeCombo = null;

    public DeviceEditorDialog(DeviceObject dvObj) {
        super(Manager.getFrame(), "", true);
        boolean isCheckPolicyEnforcement = dvObj != null;
        this.setTitle(this.createTitle(isCheckPolicyEnforcement));
        this.initialize(isCheckPolicyEnforcement);
        this.setData(dvObj);
        UiUtilities.centerComponent((Component)this);
        this.setVisible(true);
    }

    public DeviceObject getDeviceObject() {
        return this.dvObj;
    }

    @Override
    protected boolean isValidate() {
        String name = this.jTFName.getText().trim();
        if (name.length() == 0) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "DeviceEditorDialog.error.DeviceNameRequired"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "DeviceEditorDialog.title.InvalidDeviceName"), 0);
            this.focusNameField();
            return false;
        }
        String id = "";
        if (this.jRBClassID.isSelected()) {
            id = this.jTFId.getText().trim();
            if (id.length() == 0) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "DeviceEditorDialog.error.ClassIDRequired"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "DeviceEditorDialog.title.InvalidDeviceID"), 0);
                this.focusIdField();
                return false;
            }
        } else if (this.jRBInstanceID.isSelected() && (id = this.jTFInstanceId.getText().trim()).length() == 0) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "DeviceEditorDialog.error.DeviceIDRequired"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "DeviceEditorDialog.title.InvalidDeviceID"), 0);
            this.focusInstanceIdField();
            return false;
        }
        try {
            DeviceObject macObj = UsbDeviceHandler.getMacDeviceByName(name);
            if (this.dvObj == null) {
                if (macObj != null || UsbDeviceHandler.hasDeviceInPool(name)) {
                    JOptionPane.showMessageDialog(Manager.getFrame(), MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "DeviceEditorDialog.warn.DeviceExists"), name), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "DeviceEditorDialog.title.Warning"), 0);
                    this.focusNameField();
                    return false;
                }
                if (this.jRBClassID.isSelected() && UsbDeviceHandler.hasDeviceClassIdInPool(id)) {
                    Object[] arguments = new Object[]{id};
                    JOptionPane.showMessageDialog(Manager.getFrame(), MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "DeviceEditorDialog.warn.DeviceClassIDExists"), arguments), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "DeviceEditorDialog.title.Warning"), 0);
                    this.focusIdField();
                    return false;
                }
                if (this.jRBInstanceID.isSelected() && UsbDeviceHandler.hasDeviceInstanceIdInPool(id)) {
                    Object[] arguments = new Object[]{id};
                    JOptionPane.showMessageDialog(Manager.getFrame(), MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "DeviceEditorDialog.warn.DeviceInstanceIDExists"), arguments), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "DeviceEditorDialog.title.Warning"), 0);
                    this.focusInstanceIdField();
                    return false;
                }
            } else {
                DeviceObject obj = UsbDeviceHandler.getDeviceByName(name);
                if (obj != null && !this.dvObj.equals(obj) || macObj != null) {
                    JOptionPane.showMessageDialog(Manager.getFrame(), MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "DeviceEditorDialog.warn.DeviceExists"), name), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "DeviceEditorDialog.title.Warning"), 0);
                    return false;
                }
                if (this.jRBClassID.isSelected() && (obj = UsbDeviceHandler.getDeviceByClassId(id)) != null && !this.dvObj.equals(obj)) {
                    Object[] arguments = new Object[]{id};
                    JOptionPane.showMessageDialog(Manager.getFrame(), MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "DeviceEditorDialog.warn.DeviceClassIDExists"), arguments), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "DeviceEditorDialog.title.Warning"), 0);
                    this.focusIdField();
                    return false;
                }
                if (this.jRBInstanceID.isSelected() && UsbDeviceHandler.hasDeviceInstanceIdInPool(id) && (obj = UsbDeviceHandler.getDeviceByInstanceId(id)) != null && !this.dvObj.equals(obj)) {
                    Object[] arguments = new Object[]{id};
                    JOptionPane.showMessageDialog(Manager.getFrame(), MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "DeviceEditorDialog.warn.DeviceClassIDExists"), arguments), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "DeviceEditorDialog.title.Warning"), 0);
                    this.focusIdField();
                    return false;
                }
            }
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        return true;
    }

    @Override
    protected void commit() {
        if (this.dvObj == null) {
            this.dvObj = this.jRBClassID.isSelected() ? new DeviceObject(this.jTFName.getText().trim(), this.jTFId.getText().trim(), "", "") : new DeviceObject(this.jTFName.getText().trim(), "", this.jTFInstanceId.getText().trim(), "");
        } else {
            this.dvObj.setName(this.jTFName.getText().trim());
            if (this.jRBClassID.isSelected()) {
                this.dvObj.setDeviceClassId(this.jTFId.getText().trim());
                this.dvObj.setDeviceInstanceId("");
            } else {
                this.dvObj.setDeviceClassId("");
                this.dvObj.setDeviceInstanceId(this.jTFInstanceId.getText().trim());
            }
        }
        if (this.jCBOsTypeCombo.getSelectedIndex() == 0) {
            this.dvObj.setPlatform(OpDevice.WINDOWS);
        } else {
            this.dvObj.setPlatform(OpDevice.MAC);
        }
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_hardware_devices_add_hardware_device";
    }

    private void initialize(boolean isCheckPolicyEnforcement) {
        RestrictedPlainDocument nameDoc = new RestrictedPlainDocument(255);
        nameDoc.setValidator("/\\*?<>|\":", false);
        this.jTFName.setDocument(nameDoc);
        RestrictedPlainDocument idDoc = new RestrictedPlainDocument(255);
        idDoc.setValidator("/\\*?<>|\":+[]$^", false);
        this.jTFId.setDocument(idDoc);
        RestrictedPlainDocument instanceIdDoc = new RestrictedPlainDocument(255);
        this.jTFInstanceId.setDocument(instanceIdDoc);
        this.getContentPane().setLayout(new GridBagLayout());
        ButtonGroup group = new ButtonGroup();
        group.add(this.jRBClassID);
        group.add(this.jRBInstanceID);
        this.jRBInstanceID.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeviceEditorDialog.this.jRBInstanceID_actionPerformed();
            }
        });
        this.jRBClassID.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeviceEditorDialog.this.jRBClassID_actionPerformed();
            }
        });
        this.jCBOsTypeCombo = new JComboBox<String>(new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "DeviceEditorDialog.OsType.Windows"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "DeviceEditorDialog.OsType.Mac")});
        this.jCBOsTypeCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                DeviceEditorDialog.this.jCBOsType_itemStateChanged();
            }
        });
        int gridy = 0;
        this.getContentPane().add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "DeviceEditorDialog.label.DeviceName")), new GridBagConstraints(0, gridy, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.jTFName, new GridBagConstraints(1, gridy++, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.getContentPane().add((Component)this.jRBClassID, new GridBagConstraints(0, gridy, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.jTFId, new GridBagConstraints(1, gridy++, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.getContentPane().add((Component)this.jRBInstanceID, new GridBagConstraints(0, gridy, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.jTFInstanceId, new GridBagConstraints(1, gridy++, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.getContentPane().add((Component)this.getButtonPanel(), new GridBagConstraints(0, gridy, 2, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        PrivilegeContext context = DataobjectManager.getInstance().getCurrentPrivilegeContext();
        if (isCheckPolicyEnforcement && AdminACLUtils.isSharedPolicyReadOnly((PrivilegeContext)context)) {
            this.jTFName.setEnabled(false);
            this.jTFId.setEnabled(false);
            this.jBOk.setEnabled(false);
            this.jTFInstanceId.setEnabled(false);
            this.jRBClassID.setEnabled(false);
            this.jRBInstanceID.setEnabled(false);
            this.jCBOsTypeCombo.setEditable(false);
        }
        this.pack();
    }

    private void setData(DeviceObject dvObj) {
        this.dvObj = dvObj;
        if (dvObj != null && dvObj.isValid()) {
            this.jTFName.setText(dvObj.getName());
            this.jTFId.setText(dvObj.getDeviceClassId());
            this.jTFInstanceId.setText(dvObj.getDeviceInstanceId());
        }
        if (this.jTFInstanceId.getText() == null || this.jTFInstanceId.getText().equals("")) {
            this.jRBClassID.setSelected(true);
            this.jRBClassID_actionPerformed();
        } else {
            this.jRBInstanceID.setSelected(true);
            this.jRBInstanceID_actionPerformed();
        }
        if (dvObj == null || OpDevice.WINDOWS.equals(dvObj.getPlatform())) {
            this.jCBOsTypeCombo.setSelectedIndex(0);
        } else {
            this.jCBOsTypeCombo.setSelectedIndex(1);
        }
        this.jCBOsType_itemStateChanged();
    }

    private void focusNameField() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DeviceEditorDialog.this.jTFName.requestFocus();
            }
        });
    }

    private void focusIdField() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DeviceEditorDialog.this.jTFId.requestFocus();
            }
        });
    }

    private String createTitle(boolean isCheckPolicyEnforcement) {
        PrivilegeContext context = DataobjectManager.getInstance().getCurrentPrivilegeContext();
        if (isCheckPolicyEnforcement && AdminACLUtils.isSharedPolicyReadOnly((PrivilegeContext)context)) {
            return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "DeviceEditorDialog.readOnlyTitle");
        }
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "DeviceEditorDialog.title");
    }

    private void focusInstanceIdField() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DeviceEditorDialog.this.jTFInstanceId.requestFocus();
            }
        });
    }

    private void jRBInstanceID_actionPerformed() {
        PrivilegeContext context = DataobjectManager.getInstance().getCurrentPrivilegeContext();
        if (AdminACLUtils.isSharedPolicyReadOnly((PrivilegeContext)context)) {
            this.jTFInstanceId.setEditable(false);
            this.jTFId.setEditable(false);
            return;
        }
        this.jTFInstanceId.setEnabled(this.jRBInstanceID.isSelected());
        this.jTFId.setEnabled(this.jRBClassID.isSelected());
    }

    private void jRBClassID_actionPerformed() {
        PrivilegeContext context = DataobjectManager.getInstance().getCurrentPrivilegeContext();
        if (AdminACLUtils.isSharedPolicyReadOnly((PrivilegeContext)context)) {
            this.jTFInstanceId.setEditable(false);
            this.jTFId.setEditable(false);
            return;
        }
        this.jTFInstanceId.setEnabled(this.jRBInstanceID.isSelected());
        this.jTFId.setEnabled(this.jRBClassID.isSelected());
        this.jTFId.setEditable(this.jRBClassID.isSelected());
    }

    private void jCBOsType_itemStateChanged() {
        PrivilegeContext context = DataobjectManager.getInstance().getCurrentPrivilegeContext();
        if (AdminACLUtils.isSharedPolicyReadOnly((PrivilegeContext)context)) {
            this.jCBOsTypeCombo.setEnabled(false);
            return;
        }
        String selectedOS = (String)this.jCBOsTypeCombo.getSelectedItem();
        if (MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "DeviceEditorDialog.OsType.Windows").equals(selectedOS)) {
            this.jRBClassID.setEnabled(true);
            this.jTFId.setEnabled(true);
        } else {
            this.jRBClassID.setEnabled(false);
            this.jTFId.setText("");
            this.jTFId.setEnabled(false);
            this.jTFId.setEditable(false);
            this.jRBInstanceID.setSelected(true);
            this.jRBInstanceID_actionPerformed();
        }
    }
}

