/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.osprotect;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.schema.OpAppRule;
import com.sygate.scm.common.configobject.schema.OpFileChecksumMatchEntity;
import com.sygate.scm.common.configobject.schema.OpFileNameMatchEntity;
import com.sygate.scm.common.configobject.schema.OpProcessMatchEntity;
import com.sygate.scm.common.configobject.schema.ProcessImageMatch;
import com.sygate.scm.common.configobject.schema.ProcessImageNoMatch;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.ui.policy.osprotect.PermissionPanelBase;
import com.sygate.scm.console.ui.policy.osprotect.RuleDefinitionPanel;
import com.sygate.scm.util.Utility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class RulePanel
extends PermissionPanelBase
implements ChangeListener {
    private static final long serialVersionUID = -1599532166774973971L;
    private static final String NO_APPLY = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "DefinitionPanel.rule.noApplies");
    private RuleDefinitionPanel definitionPanel;
    private OpAppRule opAppRule;

    public RulePanel(boolean isReadonly) {
        this.definitionPanel = new RuleDefinitionPanel(this, isReadonly);
        this.initialize(isReadonly);
    }

    @Override
    public void initData(ConfigObject opAppRule) {
        this.opAppRule = (OpAppRule)opAppRule;
        this.definitionPanel.initData(opAppRule);
        this.jTASummary.setText(this.getSummary((OpAppRule)opAppRule));
    }

    @Override
    public void commitData() {
        this.definitionPanel.commitData();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.updateSummary();
    }

    private void initialize(boolean isReadonly) {
        JTabbedPane pane = new JTabbedPane();
        pane.add(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "RulePanel.title.ProcDefn"), this.definitionPanel);
        this.setLayout(new BorderLayout());
        this.add(pane);
        this.add((Component)this.getSummaryPanel(isReadonly), "South");
    }

    private String getSummary(OpAppRule opAppRule) {
        String fileMatchStr = "";
        String fileNoMatchStr = "";
        Object fileMatchCombinedStr = "";
        String name = this.definitionPanel.getNameText();
        String listSeparator = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "RulePanel.ListSeparator");
        String formatApplies = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "RulePanel.FormatForAppliesCriteria");
        String formatExcludes = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "RulePanel.FormatForExcludesCriteria");
        ProcessImageMatch fileMatch = opAppRule.getOpProcess().getOptProcessImageMatch();
        if (fileMatch != null && fileMatch.getOpProcessMatchEntityCount() > 0) {
            StringBuilder fileMatchBuf = new StringBuilder();
            for (int i = 0; i < fileMatch.getOpProcessMatchEntityCount(); ++i) {
                fileMatchBuf.append(this.getKeyString(fileMatch.getOpProcessMatchEntity(i)));
                fileMatchBuf.append(listSeparator);
            }
            fileMatchStr = fileMatchBuf.toString();
            if (fileMatchStr != null && fileMatchStr.length() > 0) {
                fileMatchStr = fileMatchStr.substring(0, fileMatchStr.length() - 1);
            }
        } else {
            return NO_APPLY;
        }
        ProcessImageNoMatch fileNameNoMatch = opAppRule.getOpProcess().getOptProcessImageNoMatch();
        if (fileNameNoMatch != null) {
            StringBuilder fileNoMatchBuf = new StringBuilder();
            for (int i = 0; i < fileNameNoMatch.getOpProcessMatchEntityCount(); ++i) {
                fileNoMatchBuf.append(this.getKeyString(fileNameNoMatch.getOpProcessMatchEntity(i)));
                fileNoMatchBuf.append(listSeparator);
            }
            fileNoMatchStr = fileNoMatchBuf.toString();
            if (fileNoMatchStr != null && fileNoMatchStr.length() > 0) {
                fileNoMatchStr = fileNoMatchStr.substring(0, fileNoMatchStr.length() - 1);
            }
        }
        String fileMatchAppliesStr = null;
        if (fileMatchStr.length() > 0) {
            fileMatchAppliesStr = MessageFormat.format(formatApplies, name, fileMatchStr);
            fileMatchCombinedStr = (String)fileMatchCombinedStr + fileMatchAppliesStr + " ";
            String fileMatchExcludesStr = null;
            if (fileNoMatchStr.length() > 0) {
                fileMatchExcludesStr = MessageFormat.format(formatExcludes, fileNoMatchStr);
                fileMatchCombinedStr = (String)fileMatchCombinedStr + fileMatchExcludesStr + " ";
            }
        }
        return fileMatchCombinedStr;
    }

    private String getKeyString(OpProcessMatchEntity entry) {
        OpFileNameMatchEntity fileEntry = entry.getOptOpFileNameMatchEntity();
        if (Utility.getBooleanValue((Boolean)fileEntry.getOptEnable(), (Boolean)fileEntry.getDefEnable())) {
            return fileEntry.getKeyString();
        }
        OpFileChecksumMatchEntity csEntry = entry.getOptOpFileChecksumMatchEntity();
        if (Utility.getBooleanValue((Boolean)csEntry.getOptEnable(), (Boolean)csEntry.getDefEnable())) {
            return csEntry.getFileChecksum();
        }
        return "";
    }

    private void updateSummary() {
        this.jTASummary.setText(this.getSummary(this.opAppRule));
    }

    @Override
    public boolean isValidate(List<String> existNames) {
        return this.definitionPanel.isValidate(existNames);
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return this.definitionPanel.getContentSensitiveHelpToken();
    }
}

