/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.osprotect;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.schema.OpAppRule;
import com.sygate.scm.common.configobject.schema.OpFileChecksumMatchEntity;
import com.sygate.scm.common.configobject.schema.OpFileNameMatchEntity;
import com.sygate.scm.common.configobject.schema.OpProcess;
import com.sygate.scm.common.configobject.schema.OpProcessArgumentMatchEntity;
import com.sygate.scm.common.configobject.schema.OpProcessMatchEntity;
import com.sygate.scm.common.configobject.schema.ProcessImageMatch;
import com.sygate.scm.common.configobject.schema.ProcessImageNoMatch;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.ui.policy.osprotect.DefinitionPanel;
import com.sygate.scm.console.ui.policy.osprotect.dialog.StringConditionEditorDlg;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.Utility;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.event.ChangeListener;

public class RuleDefinitionPanel
extends DefinitionPanel {
    private static final long serialVersionUID = 4174790620849730330L;
    private JCheckBox jCbxChild = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "RuleDefinitionPanel.checkbox.PermissionsInherited"));
    private OpAppRule opAppRule;
    private OpProcess opProcess;
    ChangeListener summaryRuleListener;
    private boolean isReadonly;

    public RuleDefinitionPanel(ChangeListener summaryListener, boolean isReadonly) {
        this.summaryRuleListener = summaryListener;
        this.isReadonly = isReadonly;
        this.initialize(94);
    }

    public void initData(ConfigObject configObj) {
        this.opAppRule = (OpAppRule)configObj;
        this.opProcess = this.opAppRule.getOpProcess();
        this.jTFName.setText(this.opAppRule.getName());
        this.setTADesc(this.opAppRule.getOptDescription());
        this.jCbxEnable.setSelected(Utility.getBooleanValue((Boolean)this.opAppRule.getOptEnable(), (Boolean)this.opAppRule.getDefEnable()));
        this.jCbxChild.setSelected(this.getProcessIsInherit());
        this.initMatchList();
        this.initNoMatchList();
    }

    public void commitData() {
        this.opAppRule.setName(this.jTFName.getText().trim());
        this.opAppRule.setOptDescription(this.jTADesc.getText().trim());
        this.opAppRule.setOptEnable(Boolean.valueOf(this.jCbxEnable.isSelected()));
        this.opProcess.setOptApplyToChildProcess(Boolean.valueOf(this.jCbxChild.isSelected()));
    }

    private void initialize(int type) {
        String description = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "DefinitionPanel.rule.description");
        super.initialize(type, this.summaryRuleListener, description, this.isReadonly);
        this.add((Component)this.jCbxChild, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jCbxChild.setEnabled(!this.isReadonly);
    }

    @Override
    protected void addMatch() {
        StringConditionEditorDlg dlg = new StringConditionEditorDlg(0);
        if (dlg.isOk()) {
            OpFileNameMatchEntity fileEntity = dlg.getFileNameMatchEntity();
            OpFileChecksumMatchEntity checksumEntity = dlg.getFileChecksumMatchEntity();
            OpProcessArgumentMatchEntity arguEntity = dlg.getProcessArgumentMatchEntity();
            ProcessImageMatch pMatch = this.opProcess.getOptProcessImageMatch();
            if (pMatch == null) {
                pMatch = new ProcessImageMatch();
            }
            OpProcessMatchEntity processEntity = new OpProcessMatchEntity();
            processEntity.setOptOpFileNameMatchEntity(fileEntity);
            processEntity.setOptOpFileChecksumMatchEntity(checksumEntity);
            processEntity.setOptOpProcessArgumentMatchEntity(arguEntity);
            pMatch.addOpProcessMatchEntity(processEntity);
            this.opProcess.setOptProcessImageMatch(pMatch);
            DefaultListModel model = (DefaultListModel)this.jLMatch.getModel();
            model.addElement(this.getDisplayString(fileEntity, checksumEntity, arguEntity));
            this.commitData();
        }
        dlg.dispose();
    }

    @Override
    protected void editMatch() {
        ProcessImageMatch pMatch;
        int selIndex = this.jLMatch.getMinSelectionIndex();
        try {
            pMatch = (ProcessImageMatch)PolicyHandler.getCopyOfObj((ConfigObject)this.opProcess.getOptProcessImageMatch());
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
            return;
        }
        OpProcessMatchEntity pEntity = pMatch.getOpProcessMatchEntity(selIndex);
        OpFileNameMatchEntity file = pEntity.getOptOpFileNameMatchEntity();
        OpFileChecksumMatchEntity checksum = pEntity.getOptOpFileChecksumMatchEntity();
        OpProcessArgumentMatchEntity argu = pEntity.getOptOpProcessArgumentMatchEntity();
        StringConditionEditorDlg dlg = new StringConditionEditorDlg(0, file, checksum, argu, this.isReadonly);
        if (dlg.isOk()) {
            OpFileNameMatchEntity fileEntity = dlg.getFileNameMatchEntity();
            OpFileChecksumMatchEntity checksumEntity = dlg.getFileChecksumMatchEntity();
            OpProcessArgumentMatchEntity arguEntity = dlg.getProcessArgumentMatchEntity();
            pMatch = this.opProcess.getOptProcessImageMatch();
            if (pMatch != null) {
                pEntity = pMatch.getOpProcessMatchEntity(selIndex);
                pEntity.setOptOpFileNameMatchEntity(fileEntity);
                pEntity.setOptOpFileChecksumMatchEntity(checksumEntity);
                pEntity.setOptOpProcessArgumentMatchEntity(arguEntity);
                DefaultListModel model = (DefaultListModel)this.jLMatch.getModel();
                model.setElementAt(this.getDisplayString(fileEntity, checksumEntity, arguEntity), selIndex);
            }
            this.commitData();
        }
        dlg.dispose();
    }

    @Override
    protected void deleteMatch() {
        int i;
        if (!this.canDelete(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "RuleDefinitionPanel.DelMatchingProcDefn"))) {
            return;
        }
        ArrayList itemList = new ArrayList();
        ArrayList<OpProcessMatchEntity> sEntityList = new ArrayList<OpProcessMatchEntity>();
        for (i = this.jLMatch.getMinSelectionIndex(); i <= this.jLMatch.getMaxSelectionIndex(); ++i) {
            if (!this.jLMatch.isSelectedIndex(i)) continue;
            itemList.add(this.jLMatch.getModel().getElementAt(i));
            sEntityList.add(this.opProcess.getOptProcessImageMatch().getOpProcessMatchEntity(i));
        }
        i = itemList.size();
        while (--i >= 0) {
            ((DefaultListModel)this.jLMatch.getModel()).removeElement(itemList.get(i));
            this.opProcess.getOptProcessImageMatch().removeOpProcessMatchEntity((OpProcessMatchEntity)sEntityList.get(i));
        }
        this.commitData();
        this.matchListSelected();
    }

    @Override
    protected void addNoMatch() {
        StringConditionEditorDlg dlg = new StringConditionEditorDlg(0);
        if (dlg.isOk()) {
            OpFileNameMatchEntity fileEntity = dlg.getFileNameMatchEntity();
            OpFileChecksumMatchEntity checksumEntity = dlg.getFileChecksumMatchEntity();
            OpProcessArgumentMatchEntity arguEntity = dlg.getProcessArgumentMatchEntity();
            ProcessImageNoMatch pNoMatch = this.opProcess.getOptProcessImageNoMatch();
            if (pNoMatch == null) {
                pNoMatch = new ProcessImageNoMatch();
            }
            OpProcessMatchEntity processEntity = new OpProcessMatchEntity();
            processEntity.setOptOpFileNameMatchEntity(fileEntity);
            processEntity.setOptOpFileChecksumMatchEntity(checksumEntity);
            processEntity.setOptOpProcessArgumentMatchEntity(arguEntity);
            pNoMatch.addOpProcessMatchEntity(processEntity);
            this.opProcess.setOptProcessImageNoMatch(pNoMatch);
            DefaultListModel model = (DefaultListModel)this.jLNoMatch.getModel();
            model.addElement(this.getDisplayString(fileEntity, checksumEntity, arguEntity));
            this.commitData();
        }
        dlg.dispose();
    }

    @Override
    protected void editNoMatch() {
        ProcessImageNoMatch pNoMatch;
        int selIndex = this.jLNoMatch.getMinSelectionIndex();
        try {
            pNoMatch = (ProcessImageNoMatch)PolicyHandler.getCopyOfObj((ConfigObject)this.opProcess.getOptProcessImageNoMatch());
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
            return;
        }
        OpProcessMatchEntity pEntity = pNoMatch.getOpProcessMatchEntity(selIndex);
        OpFileNameMatchEntity file = pEntity.getOptOpFileNameMatchEntity();
        OpFileChecksumMatchEntity checksum = pEntity.getOptOpFileChecksumMatchEntity();
        OpProcessArgumentMatchEntity argu = pEntity.getOptOpProcessArgumentMatchEntity();
        StringConditionEditorDlg dlg = new StringConditionEditorDlg(0, file, checksum, argu, this.isReadonly);
        if (dlg.isOk()) {
            OpFileNameMatchEntity fileEntity = dlg.getFileNameMatchEntity();
            OpFileChecksumMatchEntity checksumEntity = dlg.getFileChecksumMatchEntity();
            OpProcessArgumentMatchEntity arguEntity = dlg.getProcessArgumentMatchEntity();
            pNoMatch = this.opProcess.getOptProcessImageNoMatch();
            if (pNoMatch != null) {
                pEntity = pNoMatch.getOpProcessMatchEntity(selIndex);
                pEntity.setOptOpFileNameMatchEntity(fileEntity);
                pEntity.setOptOpFileChecksumMatchEntity(checksumEntity);
                pEntity.setOptOpProcessArgumentMatchEntity(arguEntity);
                DefaultListModel model = (DefaultListModel)this.jLNoMatch.getModel();
                model.setElementAt(this.getDisplayString(fileEntity, checksumEntity, arguEntity), selIndex);
            }
            this.commitData();
        }
        dlg.dispose();
    }

    @Override
    protected void deleteNoMatch() {
        int i;
        if (!this.canDelete(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "RuleDefinitionPanel.DelNonMatchingProcDefn"))) {
            return;
        }
        ArrayList itemList = new ArrayList();
        ArrayList<OpProcessMatchEntity> sEntityList = new ArrayList<OpProcessMatchEntity>();
        for (i = this.jLNoMatch.getMinSelectionIndex(); i <= this.jLNoMatch.getMaxSelectionIndex(); ++i) {
            if (!this.jLNoMatch.isSelectedIndex(i)) continue;
            itemList.add(this.jLNoMatch.getModel().getElementAt(i));
            sEntityList.add(this.opProcess.getOptProcessImageNoMatch().getOpProcessMatchEntity(i));
        }
        for (i = 0; i < itemList.size(); ++i) {
            ((DefaultListModel)this.jLNoMatch.getModel()).removeElement(itemList.get(i));
            this.opProcess.getOptProcessImageNoMatch().removeOpProcessMatchEntity((OpProcessMatchEntity)sEntityList.get(i));
        }
        this.commitData();
        this.noMatchListSelected();
    }

    private boolean getProcessIsInherit() {
        Boolean isInherit = this.opProcess.getOptApplyToChildProcess();
        if (isInherit == null) {
            isInherit = this.opProcess.getDefApplyToChildProcess();
        }
        return isInherit;
    }

    private void initMatchList() {
        DefaultListModel model = (DefaultListModel)this.jLMatch.getModel();
        model.clear();
        ProcessImageMatch pMatch = this.opProcess.getOptProcessImageMatch();
        if (pMatch != null) {
            for (int i = 0; i < pMatch.getOpProcessMatchEntityCount(); ++i) {
                OpProcessMatchEntity pEntity = pMatch.getOpProcessMatchEntity(i);
                OpFileNameMatchEntity fEntity = pEntity.getOptOpFileNameMatchEntity();
                if (fEntity == null) continue;
                model.addElement(this.getDisplayString(fEntity, pEntity.getOptOpFileChecksumMatchEntity(), pEntity.getOptOpProcessArgumentMatchEntity()));
            }
        }
        this.matchListSelected();
    }

    private void initNoMatchList() {
        DefaultListModel model = (DefaultListModel)this.jLNoMatch.getModel();
        model.clear();
        ProcessImageNoMatch pNoMatch = this.opProcess.getOptProcessImageNoMatch();
        if (pNoMatch != null) {
            for (int i = 0; i < pNoMatch.getOpProcessMatchEntityCount(); ++i) {
                OpProcessMatchEntity pEntity = pNoMatch.getOpProcessMatchEntity(i);
                OpFileNameMatchEntity fEntity = pEntity.getOptOpFileNameMatchEntity();
                if (fEntity == null) continue;
                model.addElement(this.getDisplayString(fEntity, pEntity.getOptOpFileChecksumMatchEntity(), pEntity.getOptOpProcessArgumentMatchEntity()));
            }
        }
        this.noMatchListSelected();
    }

    public boolean isValidate(List<String> existNames) {
        existNames.remove(this.opAppRule.getName());
        return this.isValidName(existNames, true);
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_hdp_hardware_device_protection_add_rule_definition";
    }
}

