/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.osprotect;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.schema.OpAction;
import com.sygate.scm.common.configobject.schema.OpAppliedOS;
import com.sygate.scm.common.configobject.schema.OpRegistryAccess;
import com.sygate.scm.common.configobject.schema.OpRegistryRead;
import com.sygate.scm.common.configobject.schema.OpRegistryWrite;
import com.sygate.scm.common.configobject.schema.TargetRegistryMatch;
import com.sygate.scm.common.configobject.schema.TargetRegistryNoMatch;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.ui.policy.osprotect.AccessRightsPanel;
import com.sygate.scm.console.ui.policy.osprotect.PermissionPanelBase;
import com.sygate.scm.console.ui.policy.osprotect.RegistryDefinitionPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class RegistryPanel
extends PermissionPanelBase
implements ChangeListener {
    private static final long serialVersionUID = 2029518400222821919L;
    private static final String NO_APPLY = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "DefinitionPanel.registry.noApplies");
    private RegistryDefinitionPanel definitionPanel;
    private AccessRightsPanel accessPanel;
    private JTabbedPane jTbPane = new JTabbedPane();
    private OpRegistryAccess opRegAccess;

    public RegistryPanel(boolean isReadonly) {
        String description = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "RegistryPanel.action.description");
        String descriptionWrite = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "RegistryPanel.action.description.write");
        this.definitionPanel = new RegistryDefinitionPanel(this, isReadonly);
        this.accessPanel = new AccessRightsPanel(description, descriptionWrite, this, isReadonly);
        this.initialize(isReadonly);
    }

    @Override
    public void initData(ConfigObject opRegAccess) {
        this.opRegAccess = (OpRegistryAccess)opRegAccess;
        this.checkSchma((OpRegistryAccess)opRegAccess);
        this.definitionPanel.initData(opRegAccess);
        this.accessPanel.initData(((OpRegistryAccess)opRegAccess).getOptOpRegistryRead().getOpAction(), ((OpRegistryAccess)opRegAccess).getOptOpRegistryWrite().getOpAction());
        this.jTASummary.setText(this.getSummary((OpRegistryAccess)opRegAccess));
    }

    @Override
    public void commitData() {
        this.definitionPanel.commitData();
        this.accessPanel.commitData();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.updateSummary();
    }

    private void initialize(boolean isReadonly) {
        this.jTbPane.addTab(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "RegistryPanel.title.RegDefn"), this.definitionPanel);
        this.jTbPane.addTab(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "RegistryPanel.title.AccessRightsAndRestrictions"), new JScrollPane(this.accessPanel));
        this.setLayout(new BorderLayout());
        this.add((Component)this.jTbPane, "Center");
        this.add((Component)this.getSummaryPanel(isReadonly), "South");
    }

    private void checkSchma(OpRegistryAccess opRegAccess) {
        if (opRegAccess.getOptOpRegistryRead() == null) {
            OpRegistryRead read = new OpRegistryRead();
            read.setOpAction(this.createOpAction());
            opRegAccess.setOptOpRegistryRead(read);
        }
        if (opRegAccess.getOptOpRegistryWrite() == null) {
            OpRegistryWrite write = new OpRegistryWrite();
            write.setOpAction(this.createOpAction());
            opRegAccess.setOptOpRegistryWrite(write);
        }
        if (opRegAccess.getOptOpAppliedOS() == null) {
            opRegAccess.setOptOpAppliedOS(new OpAppliedOS());
        }
    }

    private String getSummary(OpRegistryAccess opRegAccess) {
        String fileMatchStr = "";
        String fileNoMatchStr = "";
        Object fileMatchCombinedStr = "";
        String readStr = "";
        String name = this.definitionPanel.getNameText();
        String listSeparator = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "RegistryPanel.ListSeparator");
        String formatApplies = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "RegistryPanel.FormatForAppliesCriteria");
        String formatExcludes = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "RegistryPanel.FormatForExcludesCriteria");
        TargetRegistryMatch fileNameMatch = opRegAccess.getOpTargetRegistry().getOptTargetRegistryMatch();
        if (fileNameMatch != null && fileNameMatch.getOpRegistryMatchEntityCount() > 0) {
            StringBuilder fileMatchBuf = new StringBuilder();
            for (int i = 0; i < fileNameMatch.getOpRegistryMatchEntityCount(); ++i) {
                fileMatchBuf.append(fileNameMatch.getOpRegistryMatchEntity(i).getRegKey());
                fileMatchBuf.append(listSeparator);
            }
            fileMatchStr = fileMatchBuf.toString();
            if (fileMatchStr != null && fileMatchStr.length() > 0) {
                fileMatchStr = fileMatchStr.substring(0, fileMatchStr.length() - 1);
            }
        } else {
            return NO_APPLY;
        }
        TargetRegistryNoMatch fileNameNoMatch = opRegAccess.getOpTargetRegistry().getOptTargetRegistryNoMatch();
        if (fileNameNoMatch != null) {
            StringBuilder fileNoMatchBuf = new StringBuilder();
            for (int i = 0; i < fileNameNoMatch.getOpRegistryMatchEntityCount(); ++i) {
                fileNoMatchBuf.append(fileNameNoMatch.getOpRegistryMatchEntity(i).getRegKey());
                fileNoMatchBuf.append(listSeparator);
            }
            fileNoMatchStr = fileNoMatchBuf.toString();
            if (fileNoMatchStr != null && fileNoMatchStr.length() > 0) {
                fileNoMatchStr = fileNoMatchStr.substring(0, fileNoMatchStr.length() - 1);
            }
        }
        String fileMatchAppliesStr = null;
        if (fileMatchStr.length() > 0) {
            fileMatchAppliesStr = MessageFormat.format(formatApplies, name, fileMatchStr);
            fileMatchCombinedStr = (String)fileMatchCombinedStr + fileMatchAppliesStr + " ";
        }
        String fileMatchExcludesStr = null;
        if (fileNoMatchStr.length() > 0) {
            fileMatchExcludesStr = MessageFormat.format(formatExcludes, fileNoMatchStr);
            fileMatchCombinedStr = (String)fileMatchCombinedStr + fileMatchExcludesStr + " ";
        }
        OpAction actionRead = null;
        OpRegistryRead regRead = opRegAccess.getOptOpRegistryRead();
        if (regRead != null) {
            actionRead = regRead.getOpAction();
        }
        OpAction actionWrite = null;
        OpRegistryWrite regWrite = opRegAccess.getOptOpRegistryWrite();
        if (regWrite != null) {
            actionWrite = regWrite.getOpAction();
        }
        readStr = "";
        if (actionRead != null && actionWrite != null) {
            readStr = this.getOpActionSummary(actionRead, actionWrite, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "RegistryPanel.ReadAccess"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "RegistryPanel.WriteAccess"));
        }
        return (String)fileMatchCombinedStr + readStr;
    }

    private void updateSummary() {
        this.jTASummary.setText(this.getSummary(this.opRegAccess));
    }

    @Override
    public boolean isValidate(List<String> existNames) {
        return this.definitionPanel.isValidate(existNames);
    }

    @Override
    public String getContentSensitiveHelpToken() {
        Component comp = this.jTbPane.getSelectedComponent();
        if (comp instanceof JScrollPane) {
            comp = ((JScrollPane)comp).getViewport().getComponent(0);
        }
        return ((ContentSensitiveHelpPage)((Object)comp)).getContentSensitiveHelpToken();
    }
}

