/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.osprotect;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.schema.OpRegistryAccess;
import com.sygate.scm.common.configobject.schema.OpRegistryMatchEntity;
import com.sygate.scm.common.configobject.schema.OpTargetRegistry;
import com.sygate.scm.common.configobject.schema.TargetRegistryMatch;
import com.sygate.scm.common.configobject.schema.TargetRegistryNoMatch;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.ui.policy.osprotect.DefinitionPanel;
import com.sygate.scm.console.ui.policy.osprotect.dialog.RegistryPathEditorDlg;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.Utility;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.event.ChangeListener;

public class RegistryDefinitionPanel
extends DefinitionPanel {
    private static final long serialVersionUID = -4638776804887163182L;
    private OpRegistryAccess opRegAccess;
    private OpTargetRegistry opTargetReg;
    private boolean isReadonly;

    public RegistryDefinitionPanel(ChangeListener summaryListener, boolean isReadonly) {
        String description = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "DefinitionPanel.registry.description");
        this.isReadonly = isReadonly;
        this.initialize(95, summaryListener, description, isReadonly);
    }

    public void initData(ConfigObject configuObj) {
        this.opRegAccess = (OpRegistryAccess)configuObj;
        this.opTargetReg = this.opRegAccess.getOpTargetRegistry();
        this.jTFName.setText(this.opRegAccess.getName());
        this.setTADesc(this.opRegAccess.getOptDescription());
        this.jCbxEnable.setSelected(Utility.getBooleanValue((Boolean)this.opRegAccess.getOptEnable(), (Boolean)this.opRegAccess.getDefEnable()));
        this.initMatchList();
        this.initNoMatchList();
    }

    public void commitData() {
        this.opRegAccess.setName(this.jTFName.getText().trim());
        this.opRegAccess.setOptDescription(this.jTADesc.getText().trim());
        this.opRegAccess.setOptEnable(Boolean.valueOf(this.jCbxEnable.isSelected()));
    }

    @Override
    protected void addMatch() {
        RegistryPathEditorDlg dlg = new RegistryPathEditorDlg();
        if (dlg.isOk()) {
            OpRegistryMatchEntity regEntity = dlg.getRegistryMatchEntity();
            TargetRegistryMatch tMatch = this.opTargetReg.getOptTargetRegistryMatch();
            if (tMatch == null) {
                tMatch = new TargetRegistryMatch();
            }
            tMatch.addOpRegistryMatchEntity(regEntity);
            this.opTargetReg.setOptTargetRegistryMatch(tMatch);
            DefaultListModel model = (DefaultListModel)this.jLMatch.getModel();
            model.addElement(this.getDisplayString(regEntity));
        }
        dlg.dispose();
    }

    @Override
    protected void editMatch() {
        TargetRegistryMatch tMatch;
        int selIndex = this.jLMatch.getMinSelectionIndex();
        try {
            tMatch = (TargetRegistryMatch)PolicyHandler.getCopyOfObj((ConfigObject)this.opTargetReg.getOptTargetRegistryMatch());
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
            return;
        }
        RegistryPathEditorDlg dlg = new RegistryPathEditorDlg(tMatch.getOpRegistryMatchEntity(selIndex), this.isReadonly);
        if (dlg.isOk()) {
            OpRegistryMatchEntity regEntity = dlg.getRegistryMatchEntity();
            tMatch = this.opTargetReg.getOptTargetRegistryMatch();
            tMatch.setOpRegistryMatchEntity(selIndex, regEntity);
            DefaultListModel model = (DefaultListModel)this.jLMatch.getModel();
            model.setElementAt(this.getDisplayString(regEntity), selIndex);
        }
        dlg.dispose();
    }

    @Override
    protected void deleteMatch() {
        int i;
        if (!this.canDelete(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "RegistryDefinitionPanel.DelMatchingRegDefn"))) {
            return;
        }
        ArrayList itemList = new ArrayList();
        ArrayList<OpRegistryMatchEntity> sEntityList = new ArrayList<OpRegistryMatchEntity>();
        TargetRegistryMatch tMatch = this.opTargetReg.getOptTargetRegistryMatch();
        for (i = this.jLMatch.getMinSelectionIndex(); i <= this.jLMatch.getMaxSelectionIndex(); ++i) {
            if (!this.jLMatch.isSelectedIndex(i)) continue;
            itemList.add(this.jLMatch.getModel().getElementAt(i));
            sEntityList.add(tMatch.getOpRegistryMatchEntity(i));
        }
        for (i = 0; i < itemList.size(); ++i) {
            ((DefaultListModel)this.jLMatch.getModel()).removeElement(itemList.get(i));
            tMatch.removeOpRegistryMatchEntity((OpRegistryMatchEntity)sEntityList.get(i));
        }
        this.matchListSelected();
    }

    @Override
    protected void addNoMatch() {
        RegistryPathEditorDlg dlg = new RegistryPathEditorDlg();
        if (dlg.isOk()) {
            OpRegistryMatchEntity regEntity = dlg.getRegistryMatchEntity();
            TargetRegistryNoMatch tNoMatch = this.opTargetReg.getOptTargetRegistryNoMatch();
            if (tNoMatch == null) {
                tNoMatch = new TargetRegistryNoMatch();
            }
            tNoMatch.addOpRegistryMatchEntity(regEntity);
            this.opTargetReg.setOptTargetRegistryNoMatch(tNoMatch);
            DefaultListModel model = (DefaultListModel)this.jLNoMatch.getModel();
            model.addElement(this.getDisplayString(regEntity));
        }
        dlg.dispose();
    }

    @Override
    protected void editNoMatch() {
        TargetRegistryNoMatch tNoMatch;
        int selIndex = this.jLNoMatch.getMinSelectionIndex();
        try {
            tNoMatch = (TargetRegistryNoMatch)PolicyHandler.getCopyOfObj((ConfigObject)this.opTargetReg.getOptTargetRegistryNoMatch());
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
            return;
        }
        RegistryPathEditorDlg dlg = new RegistryPathEditorDlg(tNoMatch.getOpRegistryMatchEntity(selIndex), this.isReadonly);
        if (dlg.isOk()) {
            OpRegistryMatchEntity regEntity = dlg.getRegistryMatchEntity();
            tNoMatch = this.opTargetReg.getOptTargetRegistryNoMatch();
            tNoMatch.setOpRegistryMatchEntity(selIndex, regEntity);
            DefaultListModel model = (DefaultListModel)this.jLNoMatch.getModel();
            model.setElementAt(this.getDisplayString(regEntity), selIndex);
        }
        dlg.dispose();
    }

    @Override
    protected void deleteNoMatch() {
        int i;
        if (!this.canDelete(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "RegistryDefinitionPanel.DelNonMatchingRegDefn"))) {
            return;
        }
        ArrayList itemList = new ArrayList();
        ArrayList<OpRegistryMatchEntity> sEntityList = new ArrayList<OpRegistryMatchEntity>();
        TargetRegistryNoMatch tNoMatch = this.opTargetReg.getOptTargetRegistryNoMatch();
        for (i = this.jLNoMatch.getMinSelectionIndex(); i <= this.jLNoMatch.getMaxSelectionIndex(); ++i) {
            if (!this.jLNoMatch.isSelectedIndex(i)) continue;
            itemList.add(this.jLNoMatch.getModel().getElementAt(i));
            sEntityList.add(tNoMatch.getOpRegistryMatchEntity(i));
        }
        for (i = 0; i < itemList.size(); ++i) {
            ((DefaultListModel)this.jLNoMatch.getModel()).removeElement(itemList.get(i));
            tNoMatch.removeOpRegistryMatchEntity((OpRegistryMatchEntity)sEntityList.get(i));
        }
        this.noMatchListSelected();
    }

    private void initMatchList() {
        DefaultListModel model = (DefaultListModel)this.jLMatch.getModel();
        model.clear();
        TargetRegistryMatch tMatch = this.opTargetReg.getOptTargetRegistryMatch();
        if (tMatch != null) {
            for (int i = 0; i < tMatch.getOpRegistryMatchEntityCount(); ++i) {
                OpRegistryMatchEntity rEntity = tMatch.getOpRegistryMatchEntity(i);
                model.addElement(this.getDisplayString(rEntity));
            }
        }
        this.matchListSelected();
    }

    private void initNoMatchList() {
        DefaultListModel model = (DefaultListModel)this.jLNoMatch.getModel();
        model.clear();
        TargetRegistryNoMatch tNoMatch = this.opTargetReg.getOptTargetRegistryNoMatch();
        if (tNoMatch != null) {
            for (int i = 0; i < tNoMatch.getOpRegistryMatchEntityCount(); ++i) {
                OpRegistryMatchEntity rEntity = tNoMatch.getOpRegistryMatchEntity(i);
                model.addElement(this.getDisplayString(rEntity));
            }
        }
        this.noMatchListSelected();
    }

    private String getDisplayString(OpRegistryMatchEntity regEntity) {
        boolean hasData;
        String regKey = regEntity.getRegKey();
        String valueName = regEntity.getOptRegValueName();
        String valueData = regEntity.getOptRegValueData();
        boolean hasName = valueName != null && valueName.length() > 0;
        boolean bl = hasData = valueData != null && valueData.length() > 0;
        if (hasName && hasData) {
            return MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "RegistryDefinitionPanel.KeyHasValNameAndData"), regKey);
        }
        if (hasName) {
            return MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "RegistryDefinitionPanel.KeyHasValName"), regKey);
        }
        if (hasData) {
            return MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "RegistryDefinitionPanel.KeyHasValData"), regEntity.getRegKey());
        }
        return regKey;
    }

    public boolean isValidate(List<String> existNames) {
        existNames.remove(this.opRegAccess.getName());
        return this.isValidName(existNames, false);
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_hdp_hardware_device_protection_add_registry_definition";
    }
}

