/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.osprotect;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.schema.OpFileChecksumMatchEntity;
import com.sygate.scm.common.configobject.schema.OpFileNameMatchEntity;
import com.sygate.scm.common.configobject.schema.OpProcessAccess;
import com.sygate.scm.common.configobject.schema.OpProcessArgumentMatchEntity;
import com.sygate.scm.common.configobject.schema.OpProcessMatchEntity;
import com.sygate.scm.common.configobject.schema.OpTargetProcess;
import com.sygate.scm.common.configobject.schema.TargetProcessMatch;
import com.sygate.scm.common.configobject.schema.TargetProcessNoMatch;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.ui.policy.osprotect.DefinitionPanel;
import com.sygate.scm.console.ui.policy.osprotect.dialog.StringConditionEditorDlg;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.Utility;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.event.ChangeListener;

public class ProcessDefinitionPanel
extends DefinitionPanel {
    private static final long serialVersionUID = 6815701201607636297L;
    private OpProcessAccess opProcessAccess;
    private OpTargetProcess opTargetProcess;
    private boolean isLaunchProcess;
    private boolean isReadonly;

    public ProcessDefinitionPanel(boolean isLaunchProcess, ChangeListener summaryListener, boolean isReadonly) {
        this.isLaunchProcess = isLaunchProcess;
        String resource = "DefinitionPanel.launch.description";
        if (!isLaunchProcess) {
            resource = "DefinitionPanel.terminate.description";
        }
        String description = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", resource);
        this.isReadonly = isReadonly;
        this.initialize(97, summaryListener, description, isReadonly);
    }

    public void initData(ConfigObject configuObj) {
        this.opProcessAccess = (OpProcessAccess)configuObj;
        this.opTargetProcess = this.opProcessAccess.getOpTargetProcess();
        this.jTFName.setText(this.opProcessAccess.getName());
        this.setTADesc(this.opProcessAccess.getOptDescription());
        this.jCbxEnable.setSelected(Utility.getBooleanValue((Boolean)this.opProcessAccess.getOptEnable(), (Boolean)this.opProcessAccess.getDefEnable()));
        this.initMatchList();
        this.initNoMatchList();
    }

    public void commitData() {
        this.opProcessAccess.setName(this.jTFName.getText().trim());
        this.opProcessAccess.setOptDescription(this.jTADesc.getText().trim());
        this.opProcessAccess.setOptEnable(Boolean.valueOf(this.jCbxEnable.isSelected()));
    }

    @Override
    protected void addMatch() {
        StringConditionEditorDlg dlg = new StringConditionEditorDlg(this.getProcessFlag());
        if (dlg.isOk()) {
            OpFileNameMatchEntity fileEntity = dlg.getFileNameMatchEntity();
            OpFileChecksumMatchEntity checksumEntity = dlg.getFileChecksumMatchEntity();
            OpProcessArgumentMatchEntity arguEntity = dlg.getProcessArgumentMatchEntity();
            TargetProcessMatch tMatch = this.opTargetProcess.getOptTargetProcessMatch();
            if (tMatch == null) {
                tMatch = new TargetProcessMatch();
            }
            OpProcessMatchEntity processEntity = new OpProcessMatchEntity();
            processEntity.setOptOpFileNameMatchEntity(fileEntity);
            processEntity.setOptOpFileChecksumMatchEntity(checksumEntity);
            processEntity.setOptOpProcessArgumentMatchEntity(arguEntity);
            tMatch.addOpProcessMatchEntity(processEntity);
            this.opTargetProcess.setOptTargetProcessMatch(tMatch);
            DefaultListModel model = (DefaultListModel)this.jLMatch.getModel();
            model.addElement(this.getDisplayString(fileEntity, checksumEntity, arguEntity));
        }
        dlg.dispose();
    }

    @Override
    protected void editMatch() {
        TargetProcessMatch tMatch;
        int selIndex = this.jLMatch.getMinSelectionIndex();
        try {
            tMatch = (TargetProcessMatch)PolicyHandler.getCopyOfObj((ConfigObject)this.opTargetProcess.getOptTargetProcessMatch());
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
            return;
        }
        OpProcessMatchEntity pEntity = tMatch.getOpProcessMatchEntity(selIndex);
        OpFileNameMatchEntity file = pEntity.getOptOpFileNameMatchEntity();
        OpFileChecksumMatchEntity checksum = pEntity.getOptOpFileChecksumMatchEntity();
        OpProcessArgumentMatchEntity argu = pEntity.getOptOpProcessArgumentMatchEntity();
        StringConditionEditorDlg dlg = new StringConditionEditorDlg(this.getProcessFlag(), file, checksum, argu, this.isReadonly);
        if (dlg.isOk()) {
            OpFileNameMatchEntity fileEntity = dlg.getFileNameMatchEntity();
            OpFileChecksumMatchEntity checksumEntity = dlg.getFileChecksumMatchEntity();
            OpProcessArgumentMatchEntity arguEntity = dlg.getProcessArgumentMatchEntity();
            tMatch = this.opTargetProcess.getOptTargetProcessMatch();
            if (tMatch != null) {
                pEntity = tMatch.getOpProcessMatchEntity(selIndex);
                pEntity.setOptOpFileNameMatchEntity(fileEntity);
                pEntity.setOptOpFileChecksumMatchEntity(checksumEntity);
                pEntity.setOptOpProcessArgumentMatchEntity(arguEntity);
                DefaultListModel model = (DefaultListModel)this.jLMatch.getModel();
                model.setElementAt(this.getDisplayString(fileEntity, checksumEntity, arguEntity), selIndex);
            }
        }
        dlg.dispose();
    }

    @Override
    protected void deleteMatch() {
        int i;
        if (!this.canDelete(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "ProcessDefinitionPanel.DelMatchingProcessDefn"))) {
            return;
        }
        ArrayList itemList = new ArrayList();
        ArrayList<OpProcessMatchEntity> sEntityList = new ArrayList<OpProcessMatchEntity>();
        TargetProcessMatch tMatch = this.opTargetProcess.getOptTargetProcessMatch();
        for (i = this.jLMatch.getMinSelectionIndex(); i <= this.jLMatch.getMaxSelectionIndex(); ++i) {
            if (!this.jLMatch.isSelectedIndex(i)) continue;
            itemList.add(this.jLMatch.getModel().getElementAt(i));
            sEntityList.add(tMatch.getOpProcessMatchEntity(i));
        }
        for (i = 0; i < itemList.size(); ++i) {
            ((DefaultListModel)this.jLMatch.getModel()).removeElement(itemList.get(i));
            tMatch.removeOpProcessMatchEntity((OpProcessMatchEntity)sEntityList.get(i));
        }
        this.matchListSelected();
    }

    @Override
    protected void addNoMatch() {
        StringConditionEditorDlg dlg = new StringConditionEditorDlg(this.getProcessFlag());
        if (dlg.isOk()) {
            OpFileNameMatchEntity fileEntity = dlg.getFileNameMatchEntity();
            OpFileChecksumMatchEntity checksumEntity = dlg.getFileChecksumMatchEntity();
            OpProcessArgumentMatchEntity arguEntity = dlg.getProcessArgumentMatchEntity();
            TargetProcessNoMatch tNoMatch = this.opTargetProcess.getOptTargetProcessNoMatch();
            if (tNoMatch == null) {
                tNoMatch = new TargetProcessNoMatch();
            }
            OpProcessMatchEntity processEntity = new OpProcessMatchEntity();
            processEntity.setOptOpFileNameMatchEntity(fileEntity);
            processEntity.setOptOpFileChecksumMatchEntity(checksumEntity);
            processEntity.setOptOpProcessArgumentMatchEntity(arguEntity);
            tNoMatch.addOpProcessMatchEntity(processEntity);
            this.opTargetProcess.setOptTargetProcessNoMatch(tNoMatch);
            DefaultListModel model = (DefaultListModel)this.jLNoMatch.getModel();
            model.addElement(this.getDisplayString(fileEntity, checksumEntity, arguEntity));
        }
        dlg.dispose();
    }

    @Override
    protected void editNoMatch() {
        TargetProcessNoMatch tNoMatch;
        int selIndex = this.jLNoMatch.getMinSelectionIndex();
        try {
            tNoMatch = (TargetProcessNoMatch)PolicyHandler.getCopyOfObj((ConfigObject)this.opTargetProcess.getOptTargetProcessNoMatch());
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
            return;
        }
        OpProcessMatchEntity pEntity = tNoMatch.getOpProcessMatchEntity(selIndex);
        OpFileNameMatchEntity file = pEntity.getOptOpFileNameMatchEntity();
        OpFileChecksumMatchEntity checksum = pEntity.getOptOpFileChecksumMatchEntity();
        OpProcessArgumentMatchEntity argu = pEntity.getOptOpProcessArgumentMatchEntity();
        StringConditionEditorDlg dlg = new StringConditionEditorDlg(this.getProcessFlag(), file, checksum, argu, this.isReadonly);
        if (dlg.isOk()) {
            OpFileNameMatchEntity fileEntity = dlg.getFileNameMatchEntity();
            OpFileChecksumMatchEntity checksumEntity = dlg.getFileChecksumMatchEntity();
            OpProcessArgumentMatchEntity arguEntity = dlg.getProcessArgumentMatchEntity();
            tNoMatch = this.opTargetProcess.getOptTargetProcessNoMatch();
            if (tNoMatch != null) {
                pEntity = tNoMatch.getOpProcessMatchEntity(selIndex);
                pEntity.setOptOpFileNameMatchEntity(fileEntity);
                pEntity.setOptOpFileChecksumMatchEntity(checksumEntity);
                pEntity.setOptOpProcessArgumentMatchEntity(arguEntity);
                DefaultListModel model = (DefaultListModel)this.jLNoMatch.getModel();
                model.setElementAt(this.getDisplayString(fileEntity, checksumEntity, arguEntity), selIndex);
            }
        }
        dlg.dispose();
    }

    @Override
    protected void deleteNoMatch() {
        int i;
        if (!this.canDelete(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "ProcessDefinitionPanel.DelNonMatchingProcessDefn"))) {
            return;
        }
        ArrayList itemList = new ArrayList();
        ArrayList<OpProcessMatchEntity> sEntityList = new ArrayList<OpProcessMatchEntity>();
        TargetProcessNoMatch tNoMatch = this.opTargetProcess.getOptTargetProcessNoMatch();
        for (i = this.jLNoMatch.getMinSelectionIndex(); i <= this.jLNoMatch.getMaxSelectionIndex(); ++i) {
            if (!this.jLNoMatch.isSelectedIndex(i)) continue;
            itemList.add(this.jLNoMatch.getModel().getElementAt(i));
            sEntityList.add(tNoMatch.getOpProcessMatchEntity(i));
        }
        for (i = 0; i < itemList.size(); ++i) {
            ((DefaultListModel)this.jLNoMatch.getModel()).removeElement(itemList.get(i));
            tNoMatch.removeOpProcessMatchEntity((OpProcessMatchEntity)sEntityList.get(i));
        }
        this.noMatchListSelected();
    }

    private void initMatchList() {
        DefaultListModel model = (DefaultListModel)this.jLMatch.getModel();
        model.clear();
        TargetProcessMatch tMatch = this.opTargetProcess.getOptTargetProcessMatch();
        if (tMatch != null) {
            for (int i = 0; i < tMatch.getOpProcessMatchEntityCount(); ++i) {
                OpProcessMatchEntity pEntity = tMatch.getOpProcessMatchEntity(i);
                OpFileNameMatchEntity fEntity = pEntity.getOptOpFileNameMatchEntity();
                if (fEntity == null) continue;
                model.addElement(this.getDisplayString(fEntity, pEntity.getOptOpFileChecksumMatchEntity(), pEntity.getOptOpProcessArgumentMatchEntity()));
            }
        }
        this.matchListSelected();
    }

    private void initNoMatchList() {
        DefaultListModel model = (DefaultListModel)this.jLNoMatch.getModel();
        model.clear();
        TargetProcessNoMatch tNoMatch = this.opTargetProcess.getOptTargetProcessNoMatch();
        if (tNoMatch != null) {
            for (int i = 0; i < tNoMatch.getOpProcessMatchEntityCount(); ++i) {
                OpProcessMatchEntity pEntity = tNoMatch.getOpProcessMatchEntity(i);
                OpFileNameMatchEntity fEntity = pEntity.getOptOpFileNameMatchEntity();
                if (fEntity == null) continue;
                model.addElement(this.getDisplayString(fEntity, pEntity.getOptOpFileChecksumMatchEntity(), pEntity.getOptOpProcessArgumentMatchEntity()));
            }
        }
        this.noMatchListSelected();
    }

    private int getProcessFlag() {
        return this.isLaunchProcess ? 2 : 3;
    }

    public boolean isValidate(List<String> existNames) {
        existNames.remove(this.opProcessAccess.getName());
        return this.isValidName(existNames, false);
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_hdp_hardware_device_protection_add_process_definition";
    }
}

