/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.osprotect;

import com.sygate.scm.common.configobject.schema.OpAction;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.ui.policy.osprotect.OSProtectionBlockPanel;
import com.sygate.scm.console.ui.util.UIUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.text.MessageFormat;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public abstract class PermissionPanelBase
extends JPanel
implements OSProtectionBlockPanel {
    private static final long serialVersionUID = 3373963335249342919L;
    private static final String formatAttemptNoLogNoNotify = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "PermissionPanelBase.AttemptNoLogNoNotify");
    private static final String formatAttemptLogNoNotify = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "PermissionPanelBase.AttemptLogNoNotify");
    private static final String formatAttemptNoLogNotify = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "PermissionPanelBase.AttemptNoLogNotify");
    private static final String formatAttemptLogNotify = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "PermissionPanelBase.AttemptLogNotify");
    private static final String formatAttemptContinueLogNoNotify = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "PermissionPanelBase.AttemptContinueLogNoNotify");
    private static final String formatAttemptContinueNoLogNotify = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "PermissionPanelBase.AttemptContinueNoLogNotify");
    private static final String formatAttemptContinueLogNotify = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "PermissionPanelBase.AttemptContinueLogNotify");
    private static final String openParan = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "PermissionPanelBase.openParan");
    private static final String closeParan = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "PermissionPanelBase.closeParan");
    private static final String log = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "PermissionPanelBase.Log");
    private static final String notify = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "PermissionPanelBase.Notify");
    protected JTextArea jTASummary = new JTextArea();

    protected JPanel getSummaryPanel(boolean isReadonly) {
        this.jTASummary.setEditable(false);
        this.jTASummary.setLineWrap(true);
        this.jTASummary.setWrapStyleWord(true);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "PermissionPanelBase.label.CriteriaSummary")), "North");
        this.jTASummary.setRows(5);
        JScrollPane scrollSummary = new JScrollPane();
        UiUtilities.setupScrollPane((JScrollPane)scrollSummary, (JTextArea)this.jTASummary);
        panel.add((Component)scrollSummary, "Center");
        if (!isReadonly) {
            UIUtilities.setContainerStatus(panel, false);
        }
        return panel;
    }

    protected OpAction createOpAction() {
        OpAction action = new OpAction();
        action.setAction(OpAction.DONOTHING);
        action.setSeverity(Long.valueOf(0L));
        return action;
    }

    protected String getNameSummary(String name) {
        return MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "PermissionPanelBase.CriteriaApplyTo"), name);
    }

    protected String getOpActionSummary(OpAction action, String term) {
        String accessStr = this.getActionStr(action);
        String logStr = "";
        String notifyStr = "";
        if (accessStr != null && accessStr.length() != 0) {
            accessStr = MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "PermissionPanelBase.TheyFollowedByVerbThenNoun"), accessStr, term);
        }
        if (action.getOptLogEvent() != null && action.getOptLogEvent().booleanValue()) {
            logStr = MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "PermissionPanelBase.TheyLogFollowedByNoun"), term);
        }
        if (action.getOptOpNotification() != null && action.getOptOpNotification().getOptEnable() != null && action.getOptOpNotification().getOptEnable().booleanValue()) {
            notifyStr = MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "PermissionPanelBase.TheyWillNotifyUserOf"), term);
        }
        return accessStr + logStr + notifyStr;
    }

    protected String getOpActionSummary(OpAction actionRead, OpAction actionWrite, String termRead, String termWrite) {
        StringBuffer readLine = new StringBuffer();
        StringBuffer writeLine = new StringBuffer();
        boolean logRead = actionRead.getOptLogEvent() != null && actionRead.getOptLogEvent() != false;
        boolean logWrite = actionWrite != null && actionWrite.getOptLogEvent() != null && actionWrite.getOptLogEvent() != false;
        boolean notifyRead = actionRead.getOptOpNotification() != null && actionRead.getOptOpNotification().getOptEnable() != null && actionRead.getOptOpNotification().getOptEnable() != false;
        boolean notifyWrite = actionWrite != null && actionWrite.getOptOpNotification() != null && actionWrite.getOptOpNotification().getOptEnable() != null && actionWrite.getOptOpNotification().getOptEnable() != false;
        String accessStrRead = this.getActionStr(actionRead);
        boolean addReadLine = false;
        if (accessStrRead.length() > 0 || logRead || notifyRead) {
            readLine.append(termRead);
            addReadLine = true;
            readLine.append(":");
        }
        int lengthReadAction = readLine.length();
        String accessStrWrite = null;
        if (actionWrite != null) {
            accessStrWrite = this.getActionStr(actionWrite);
        }
        boolean addWriteLine = false;
        if (termWrite != null && (accessStrWrite != null && accessStrWrite.length() > 0 || logWrite || notifyWrite)) {
            writeLine.append(termWrite);
            addWriteLine = true;
            writeLine.append(":");
        }
        int lengthWriteAction = writeLine.length();
        while (lengthWriteAction < lengthReadAction) {
            writeLine.append(" ");
            lengthWriteAction = writeLine.length();
        }
        while (lengthReadAction < lengthWriteAction) {
            readLine.append(" ");
            lengthReadAction = readLine.length();
        }
        readLine.append("   ");
        writeLine.append("   ");
        readLine.append(accessStrRead);
        if (accessStrWrite != null) {
            writeLine.append(accessStrWrite);
        }
        if (logRead || notifyRead) {
            readLine.append(" ");
            readLine.append(openParan);
            if (logRead) {
                readLine.append(log);
            }
            if (logRead && notifyRead) {
                readLine.append(" ");
            }
            if (notifyRead) {
                readLine.append(notify);
            }
            readLine.append(closeParan);
        }
        if (logWrite || notifyWrite) {
            writeLine.append(" ");
            writeLine.append(openParan);
            if (logWrite) {
                writeLine.append(log);
            }
            if (logWrite && notifyWrite) {
                writeLine.append(" ");
            }
            if (notifyWrite) {
                writeLine.append(notify);
            }
            writeLine.append(closeParan);
        }
        StringBuffer returnLine = new StringBuffer();
        if (addReadLine || addWriteLine) {
            returnLine.insert(0, "\n");
        }
        if (addReadLine) {
            returnLine.append(readLine);
            if (addWriteLine) {
                returnLine.append("\n");
            }
        }
        if (addWriteLine) {
            returnLine.append(writeLine);
        }
        return returnLine.toString();
    }

    protected String getOpActionSummary(OpAction actionRead, OpAction actionWrite, String termRead, String termWrite, boolean doText) {
        boolean logRead = actionRead.getOptLogEvent() != null && actionRead.getOptLogEvent() != false;
        boolean logWrite = actionWrite != null && actionWrite.getOptLogEvent() != null && actionWrite.getOptLogEvent() != false;
        boolean notifyRead = actionRead.getOptOpNotification() != null && actionRead.getOptOpNotification().getOptEnable() != null && actionRead.getOptOpNotification().getOptEnable() != false;
        boolean notifyWrite = actionWrite != null && actionWrite.getOptOpNotification() != null && actionWrite.getOptOpNotification().getOptEnable() != null && actionWrite.getOptOpNotification().getOptEnable() != false;
        String accessStrRead = this.getActionStr(actionRead);
        boolean accessRead = accessStrRead.length() > 0;
        String accessStrWrite = "";
        if (actionWrite != null) {
            accessStrWrite = this.getActionStr(actionWrite);
        }
        boolean accessWrite = accessStrWrite.length() > 0;
        String fomatterRead = null;
        if (accessRead && !logRead && !notifyRead) {
            fomatterRead = formatAttemptNoLogNoNotify;
        } else if (accessRead && logRead && !notifyRead) {
            fomatterRead = formatAttemptLogNoNotify;
        } else if (accessRead && !logRead && notifyRead) {
            fomatterRead = formatAttemptNoLogNotify;
        } else if (accessRead && logRead && notifyRead) {
            fomatterRead = formatAttemptLogNotify;
        } else if (!accessRead && logRead && !notifyRead) {
            fomatterRead = formatAttemptContinueLogNoNotify;
        } else if (!accessRead && !logRead && notifyRead) {
            fomatterRead = formatAttemptContinueNoLogNotify;
        } else if (!accessRead && logRead && notifyRead) {
            fomatterRead = formatAttemptContinueLogNotify;
        }
        fomatterRead = fomatterRead != null ? MessageFormat.format(fomatterRead, termRead, accessStrRead) : "";
        String fomatterWrite = null;
        if (accessWrite && !logWrite && !notifyWrite) {
            fomatterWrite = formatAttemptNoLogNoNotify;
        } else if (accessWrite && logWrite && !notifyWrite) {
            fomatterWrite = formatAttemptLogNoNotify;
        } else if (accessWrite && !logWrite && notifyWrite) {
            fomatterWrite = formatAttemptNoLogNotify;
        } else if (accessWrite && logWrite && notifyWrite) {
            fomatterWrite = formatAttemptLogNotify;
        } else if (!accessWrite && logWrite && !notifyWrite) {
            fomatterWrite = formatAttemptContinueLogNoNotify;
        } else if (!accessWrite && !logWrite && notifyWrite) {
            fomatterWrite = formatAttemptContinueNoLogNotify;
        } else if (!accessWrite && logWrite && notifyWrite) {
            fomatterWrite = formatAttemptContinueLogNotify;
        }
        fomatterWrite = fomatterWrite != null ? MessageFormat.format(fomatterWrite, termWrite, accessStrWrite) : "";
        return fomatterRead + " " + fomatterWrite;
    }

    protected String getActionStr(OpAction opAction) {
        int action = opAction.getAction();
        if (action == OpAction.ALLOW) {
            return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "PermissionPanelBase.Allow");
        }
        if (action == OpAction.BLOCK) {
            return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "PermissionPanelBase.Block");
        }
        if (action == OpAction.TERMINATE) {
            return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "PermissionPanelBase.Terminate");
        }
        return "";
    }
}

