/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.osprotect;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.schema.OpAction;
import com.sygate.scm.common.configobject.schema.OpAppRule;
import com.sygate.scm.common.configobject.schema.OpCreateProcess;
import com.sygate.scm.common.configobject.schema.OpFileAccess;
import com.sygate.scm.common.configobject.schema.OpFileRead;
import com.sygate.scm.common.configobject.schema.OpFileWrite;
import com.sygate.scm.common.configobject.schema.OpLoadModule;
import com.sygate.scm.common.configobject.schema.OpModuleAccess;
import com.sygate.scm.common.configobject.schema.OpProcessAccess;
import com.sygate.scm.common.configobject.schema.OpRegistryAccess;
import com.sygate.scm.common.configobject.schema.OpRegistryRead;
import com.sygate.scm.common.configobject.schema.OpRegistryWrite;
import com.sygate.scm.common.configobject.schema.OpTerminateProcess;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.logicobject.TreeItem;
import java.text.MessageFormat;

public class OSProtectionTreeUserObject
implements TreeItem {
    private int uiKey;
    private ConfigObject userObject;
    private static String verbRead = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "OSProtectionTreeUserObject.VerbRead");
    private static String presPartReading = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "OSProtectionTreeUserObject.PresPartReading");
    private static String verbWrite = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "OSProtectionTreeUserObject.VerbWrite");
    private static String presPartWriting = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "OSProtectionTreeUserObject.PresPartWriting");
    private static String verbAccess = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "OSProtectionTreeUserObject.VerbAccess");
    private static String presPartAccessing = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "OSProtectionTreeUserObject.PresPartAccessing");

    public OSProtectionTreeUserObject(int uiKey, ConfigObject userObject) {
        this.uiKey = uiKey;
        this.userObject = userObject;
    }

    @Override
    public String getName() {
        switch (this.uiKey) {
            case 94: {
                return ((OpAppRule)this.userObject).getName();
            }
            case 95: {
                return this.getRegAccessName((OpRegistryAccess)this.userObject);
            }
            case 96: {
                return this.getFileAccessName((OpFileAccess)this.userObject);
            }
            case 97: {
                return this.getLaunchProcessName((OpProcessAccess)this.userObject);
            }
            case 98: {
                return this.getTerminateProcessName((OpProcessAccess)this.userObject);
            }
        }
        return this.getModuleAccessName((OpModuleAccess)this.userObject);
    }

    @Override
    public String getId() {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "OSProtectionTreeUserObject.OSProtection");
    }

    @Override
    public int getItemType() {
        return this.uiKey;
    }

    public int getUIKey() {
        return this.uiKey;
    }

    public ConfigObject getUserObject() {
        return this.userObject;
    }

    public boolean isOpAppRule() {
        return this.uiKey == 94;
    }

    public String toString() {
        return this.getName();
    }

    private String getRegAccessName(OpRegistryAccess opRegAccess) {
        OpRegistryWrite write;
        StringBuffer name = new StringBuffer(opRegAccess.getName());
        OpRegistryRead read = opRegAccess.getOptOpRegistryRead();
        if (read != null) {
            name.append(":" + this.getActionString(read.getOpAction(), verbRead, presPartReading));
        }
        if ((write = opRegAccess.getOptOpRegistryWrite()) != null) {
            name.append(";" + this.getActionString(write.getOpAction(), verbWrite, presPartWriting));
        }
        return opRegAccess.getName();
    }

    private String getFileAccessName(OpFileAccess opFileAccess) {
        OpFileWrite write;
        StringBuffer name = new StringBuffer(opFileAccess.getName());
        OpFileRead read = opFileAccess.getOptOpFileRead();
        if (read != null) {
            name.append(":" + this.getActionString(read.getOpAction(), verbRead, presPartReading));
        }
        if ((write = opFileAccess.getOptOpFileWrite()) != null) {
            name.append(";" + this.getActionString(write.getOpAction(), verbWrite, presPartWriting));
        }
        return opFileAccess.getName();
    }

    private String getLaunchProcessName(OpProcessAccess opProcessAccess) {
        StringBuffer name = new StringBuffer(opProcessAccess.getName());
        OpCreateProcess create = opProcessAccess.getOptOpCreateProcess();
        if (create != null) {
            name.append(":" + this.getActionString(create.getOpAction(), verbAccess, presPartAccessing));
        }
        return opProcessAccess.getName();
    }

    private String getTerminateProcessName(OpProcessAccess opProcessAccess) {
        StringBuffer name = new StringBuffer(opProcessAccess.getName());
        OpTerminateProcess tm = opProcessAccess.getOptOpTerminateProcess();
        if (tm != null) {
            name.append(":" + this.getActionString(tm.getOpAction(), verbAccess, presPartAccessing));
        }
        return opProcessAccess.getName();
    }

    private String getModuleAccessName(OpModuleAccess opModuleAccess) {
        StringBuffer name = new StringBuffer(opModuleAccess.getName());
        OpLoadModule load = opModuleAccess.getOptOpLoadModule();
        if (load != null) {
            name.append(":" + this.getActionString(load.getOpAction(), verbAccess, presPartAccessing));
        }
        return opModuleAccess.getName();
    }

    private String getActionString(OpAction action, String str1, String str2) {
        Integer type = action.getAction();
        if (type.intValue() == OpAction.DONOTHING.intValue()) {
            return MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "OSProtectionTreeUserObject.IgnoreFollowedByPresParticiple"), str2);
        }
        if (type.intValue() == OpAction.ALLOW.intValue()) {
            return MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "OSProtectionTreeUserObject.AllowToFollowedByVerb"), str1);
        }
        if (type.intValue() == OpAction.BLOCK.intValue()) {
            return MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "OSProtectionTreeUserObject.DenyToFollwedByVerb"), str1);
        }
        return MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "OSProtectionTreeUserObject.TerminateWhenFollowedByPresParticiple"), str2);
    }
}

