/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.osprotect;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.schema.OpAppRule;
import com.sygate.scm.common.configobject.schema.OpFileAccess;
import com.sygate.scm.common.configobject.schema.OpModuleAccess;
import com.sygate.scm.common.configobject.schema.OpProcessAccess;
import com.sygate.scm.common.configobject.schema.OpRegistryAccess;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.ui.policy.common.CopitableObject;
import com.sygate.scm.console.ui.policy.osprotect.AddRulePermissionMenu;
import com.sygate.scm.console.ui.policy.osprotect.OSProtectionTreeModel;
import com.sygate.scm.console.ui.policy.osprotect.OSProtectionTreeUserObject;
import com.sygate.scm.console.ui.policy.osprotect.dialog.RuleEditorDlg;
import com.sygate.scm.console.ui.policy.osprotect.logicobject.LaunchProcessAccessObject;
import com.sygate.scm.console.ui.policy.osprotect.logicobject.OpAppProtectionBlockObject;
import com.sygate.scm.console.ui.policy.osprotect.logicobject.OpAppRuleObject;
import com.sygate.scm.console.ui.policy.osprotect.logicobject.OpFileAccessObject;
import com.sygate.scm.console.ui.policy.osprotect.logicobject.OpModuleAccessObject;
import com.sygate.scm.console.ui.policy.osprotect.logicobject.OpRegistryAccessObject;
import com.sygate.scm.console.ui.policy.osprotect.logicobject.TerminateProcessAccessObject;
import com.sygate.scm.console.util.ConsoleException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;

public class OSProtectionTreePopupMenu
extends AddRulePermissionMenu {
    private static final long serialVersionUID = -3572147736382750807L;
    private RuleEditorDlg editorDlg;
    private JMenuItem jMIDelete = new JMenuItem(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "OSProtectionTreePopupMenu.menu.Delete"));
    private JMenuItem jMIUp = new JMenuItem(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "OSProtectionTreePopupMenu.menu.MoveUp"));
    private JMenuItem jMIDown = new JMenuItem(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "OSProtectionTreePopupMenu.menu.MoveDown"));
    private JMenuItem jMICopy = new JMenuItem(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "OSProtectionTreePopupMenu.menu.Copy"));
    private JMenuItem jMIPaste = new JMenuItem(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "OSProtectionTreePopupMenu.menu.Paste"));

    public OSProtectionTreePopupMenu(RuleEditorDlg editorDlg, JTree tree, boolean isReadonly) {
        super(tree, false);
        this.editorDlg = editorDlg;
        this.initialize(isReadonly);
    }

    @Override
    protected void setupMenuItemListener() {
        super.setupMenuItemListener();
        this.jMIDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OSProtectionTreePopupMenu.this.editorDlg.deleteTreeNode();
            }
        });
        this.jMIUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OSProtectionTreePopupMenu.this.editorDlg.moveUpTreeNode();
            }
        });
        this.jMIDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OSProtectionTreePopupMenu.this.editorDlg.moveDownTreeNode();
            }
        });
        this.jMICopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OSProtectionTreePopupMenu.this.copyNode();
            }
        });
        this.jMIPaste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OSProtectionTreePopupMenu.this.pasteNode();
            }
        });
    }

    @Override
    protected void setupMenuItems() {
        super.setupMenuItems();
        this.addSeparator();
        this.add(this.jMIDelete);
        this.add(this.jMIUp);
        this.add(this.jMIDown);
        this.add(this.jMICopy);
        this.add(this.jMIPaste);
    }

    private void initialize(boolean isReadonly) {
        this.setupMenuItemListener();
        this.setupMenuItems();
        this.checkMenuItem(isReadonly);
    }

    private void copyNode() {
        DefaultMutableTreeNode selNode = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (selNode == null) {
            return;
        }
        PolicyHandler.copyObject(this.getCopitableObject((OSProtectionTreeUserObject)selNode.getUserObject()));
    }

    private void pasteNode() {
        Class<? extends CopitableObject> copiedClass = this.getCopiedObjectClass();
        if (copiedClass == null) {
            return;
        }
        try {
            CopitableObject copiedObj = PolicyHandler.getPastedObject(copiedClass);
            if (copiedClass.isAssignableFrom(OpAppRuleObject.class)) {
                this.pasteRule((OpAppRuleObject)copiedObj);
            } else {
                this.pastePermission(copiedClass, copiedObj);
            }
        }
        catch (ConsoleException ex) {
            JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "OSProtectionTreePopupMenu.title.ErrorMessage"), 0);
        }
    }

    private void pasteRule(OpAppRuleObject opAppRuleObj) {
        OpAppRule opAppRule = (OpAppRule)opAppRuleObj.getSchemaObject();
        opAppRule.setName(PolicyHandler.adjustName(opAppRule.getName(), new OpAppProtectionBlockObject(this.model.getOpAppProtectionBlock()).getAllRuleNames(), 255));
        this.nodeAdded(this.model.addNode(94, (ConfigObject)opAppRule, null));
    }

    private void pastePermission(Class<? extends CopitableObject> copiedClass, CopitableObject copiedObj) {
        DefaultMutableTreeNode ruleNode = this.getRuleNode();
        if (copiedClass.isAssignableFrom(OpRegistryAccessObject.class)) {
            OpRegistryAccessObject opRegObj = (OpRegistryAccessObject)copiedObj;
            OpRegistryAccess regAccess = (OpRegistryAccess)opRegObj.getSchemaObject();
            regAccess.setName(PolicyHandler.adjustName(regAccess.getName(), this.getAllPermissionName(ruleNode), 255));
            this.nodeAdded(this.model.addNode(95, (ConfigObject)regAccess, ruleNode));
        } else if (copiedClass.isAssignableFrom(OpFileAccessObject.class)) {
            OpFileAccessObject opFileObj = (OpFileAccessObject)copiedObj;
            OpFileAccess fileAccess = (OpFileAccess)opFileObj.getSchemaObject();
            fileAccess.setName(PolicyHandler.adjustName(fileAccess.getName(), this.getAllPermissionName(ruleNode), 255));
            this.nodeAdded(this.model.addNode(96, (ConfigObject)fileAccess, ruleNode));
        } else if (copiedClass.isAssignableFrom(LaunchProcessAccessObject.class)) {
            LaunchProcessAccessObject launchObj = (LaunchProcessAccessObject)copiedObj;
            OpProcessAccess processAccess = (OpProcessAccess)launchObj.getSchemaObject();
            processAccess.setName(PolicyHandler.adjustName(processAccess.getName(), this.getAllPermissionName(ruleNode), 255));
            this.nodeAdded(this.model.addNode(97, (ConfigObject)processAccess, ruleNode));
        } else if (copiedClass.isAssignableFrom(TerminateProcessAccessObject.class)) {
            TerminateProcessAccessObject tmObj = (TerminateProcessAccessObject)copiedObj;
            OpProcessAccess processAccess = (OpProcessAccess)tmObj.getSchemaObject();
            processAccess.setName(PolicyHandler.adjustName(processAccess.getName(), this.getAllPermissionName(ruleNode), 255));
            this.nodeAdded(this.model.addNode(98, (ConfigObject)processAccess, ruleNode));
        } else if (copiedClass.isAssignableFrom(OpModuleAccessObject.class)) {
            OpModuleAccessObject opModuleObj = (OpModuleAccessObject)copiedObj;
            OpModuleAccess moduleAccess = (OpModuleAccess)opModuleObj.getSchemaObject();
            moduleAccess.setName(PolicyHandler.adjustName(moduleAccess.getName(), this.getAllPermissionName(ruleNode), 255));
            this.nodeAdded(this.model.addNode(99, (ConfigObject)moduleAccess, ruleNode));
        }
    }

    private void checkMenuItem(boolean isReadonly) {
        this.jMIRule.setEnabled(!isReadonly);
        this.jMCondition.setEnabled(!isReadonly);
        boolean hasSelected = this.tree.getSelectionPath() != null;
        this.jMIDelete.setEnabled(hasSelected && !isReadonly);
        this.jMIUp.setEnabled(hasSelected && !isReadonly);
        this.jMIDown.setEnabled(hasSelected && !isReadonly);
        if (hasSelected && !isReadonly) {
            OSProtectionTreeModel model = (OSProtectionTreeModel)this.tree.getModel();
            DefaultMutableTreeNode selNode = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
            this.jMIUp.setEnabled(model.canMoveUp(selNode));
            this.jMIDown.setEnabled(model.canMoveDown(selNode));
        }
        this.jMIPaste.setEnabled(this.getCopiedObjectClass() != null && !isReadonly);
    }

    private CopitableObject getCopitableObject(OSProtectionTreeUserObject userObj) {
        ConfigObject schemaObj = userObj.getUserObject();
        switch (userObj.getItemType()) {
            case 94: {
                return new OpAppRuleObject((OpAppRule)schemaObj);
            }
            case 95: {
                return new OpRegistryAccessObject((OpRegistryAccess)schemaObj);
            }
            case 96: {
                return new OpFileAccessObject((OpFileAccess)schemaObj);
            }
            case 97: {
                return new LaunchProcessAccessObject((OpProcessAccess)schemaObj);
            }
            case 98: {
                return new TerminateProcessAccessObject((OpProcessAccess)schemaObj);
            }
        }
        return new OpModuleAccessObject((OpModuleAccess)schemaObj);
    }

    private Class<? extends CopitableObject> getCopiedObjectClass() {
        if (PolicyHandler.hasCopiedObject(OpAppRuleObject.class)) {
            return OpAppRuleObject.class;
        }
        if (PolicyHandler.hasCopiedObject(OpRegistryAccessObject.class)) {
            return OpRegistryAccessObject.class;
        }
        if (PolicyHandler.hasCopiedObject(OpFileAccessObject.class)) {
            return OpFileAccessObject.class;
        }
        if (PolicyHandler.hasCopiedObject(LaunchProcessAccessObject.class)) {
            return LaunchProcessAccessObject.class;
        }
        if (PolicyHandler.hasCopiedObject(TerminateProcessAccessObject.class)) {
            return TerminateProcessAccessObject.class;
        }
        if (PolicyHandler.hasCopiedObject(OpModuleAccessObject.class)) {
            return OpModuleAccessObject.class;
        }
        return null;
    }
}

