/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.osprotect;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.schema.OpAppProtectionBlock;
import com.sygate.scm.common.configobject.schema.OpAppRule;
import com.sygate.scm.common.configobject.schema.OpFileAccess;
import com.sygate.scm.common.configobject.schema.OpModuleAccess;
import com.sygate.scm.common.configobject.schema.OpProcessAccess;
import com.sygate.scm.common.configobject.schema.OpRegistryAccess;
import com.sygate.scm.console.logicobject.ContainerObject;
import com.sygate.scm.console.ui.policy.osprotect.OSProtectionTreeUserObject;
import com.sygate.scm.console.ui.policy.osprotect.logicobject.OpPermissionListObject;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class OSProtectionTreeModel
extends DefaultTreeModel {
    private static final long serialVersionUID = 8770141092677795930L;
    private OpAppProtectionBlock protectionBlock;

    public OSProtectionTreeModel(OpAppProtectionBlock protectionBlock) {
        super(OSProtectionTreeModel.getRootNode(protectionBlock));
        this.protectionBlock = protectionBlock;
    }

    public TreePath addNode(int nodeType, ConfigObject configObj, DefaultMutableTreeNode parentNode) {
        if (nodeType == 94) {
            return this.addRule((OpAppRule)configObj);
        }
        return this.addPermission(nodeType, configObj, parentNode);
    }

    public TreePath deleteNode(DefaultMutableTreeNode node) {
        DefaultMutableTreeNode remainNode = node.getNextSibling();
        if (remainNode == null && (remainNode = node.getPreviousSibling()) == null) {
            remainNode = node.getPreviousNode();
        }
        if (((OSProtectionTreeUserObject)node.getUserObject()).isOpAppRule()) {
            this.deleteRule(node);
        } else {
            this.deletePermission(node);
        }
        this.removeNodeFromParent(node);
        return remainNode.isRoot() ? null : new TreePath(remainNode.getPath());
    }

    public void swapNode(DefaultMutableTreeNode prevNode, DefaultMutableTreeNode nextNode) {
        if (((OSProtectionTreeUserObject)prevNode.getUserObject()).isOpAppRule()) {
            this.swapRule(prevNode, nextNode);
        } else {
            this.swapPermission(prevNode, nextNode);
        }
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)prevNode.getParent();
        int prevNodeIndex = parentNode.getIndex(prevNode);
        this.removeNodeFromParent(nextNode);
        this.insertNodeInto(nextNode, parentNode, prevNodeIndex);
    }

    public boolean canMoveUp(DefaultMutableTreeNode selNode) {
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)selNode.getParent();
        if (parentNode.getIndex(selNode) == 0) {
            return false;
        }
        if (!((OSProtectionTreeUserObject)selNode.getUserObject()).isOpAppRule()) {
            return this.canMovePermission(selNode, true);
        }
        return true;
    }

    public boolean canMoveDown(DefaultMutableTreeNode selNode) {
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)selNode.getParent();
        if (parentNode.getIndex(selNode) == parentNode.getChildCount() - 1) {
            return false;
        }
        if (!((OSProtectionTreeUserObject)selNode.getUserObject()).isOpAppRule()) {
            return this.canMovePermission(selNode, false);
        }
        return true;
    }

    public boolean canDelete(DefaultMutableTreeNode selNode) {
        if (!((OSProtectionTreeUserObject)selNode.getUserObject()).isOpAppRule()) {
            return true;
        }
        return ((TreeNode)this.getRoot()).getChildCount() > 1;
    }

    public OpAppProtectionBlock getOpAppProtectionBlock() {
        return this.protectionBlock;
    }

    private TreePath addRule(OpAppRule appRule) {
        this.protectionBlock.addOpAppRule(appRule);
        DefaultMutableTreeNode node = OSProtectionTreeModel.getRuleNode(appRule);
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getRoot();
        this.insertNodeInto(node, root, root.getChildCount());
        return new TreePath(node.getPath());
    }

    private TreePath addPermission(int nodeType, ConfigObject configObj, DefaultMutableTreeNode ruleNode) {
        OpPermissionListObject listObj = this.getPermissionListObject(ruleNode);
        int index = this.addPermission(nodeType, listObj, configObj);
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(new OSProtectionTreeUserObject(nodeType, configObj));
        this.insertNodeInto(node, ruleNode, index);
        return new TreePath(node.getPath());
    }

    private int addPermission(int nodeType, OpPermissionListObject listObj, ConfigObject configObj) {
        int index = 0;
        switch (nodeType) {
            case 95: {
                index = listObj.addOpRegistryAccess((OpRegistryAccess)configObj);
                break;
            }
            case 96: {
                index = listObj.addOpFileAccess((OpFileAccess)configObj);
                break;
            }
            case 97: {
                index = listObj.addLaunchProcessAccess((OpProcessAccess)configObj);
                break;
            }
            case 98: {
                index = listObj.addTerminateProcessAccess((OpProcessAccess)configObj);
                break;
            }
            default: {
                index = listObj.addOpModuleAccess((OpModuleAccess)configObj);
            }
        }
        return index;
    }

    private void deleteRule(DefaultMutableTreeNode ruleNode) {
        OpAppRule opAppRule = (OpAppRule)this.getNodeUserSchma(ruleNode);
        this.protectionBlock.removeOpAppRule(opAppRule);
    }

    private void deletePermission(DefaultMutableTreeNode node) {
        OpPermissionListObject listObj = this.getPermissionListObject((DefaultMutableTreeNode)node.getParent());
        OSProtectionTreeUserObject userObj = (OSProtectionTreeUserObject)node.getUserObject();
        ConfigObject configObj = userObj.getUserObject();
        switch (userObj.getItemType()) {
            case 95: {
                listObj.removeOpRegistryAccess((OpRegistryAccess)configObj);
                break;
            }
            case 96: {
                listObj.removeOpFileAccess((OpFileAccess)configObj);
                break;
            }
            case 97: {
                listObj.removeLaunchProcessAccess((OpProcessAccess)configObj);
                break;
            }
            case 98: {
                listObj.removeTerminateProcessAccess((OpProcessAccess)configObj);
                break;
            }
            default: {
                listObj.removeOpModuleAccess((OpModuleAccess)configObj);
            }
        }
    }

    private void swapRule(DefaultMutableTreeNode prevNode, DefaultMutableTreeNode nextNode) {
        OpAppRule prevObj = (OpAppRule)this.getNodeUserSchma(prevNode);
        OpAppRule nextObj = (OpAppRule)this.getNodeUserSchma(nextNode);
        int index = ((DefaultMutableTreeNode)this.getRoot()).getIndex(prevNode);
        this.protectionBlock.setOpAppRule(index, nextObj);
        this.protectionBlock.setOpAppRule(index + 1, prevObj);
    }

    private void swapPermission(DefaultMutableTreeNode prevNode, DefaultMutableTreeNode nextNode) {
        ConfigObject prevObj = this.getNodeUserSchma(prevNode);
        ConfigObject nextObj = this.getNodeUserSchma(nextNode);
        DefaultMutableTreeNode ruleNode = (DefaultMutableTreeNode)prevNode.getParent();
        OpPermissionListObject listObj = this.getPermissionListObject(ruleNode);
        int index = ruleNode.getIndex(prevNode);
        switch (((OSProtectionTreeUserObject)prevNode.getUserObject()).getItemType()) {
            case 95: {
                listObj.setOpRegistryAccess(index, (OpRegistryAccess)nextObj);
                listObj.setOpRegistryAccess(index + 1, (OpRegistryAccess)prevObj);
                break;
            }
            case 96: {
                listObj.setOpFileAccess(index, (OpFileAccess)nextObj);
                listObj.setOpFileAccess(index + 1, (OpFileAccess)prevObj);
                break;
            }
            case 97: {
                listObj.setLaunchProcessAccess(index, (OpProcessAccess)nextObj);
                listObj.setLaunchProcessAccess(index + 1, (OpProcessAccess)prevObj);
                break;
            }
            case 98: {
                listObj.setTerminateProcessAccess(index, (OpProcessAccess)nextObj);
                listObj.setTerminateProcessAccess(index + 1, (OpProcessAccess)prevObj);
                break;
            }
            default: {
                listObj.setOpModuleAccess(index, (OpModuleAccess)nextObj);
                listObj.setOpModuleAccess(index + 1, (OpModuleAccess)prevObj);
            }
        }
    }

    private boolean canMovePermission(DefaultMutableTreeNode node, boolean isMoveUp) {
        int index = 0;
        OpPermissionListObject listObj = this.getPermissionListObject((DefaultMutableTreeNode)node.getParent());
        ConfigObject configObj = ((OSProtectionTreeUserObject)node.getUserObject()).getUserObject();
        switch (((OSProtectionTreeUserObject)node.getUserObject()).getItemType()) {
            case 95: {
                index = isMoveUp ? 0 : listObj.getOpRegistryAccessCount() - 1;
                return listObj.indexOfOpRegistryAccess((OpRegistryAccess)configObj) != index;
            }
            case 96: {
                index = isMoveUp ? 0 : listObj.getOpFileAccessCount() - 1;
                return listObj.indexOfOpFileAccess((OpFileAccess)configObj) != index;
            }
            case 97: {
                index = isMoveUp ? 0 : listObj.getLaunchProcessAccessCount() - 1;
                return listObj.indexOfLaunchProcessAccess((OpProcessAccess)configObj) != index;
            }
            case 98: {
                index = isMoveUp ? 0 : listObj.getTerminateProcessAccessCount() - 1;
                return listObj.indexOfTerminateProcessAccess((OpProcessAccess)configObj) != index;
            }
        }
        index = isMoveUp ? 0 : listObj.getOpModuleAccessCount() - 1;
        return listObj.indexOfOpModuleAccess((OpModuleAccess)configObj) != index;
    }

    private ConfigObject getNodeUserSchma(DefaultMutableTreeNode node) {
        OSProtectionTreeUserObject userObj = (OSProtectionTreeUserObject)node.getUserObject();
        return userObj.getUserObject();
    }

    private OpPermissionListObject getPermissionListObject(DefaultMutableTreeNode node) {
        OpAppRule opAppRule = (OpAppRule)this.getNodeUserSchma(node);
        return new OpPermissionListObject(opAppRule.getOpPermissionList());
    }

    private static DefaultMutableTreeNode getRootNode(OpAppProtectionBlock protectionBlock) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(new ContainerObject(94, "Root"));
        for (int i = 0; i < protectionBlock.getOpAppRuleCount(); ++i) {
            DefaultMutableTreeNode ruleNode = OSProtectionTreeModel.getRuleNode(protectionBlock.getOpAppRule(i));
            root.add(ruleNode);
        }
        return root;
    }

    private static DefaultMutableTreeNode getRuleNode(OpAppRule appRule) {
        DefaultMutableTreeNode node;
        int i;
        DefaultMutableTreeNode ruleNode = new DefaultMutableTreeNode(new OSProtectionTreeUserObject(94, (ConfigObject)appRule));
        OpPermissionListObject listObj = new OpPermissionListObject(appRule.getOpPermissionList());
        for (i = 0; i < listObj.getOpRegistryAccessCount(); ++i) {
            node = new DefaultMutableTreeNode(new OSProtectionTreeUserObject(95, (ConfigObject)listObj.getOpRegistryAccess(i)));
            ruleNode.add(node);
        }
        for (i = 0; i < listObj.getOpFileAccessCount(); ++i) {
            node = new DefaultMutableTreeNode(new OSProtectionTreeUserObject(96, (ConfigObject)listObj.getOpFileAccess(i)));
            ruleNode.add(node);
        }
        for (i = 0; i < listObj.getLaunchProcessAccessCount(); ++i) {
            node = new DefaultMutableTreeNode(new OSProtectionTreeUserObject(97, (ConfigObject)listObj.getLaunchProcessAccess(i)));
            ruleNode.add(node);
        }
        for (i = 0; i < listObj.getTerminateProcessAccessCount(); ++i) {
            node = new DefaultMutableTreeNode(new OSProtectionTreeUserObject(98, (ConfigObject)listObj.getTerminateProcessAccess(i)));
            ruleNode.add(node);
        }
        for (i = 0; i < listObj.getOpModuleAccessCount(); ++i) {
            node = new DefaultMutableTreeNode(new OSProtectionTreeUserObject(99, (ConfigObject)listObj.getOpModuleAccess(i)));
            ruleNode.add(node);
        }
        return ruleNode;
    }
}

