/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.osprotect;

import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.ui.policy.osprotect.OSProtectionPanel;
import com.sygate.scm.console.ui.policy.osprotect.logicobject.OpAppProtBlockEntityObject;
import com.sygate.scm.console.util.UIText;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;

public class OSProtectionTablePopupMenu
extends JPopupMenu {
    private static final long serialVersionUID = 418784835113688905L;
    private JMenuItem jMIAdd = new JMenuItem(UIText.get(5));
    private JMenuItem jMIEdit = new JMenuItem(UIText.get(1024));
    private JMenuItem jMIImport = new JMenuItem(UIText.get(2049));
    private JMenuItem jMIExport = new JMenuItem(UIText.get(1031));
    private JMenuItem jMIUp = new JMenuItem(UIText.get(3075));
    private JMenuItem jMIDown = new JMenuItem(UIText.get(3074));
    private JMenuItem jMIDelete = new JMenuItem(UIText.get(769));
    private JMenuItem jMICopy = new JMenuItem(UIText.get(520));
    private JMenuItem jMIPaste = new JMenuItem(UIText.get(3840));
    private OSProtectionPanel parentPanel;
    private JTable table;

    public OSProtectionTablePopupMenu(OSProtectionPanel parentDlg, JTable table, boolean isReadonly) {
        this.parentPanel = parentDlg;
        this.table = table;
        this.initialize(isReadonly);
    }

    private void initialize(boolean isReadonly) {
        this.setupMenuItemListener();
        this.setupMenuItems();
        this.checkMenuItem(isReadonly);
    }

    private void setupMenuItemListener() {
        this.jMIAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OSProtectionTablePopupMenu.this.parentPanel.addRule();
            }
        });
        this.jMIEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OSProtectionTablePopupMenu.this.parentPanel.editRule();
            }
        });
        this.jMIImport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OSProtectionTablePopupMenu.this.parentPanel.importCompoundRule();
            }
        });
        this.jMIExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OSProtectionTablePopupMenu.this.parentPanel.exportCompoundRule();
            }
        });
        this.jMIUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OSProtectionTablePopupMenu.this.parentPanel.moveUpRule();
            }
        });
        this.jMIDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OSProtectionTablePopupMenu.this.parentPanel.moveDownRule();
            }
        });
        this.jMIDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OSProtectionTablePopupMenu.this.parentPanel.deleteRule();
            }
        });
        this.jMICopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OSProtectionTablePopupMenu.this.parentPanel.copyRule();
            }
        });
        this.jMIPaste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OSProtectionTablePopupMenu.this.parentPanel.pasteRule(-1);
            }
        });
    }

    private void setupMenuItems() {
        this.add(this.jMIAdd);
        this.add(this.jMIEdit);
        this.add(this.jMIDelete);
        this.addSeparator();
        this.add(this.jMIImport);
        this.add(this.jMIExport);
        this.addSeparator();
        this.add(this.jMIUp);
        this.add(this.jMIDown);
        this.addSeparator();
        this.add(this.jMICopy);
        this.add(this.jMIPaste);
    }

    private void checkMenuItem(boolean isReadonly) {
        int selIndex = this.table.getSelectedRow();
        boolean isSelected = selIndex != -1;
        this.jMIAdd.setEnabled(!isReadonly);
        this.jMIEdit.setEnabled(isSelected);
        this.jMIImport.setEnabled(!isReadonly);
        this.jMIExport.setEnabled(isSelected);
        this.jMIDelete.setEnabled(isSelected && !isReadonly);
        this.jMICopy.setEnabled(isSelected);
        this.jMIUp.setEnabled(isSelected && selIndex > 0 && !isReadonly);
        this.jMIDown.setEnabled(isSelected && selIndex < this.table.getRowCount() - 1 && !isReadonly);
        this.jMIPaste.setEnabled(PolicyHandler.hasCopiedObject(OpAppProtBlockEntityObject.class) && !isReadonly);
    }
}

